/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.WSThreadPool;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.HashMap;

public class WSThreadPoolRepository
implements ThreadPoolRepository {
    private static final TraceComponent tc = Tr.register(WSThreadPoolRepository.class, "Runtime", "com.ibm.ws.runtime");
    private final HashMap _threadPools = new HashMap();
    private ThreadPoolMgr _threadPoolMgr = null;

    public WSThreadPoolRepository() {
        try {
            this._threadPoolMgr = (ThreadPoolMgr)WsServiceRegistry.getService((Object)this, (Class)ThreadPoolMgr.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.WSThreadPoolRepository.WSThreadPoolRepository", "45", this);
        }
    }

    public ThreadPool createThreadPool(String string) throws ThreadPoolAlreadyKnownException {
        return this.createThreadPool(string, 0, 10, 5000L);
    }

    public ThreadPool createThreadPool(String string, int n, int n2) throws ThreadPoolAlreadyKnownException {
        return this.createThreadPool(string, n, n2, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool createThreadPool(String string, int n, int n2, long l) throws ThreadPoolAlreadyKnownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createThreadPool", new Object[]{string, new Integer(n), new Integer(n2), new Long(l), this});
        }
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            if (this._threadPools.get(string) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createThreadPool", "ThreadPoolAlreadyKnownException");
                }
                throw new ThreadPoolAlreadyKnownException();
            }
            WSThreadPool wSThreadPool = new WSThreadPool(string, n, n2, l, this);
            this._threadPools.put(string, wSThreadPool);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadPool", wSThreadPool);
            }
            return wSThreadPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool createThreadPool(String string, int n, int n2, long l, int n3) throws ThreadPoolAlreadyKnownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createThreadPool", new Object[]{string, new Integer(n), new Integer(n2), new Long(l), new Integer(n3), this});
        }
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            if (this._threadPools.get(string) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createThreadPool", "ThreadPoolAlreadyKnownException");
                }
                throw new ThreadPoolAlreadyKnownException();
            }
            WSThreadPool wSThreadPool = new WSThreadPool(string, n, n2, l, n3, this);
            this._threadPools.put(string, wSThreadPool);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadPool", wSThreadPool);
            }
            return wSThreadPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getThreadPool(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool", new Object[]{string, this});
        }
        ThreadPool threadPool = null;
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            com.ibm.ws.util.ThreadPool threadPool2;
            threadPool = (ThreadPool)this._threadPools.get(string);
            if (threadPool == null && (threadPool2 = this._threadPoolMgr.getThreadPool(string)) != null) {
                threadPool = new WSThreadPool(threadPool2, this);
                this._threadPools.put(string, threadPool);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool", threadPool);
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeThreadPool(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeThreadPool", new Object[]{string, this});
        }
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            this._threadPools.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeThreadPool");
        }
    }
}

