/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.WsServer;
import com.ibm.ws.runtime.component.RuntimeBundleActivator;
import com.ibm.ws.runtime.component.ServerImpl;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ContainerConfigFactory;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ComponentManagerFactory;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.ecore.EObject;

public class WsServerImpl
implements WsServer.Implementation {
    private static TraceComponent tc;
    private static final String SERVER_TYPE = "process.Server";
    private final String CONFIG_LOCATOR_PLUGIN = "META-INF/ws-server.config";
    private final String SERVER_COMPONENTS_PLUGIN = "META-INF/ws-server-components.xml";
    private static WsServerImpl server;
    private WsComponent serverComponent = null;
    private static boolean isZOS;
    private static boolean isServant;
    private static boolean isControl;
    private static boolean runningWhereConfigured;
    private static boolean isCRA;
    private static boolean warnings;

    protected void start(String string, String string2, String string3, String string4) throws ConfigurationError, RuntimeError {
        try {
            StopWatch stopWatch = StopWatch.instance();
            stopWatch.start("WsServer.start()");
            RepositoryImpl repositoryImpl = this.bootRepository(string, string2, string3, string4);
            ConfigLocator[] configLocatorArray = this.bootConfigLocators(repositoryImpl);
            com.ibm.websphere.models.config.process.Server server2 = this.readConfiguration(configLocatorArray, repositoryImpl, string2);
            repositoryImpl.setClusterName(server2.getClusterName());
            VariableMapImpl variableMapImpl = this.bootVariableMap();
            ComponentManager componentManager = this.bootComponentManager();
            this.bootServerContainer(server2, repositoryImpl, configLocatorArray, componentManager);
            stopWatch.stop();
        }
        catch (ConfigurationError configurationError) {
            Tr.error(tc, "WSVR0009E", new Object[]{"META-INF/ws-server-components.xml", configurationError});
            throw configurationError;
        }
        catch (RuntimeError runtimeError) {
            Tr.error(tc, "WSVR0009E", new Object[]{"META-INF/ws-server-components.xml", runtimeError});
            throw runtimeError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootServerContainer(com.ibm.websphere.models.config.process.Server server2, RepositoryImpl repositoryImpl, ConfigLocator[] configLocatorArray, ComponentManager componentManager) throws ConfigurationError, RuntimeError {
        Object object;
        StopWatch stopWatch = StopWatch.instance();
        stopWatch.start("WsServer.bootServerContainer()");
        this.serverComponent = (WsComponent)componentManager.getComponent((EObject)server2);
        Object object2 = object = ((ServerImpl)this.serverComponent).recoveryLock;
        synchronized (object2) {
            stopWatch.start("WsServer.bootServerContainer() -- initialize server");
            try {
                this.serverComponent.initialize(ContainerConfigFactory.createContainerConfig(server2, configLocatorArray));
            }
            catch (ConfigurationWarning configurationWarning) {
                configurationWarning.printStackTrace();
                warnings = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.serverComponent.destroy();
                throw new ConfigurationError(throwable);
            }
            stopWatch.stop();
            stopWatch.start("WsServer.bootServerContainer() -- start server");
            try {
                this.serverComponent.start();
            }
            catch (RuntimeWarning runtimeWarning) {
                runtimeWarning.printStackTrace();
                warnings = true;
            }
            catch (Throwable throwable) {
                this.serverComponent.stop();
                this.serverComponent.destroy();
                throw new RuntimeError(throwable);
            }
            finally {
                repositoryImpl.stopSharing();
            }
            stopWatch.stop();
            if (!isZOS || !isControl) {
                this.issueOpenMessage(warnings);
            }
            stopWatch.stop();
            if (!isZOS && ((ServerImpl)this.serverComponent).getServerMode() == 1) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private RepositoryImpl bootRepository(String string, String string2, String string3, String string4) {
        StopWatch.instance().start("WsServer.bootRepository()");
        RepositoryImpl repositoryImpl = new RepositoryImpl("server", string, string2, string3, string4);
        System.setProperty("was.repository.root", string);
        StopWatch.instance().stop();
        return repositoryImpl;
    }

    private VariableMapImpl bootVariableMap() {
        StopWatch.instance().start("WsServer.bootVariableMap()");
        VariableMapImpl variableMapImpl = (VariableMapImpl)VariableMapFactory.createVariableMap();
        variableMapImpl.initialize(null);
        StopWatch.instance().stop();
        return variableMapImpl;
    }

    private ComponentManager bootComponentManager() throws ConfigurationError {
        ComponentManager componentManager;
        StopWatch.instance().start("WsServer.bootComponentManager()");
        String string = "META-INF/ws-server-components.xml";
        try {
            if (isZOS) {
                if (isServant) {
                    if (!runningWhereConfigured) {
                        string = "META-INF/ws-server-recovery-mode-components.xml";
                    }
                } else {
                    string = "META-INF/ws-server-control-region-components.xml";
                }
            }
            componentManager = ComponentManagerFactory.createComponentManager(string, Thread.currentThread().getContextClassLoader());
            try {
                WsServiceRegistry.addService((Object)componentManager, (Class)ComponentManager.class);
            }
            catch (Exception exception) {
                throw new ConfigurationError("couldnt register ComponentManager", exception);
            }
        }
        catch (ConfigurationError configurationError) {
            Tr.error(tc, "WSVR0008E", new Object[]{string, configurationError});
            throw configurationError;
        }
        StopWatch.instance().stop();
        return componentManager;
    }

    private ConfigLocator[] bootConfigLocators(Repository repository2) throws ConfigurationError {
        StopWatch.instance().start("WsServer.bootConfigLocators()");
        ConfigLocator[] configLocatorArray = this.getConfigLocators();
        for (int i = 0; i < configLocatorArray.length; ++i) {
            try {
                configLocatorArray[i].initialize(repository2);
                continue;
            }
            catch (ConfigurationWarning configurationWarning) {
                continue;
            }
            catch (ConfigurationError configurationError) {
                Tr.error(tc, "WSVR0100W", new Object[]{configLocatorArray[i], configurationError});
                throw configurationError;
            }
        }
        StopWatch.instance().stop();
        return configLocatorArray;
    }

    private ConfigLocator[] getConfigLocators() throws ConfigurationError {
        Object object;
        Object object2;
        Object object3;
        String string;
        ArrayList<ConfigLocator> arrayList = new ArrayList<ConfigLocator>(3);
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".server-config");
        if (iExtensionPoint == null) {
            throw new ConfigurationError("extension point, " + string + ", is null");
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            object3 = iExtensionArray[i];
            object2 = object3.getConfigurationElements();
            for (int j = 0; j < ((IConfigurationElement[])object2).length; ++j) {
                object = object2[j];
                String string2 = object.getAttribute("name");
                if (!object.getName().equals("configLocator")) {
                    System.err.println("IGNORING: configuration element : " + object.getName() + "[" + object3.getExtensionPointUniqueIdentifier() + "]");
                    continue;
                }
                if (string2 == null) {
                    System.err.println("IGNORING: extension (no \"name\" attribute) : " + object3.getExtensionPointUniqueIdentifier());
                    continue;
                }
                try {
                    ConfigLocator configLocator = (ConfigLocator)object.createExecutableExtension("name");
                    arrayList.add(configLocator);
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WSVR0100W", new Object[]{string2, throwable});
                    throw new ConfigurationError("Error processing config locator " + string2, throwable);
                }
            }
        }
        ConfigLocator[] configLocatorArray = null;
        try {
            configLocatorArray = Thread.currentThread().getContextClassLoader().getResources("META-INF/ws-server.config");
            while (configLocatorArray.hasMoreElements()) {
                object3 = (URL)configLocatorArray.nextElement();
                object2 = null;
                try {
                    String string3;
                    object2 = new BufferedReader(new InputStreamReader(((URL)object3).openStream()));
                    while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                        try {
                            object = (ConfigLocator)ImplFactory.loadImplFromClass(string3);
                            arrayList.add((ConfigLocator)object);
                        }
                        catch (Throwable throwable) {
                            Tr.error(tc, "WSVR0100W", new Object[]{string3, throwable});
                            throw new ConfigurationError("Error processing plugin " + ((URL)object3).getPath(), throwable);
                        }
                    }
                }
                catch (IOException iOException) {
                    Tr.service(tc, "WSVR0100W", new Object[]{((URL)object3).toString(), iOException});
                    throw new ConfigurationError("Error processing plugin " + ((URL)object3).getPath(), iOException);
                }
                finally {
                    if (object2 == null) continue;
                    try {
                        ((BufferedReader)object2).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        configLocatorArray = new ConfigLocator[arrayList.size()];
        arrayList.toArray(configLocatorArray);
        return configLocatorArray;
    }

    protected com.ibm.websphere.models.config.process.Server readConfiguration(ConfigLocator[] configLocatorArray, Repository repository2, String string) throws ConfigurationError {
        com.ibm.websphere.models.config.process.Server server2 = null;
        try {
            for (int i = 0; server2 == null && i < configLocatorArray.length; ++i) {
                server2 = (com.ibm.websphere.models.config.process.Server)configLocatorArray[i].getConfig(null, SERVER_TYPE);
            }
            if (server2 == null) {
                Tr.error(tc, "WSVR0007E", new Object[]{SERVER_TYPE, string});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Tr.error(tc, "WSVR0008E", new Object[]{string, throwable});
            throw new ConfigurationError(throwable);
        }
        if (server2 != null && !server2.getName().equals(repository2.getServerName())) {
            Tr.error(tc, "WSVR0004E", repository2.getServerName());
            throw new ConfigurationError("bad process name");
        }
        return server2;
    }

    public void main(String[] stringArray) {
        if (stringArray.length < 4) {
            throw new IllegalArgumentException("<config root> <cell> <node> <process>");
        }
        StopWatch.instance().start("WsServer.main");
        try {
            this.start(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0009E", throwable);
            throwable.printStackTrace();
            System.exit(-1);
        }
        StopWatch.instance().stop();
        if (!isZOS) {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static WsServerImpl getInstance() {
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (isZOS) {
            try {
                this.serverComponent.stop();
                this.serverComponent.destroy();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                String string = "";
                if (isCRA) {
                    string = "ADJUNCT";
                } else if (isServant) {
                    string = "SERVANT";
                } else if (isControl) {
                    string = "CONTROL";
                }
                Tr.audit(tc, "WSVR0024I", string + " PROCESS " + this.serverComponent.getName());
                RuntimeBundleActivator.instance().shutdownEclipse();
                this.serverComponent = null;
                server = null;
            }
        } else {
            FFDCFilter.processException(new Exception("Stop"), WsServerImpl.class.getName(), "424");
        }
    }

    public void issueOpenMessage(boolean bl) {
        boolean bl2;
        String string;
        Object object;
        if (isZOS) {
            object = "";
            if (isCRA) {
                object = "ADJUNCT";
            } else if (isServant) {
                object = "SERVANT";
            } else if (isControl) {
                object = "CONTROL";
            }
            string = (String)object + " PROCESS " + this.serverComponent.getName();
        } else {
            string = this.serverComponent.getName();
        }
        object = (Server)((Object)this.serverComponent);
        boolean bl3 = bl2 = object.getServerMode() == 1;
        if (warnings || bl) {
            if (bl2) {
                Tr.audit(tc, "WSVR0010I", string);
            } else {
                Tr.audit(tc, "WSVR0002I", string);
            }
        } else if (bl2) {
            Tr.audit(tc, "WSVR0005I", string);
        } else {
            Tr.audit(tc, "WSVR0001I", string);
        }
    }

    public boolean getWarnings() {
        return warnings;
    }

    public static void setWarnings(boolean bl) {
        warnings = bl;
    }

    static {
        server = null;
        isZOS = false;
        isServant = false;
        isControl = false;
        runningWhereConfigured = false;
        isCRA = false;
        warnings = false;
        tc = Tr.register(WsServerImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        isZOS = platformHelper.isZOS();
        if (isZOS) {
            isControl = platformHelper.isControlJvm();
            isServant = platformHelper.isServantJvm();
            isCRA = platformHelper.isCRAJvm();
            runningWhereConfigured = platformHelper.runningWhereConfigured();
        }
    }
}

