/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.classloader.ClassLoaderListener;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsRuntimeFwException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.AsynchronousInitializer;
import com.ibm.ws.runtime.component.DeployedApplicationImpl;
import com.ibm.ws.runtime.component.DeployedModuleImpl;
import com.ibm.ws.runtime.component.ResourceMgrImpl;
import com.ibm.ws.runtime.component.collaborator.J2EEApplication;
import com.ibm.ws.runtime.deploy.DeployedApplicationFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObjectAdjuster;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectHandler;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.LibraryMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.server.services.NameSpaceBindStatus;
import com.ibm.ws.server.services.NameSpaceBindStatusHelper;
import com.ibm.ws.util.Join;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.component.WsContainer;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.Introspector;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.jar.Attributes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;

public class ApplicationMgrImpl
extends WsContainer
implements ApplicationMgr,
DeployedObjectListener,
DeployedObjectHandler,
DeployedObjectAdjuster {
    private static TraceComponent tc = Tr.register(ApplicationMgrImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    static final String SERVERINDEX = "serverindex.xml";
    static final String SYSTEMAPPS = "systemapps.xml";
    static final String EAR_EXTENSION = ".ear";
    private static final boolean isZOS;
    private static final boolean isCRA;
    private boolean extraProcessing = false;
    private ArrayList deployedApplications = new ArrayList();
    private ArrayList deployedObjectListeners = new ArrayList();
    private ArrayList deployedObjectHandlers = new ArrayList();
    private ArrayList deployedObjectAdjusters = new ArrayList();
    private ArrayList deployedApplicationFilters = new ArrayList();
    private boolean allowNamingOps;
    private NameSpaceBindStatus nameSpaceBindStatus;
    private BlockerJoin blockers = null;
    private List blockingServices = null;
    private StopWatch stopwatch = StopWatch.instance();
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VirtualHostMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$LibraryMgr;

    public ApplicationMgrImpl() {
        super("application-mgr-startup-not-used");
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object, this});
        }
        try {
            WsServiceRegistry.addService((Object)this, (Class)ApplicationMgr.class);
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception);
        }
        this.setState("INITIALIZING");
        try {
            Server server2 = (Server)this._getService(Server.class);
            if (server2.getServerMode() != 1) {
                ApplicationServer applicationServer = (ApplicationServer)WsServiceRegistry.getService((Object)this, (Class)ApplicationServer.class);
                int n = applicationServer.getClassLoaderPolicy();
                int n2 = applicationServer.getClassLoadingMode();
                boolean bl = n == 1;
                ClassLoaderManager.setSingleServerClassLoader(bl);
                if (bl) {
                    ClassLoaderManager.setDefaultDelegationMode(n2 == 0);
                }
                ResourceMgr resourceMgr = (ResourceMgr)WsServiceRegistry.getService((Object)this, (Class)ResourceMgr.class);
                ResourceMgrImpl resourceMgrImpl = (ResourceMgrImpl)resourceMgr;
                this.addDeployedObjectHandler(resourceMgrImpl);
                this.registerMBean();
            }
            this.setState("INITIALIZED");
        }
        catch (Exception exception) {
            try {
                throw new ConfigurationError(exception);
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize", new Object[]{object, this});
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Object[]{object, this});
        }
    }

    public static Properties getEditionProps(String string, Repository repository2) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEditionProps", new Object[]{string, repository2});
        }
        Properties properties = new Properties();
        try {
            InputStream inputStream = repository2.getConfigRoot().getInputStream(0, "applications/" + string + EAR_EXTENSION + "/" + "ibm-edition-metadata.props");
            properties.load(inputStream);
            inputStream.close();
        }
        catch (Throwable throwable) {
            throw new ConfigurationError(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEditionProps", properties);
        }
        return properties;
    }

    private boolean onlyOneDeployment(List list, String string) {
        int n = 0;
        String string2 = string + EAR_EXTENSION + "/";
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (!string3.startsWith(string2)) continue;
            ++n;
        }
        return n == 1;
    }

    private boolean isActiveEditionApp(String string, Repository repository2, List list, Hashtable hashtable, List list2) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isActiveEditionApp", new Object[]{string, repository2, list, hashtable, list2});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isActiveEditionApp " + string + ", " + list2);
            Tr.debug(tc, "Edition PropTable = " + hashtable);
            Tr.debug(tc, "Repo ==>" + repository2);
            Tr.debug(tc, "apps --> " + list);
            Tr.debug(tc, "started --> " + list2);
        }
        if ((n = string.lastIndexOf("/")) == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Malformed serverindex entry, skipping: " + string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isActiveEditionApp");
            }
            return false;
        }
        String string2 = string.substring(n + 1);
        String[] stringArray = EditionHelper.getAppAndEdition(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mangled name = " + string2);
            Tr.debug(tc, "appName=" + stringArray[0] + " --> " + stringArray[1]);
        }
        if ("".equals(stringArray[1]) && this.onlyOneDeployment(list, stringArray[0])) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " = default edition and only one. Should be started.");
            }
            list2.add(stringArray[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isActiveEditionApp");
            }
            return true;
        }
        if (list2.contains(stringArray[0])) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Another app already started.  Skipping: " + string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isActiveEditionApp");
            }
            return false;
        }
        try {
            String string3;
            String string4;
            Properties properties = (Properties)hashtable.get(stringArray[0]);
            if (properties == null) {
                properties = ApplicationMgrImpl.getEditionProps(stringArray[0], repository2);
                hashtable.put(stringArray[0], properties);
            }
            if ((string4 = (String)properties.get(string3 = EditionHelper.getEditionStatePropName(string2))) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isActiveEditionApp");
                }
                return false;
            }
            if (string4.equalsIgnoreCase("ACTIVE") || string4.equalsIgnoreCase("VALIDATE")) {
                list2.add(stringArray[0]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Edition prop file indicates starting " + string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isActiveEditionApp");
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.runtime.component.ApplicationMgrImpl.isActiveEditionApp", "161");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isActiveEditionApp");
        }
        return false;
    }

    private static ServerEntry getServerEntry(Repository repository2, String string) throws ConfigurationWarning {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerEntry", new Object[]{repository2, string});
        }
        String string2 = repository2.getServerName();
        try {
            resource = repository2.getConfigRoot().getResource(3, string);
        }
        catch (Exception exception) {
            throw new ConfigurationWarning("Error loading " + string, exception);
        }
        EList eList = ((ServerIndex)resource.getContents().get(0)).getServerEntries();
        ServerEntry serverEntry = null;
        for (int i = 0; i < eList.size() && serverEntry == null; ++i) {
            ServerEntry serverEntry2 = (ServerEntry)eList.get(i);
            if (!serverEntry2.getServerName().equals(string2)) continue;
            serverEntry = serverEntry2;
        }
        if (serverEntry == null) {
            throw new ConfigurationWarning("Error loading server " + string2 + " in " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerEntry", serverEntry);
        }
        return serverEntry;
    }

    private DeployedApplicationImpl initializeApplication(Repository repository2, String string, String string2, boolean bl, boolean bl2) throws ConfigurationWarning, ConfigurationError {
        DeployedApplicationImpl deployedApplicationImpl;
        ConfigurationWarning configurationWarning;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeApplication", new Object[]{string, string2, bl});
            }
            int n = this.deployedApplications.size();
            for (int i = 0; i < n; ++i) {
                DeployedApplicationImpl deployedApplicationImpl2 = (DeployedApplicationImpl)this.deployedApplications.get(i);
                if (!deployedApplicationImpl2.getName().equals(string)) continue;
                Tr.warning(tc, "WSVR0214W", string);
                throw new ConfigurationWarning("Duplicate application, " + string + ". Application may already have been started.");
            }
            configurationWarning = null;
            deployedApplicationImpl = new DeployedApplicationImpl(string, string2, bl2);
            this.add(deployedApplicationImpl);
            boolean bl3 = false;
            try {
                deployedApplicationImpl.initialize(bl ? Boolean.TRUE : Boolean.FALSE);
                if (deployedApplicationImpl.getState() != "INITIALIZED") break block15;
                bl3 = true;
                this.deployedApplications.add(deployedApplicationImpl);
                try {
                    deployedApplicationImpl.addDeployedObjectAdjuster(this);
                    deployedApplicationImpl.addDeployedObjectListener(this);
                    deployedApplicationImpl.addDeployedObjectHandler(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    bl3 = true;
                    throw new ConfigurationError(tooManyListenersException);
                }
            }
            catch (ConfigurationWarning configurationWarning2) {
                Tr.warning(tc, "WSVR0100W", new Object[]{deployedApplicationImpl.getName(), configurationWarning2});
                configurationWarning = configurationWarning2;
            }
            catch (ConfigurationError configurationError) {
                Tr.error(tc, "WSVR0100W", new Object[]{deployedApplicationImpl.getName(), configurationError});
                throw configurationError;
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WSVR0100W", new Object[]{deployedApplicationImpl.getName(), throwable});
                throw new ConfigurationWarning(throwable);
            }
            finally {
                if (!bl3) {
                    this.destroyApplication(deployedApplicationImpl);
                }
            }
        }
        if (configurationWarning != null) {
            throw configurationWarning;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeApplication", new Object[]{string, string2, bl});
        }
        return deployedApplicationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start ", new Object[]{this, "#apps=" + this.deployedApplications.size()});
        }
        RuntimeWarning runtimeWarning = null;
        this.stopwatch.start("ApplicationMgrImpl : start");
        this.setState("STARTING");
        Server server2 = (Server)this._getService(Server.class);
        try {
            if (server2.getServerMode() != 1) {
                if (this.blockers != null) {
                    this.stopwatch.start("ApplicationMgrImpl : block services");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "waiting for " + this.blockingServices.size() + " services to arrive");
                    }
                    try {
                        this.blockers.reportingInterruptableJoin(10000);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof RuntimeError) {
                            FFDCFilter.processException(throwable, this.getClass().getName(), "319", this);
                            throw (RuntimeError)throwable;
                        }
                        runtimeWarning = new RuntimeWarning(throwable);
                    }
                    this.blockers = null;
                    this.blockingServices = null;
                    this.stopwatch.stop();
                }
                try {
                    this.initializeApplications();
                }
                catch (ConfigurationWarning configurationWarning) {
                    runtimeWarning = new RuntimeWarning(configurationWarning);
                }
                catch (ConfigurationError configurationError) {
                    FFDCFilter.processException(configurationError, this.getClass().getName(), "282");
                    throw new RuntimeError(configurationError.getMessage(), configurationError);
                }
                this.lookupNameSpaceBindStatus();
                Collections.sort(this.deployedApplications);
                this.startApplications();
            }
            this.setState("STARTED");
        }
        finally {
            this.releaseService(server2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start ");
            }
            this.stopwatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeApplications() throws ConfigurationError, ConfigurationWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeApplications");
        }
        this.stopwatch.start("ApplicationMgrImpl : initializing applications");
        ConfigurationWarning configurationWarning = null;
        try {
            Repository repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
            try {
                this.initializeApplications(repository2, false);
            }
            catch (ConfigurationWarning configurationWarning2) {
                FFDCFilter.processException(configurationWarning2, this.getClass().getName(), "337");
                configurationWarning = configurationWarning2;
            }
            try {
                this.initializeApplications(repository2, true);
            }
            catch (ConfigurationWarning configurationWarning3) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName(), "441", this);
            configurationWarning = new ConfigurationWarning(exception);
        }
        finally {
            this.stopwatch.stop();
        }
        if (configurationWarning != null) {
            throw configurationWarning;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeApplications");
        }
    }

    private void initializeApplications(Repository repository2, boolean bl) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeApplications", bl);
        }
        Hashtable hashtable = new Hashtable();
        ArrayList arrayList = new ArrayList();
        String string = bl ? SYSTEMAPPS : SERVERINDEX;
        ServerEntry serverEntry = ApplicationMgrImpl.getServerEntry(repository2, string);
        EList eList = serverEntry.getDeployedApplications();
        int n = 0;
        ConfigurationWarning configurationWarning = null;
        int n2 = eList.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)eList.get(i);
            if (bl) {
                try {
                    string2 = this.expandVariable(string2);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "655");
                    string2 = null;
                }
                if (string2 == null) {
                    string2 = (String)eList.get(i);
                }
            }
            String string3 = string2;
            try {
                if (bl) {
                    string3 = string3.substring(string3.lastIndexOf(47) + 1);
                    string3 = string3.substring(0, string3.lastIndexOf(EAR_EXTENSION));
                } else {
                    string3 = string2.substring(0, string2.indexOf(47) - EAR_EXTENSION.length());
                }
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "asked to start --> " + string2);
                    }
                    if (!this.isActiveEditionApp(string2, repository2, (List)eList, hashtable, arrayList)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, string2 + " Not Active");
                        continue;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InitializeApp " + string3 + "  " + string2 + "  systemapp = " + bl);
                }
                this.initializeApplication(repository2, string3, string2, true, bl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "couldnt process deployment name", string2);
                }
                FFDCFilter.processException(indexOutOfBoundsException, this.getClass().getName(), "393");
                string3 = string2;
                continue;
            }
            catch (ConfigurationWarning configurationWarning2) {
                FFDCFilter.processException(configurationWarning2, this.getClass().getName(), "412");
                ++n;
                configurationWarning = configurationWarning2;
                continue;
            }
            catch (ConfigurationError configurationError) {
                throw configurationError;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "417");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " configuration errors encountered", throwable);
                }
                throw new ConfigurationWarning("Unable to start applications due to unexpected exception");
            }
        }
        if (n != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n + " configuration warnings encountered");
            }
            throw new ConfigurationWarning("Multiple ConfigurationWarning exceptions encountered", configurationWarning);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeApplications", bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startApplications() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startApplications", new Integer(this.deployedApplications.size()));
        }
        this.stopwatch.start("ApplicationMgrImpl : start applications");
        RuntimeWarning runtimeWarning = null;
        DeployedApplicationImpl[] deployedApplicationImplArray = this.deployedApplications.toArray(new DeployedApplicationImpl[this.deployedApplications.size()]);
        int n = -1;
        for (int i = 0; i < deployedApplicationImplArray.length; ++i) {
            if (n != deployedApplicationImplArray[i].getWeight()) {
                try {
                    this.stopwatch.start("ApplicationMgrImpl : joining weight");
                    this.join();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "317");
                    runtimeWarning = new RuntimeWarning(throwable);
                }
                finally {
                    this.stopwatch.stop();
                }
            }
            try {
                this.stopwatch.start("ApplicationMgrImpl : starting " + deployedApplicationImplArray[i].getName());
                this.runAsynchronousInitializer(new AppInitializer(deployedApplicationImplArray[i]), !deployedApplicationImplArray[i].isBackgroundApp());
            }
            catch (WsRuntimeFwException wsRuntimeFwException) {
                FFDCFilter.processException(wsRuntimeFwException, this.getClass().getName(), "327");
                runtimeWarning = wsRuntimeFwException instanceof RuntimeWarning ? (RuntimeWarning)wsRuntimeFwException : new RuntimeWarning(wsRuntimeFwException);
            }
            finally {
                this.stopwatch.stop();
            }
            n = deployedApplicationImplArray[i].getWeight();
        }
        try {
            this.stopwatch.start("ApplicationMgrImpl : joining weight");
            this.join();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName(), "348");
            runtimeWarning = new RuntimeWarning(throwable);
        }
        finally {
            this.stopwatch.stop();
        }
        this.stopwatch.stop();
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startApplications");
        }
    }

    private void lookupNameSpaceBindStatus() {
        if (isZOS && !isCRA && this.nameSpaceBindStatus == null) {
            ORB oRB = null;
            try {
                com.ibm.CORBA.iiop.ORB oRB2 = null;
                oRB = (ORB)WsServiceRegistry.getService((Object)this, (Class)ORB.class);
                if (oRB != null && (oRB2 = oRB.getORB()) != null) {
                    String string = "WSNameSpaceBindStatus";
                    this.nameSpaceBindStatus = NameSpaceBindStatusHelper.narrow(oRB2.resolve_initial_references(string));
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.runtime.component.ApplicationMgrImpl.updateDoBind", "845");
            }
        }
    }

    private void updateAllowNamingOps(String string, boolean bl) {
        if (this.nameSpaceBindStatus == null) {
            this.allowNamingOps = !isCRA;
        } else {
            boolean bl2 = this.allowNamingOps = bl ? this.nameSpaceBindStatus.bindApplication(string) : this.nameSpaceBindStatus.unbindApplication(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allowNamingOps = " + this.allowNamingOps + " (" + string + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startApplication(DeployedApplicationImpl deployedApplicationImpl) throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startApplication", new Object[]{deployedApplicationImpl, this});
        }
        String string = deployedApplicationImpl.getName();
        if (EditionHelper.isEditionSupportEnabled()) {
            String string2 = deployedApplicationImpl.getAppDeploymentName();
            String[] stringArray = string2.split("/");
            string = stringArray[2];
        }
        boolean bl = false;
        try {
            int n = this.deployedApplicationFilters.size();
            for (int i = 0; i < n; ++i) {
                DeployedApplicationFilter deployedApplicationFilter = (DeployedApplicationFilter)this.deployedApplicationFilters.get(i);
                if (deployedApplicationFilter.applicationMayStart(deployedApplicationImpl)) continue;
                throw new RuntimeWarning("could not start application " + string + " because of filter " + deployedApplicationFilter);
            }
            String string3 = deployedApplicationImpl.getEARFile().getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            Tr.audit(tc, "WSVR0200I", string);
            if (string3 != null) {
                Tr.audit(tc, "WSVR0203I", new Object[]{string, string3});
            } else {
                Tr.audit(tc, "WSVR0204I", string);
            }
            try {
                this.updateAllowNamingOps(deployedApplicationImpl.getName(), true);
                deployedApplicationImpl.start();
                deployedApplicationImpl.addClassLoaderListener(new ApplicationNotifier(deployedApplicationImpl));
                Tr.audit(tc, "WSVR0221I", string);
                bl = true;
            }
            finally {
                if (!bl) {
                    try {
                        this.stopApplication(deployedApplicationImpl);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, this.getClass().getName(), "964", this);
                    }
                }
            }
        }
        catch (RuntimeWarning runtimeWarning) {
            Tr.warning(tc, "WSVR0101W", string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception", runtimeWarning);
            }
            throw runtimeWarning;
        }
        catch (RuntimeError runtimeError) {
            Tr.error(tc, "WSVR0101W", string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception", runtimeError);
            }
            throw runtimeError;
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0101W", string);
            FFDCFilter.processException(throwable, this.getClass().getName(), "972", this);
            throw new RuntimeError(throwable);
        }
        finally {
            if (!bl) {
                try {
                    ApplicationMgrImpl applicationMgrImpl = this;
                    synchronized (applicationMgrImpl) {
                        this.destroyApplication(deployedApplicationImpl);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "996", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startApplication");
        }
    }

    protected void registerMBean() {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this, "ApplicationManager");
            mBeanFactory.activateMBean("ApplicationManager", defaultRuntimeCollaborator, "ApplicationManager");
        }
        catch (Throwable throwable) {
            Tr.service(tc, "Attempting to register MBean:", throwable);
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", new Object[]{this});
        }
        this.setState("STOPPING");
        this.allowNamingOps = false;
        for (int i = this.deployedApplications.size() - 1; i >= 0; --i) {
            DeployedApplicationImpl deployedApplicationImpl = (DeployedApplicationImpl)this.deployedApplications.get(i);
            if (deployedApplicationImpl.getState() != "STARTED") continue;
            try {
                this.stopApplication(deployedApplicationImpl);
                continue;
            }
            catch (RuntimeWarning runtimeWarning) {
                FFDCFilter.processException(runtimeWarning, (class$com$ibm$ws$runtime$component$ApplicationMgrImpl == null ? ApplicationMgrImpl.class$("com.ibm.ws.runtime.component.ApplicationMgrImpl") : class$com$ibm$ws$runtime$component$ApplicationMgrImpl).getName(), "525");
            }
        }
        this.setState("STOPPED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    protected void stopApplication(DeployedApplicationImpl deployedApplicationImpl) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopApplication", new Object[]{deployedApplicationImpl, this});
        }
        boolean bl = this._canStopApplication(deployedApplicationImpl);
        String string = deployedApplicationImpl.getName();
        if (EditionHelper.isEditionSupportEnabled()) {
            String string2 = deployedApplicationImpl.getAppDeploymentName();
            String[] stringArray = string2.split("/");
            string = stringArray[2];
        }
        if (bl) {
            try {
                Tr.audit(tc, "WSVR0217I", string);
                deployedApplicationImpl.stop();
                Tr.audit(tc, "WSVR0220I", string);
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WSVR0102E", new Object[]{string, throwable});
            }
        } else {
            Tr.error(tc, "WSVR0102E", new Object[]{string});
            throw new RuntimeWarning("Could not stop application " + string + " (filtered)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopApplication");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", new Object[]{this});
        }
        this.setState("DESTROYING");
        for (int i = this.deployedApplications.size() - 1; i >= 0; --i) {
            DeployedApplicationImpl deployedApplicationImpl = (DeployedApplicationImpl)this.deployedApplications.get(i);
            this.destroyApplication(deployedApplicationImpl);
        }
        this.deployedApplications.clear();
        this.setState("DESTROYED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    protected void destroyApplication(DeployedApplicationImpl deployedApplicationImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyApplication", new Object[]{deployedApplicationImpl, this});
        }
        try {
            deployedApplicationImpl.destroy();
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0102E", new Object[]{deployedApplicationImpl.getName(), throwable});
        }
        deployedApplicationImpl.removeDeployedObjectAdjuster(this);
        deployedApplicationImpl.removeDeployedObjectListener(this);
        deployedApplicationImpl.removeDeployedObjectHandler(this);
        this.remove(deployedApplicationImpl);
        this.deployedApplications.remove(deployedApplicationImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyApplication");
        }
    }

    public void addDeployedObjectListener(DeployedObjectListener deployedObjectListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addDeployedObjectListener", new Object[]{deployedObjectListener, this});
        }
        if (deployedObjectListener == null) {
            throw new IllegalArgumentException("null " + DeployedObjectListener.class.getName());
        }
        this.deployedObjectListeners.add(deployedObjectListener);
    }

    public void removeDeployedObjectListener(DeployedObjectListener deployedObjectListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDeployedObjectListener", new Object[]{deployedObjectListener, this});
        }
        this.deployedObjectListeners.remove(deployedObjectListener);
    }

    public void addDeployedObjectAdjuster(DeployedObjectAdjuster deployedObjectAdjuster) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addDeployedObjectAdjuster", new Object[]{deployedObjectAdjuster, this});
        }
        if (deployedObjectAdjuster == null) {
            throw new IllegalArgumentException("null " + DeployedObjectAdjuster.class.getName());
        }
        this.deployedObjectAdjusters.add(deployedObjectAdjuster);
    }

    public void removeDeployedObjectAdjuster(DeployedObjectAdjuster deployedObjectAdjuster) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDeployedObjectAdjuster", new Object[]{deployedObjectAdjuster, this});
        }
        this.deployedObjectAdjusters.remove(deployedObjectAdjuster);
    }

    public void adjust(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjust", new Object[]{deployedObjectEvent, this});
        }
        RuntimeWarning runtimeWarning = null;
        int n = this.deployedObjectAdjusters.size();
        for (int i = 0; i < n; ++i) {
            try {
                ((DeployedObjectAdjuster)this.deployedObjectAdjusters.get(i)).adjust(deployedObjectEvent);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "deployed object adjusted", new Object[]{this.deployedObjectAdjusters.get(i), deployedObjectEvent});
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjusted");
        }
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        RuntimeWarning runtimeWarning = null;
        for (int i = 0; i < this.deployedObjectListeners.size(); ++i) {
            try {
                ((DeployedObjectListener)this.deployedObjectListeners.get(i)).stateChanged(deployedObjectEvent);
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    public void addDeployedObjectHandler(DeployedObjectHandler deployedObjectHandler) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addDeployedObjectHandler", new Object[]{deployedObjectHandler, this});
        }
        if (deployedObjectHandler == null) {
            throw new IllegalArgumentException("null " + DeployedObjectHandler.class.getName());
        }
        this.deployedObjectHandlers.add(deployedObjectHandler);
    }

    public void removeDeployedObjectHandler(DeployedObjectHandler deployedObjectHandler) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDeployedObjectHandler", new Object[]{deployedObjectHandler, this});
        }
        this.deployedObjectHandlers.remove(deployedObjectHandler);
    }

    public boolean start(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start(DeployedObjectEvent)", new Object[]{deployedObjectEvent, this});
        }
        RuntimeWarning runtimeWarning = null;
        boolean bl = false;
        for (int i = 0; i < this.deployedObjectHandlers.size(); ++i) {
            try {
                bl |= ((DeployedObjectHandler)this.deployedObjectHandlers.get(i)).start(deployedObjectEvent);
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start(DeployedObjectEvent)", new Boolean(bl));
        }
        return bl;
    }

    public void stop(DeployedObjectEvent deployedObjectEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop(DeployedObjectEvent)", new Object[]{deployedObjectEvent, this});
        }
        for (int i = 0; i < this.deployedObjectHandlers.size(); ++i) {
            ((DeployedObjectHandler)this.deployedObjectHandlers.get(i)).stop(deployedObjectEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop(DeployedObjectEvent)", new Object[]{deployedObjectEvent, this});
        }
    }

    private static String getAppNameIfActiveEdition(String string, Repository repository2) throws ConfigurationError {
        String string2;
        String string3;
        String string4 = EditionHelper.getAppAndEdition(string)[0];
        Properties properties = ApplicationMgrImpl.getEditionProps(string4, repository2);
        if (properties != null && ((string3 = (String)properties.get(string2 = EditionHelper.getEditionStatePropName(string))) == null || !string3.equals("ACTIVE") && !string3.equals("VALIDATE"))) {
            return null;
        }
        return string4;
    }

    private static String getInstalledAppDeploymentName(String string, String string2, Repository repository2) throws ConfigurationWarning {
        ServerEntry serverEntry = ApplicationMgrImpl.getServerEntry(repository2, SERVERINDEX);
        EList eList = serverEntry.getDeployedApplications();
        Object var5_5 = null;
        int n = eList.size();
        for (int i = 0; var5_5 == null && i < n; ++i) {
            String string3 = (String)eList.get(i);
            if (!string3.startsWith(string2) || !string3.regionMatches(string2.length(), EAR_EXTENSION, 0, EAR_EXTENSION.length()) || string3.charAt(string2.length() + EAR_EXTENSION.length()) != '/' || !string3.endsWith(string)) continue;
            return string3;
        }
        return null;
    }

    public synchronized void startApplication(String string) throws ConfigurationWarning, ConfigurationError, RuntimeWarning, RuntimeError {
        block16: {
            DeployedApplicationImpl deployedApplicationImpl;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startApplication", new Object[]{string, this});
            }
            AdminHelper.getInstance().audit("ADMN1008I", "ADMN1009I", new Object[]{string, null});
            Repository repository2 = (Repository)this._getService(Repository.class);
            boolean bl = false;
            String string2 = string;
            if (EditionHelper.isEditionSupportEnabled()) {
                string = ApplicationMgrImpl.getAppNameIfActiveEdition(string2, repository2);
                if (string == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "startApplication");
                    }
                    throw new ConfigurationError("Application " + string + " is not active");
                }
                object4 = this.getDeployedApplication(string);
                if (object4 != null) {
                    String string3 = ((DeployedApplicationImpl)object4).getAppDeploymentName();
                    String[] stringArray = string3.split("/");
                    String string4 = "Another application edition " + stringArray[2] + " is running.  Please stop it first.  Failed to start application edition " + string2 + ".";
                    Tr.warning(tc, "WSVR0207W", new Object[]{stringArray[2], string2});
                    throw new ConfigurationWarning(string4);
                }
            }
            if ((object4 = ApplicationMgrImpl.getInstalledAppDeploymentName(string2, string, repository2)) == null) {
                try {
                    object3 = ApplicationMgrImpl.getServerEntry(repository2, SYSTEMAPPS);
                    object2 = object3.getDeployedApplications();
                    int n = object2.size();
                    for (int i = 0; object4 == null && i < n; ++i) {
                        String string5 = (String)object2.get(i);
                        if (string5.indexOf(string) < 0) continue;
                        object = string5;
                        object = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
                        if (!string.equals(object = ((String)object).substring(0, ((String)object).lastIndexOf(EAR_EXTENSION)))) continue;
                        object4 = string5;
                        bl = true;
                    }
                }
                catch (ConfigurationWarning configurationWarning) {
                    FFDCFilter.processException(configurationWarning, this.getClass().getName(), "1094");
                }
            }
            if (object4 == null) {
                Tr.warning(tc, "WSVR0215W", string);
                throw new ConfigurationWarning("Application " + string + " not installed");
            }
            object3 = (VariableMap)this._getService(VariableMap.class);
            object3.refresh();
            object2 = object3.expand((String)object4);
            if (object2 != null) {
                object4 = object2;
            }
            if ((deployedApplicationImpl = this.initializeApplication(repository2, string, (String)object4, false, bl)) != null) {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        VirtualHostMgr virtualHostMgr = (VirtualHostMgr)ApplicationMgrImpl.this._getService(class$com$ibm$ws$runtime$service$VirtualHostMgr == null ? (class$com$ibm$ws$runtime$service$VirtualHostMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.VirtualHostMgr")) : class$com$ibm$ws$runtime$service$VirtualHostMgr);
                        virtualHostMgr.reload();
                        ResourceMgr resourceMgr = (ResourceMgr)ApplicationMgrImpl.this._getService(class$com$ibm$ws$runtime$service$ResourceMgr == null ? (class$com$ibm$ws$runtime$service$ResourceMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ResourceMgr")) : class$com$ibm$ws$runtime$service$ResourceMgr);
                        LibraryMgr libraryMgr = (LibraryMgr)ApplicationMgrImpl.this._getService(class$com$ibm$ws$runtime$service$LibraryMgr == null ? (class$com$ibm$ws$runtime$service$LibraryMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.LibraryMgr")) : class$com$ibm$ws$runtime$service$LibraryMgr);
                        try {
                            resourceMgr.reload();
                            libraryMgr.refresh();
                        }
                        catch (RuntimeError runtimeError) {
                        }
                        catch (RuntimeWarning runtimeWarning) {
                            // empty catch block
                        }
                        ApplicationMgrImpl.this.startApplication(deployedApplicationImpl);
                        return null;
                    }
                };
                try {
                    SecurityContext.runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    object = privilegedActionException.getCause();
                    FFDCFilter.processException((Throwable)object, this.getClass().getName(), "1449", this);
                    if (object instanceof RuntimeWarning) {
                        throw (RuntimeWarning)object;
                    }
                    if (!(object instanceof RuntimeError)) break block16;
                    throw (RuntimeError)object;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startApplication", new Object[]{string, this});
        }
    }

    private Object _getService(Class clazz) throws RuntimeWarning {
        try {
            return WsServiceRegistry.getService((Object)this, (Class)clazz);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName(), "1181", this);
            throw new RuntimeWarning(exception);
        }
    }

    public synchronized void stopApplication(String object) throws RuntimeWarning {
        double d;
        block16: {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopApplication", new Object[]{object, this, new Boolean(EditionHelper.isEditionSupportEnabled())});
            }
            AdminHelper.getInstance().audit("ADMN1010I", "ADMN1011I", new Object[]{object, null});
            String string = object;
            if (EditionHelper.isEditionSupportEnabled()) {
                object5 = (Repository)this._getService(Repository.class);
                object4 = EditionHelper.getAppAndEdition(string);
                try {
                    object3 = ApplicationMgrImpl.getEditionProps(object4[0], (Repository)object5);
                    if (object3 != null) {
                        object2 = EditionHelper.getEditionStatePropName(string);
                        String string2 = (String)((Properties)object3).get(object2);
                        if (string2 == null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "stopApplication");
                            }
                            throw new RuntimeWarning("Application " + (String)object + " is not active");
                        }
                        if (!string2.equalsIgnoreCase("ACTIVE") && !string2.equalsIgnoreCase("VALIDATE")) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "stopApplication");
                            }
                            throw new RuntimeWarning("Application " + (String)object + " is not active");
                        }
                    }
                }
                catch (Exception exception) {
                    Tr.debug(tc, exception.getMessage());
                }
                object = object4[0];
            }
            if ((object5 = this.getDeployedApplication((String)object)) == null) {
                Tr.warning(tc, "WSVR0216W", object);
                throw new RuntimeWarning("Application " + (String)object + " not started");
            }
            if (EditionHelper.isEditionSupportEnabled() && !(object3 = ((String)(object4 = ((DeployedApplicationImpl)object5).getAppDeploymentName())).split("/"))[2].equalsIgnoreCase(string)) {
                throw new RuntimeWarning("Application " + string + " is not running or active. Cannot be stopped");
            }
            this.updateAllowNamingOps((String)object, false);
            object4 = new PrivilegedExceptionAction((DeployedApplicationImpl)object5){
                private final /* synthetic */ DeployedApplicationImpl val$dai;
                {
                    this.val$dai = deployedApplicationImpl;
                }

                public Object run() throws Exception {
                    ApplicationMgrImpl.this.stopApplication(this.val$dai);
                    ApplicationMgrImpl.this.destroyApplication(this.val$dai);
                    return null;
                }
            };
            try {
                SecurityContext.runAsSystem((PrivilegedExceptionAction)object4);
            }
            catch (PrivilegedActionException privilegedActionException) {
                object2 = privilegedActionException.getCause();
                FFDCFilter.processException((Throwable)object2, this.getClass().getName(), "1670", this);
                if (!(object2 instanceof RuntimeWarning)) break block16;
                throw (RuntimeWarning)object2;
            }
        }
        Introspector.flushCaches();
        if (tc.isDebugEnabled()) {
            long l = Runtime.getRuntime().freeMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            d = (double)l / (double)l2;
            Tr.debug(tc, "Before GC and finalization: JVM free memory/JVM total memory = " + l + "/" + l2 + " = " + d);
        }
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
        if (tc.isDebugEnabled()) {
            long l = Runtime.getRuntime().freeMemory();
            long l3 = Runtime.getRuntime().totalMemory();
            d = (double)l / (double)l3;
            Tr.debug(tc, "After GC and finalization: JVM free memory/JVM total memory = " + l + "/" + l3 + " = " + d);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopApplication", new Object[]{object, this});
        }
    }

    private DeployedApplicationImpl getDeployedApplication(String string) {
        DeployedApplicationImpl deployedApplicationImpl = null;
        int n = this.deployedApplications.size();
        for (int i = 0; deployedApplicationImpl == null && i < n; ++i) {
            DeployedApplicationImpl deployedApplicationImpl2 = (DeployedApplicationImpl)this.deployedApplications.get(i);
            if (!deployedApplicationImpl2.getName().equals(string)) continue;
            deployedApplicationImpl = deployedApplicationImpl2;
        }
        return deployedApplicationImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void _startModule(String string, String string2) throws RuntimeError, RuntimeWarning {
        Tr.info(tc, "WSVR0225I", new Object[]{string, string2});
        try {
            DeployedApplicationImpl deployedApplicationImpl = this.getDeployedApplication(string);
            ClassLoaderManager classLoaderManager = deployedApplicationImpl.getClassLoaderManager();
            if (deployedApplicationImpl == null || deployedApplicationImpl.getState() != "STARTED") throw new RuntimeError("Unable to start module, application not in STARTED state");
            List list = deployedApplicationImpl.getModules();
            DeployedModule deployedModule = this.getModule(list, string2);
            if (deployedModule == null) {
                try {
                    deployedApplicationImpl.initializeForUpdateOrAdd(string2);
                }
                catch (ConfigurationWarning configurationWarning) {
                    configurationWarning.printStackTrace();
                    throw new RuntimeError("Unable to parse configuration info for new module", configurationWarning);
                }
                catch (ConfigurationError configurationError) {
                    configurationError.printStackTrace();
                    throw new RuntimeError("Unable to parse configuration info for new module", configurationError);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, ApplicationMgrImpl.class.getName(), "747");
                    throw new RuntimeError("Unable to start new module", throwable);
                }
            } else {
                Tr.error(tc, "WSVR0224E", new Object[]{this.getModule(list, string2).getName(), this.getModule(list, string2).getDeployedApplication().getName()});
                RuntimeError runtimeError = new RuntimeError("Internal Error: Unable to start module");
                FFDCFilter.processException(runtimeError, ApplicationMgrImpl.class.getName(), "757");
                throw runtimeError;
            }
            list = deployedApplicationImpl.getModules();
            this.startModule(classLoaderManager, (DeployedModuleImpl)this.getModule(list, string2), "INITIALIZED");
            return;
        }
        catch (RuntimeError runtimeError) {
            throw runtimeError;
        }
        catch (RuntimeWarning runtimeWarning) {
            throw runtimeWarning;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FFDCFilter.processException(throwable, ApplicationMgrImpl.class.getName(), "767");
            throw new RuntimeError("Unable to process request to start module");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startModule(ClassLoaderManager classLoaderManager, DeployedModuleImpl deployedModuleImpl, String string) throws RuntimeError, RuntimeWarning {
        if (deployedModuleImpl == null) throw new RuntimeError("Unable to start module, the specified module was not found");
        if (deployedModuleImpl.getState() != string) throw new RuntimeError("Unable to start module, module not in " + string + " state");
        if (deployedModuleImpl.allowsThisModuleOperation(DeployedModuleImpl.START_MODULE_REQUEST)) {
            JarClassLoader jarClassLoader = (JarClassLoader)classLoaderManager.lookupClassLoader((com.ibm.etools.commonarchive.ModuleRef)deployedModuleImpl.getModuleRef());
            if (jarClassLoader == null) {
                classLoaderManager.addNewModule((com.ibm.etools.commonarchive.ModuleRef)deployedModuleImpl.getModuleRef());
            }
        } else {
            Tr.error(tc, "WSVR0224E", new Object[]{deployedModuleImpl.getName(), deployedModuleImpl.getDeployedApplication().getName()});
            throw new RuntimeWarning("unable to start module " + deployedModuleImpl.getName());
        }
        deployedModuleImpl.start();
        Tr.info(tc, "WSVR0226I", new Object[]{deployedModuleImpl.getDeployedApplication().getName(), deployedModuleImpl.getName()});
    }

    private DeployedModule getModule(List list, String string) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DeployedModule deployedModule = (DeployedModule)iterator.next();
                if (!deployedModule.getName().trim().equalsIgnoreCase(string.trim())) continue;
                return deployedModule;
            }
        }
        return null;
    }

    public synchronized void _stopModule(String string, String string2) throws RuntimeError, RuntimeWarning {
        Tr.info(tc, "WSVR0227I", new Object[]{string, string2});
        DeployedApplicationImpl deployedApplicationImpl = this.getDeployedApplication(string);
        if (deployedApplicationImpl != null && deployedApplicationImpl.getState() == "STARTED") {
            List list = deployedApplicationImpl.getModules();
            boolean bl = false;
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DeployedModuleImpl deployedModuleImpl = (DeployedModuleImpl)iterator.next();
                    if (!deployedModuleImpl.getName().trim().equalsIgnoreCase(string2.trim())) continue;
                    bl = true;
                    if (deployedModuleImpl.getState() == "STARTED") {
                        if (deployedModuleImpl.allowsThisModuleOperation(DeployedModuleImpl.STOP_MODULE_REQUEST)) {
                            deployedModuleImpl.stop();
                            deployedApplicationImpl.removeModule(deployedModuleImpl);
                            Tr.info(tc, "WSVR0228I", new Object[]{string, string2});
                            break;
                        }
                        Tr.error(tc, "WSVR0223E", new Object[]{string2, string});
                        throw new RuntimeWarning("unable to stop module " + string2);
                    }
                    throw new RuntimeError("Unable to stop module, module not in STARTED state");
                }
            }
            if (!bl) {
                throw new RuntimeError("Unable to stop module, the specified module was not found");
            }
        } else {
            throw new RuntimeError("Unable to stop module, application not in STARTED state");
        }
    }

    protected void setState(String string) {
        try {
            super.setState(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.getClass().getName(), "532");
        }
    }

    public void setExtraProcessing(boolean bl) {
        this.extraProcessing = bl;
    }

    public boolean getExtraProcessing() {
        return this.extraProcessing;
    }

    public void applicationInstalled(String string) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applicationInstalled", new Object[]{string, this});
        }
        Repository repository2 = null;
        try {
            Resource resource;
            repository2 = (Repository)this._getService(Repository.class);
            String string2 = string;
            if (EditionHelper.isEditionSupportEnabled() && (string = ApplicationMgrImpl.getAppNameIfActiveEdition(string2, repository2)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "applicationInstalled");
                }
                return;
            }
            String string3 = ApplicationMgrImpl.getInstalledAppDeploymentName(string2, string, repository2);
            if (string3 == null) {
                throw new ConfigurationWarning("Application " + string + " not installed");
            }
            ConfigRoot configRoot = repository2.getConfigRoot();
            configRoot.setValue(1, string3);
            try {
                resource = configRoot.getResource(1, "deployment.xml");
            }
            catch (Exception exception) {
                Tr.error(tc, "WSVR0100W", new Object[]{string2, exception});
                throw new ConfigurationWarning("Error loading deployment.xml for " + string2, exception);
            }
            Deployment deployment = (Deployment)resource.getContents().get(0);
            ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
            String string4 = this.expandVariable(applicationDeployment.getBinariesURL());
            Properties properties = new Properties();
            Server server2 = (Server)this._getService(Server.class);
            properties.put("Server", server2.getName());
            properties.put("J2EEName", string);
            J2EEApplication j2EEApplication = new J2EEApplication(string4, "META-INF/application.xml", 3);
            this.registerMBean("J2EEApplication", j2EEApplication, string, this.getConfigId(applicationDeployment), properties);
        }
        catch (ConfigurationWarning configurationWarning) {
            FFDCFilter.processException(configurationWarning, this.getClass().getName() + ".applicationInstalled", "639");
            throw configurationWarning;
        }
        catch (ConfigurationError configurationError) {
            FFDCFilter.processException(configurationError, this.getClass().getName() + ".applicationInstalled", "642");
            throw configurationError;
        }
        catch (RuntimeWarning runtimeWarning) {
            throw new ConfigurationWarning(runtimeWarning);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applicationInstalled", new Object[]{string, this});
        }
    }

    public void applicationUninstalled(String string) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applicationUninstalled", new Object[]{string, this});
        }
        String string2 = "WebSphere:j2eeType=J2EEApplication,J2EEName=" + string + ",*";
        this.deregisterMBeanViaQuery(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applicationUninstalled", new Object[]{string, this});
        }
    }

    public void _applicationInstalled(String string) throws ConfigurationWarning, ConfigurationError {
        this.applicationInstalled(string);
    }

    public void _applicationUninstalled(String string) throws ConfigurationWarning, ConfigurationError {
        this.applicationUninstalled(string);
    }

    public boolean doBind() {
        return this.allowNamingOps;
    }

    public boolean doUnBind() {
        return this.allowNamingOps;
    }

    public NameSpaceBindStatus getNameSpaceBindStatus() {
        return this.nameSpaceBindStatus;
    }

    public void setNameSpaceBindStatus(NameSpaceBindStatus nameSpaceBindStatus) {
        this.nameSpaceBindStatus = nameSpaceBindStatus;
    }

    public void addDeployedApplicationFilter(DeployedApplicationFilter deployedApplicationFilter) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addDeployedApplicationFilter", new Object[]{deployedApplicationFilter, this});
        }
        if (deployedApplicationFilter == null) {
            throw new IllegalArgumentException("null " + DeployedApplicationFilter.class.getName());
        }
        this.deployedApplicationFilters.add(deployedApplicationFilter);
    }

    public void removeDeployedApplicationFilter(DeployedApplicationFilter deployedApplicationFilter) {
        this.deployedApplicationFilters.remove(deployedApplicationFilter);
    }

    public void serviceIsReady(Class clazz, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serviceIsReady", new Object[]{clazz, throwable});
        }
        if (!this.blockingServices.contains(clazz)) {
            throw new IllegalStateException("INTERNAL ERROR: blocking service " + clazz + " was never registered");
        }
        if (throwable instanceof RuntimeError) {
            this.blockers.interrupt(throwable);
        }
        this.blockingServices.remove(clazz);
        this.blockers.decrement();
    }

    public void waitForService(Class clazz) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForService", clazz);
        }
        if (!this.getState().equals("INITIALIZED")) {
            throw new IllegalStateException("INTERNAL ERROR: could not register blocking service " + clazz + " because the Application Manager is not initialized.");
        }
        if (this.blockers == null) {
            this.blockers = new BlockerJoin();
        }
        if (this.blockingServices == null) {
            this.blockingServices = Collections.synchronizedList(new ArrayList());
        }
        if (this.blockingServices.contains(clazz)) {
            throw new IllegalStateException("INTERNAL ERROR: blocking service " + clazz + " has already been initialized");
        }
        this.blockers.increment();
        this.blockingServices.add(clazz);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForService", clazz);
        }
    }

    public void releaseService(Object object) {
    }

    public void serviceIsReady(Class clazz) {
        this.serviceIsReady(clazz, null);
    }

    public synchronized Boolean _canStopApplication(String string) throws RuntimeWarning {
        Object object;
        block16: {
            Object object2;
            Object object3;
            Object object4;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_canStopApplication", new Object[]{string, this, new Boolean(EditionHelper.isEditionSupportEnabled())});
            }
            String string2 = string;
            if (EditionHelper.isEditionSupportEnabled()) {
                object4 = (Repository)this._getService(Repository.class);
                object = EditionHelper.getAppAndEdition(string2);
                try {
                    object3 = ApplicationMgrImpl.getEditionProps(object[0], (Repository)object4);
                    if (object3 != null) {
                        String string3 = EditionHelper.getEditionStatePropName(string2);
                        object2 = (String)((Properties)object3).get(string3);
                        if (object2 == null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "_canStopApplication");
                            }
                            throw new RuntimeWarning("Application " + string + " is not active");
                        }
                        if (!((String)object2).equalsIgnoreCase("ACTIVE") && !((String)object2).equalsIgnoreCase("VALIDATE")) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "_canStopApplication");
                            }
                            throw new RuntimeWarning("Application " + string + " is not active");
                        }
                    }
                }
                catch (Exception exception) {
                    Tr.debug(tc, exception.getMessage());
                }
                string = object[0];
            }
            if (string == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_canStopApplication");
                }
                throw new RuntimeWarning("Application " + string + " is not active");
            }
            object4 = this.getDeployedApplication(string);
            if (object4 == null) {
                Tr.warning(tc, "WSVR0216W", string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_canStopApplication(String)", string);
                }
                throw new RuntimeWarning("Application " + string + " not started");
            }
            object = new Boolean(false);
            object3 = new PrivilegedExceptionAction((DeployedApplicationImpl)object4){
                private final /* synthetic */ DeployedApplicationImpl val$dai;
                {
                    this.val$dai = deployedApplicationImpl;
                }

                public Object run() throws Exception {
                    return new Boolean(ApplicationMgrImpl.this._canStopApplication(this.val$dai));
                }
            };
            try {
                object = (Boolean)SecurityContext.runAsSystem((PrivilegedExceptionAction)object3);
            }
            catch (PrivilegedActionException privilegedActionException) {
                object2 = privilegedActionException.getCause();
                FFDCFilter.processException((Throwable)object2, this.getClass().getName(), "1603", this);
                if (!(object2 instanceof RuntimeWarning)) break block16;
                throw (RuntimeWarning)object2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_canStopApplication", new Object[]{string, this, object});
        }
        return object;
    }

    protected boolean _canStopApplication(DeployedApplicationImpl deployedApplicationImpl) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_canStopApplication", new Object[]{deployedApplicationImpl, this});
        }
        boolean bl = true;
        if ("STARTED".equals(this.getState())) {
            int n = this.deployedApplicationFilters.size();
            for (int i = 0; i < n && bl; ++i) {
                DeployedApplicationFilter deployedApplicationFilter = (DeployedApplicationFilter)this.deployedApplicationFilters.get(i);
                if (deployedApplicationFilter.applicationMayStop(deployedApplicationImpl)) continue;
                bl = false;
                FFDCFilter.processException(new Exception("could not stop application" + deployedApplicationImpl.getName() + " because of filter " + deployedApplicationFilter.toString()), (class$com$ibm$ws$runtime$service$ApplicationMgr == null ? ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ApplicationMgr") : class$com$ibm$ws$runtime$service$ApplicationMgr).getName(), "385");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_canStopApplication", new Object[]{deployedApplicationImpl, new Boolean(bl)});
        }
        return bl;
    }

    static {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        isZOS = platformHelper.isZOS();
        isCRA = isZOS && platformHelper.isCRAJvm();
    }

    private class BlockerJoin
    extends Join {
        private BlockerJoin() {
        }

        public synchronized void reportingInterruptableJoin(int n) throws Throwable {
            while (this.getValue() > 0 && this.interruptReason == null) {
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    this.interruptReason = interruptedException;
                }
                if (!tc.isDebugEnabled()) continue;
                for (int i = ApplicationMgrImpl.this.blockingServices.size() - 1; i >= 0; --i) {
                    Tr.debug(tc, "Service " + ApplicationMgrImpl.this.blockingServices.get(i).toString() + " is blocking server startup");
                }
            }
            if (this.interruptReason != null) {
                throw this.interruptReason;
            }
        }
    }

    private class AppInitializer
    implements AsynchronousInitializer {
        DeployedApplicationImpl deployedApplication;

        AppInitializer(DeployedApplicationImpl deployedApplicationImpl) {
            this.deployedApplication = deployedApplicationImpl;
        }

        public void run() throws WsRuntimeFwException {
            ApplicationMgrImpl.this.startApplication(this.deployedApplication);
        }
    }

    class ApplicationNotifier
    implements ClassLoaderListener {
        DeployedApplicationImpl deployedApp;
        boolean isJ9vmEnabled;
        private volatile boolean isSpent = false;

        public ApplicationNotifier(DeployedApplicationImpl deployedApplicationImpl) {
            this.deployedApp = deployedApplicationImpl;
            this.isJ9vmEnabled = Boolean.getBoolean("com.ibm.ws.classloader.j9enabled");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void classChanged(ModuleRef moduleRef) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "classChanged");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "J9 support enabled?: " + this.isJ9vmEnabled);
            }
            if (!this.isJ9vmEnabled) {
                boolean bl;
                boolean bl2 = bl = this.deployedApp.getApplicationDeployment().getWarClassLoaderPolicy().getValue() == 1;
                if (moduleRef != null && moduleRef.isWeb() && !bl) {
                    Object object;
                    String string;
                    boolean bl3 = false;
                    DeployedModuleImpl deployedModuleImpl = this.deployedApp.getDeployedModule((com.ibm.etools.commonarchive.ModuleRef)moduleRef);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "War module '" + deployedModuleImpl.getName() + "' restart in progress");
                    }
                    try {
                        string = this.deployedApp.getName();
                        object = moduleRef.getUri();
                        ApplicationMgrImpl.this._stopModule(string, (String)object);
                        ApplicationMgrImpl.this._startModule(string, (String)object);
                    }
                    catch (RuntimeWarning runtimeWarning) {
                        bl3 = true;
                        FFDCFilter.processException((Throwable)runtimeWarning, this.getClass().getName(), "1487", this);
                    }
                    catch (RuntimeError runtimeError) {
                        bl3 = true;
                        FFDCFilter.processException((Throwable)runtimeError, this.getClass().getName(), "1490", this);
                    }
                    catch (Throwable throwable) {
                        bl3 = true;
                        Tr.error(tc, "WSVR206E", new Object[]{deployedModuleImpl.getName(), this.deployedApp.getName()});
                        FFDCFilter.processException(throwable, this.getClass().getName(), "507");
                    }
                    if (bl3) {
                        try {
                            string = this.deployedApp.getName();
                            object = this;
                            synchronized (object) {
                                ApplicationMgrImpl.this.stopApplication(string);
                                ApplicationMgrImpl.this.startApplication(string);
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, this.getClass().getName(), "1487", this);
                        }
                    }
                } else {
                    String string = this.deployedApp.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Application '" + string + "' restart in progress");
                    }
                    try {
                        ApplicationNotifier applicationNotifier = this;
                        synchronized (applicationNotifier) {
                            if (!this.isSpent) {
                                ApplicationMgrImpl.this.stopApplication(string);
                                ApplicationMgrImpl.this.startApplication(string);
                                this.isSpent = true;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, this.getClass().getName(), "1529", this);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "classChanged");
            }
        }
    }
}

