/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.classloader.ClassLoaderUtils;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.ExtJarClassLoader;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.service.LibraryMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.util.PathUtils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ApplicationServerImpl
extends ContainerImpl
implements com.ibm.ws.runtime.service.ApplicationServer {
    private static final TraceComponent tc = Tr.register(ApplicationServerImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private int classloaderPolicy;
    private int classloadingMode;
    private ClassLoader applicationClassLoader;
    private Properties customProperties = null;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        ConfigurationWarning configurationWarning = null;
        ContainerConfig containerConfig = (ContainerConfig)object;
        ApplicationServer applicationServer = (ApplicationServer)containerConfig.getConfig();
        if (applicationServer.getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        this.customProperties = new Properties();
        Iterator iterator = applicationServer.getProperties().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            this.customProperties.setProperty(property.getName(), property.getValue());
        }
        try {
            WsServiceRegistry.addService((Object)this, (Class)com.ibm.ws.runtime.service.ApplicationServer.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, ApplicationServerImpl.class.getName(), "96", this);
            throw new ConfigurationError(exception);
        }
        this.classloaderPolicy = applicationServer.getApplicationClassLoaderPolicy().getValue();
        this.classloadingMode = applicationServer.getApplicationClassLoadingMode().getValue();
        try {
            this.setState("INITIALIZING");
        }
        catch (ConfigurationWarning configurationWarning2) {
            configurationWarning = configurationWarning2;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName(), "115", this);
            configurationWarning = new ConfigurationWarning(exception);
        }
        this.components = this.loadComponents("META-INF/ws-applicationserver-startup.xml");
        try {
            this.initializeComponents((EObject)applicationServer, containerConfig.getLocators());
        }
        catch (ConfigurationWarning configurationWarning3) {
            configurationWarning = configurationWarning3;
        }
        this.initializeClassLoader(applicationServer);
        try {
            this.setState("INITIALIZED");
        }
        catch (ConfigurationWarning configurationWarning4) {
            configurationWarning = configurationWarning4;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName(), "137", this);
            configurationWarning = new ConfigurationWarning(exception);
        }
        if (configurationWarning != null) {
            throw configurationWarning;
        }
    }

    public void destroy() {
        try {
            this.setState("DESTROYING");
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.destroy();
        try {
            this.setState("DESTROYED");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        RuntimeWarning runtimeWarning = null;
        try {
            this.setState("STARTING");
        }
        catch (RuntimeWarning runtimeWarning2) {
            runtimeWarning = runtimeWarning2;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName(), "176", this);
            runtimeWarning = new RuntimeWarning(exception);
        }
        try {
            super.start();
        }
        catch (RuntimeWarning runtimeWarning3) {
            runtimeWarning = runtimeWarning3;
        }
        try {
            this.setState("STARTED");
        }
        catch (RuntimeWarning runtimeWarning4) {
            runtimeWarning = runtimeWarning4;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName(), "196", this);
            runtimeWarning = new RuntimeWarning(exception);
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    public void stop() {
        try {
            this.setState("STOPPING");
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stop();
        try {
            this.setState("STOPPED");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClassLoader getClassLoader() {
        return this.applicationClassLoader;
    }

    protected void initializeClassLoader(ApplicationServer applicationServer) throws ConfigurationError {
        LibraryMgr libraryMgr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClassLoader");
        }
        this.applicationClassLoader = this.buildApplicationClassLoader();
        try {
            libraryMgr = (LibraryMgr)WsServiceRegistry.getService((Object)this, (Class)LibraryMgr.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, ApplicationServerImpl.class.getName(), "214", this);
            throw new ConfigurationError(exception);
        }
        EList eList = applicationServer.getClassloaders();
        if (eList != null) {
            DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
            CompoundClassLoader compoundClassLoader = null;
            HashMap hashMap = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Classloader classloader = (Classloader)iterator.next();
                String[] stringArray = libraryMgr.getClassPaths(classloader);
                String[] stringArray2 = libraryMgr.getNativeLibPaths(classloader);
                if (stringArray.length == 0) continue;
                boolean bl = true;
                if (classloader.getMode().getValue() == 1) {
                    bl = false;
                }
                stringArray = PathUtils.expandPaths(stringArray);
                stringArray = ClassLoaderUtils.addDependentJars(stringArray);
                if (compoundClassLoader == null || compoundClassLoader.getDelegationMode() != bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && compoundClassLoader != null) {
                        Tr.debug(tc, "created user-defined server class loader: " + compoundClassLoader);
                    }
                    compoundClassLoader = new ExtJarClassLoader(stringArray, this.applicationClassLoader, null, bl);
                    hashMap = new HashMap();
                    compoundClassLoader.setCodeSourcePermissions(hashMap);
                    this.applicationClassLoader = compoundClassLoader;
                } else {
                    compoundClassLoader.addPaths(stringArray);
                }
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>(2);
                hashMap2.put("type", "library");
                hashMap2.put("classpath", stringArray);
                dynamicPolicy.getSecurityPolicy(hashMap2, hashMap);
                if (stringArray2.length == 0) continue;
                compoundClassLoader.addNativeLibPaths(stringArray2);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && compoundClassLoader != null) {
                Tr.debug(tc, "created user-defined server class loader: " + compoundClassLoader);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeClassLoader");
        }
    }

    protected ClassLoader buildApplicationClassLoader() throws ConfigurationError {
        Server server2;
        try {
            server2 = (Server)WsServiceRegistry.getService((Object)this, (Class)Server.class);
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception);
        }
        ClassLoader classLoader = server2.getPublicClassLoader();
        String string = this.expandVariable("${USER_INSTALL_ROOT}");
        if (string == null || string.length() == 0) {
            throw new ConfigurationError("Missing variable: USER_INSTALL_ROOT");
        }
        string = string + File.separator + "lib" + File.separator + "app";
        String string2 = this.expandVariable("${WAS_INSTALL_ROOT}");
        if (string2 == null || string2.length() == 0) {
            throw new ConfigurationError("Missing variable: WAS_INSTALL_ROOT");
        }
        string2 = string2 + File.separator + "lib" + File.separator + "app";
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists() && !file2.exists()) {
            return classLoader;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        if (file.exists()) {
            arrayList.add(string);
            arrayList2.addAll(this.getProtectedPrefixes(string));
        }
        if (file2.exists()) {
            arrayList.add(string2);
            arrayList2.addAll(this.getProtectedPrefixes(string2));
        }
        String[] stringArray = new String[arrayList.size()];
        String[] stringArray2 = new String[arrayList2.size()];
        arrayList.toArray(stringArray);
        arrayList2.toArray(stringArray2);
        ExtJarClassLoader extJarClassLoader = new ExtJarClassLoader(stringArray, classLoader, stringArray2, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "created lib/app server class loader: " + extJarClassLoader);
        }
        return extJarClassLoader;
    }

    private ArrayList getProtectedPrefixes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + File.separator + "protected.prefixes"));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public int getClassLoaderPolicy() {
        return this.classloaderPolicy;
    }

    public int getClassLoadingMode() {
        return this.classloadingMode;
    }

    public String getCustomProperty(String string) {
        return this.customProperties.getProperty(string);
    }
}

