/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.AsynchronousInitializer;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ContainerConfigFactory;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ServiceProvider;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.component.WsContainer;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ContainerImpl
extends ComponentImpl
implements BeanContextServices {
    private static final TraceComponent tc = Tr.register(ContainerImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected List components = Collections.EMPTY_LIST;
    protected ArrayList bcmListeners;
    protected ArrayList children;
    protected ArrayList bcsListeners;
    protected HashMap services;
    protected Map componentStartupData = new HashMap();
    private PlatformCheck platformCheck = new PlatformCheck();

    public ContainerImpl() {
        this.children = new ArrayList(3);
        this.bcmListeners = new ArrayList(1);
        this.bcsListeners = new ArrayList(1);
        this.services = new HashMap(3);
    }

    protected BeanContextServices getOuterBCS() {
        return this.getBeanContextServices();
    }

    public Object instantiateChild(String string) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public InputStream getResourceAsStream(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResourceAsStream(string);
    }

    public URL getResource(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(beanContextMembershipListener)) {
                this.bcmListeners.add(beanContextMembershipListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        BeanContextMembershipListener beanContextMembershipListener2 = beanContextMembershipListener;
        synchronized (beanContextMembershipListener2) {
            this.bcmListeners.remove(beanContextMembershipListener);
        }
    }

    public void revokeService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
        Object v = this.services.remove(clazz);
        if (v != null) {
            this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, clazz, bl));
        }
    }

    public boolean hasService(Class clazz) {
        if (this.services.get(clazz) == null) {
            BeanContextServices beanContextServices = this.getBeanContextServices();
            return beanContextServices == null ? false : beanContextServices.hasService(clazz);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(BeanContextChild beanContextChild, Object object, Class clazz, Object object2, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
        BeanContextServiceProvider beanContextServiceProvider = null;
        Object object3 = this.services;
        synchronized (object3) {
            beanContextServiceProvider = (BeanContextServiceProvider)this.services.get(clazz);
        }
        if (beanContextServiceProvider != null) {
            return beanContextServiceProvider.getService(this, object, clazz, object2);
        }
        object3 = this.getBeanContextServices();
        if (object3 != null) {
            return object3.getService(this, object, clazz, object2, beanContextServiceRevokedListener);
        }
        return null;
    }

    public void releaseService(BeanContextChild beanContextChild, Object object, Object object2) {
        BeanContextServices beanContextServices;
        if (this.services.get(object2) == null && (beanContextServices = this.getBeanContextServices()) != null) {
            beanContextServices.releaseService(this, object, object2);
        }
    }

    public Iterator getCurrentServiceClasses() {
        return this.services.keySet().iterator();
    }

    public Iterator getCurrentServiceSelectors(Class clazz) {
        BeanContextServiceProvider beanContextServiceProvider = (BeanContextServiceProvider)this.services.get(clazz);
        return beanContextServiceProvider == null ? null : beanContextServiceProvider.getCurrentServiceSelectors(this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(beanContextServicesListener)) {
                this.bcsListeners.add(beanContextServicesListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.remove(beanContextServicesListener);
        }
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        if (this.services.containsKey(beanContextServiceAvailableEvent.getServiceClass())) {
            return;
        }
        this.fireServiceAdded(beanContextServiceAvailableEvent);
        for (int i = 0; i < this.children.size(); ++i) {
            Object e2 = this.children.get(i);
            if (!(e2 instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)e2).serviceAvailable(beanContextServiceAvailableEvent);
        }
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        if (this.services.containsKey(beanContextServiceRevokedEvent.getServiceClass())) {
            return;
        }
        this.fireServiceRevoked(beanContextServiceRevokedEvent);
        for (int i = 0; i < this.children.size(); ++i) {
            Object e2 = this.children.get(i);
            if (!(e2 instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)e2).serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    public boolean needsGui() {
        return false;
    }

    public void dontUseGui() {
    }

    public void okToUseGui() {
    }

    public boolean avoidingGui() {
        return true;
    }

    public void setDesignTime(boolean bl) {
    }

    public boolean isDesignTime() {
        return false;
    }

    public int size() {
        return this.children.size();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean contains(Object object) {
        return this.children.contains(object);
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public Object[] toArray() {
        return this.children.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.children.toArray(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this.children;
        synchronized (object2) {
            if (this.children.contains(object)) {
                return false;
            }
            this.children.add(object);
        }
        if (object instanceof BeanContextChild) {
            object2 = (BeanContextChild)object;
            try {
                object2.setBeanContext(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                ArrayList arrayList = this.children;
                synchronized (arrayList) {
                    this.children.remove(object);
                }
                throw new IllegalStateException();
            }
        }
        this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        Object object2 = this.children;
        synchronized (object2) {
            if (!this.children.contains(object)) {
                return false;
            }
        }
        if (object instanceof BeanContextChild) {
            object2 = (BeanContextChild)object;
            try {
                object2.setBeanContext(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new IllegalStateException();
            }
        }
        object2 = this.children;
        synchronized (object2) {
            this.children.remove(object);
        }
        this.fireChildrenRemoved(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.containsAll(collection);
        }
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected void fireServiceAdded(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        BeanContextServicesListener[] beanContextServicesListenerArray = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(beanContextServicesListenerArray);
        for (int i = 0; i < beanContextServicesListenerArray.length; ++i) {
            beanContextServicesListenerArray[i].serviceAvailable(beanContextServiceAvailableEvent);
        }
    }

    protected void fireServiceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        BeanContextServicesListener[] beanContextServicesListenerArray = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(beanContextServicesListenerArray);
        for (int i = 0; i < beanContextServicesListenerArray.length; ++i) {
            beanContextServicesListenerArray[i].serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    protected void fireChildrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
        BeanContextMembershipListener[] beanContextMembershipListenerArray = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(beanContextMembershipListenerArray);
        for (int i = 0; i < beanContextMembershipListenerArray.length; ++i) {
            beanContextMembershipListenerArray[i].childrenAdded(beanContextMembershipEvent);
        }
    }

    protected void fireChildrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
        BeanContextMembershipListener[] beanContextMembershipListenerArray = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(beanContextMembershipListenerArray);
        for (int i = 0; i < beanContextMembershipListenerArray.length; ++i) {
            beanContextMembershipListenerArray[i].childrenRemoved(beanContextMembershipEvent);
        }
    }

    public void destroy() {
        this.destroyComponents();
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
        this.componentStartupData.clear();
    }

    public void stop() {
        this.stopComponents();
    }

    protected List loadComponents(String string) throws ConfigurationError {
        int n;
        IExtension[] iExtensionArray;
        String string2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadComponents", new Object[]{string, this});
        }
        List<ComponentStartup> list = Collections.synchronizedList(new ArrayList());
        String string3 = "META-INF/ws-";
        int n2 = string.indexOf(string3);
        String string4 = string;
        if (n2 == 0) {
            string4 = string.substring(string3.length());
        }
        if (string4.endsWith(".xml")) {
            string4 = string4.substring(0, string4.length() - 4);
        }
        string4 = string4.replaceFirst("recovery-mode-", "");
        string4 = string4.replaceFirst("control-region-", "");
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string2 = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + string4);
        if (iExtensionPoint == null && (iExtensionArray = this.getHostingBundleId()) != null) {
            iExtensionPoint = iExtensionRegistry.getExtensionPoint((String)iExtensionArray + "." + string4);
        }
        iExtensionArray = null;
        if (iExtensionPoint != null) {
            iExtensionArray = iExtensionPoint.getExtensions();
            for (n = 0; n < iExtensionArray.length; ++n) {
                IConfigurationElement[] iConfigurationElementArray;
                IExtension iExtension = iExtensionArray[n];
                IConfigurationElement[] iConfigurationElementArray2 = iExtension.getConfigurationElements();
                if (iConfigurationElementArray2.length != 1) continue;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[0];
                if (!iConfigurationElement.getName().equals("components")) {
                    iConfigurationElementArray = iConfigurationElement.getName();
                    continue;
                }
                iConfigurationElementArray = iConfigurationElement.getChildren();
                for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                    String string5;
                    String string6;
                    String string7;
                    int n3;
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[i];
                    if (!iConfigurationElement2.getName().equals("component")) continue;
                    String string8 = iConfigurationElement2.getAttribute("type");
                    String string9 = iConfigurationElement2.getAttribute("class");
                    String string10 = iConfigurationElement2.getAttribute("startup");
                    String string11 = iConfigurationElement2.getAttribute("platform");
                    try {
                        n3 = Integer.parseInt(string10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    ComponentStartup componentStartup = new ComponentStartup();
                    boolean bl = componentStartup.configurationDataRequired;
                    boolean bl2 = componentStartup.asyncStart;
                    boolean bl3 = componentStartup.asyncInitialize;
                    boolean bl4 = componentStartup.inhibitAsynchronousBehavior;
                    String string12 = iConfigurationElement2.getAttribute("configurationDataRequired");
                    if (string12 != null) {
                        bl = string12.equalsIgnoreCase("true");
                    }
                    if ((string7 = iConfigurationElement2.getAttribute("asyncStart")) != null) {
                        bl2 = string7.equalsIgnoreCase("true");
                    }
                    if ((string6 = iConfigurationElement2.getAttribute("asyncInitialize")) != null) {
                        bl3 = string6.equalsIgnoreCase("true");
                    }
                    if ((string5 = iConfigurationElement2.getAttribute("inhibitAsynchronousBehavior")) != null) {
                        bl4 = string5.equalsIgnoreCase("true");
                    }
                    componentStartup.type = string8;
                    componentStartup.clazz = string9;
                    if (string9 != null) {
                        componentStartup.configElement = iConfigurationElement2;
                    }
                    componentStartup.order = n3;
                    componentStartup.platforms = string11;
                    componentStartup.configurationDataRequired = bl;
                    componentStartup.asyncStart = bl2;
                    componentStartup.asyncInitialize = bl3;
                    componentStartup.inhibitAsynchronousBehavior = bl4;
                    componentStartup.processtypes = iConfigurationElement2.getAttribute("processType");
                    componentStartup.recoverytypes = iConfigurationElement2.getAttribute("recoveryType");
                    if (!this.platformCheck.validOn(componentStartup.platforms, componentStartup.processtypes, componentStartup.recoverytypes)) continue;
                    if (list.contains(componentStartup)) {
                        Tr.warning(tc, "WSVR0107W", new Object[]{componentStartup.getName(), string});
                        continue;
                    }
                    list.add(componentStartup);
                }
            }
        }
        this.loadLegacyPlugins(string, list);
        Collections.sort(list, new StartupCompartor());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadedComponents " + list.size(), this);
            for (n = 0; n < list.size(); ++n) {
                Tr.debug(tc, " component " + n, list.get(n));
            }
        }
        return list;
    }

    private void loadLegacyPlugins(String string, List list) throws ConfigurationError {
        Object object;
        Enumeration<URL> enumeration;
        try {
            enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationError(iOException);
        }
        XMLReader xMLReader = null;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new ConfigurationError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationError(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigurationError(factoryConfigurationError);
        }
        object = new StartupHandler();
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        xMLReader.setEntityResolver((EntityResolver)object);
        xMLReader.setErrorHandler((ErrorHandler)object);
        Object var6_10 = null;
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parsing", uRL);
            }
            try {
                xMLReader.parse(new InputSource(uRL.openStream()));
                List list2 = ((StartupHandler)object).getComponents();
                for (int i = 0; i < list2.size(); ++i) {
                    ComponentStartup componentStartup = (ComponentStartup)list2.get(i);
                    if (list.contains(componentStartup)) continue;
                    list.add(componentStartup);
                }
            }
            catch (SAXParseException sAXParseException) {
                FFDCFilter.processException(sAXParseException, this.getClass().getName(), "462");
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException});
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException(sAXException, this.getClass().getName(), "467");
                Exception exception = sAXException.getException();
                if (exception == null) {
                    exception = sAXException;
                }
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", exception});
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, this.getClass().getName(), "467");
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", iOException});
            }
        }
    }

    private String getHostingBundleId() {
        String string = null;
        BundleContext bundleContext = BundleContextMap.instance().get(this.getClass().getClassLoader());
        if (bundleContext != null) {
            string = bundleContext.getBundle().getSymbolicName();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComponents() throws RuntimeWarning, RuntimeError {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "startComponents " + this.components.size(), this);
        }
        StopWatch stopWatch = StopWatch.instance();
        try {
            stopWatch.start("ContainerImpl.startComponents() " + this);
            RuntimeWarning runtimeWarning = null;
            for (int i = 0; i < this.components.size(); ++i) {
                WsComponent wsComponent = (WsComponent)this.components.get(i);
                try {
                    ComponentStartup componentStartup;
                    stopWatch.start("ContainerImpl : start " + wsComponent);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "starting " + i, wsComponent);
                    }
                    if ((componentStartup = (ComponentStartup)this.componentStartupData.get(wsComponent)) != null && componentStartup.asyncStart && !componentStartup.inhibitAsynchronousBehavior) {
                        this.runAsynchronousInitializer(new AsynchComponentSupport(1, wsComponent, null, null));
                        continue;
                    }
                    wsComponent.start();
                    continue;
                }
                catch (RuntimeWarning runtimeWarning2) {
                    runtimeWarning = runtimeWarning2;
                    Tr.error(tc, "WSVR0501E", new Object[]{wsComponent, runtimeWarning2});
                    continue;
                }
                catch (RuntimeError runtimeError) {
                    throw runtimeError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "546");
                    Tr.error(tc, "WSVR0501E", new Object[]{wsComponent, throwable});
                    runtimeWarning = new RuntimeWarning(throwable);
                    continue;
                }
                finally {
                    stopWatch.stop();
                }
            }
            if (runtimeWarning != null) {
                throw runtimeWarning;
            }
        }
        finally {
            stopWatch.stop();
        }
    }

    protected void stopComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stopComponents " + this.components.size(), this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            WsComponent wsComponent = (WsComponent)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopping " + i, wsComponent);
                }
                wsComponent.stop();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "572");
                Tr.error(tc, "WSVR0102E", new Object[]{wsComponent, throwable});
            }
        }
    }

    protected void destroyComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "destroyComponents " + this.components.size(), this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            WsComponent wsComponent = (WsComponent)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "destroying " + i, wsComponent);
                }
                wsComponent.destroy();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "597");
                Tr.error(tc, "WSVR0103E", new Object[]{wsComponent, throwable});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponents(EObject eObject, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "initializeComponents", this);
        }
        StopWatch stopWatch = StopWatch.instance();
        ConfigurationWarning configurationWarning = null;
        try {
            stopWatch.start("ContainerImpl.initializeComponents() : " + (eObject != null ? eObject.getClass() : null));
            ComponentManager componentManager = null;
            List list = Collections.synchronizedList(new ArrayList());
            HashMap hashMap = new HashMap();
            try {
                componentManager = (ComponentManager)this.getService(ComponentManager.class);
                for (int i = 0; i < this.components.size(); ++i) {
                    ComponentStartup componentStartup = (ComponentStartup)this.components.get(i);
                    stopWatch.start("ContainerImpl : init " + componentStartup);
                    try {
                        if (bl) {
                            Tr.debug(tc, "processing", componentStartup);
                        }
                        if (componentStartup.clazz != null && componentStartup.type == null) {
                            this.initializeComponent(componentStartup.clazz, null, componentManager, hashMap, list, configLocatorArray, componentStartup);
                            continue;
                        }
                        Object object = null;
                        for (int j = 0; object == null && j < configLocatorArray.length; ++j) {
                            object = configLocatorArray[j].getConfig(eObject, componentStartup.type);
                            if (!bl || object == null) continue;
                            Tr.debug(tc, "config object " + object + " found by locator " + configLocatorArray[j]);
                        }
                        if (object != null) {
                            if (object instanceof List) {
                                List list2 = (List)object;
                                for (int j = 0; j < list2.size(); ++j) {
                                    EObject eObject2 = (EObject)list2.get(j);
                                    this.initializeComponent(null, (Object)eObject2, componentManager, hashMap, list, configLocatorArray, componentStartup);
                                }
                                continue;
                            }
                            EObject eObject3 = (EObject)object;
                            this.initializeComponent(componentStartup.type, (Object)eObject3, componentManager, hashMap, list, configLocatorArray, componentStartup);
                            continue;
                        }
                        if (bl) {
                            Tr.debug(tc, "config object not found!");
                        }
                        if (componentStartup.configurationDataRequired) continue;
                        this.initializeComponent(componentStartup.clazz, null, componentManager, hashMap, list, configLocatorArray);
                        throw new ConfigurationWarning("configuration data missing for " + componentStartup);
                    }
                    catch (ConfigurationWarning configurationWarning2) {
                        configurationWarning = configurationWarning2;
                        continue;
                    }
                    finally {
                        stopWatch.stop();
                    }
                }
            }
            catch (Throwable throwable) {
                this.releaseService(componentManager);
                this.components = list;
                throw throwable;
            }
            this.releaseService(componentManager);
            this.components = list;
        }
        finally {
            stopWatch.stop();
        }
        if (configurationWarning != null) {
            FFDCFilter.processException(configurationWarning, this.getClass().getName(), "717");
            throw configurationWarning;
        }
    }

    protected void initializeComponent(String string, Object object, EObject eObject, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponent(string, object, componentManager, map, list, configLocatorArray);
    }

    protected void initializeComponent(String string, Object object, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponent(string, object, componentManager, map, list, configLocatorArray, null);
    }

    protected void initializeComponent(String string, Object object, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray, ComponentStartup componentStartup) throws ConfigurationWarning, ConfigurationError {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "initializeComponent", new Object[]{string, object});
        }
        if (object == null) {
            object = string;
        }
        if (map.get(object) != null) {
            if (bl) {
                Tr.debug(tc, "component already loaded");
            }
            return;
        }
        map.put(object, object);
        Object object2 = null;
        if (componentStartup != null && componentStartup.configElement != null) {
            try {
                object2 = componentStartup.configElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                coreException.printStackTrace(System.out);
                System.out.println("got CoreException");
                throw new ConfigurationWarning(coreException);
            }
            finally {
                componentStartup.configElement = null;
            }
        } else {
            object2 = componentManager.getInstance(object);
        }
        if (componentStartup != null && componentStartup.inhibitAsynchronousBehavior && object2 instanceof ComponentImpl) {
            ((ComponentImpl)object2).inhibitAsynchBehavior();
        }
        if (object2 instanceof WsComponent) {
            boolean bl2;
            ConfigurationWarning configurationWarning = null;
            WsComponent wsComponent = (WsComponent)object2;
            this.componentStartupData.put(wsComponent, componentStartup);
            boolean bl3 = bl2 = componentStartup != null && componentStartup.asyncInitialize && !componentStartup.inhibitAsynchronousBehavior;
            if (this.add(wsComponent)) {
                try {
                    if (bl) {
                        Tr.debug(tc, "initializing", wsComponent);
                    }
                    if (object2 instanceof ContainerImpl || object2 instanceof WsContainer) {
                        object = ContainerConfigFactory.createContainerConfig(object, configLocatorArray);
                    }
                    if (bl2) {
                        list.add(wsComponent);
                        this.runAsynchronousInitializer(new AsynchComponentSupport(0, wsComponent, object, list));
                    } else {
                        wsComponent.initialize(object);
                    }
                }
                catch (ComponentDisabledException componentDisabledException) {
                    wsComponent = null;
                }
                catch (ConfigurationWarning configurationWarning2) {
                    if (bl) {
                        Tr.debug(tc, "Component, " + wsComponent + " failed to initialize", configurationWarning2);
                    }
                    configurationWarning = configurationWarning2;
                    if (configurationWarning2.getCause() instanceof ComponentDisabledException) {
                        wsComponent = null;
                        configurationWarning = new ConfigurationWarning(configurationWarning2.getMessage(), configurationWarning2);
                    }
                }
                catch (ConfigurationError configurationError) {
                    throw configurationError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "707");
                    wsComponent = null;
                    configurationWarning = new ConfigurationWarning("Exception caught when initializing component", throwable);
                    Tr.error(tc, "WSVR0501E", new Object[]{string, throwable});
                }
                if (wsComponent != null) {
                    if (!bl2) {
                        list.add(wsComponent);
                    }
                } else {
                    if (bl) {
                        Tr.debug(tc, "Component, " + object2 + " is disabled");
                    }
                    this.remove(object2);
                }
                if (configurationWarning != null) {
                    throw configurationWarning;
                }
            }
        } else if (object2 instanceof ServiceProvider) {
            ((ServiceProvider)object2).initialize(this.getBeanContextServices());
        } else if (bl) {
            Tr.debug(tc, "component ignored: " + (object2 != null ? object2.getClass().getName() : "<null>"));
        }
    }

    static class StartupCompartor
    implements Comparator {
        StartupCompartor() {
        }

        public int compare(Object object, Object object2) {
            ComponentStartup componentStartup = (ComponentStartup)object;
            ComponentStartup componentStartup2 = (ComponentStartup)object2;
            return componentStartup.order - componentStartup2.order;
        }
    }

    static class StartupHandler
    extends DefaultHandler {
        static final String DISTRIBUTED = "distributed";
        static final String ZSERIES = "zos";
        static final String ISERIES = "os400";
        static final String ALL = "all";
        static final String COMPONENT = "component";
        static final String PLATFORM = "platform";
        static final String CLASS = "class";
        static final String TYPE = "type";
        static final String STARTUP = "startup";
        static final String OVERRIDE = "override";
        static final String CONFIG_DATA_REQUIRED = "configurationDataRequired";
        static final String ASYNC_INIT = "asynchronousInit";
        static final String ASYNC_START = "asynchronousStart";
        static final String INHIBIT_MULTI_THREAD = "inhibitMultiThreadedBehavior";
        static final String PROCESSTYPE = "processType";
        static final String ADJUNCT = "adjunct";
        static final String SERVANT = "servant";
        static final String CONTROL = "control";
        private Locator locator = null;
        URL documentURL = null;
        private List components = new ArrayList();
        private ComponentStartup currentComponent = null;
        private StringBuffer value = new StringBuffer();
        private boolean overriding = false;
        private boolean ignoring = false;
        private static String actualPlatformString = null;
        private static String processType = "control";

        StartupHandler() {
        }

        public List getComponents() {
            return this.components;
        }

        public void startDocument() throws SAXException {
            this.components.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
            this.value.setLength(0);
            if (string3.equals(COMPONENT)) {
                this.currentComponent = new ComponentStartup();
                this.currentComponent.platforms = this.getStringAttribute(attributes2, PLATFORM, null);
                this.currentComponent.processtypes = this.getStringAttribute(attributes2, PROCESSTYPE, null);
                this.currentComponent.configurationDataRequired = this.getBooleanAttribute(attributes2, CONFIG_DATA_REQUIRED, true);
                this.currentComponent.asyncInitialize = this.getBooleanAttribute(attributes2, ASYNC_INIT, false);
                this.currentComponent.asyncStart = this.getBooleanAttribute(attributes2, ASYNC_START, false);
                this.currentComponent.inhibitAsynchronousBehavior = this.getBooleanAttribute(attributes2, INHIBIT_MULTI_THREAD, false);
            } else if (string3.equals(OVERRIDE)) {
                String string4 = this.getStringAttribute(attributes2, PLATFORM, null);
                String string5 = this.getStringAttribute(attributes2, PROCESSTYPE, null);
                if (string4 != null) {
                    if (this.validOn(string4, string5)) {
                        this.overriding = true;
                        this.currentComponent.configurationDataRequired = this.getBooleanAttribute(attributes2, CONFIG_DATA_REQUIRED, this.currentComponent.configurationDataRequired);
                        this.currentComponent.asyncInitialize = this.getBooleanAttribute(attributes2, ASYNC_INIT, this.currentComponent.asyncInitialize);
                        this.currentComponent.asyncStart = this.getBooleanAttribute(attributes2, ASYNC_START, this.currentComponent.asyncStart);
                        this.currentComponent.inhibitAsynchronousBehavior = this.getBooleanAttribute(attributes2, INHIBIT_MULTI_THREAD, this.currentComponent.inhibitAsynchronousBehavior);
                    } else {
                        this.ignoring = true;
                    }
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentComponent == null) {
                return;
            }
            if (COMPONENT.equals(string3)) {
                this.endComponent();
            } else if (CLASS.equals(string3)) {
                this.endClass();
            } else if (TYPE.equals(string3)) {
                this.endType();
            } else if (STARTUP.equals(string3)) {
                this.endStartup();
            } else if (OVERRIDE.equals(string3)) {
                this.overriding = false;
                this.ignoring = false;
            } else {
                this.parsingError("Invalid tag: " + string3);
            }
            this.value.setLength(0);
        }

        private void parsingError(String string) throws SAXException {
            throw new SAXException(string + "[" + this.documentURL + ", line:" + this.locator.getLineNumber() + ", col:" + this.locator.getColumnNumber() + "]");
        }

        private void endComponent() throws SAXException {
            if (this.currentComponent.type == null && this.currentComponent.clazz == null) {
                Tr.error(tc, "WSVR0104E", new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            } else if (this.currentComponent.type != null && this.currentComponent.clazz != null && this.currentComponent.configurationDataRequired) {
                Tr.error(tc, "WSVR0105E", new Object[]{this.currentComponent.type, this.currentComponent.clazz, this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            } else if (this.validOn(this.currentComponent.platforms, this.currentComponent.processtypes)) {
                this.components.add(this.currentComponent);
            }
            this.currentComponent = null;
        }

        private void endClass() throws SAXException {
            if (!this.ignoring) {
                if (this.overriding || this.currentComponent.clazz == null) {
                    this.currentComponent.clazz = this.value.toString();
                } else {
                    this.parsingError("<class> already defined");
                }
            }
        }

        private void endType() throws SAXException {
            if (!this.ignoring) {
                if (this.currentComponent.type == null || this.overriding) {
                    this.currentComponent.type = this.value.toString();
                } else {
                    this.parsingError("<type> already defined");
                }
            }
        }

        private void endStartup() throws SAXException {
            if (this.ignoring) {
                return;
            }
            try {
                int n;
                this.currentComponent.order = n = Integer.parseInt(this.value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                Tr.error(tc, "WSVR0106E", new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            }
        }

        private boolean validOn(String string, String string2) {
            boolean bl;
            block6: {
                String string3;
                StringTokenizer stringTokenizer;
                block7: {
                    bl = false;
                    if (string == null) {
                        bl = true;
                    } else {
                        stringTokenizer = new StringTokenizer(string, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken().trim().toLowerCase();
                            if (string3.equals(ALL)) {
                                bl = true;
                                break;
                            }
                            if (!string3.equals(actualPlatformString)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl || !actualPlatformString.equals(ZSERIES)) break block6;
                    bl = false;
                    if (string2 != null) break block7;
                    if (processType.equals(ADJUNCT)) break block6;
                    bl = true;
                    break block6;
                }
                stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().trim().toLowerCase();
                    if (string3.equals(ALL)) {
                        bl = true;
                        break;
                    }
                    if (!string3.equals(processType)) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.components.clear();
            this.currentComponent = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private String getStringAttribute(Attributes attributes2, String string, String string2) {
            String string3 = attributes2.getValue(string);
            return string3 != null ? string3 : string2;
        }

        private boolean getBooleanAttribute(Attributes attributes2, String string, boolean bl) {
            String string2 = attributes2.getValue(string);
            return string2 != null ? Boolean.valueOf(string2) : bl;
        }

        static {
            actualPlatformString = DISTRIBUTED;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isZOS()) {
                actualPlatformString = ZSERIES;
                if (platformHelper.isCRAJvm()) {
                    processType = ADJUNCT;
                } else if (platformHelper.isServantJvm()) {
                    processType = SERVANT;
                }
            } else if (platformHelper.isOS400()) {
                actualPlatformString = ISERIES;
            }
        }
    }

    static class PlatformCheck {
        static final String DISTRIBUTED = "distributed";
        static final String ZSERIES = "zos";
        static final String ISERIES = "os400";
        static final String ALL = "all";
        static final String ADJUNCT = "adjunct";
        static final String CONTROL = "control";
        static final String SERVANT = "servant";
        static final String CLIENT = "client";
        private static String actualPlatformString = null;
        private static String processType = "control";
        private static boolean recoveryMode = false;

        PlatformCheck() {
        }

        private boolean validOn(String string, String string2, String string3) {
            String string4;
            StringTokenizer stringTokenizer;
            boolean bl = false;
            if (string == null) {
                bl = true;
            } else {
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().trim().toLowerCase();
                    if (string4.equals(ALL)) {
                        bl = true;
                        break;
                    }
                    if (!string4.equals(actualPlatformString)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && actualPlatformString.equals(ZSERIES)) {
                bl = false;
                if (recoveryMode && (string2 = string3) == null) {
                    string2 = "";
                }
                if (string2 == null) {
                    bl = true;
                } else {
                    stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken().trim().toLowerCase();
                        if (string4.equals(ALL)) {
                            bl = true;
                            break;
                        }
                        if (!string4.equalsIgnoreCase(processType)) continue;
                        bl = true;
                        break;
                    }
                }
            }
            return bl;
        }

        static {
            actualPlatformString = DISTRIBUTED;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isZOS()) {
                actualPlatformString = ZSERIES;
                if (platformHelper.isCRAJvm()) {
                    processType = ADJUNCT;
                } else if (platformHelper.isServantJvm()) {
                    processType = SERVANT;
                } else if (platformHelper.isClientJvm()) {
                    processType = CLIENT;
                }
                if (processType != CLIENT && !platformHelper.runningWhereConfigured()) {
                    recoveryMode = true;
                }
            } else if (platformHelper.isOS400()) {
                actualPlatformString = ISERIES;
            }
        }
    }

    protected static class ComponentStartup {
        public int order = Integer.MAX_VALUE;
        public String type = null;
        public String clazz = null;
        public IConfigurationElement configElement = null;
        public String platforms = null;
        public String processtypes = null;
        public String recoverytypes = null;
        boolean configurationDataRequired = true;
        boolean asyncStart = false;
        boolean asyncInitialize = false;
        boolean inhibitAsynchronousBehavior = false;

        protected ComponentStartup() {
        }

        public String toString() {
            String string = (this.type != null ? this.type : this.clazz) + " [" + this.order + "]" + (this.asyncInitialize ? " asynch-init" : "") + (this.asyncStart ? " asynch-start" : "");
            if (this.platforms != null) {
                string = string + " [platforms:" + this.platforms + "]";
            }
            if (this.processtypes != null) {
                string = string + " [processtypes:" + this.processtypes + "]";
            }
            if (this.recoverytypes != null) {
                string = string + " [recoverytypes:" + this.recoverytypes + "]";
            }
            return string;
        }

        public boolean equals(Object object) {
            if (object instanceof ComponentStartup) {
                boolean bl;
                ComponentStartup componentStartup = (ComponentStartup)object;
                boolean bl2 = this.type == null ? this.type == componentStartup.type : (bl = this.type.equals(componentStartup.type));
                boolean bl3 = this.clazz == null ? this.clazz == componentStartup.clazz : this.clazz.equals(componentStartup.clazz);
                return bl && bl3;
            }
            return false;
        }

        public String getName() {
            return this.type != null ? this.type : this.clazz;
        }
    }

    private class AsynchComponentSupport
    implements AsynchronousInitializer {
        static final int INIT_ = 0;
        static final int START_ = 1;
        final int operation;
        final WsComponent component;
        final Object configurationData;
        final List componentsList;

        AsynchComponentSupport(int n, WsComponent wsComponent, Object object, List list) {
            this.operation = n;
            this.component = wsComponent;
            this.configurationData = object;
            this.componentsList = list;
        }

        public void run() throws ConfigurationWarning, ConfigurationError, RuntimeWarning, RuntimeError {
            switch (this.operation) {
                case 0: {
                    try {
                        this.component.initialize(this.configurationData);
                        break;
                    }
                    catch (ComponentDisabledException componentDisabledException) {
                        this.componentsList.remove(this.component);
                        break;
                    }
                    catch (ConfigurationWarning configurationWarning) {
                        throw configurationWarning;
                    }
                }
                case 1: {
                    this.component.start();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported operation : " + this.operation);
                }
            }
        }
    }
}

