/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.models.config.appcfg.ApplicationConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.classloader.ClassLoaderListener;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.component.DeployedModuleImpl;
import com.ibm.ws.runtime.component.collaborator.J2EEApplication;
import com.ibm.ws.runtime.deploy.ApplicationCollaborator;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObjectAdjuster;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectHandler;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.ConfigRootImpl;
import com.ibm.ws.runtime.service.LibraryMgr;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfiguration;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigFactory;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigPackage;

public class DeployedApplicationImpl
extends ContainerImpl
implements DeployedApplication,
Comparable {
    private static TraceComponent tc = Tr.register(DeployedApplicationImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static final String DEPLOYMENT = "deployment.xml";
    private static final String SECURITY_POLICY = "META-INF/was.policy";
    private static final String SHAREDLIB_BYPASS = "com.ibm.ws.classloader.sharedLibBypass";
    private ApplicationDeployment applicationDeployment;
    private String appDeploymentName;
    private ClassLoaderManager classLoaderMgr;
    private ApplicationMetaData applicationMetadata;
    private DeployedObjectListener deployedObjectListener = null;
    private DeployedObjectHandler deployedObjectHandler = null;
    private DeployedObjectAdjuster deployedObjectAdjuster = null;
    private DeploymentTargetMapping serverMap;
    private DeploymentTargetMapping clusterMap;
    private int weight;
    private boolean extraProcessing;
    private String id;
    private boolean isSystemApp = false;
    private MappableContentsArchive applicationArchive = null;
    private Map moduleSharedLibClassPathMap = new HashMap();
    private Map moduleSharedLibNativeLibPathMap = new HashMap();

    DeployedApplicationImpl(String string, String string2, boolean bl) {
        this.setName(string);
        this.appDeploymentName = string2;
        this.isSystemApp = bl;
        this.components = new ArrayList(2);
    }

    public String getId() {
        return this.id;
    }

    EARFile getEARFile() {
        return this.applicationArchive.getEARFile();
    }

    public ModuleFile getModuleFile() {
        return this.applicationArchive.getEARFile();
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.classLoaderMgr.getApplicationClassLoader();
        if (classLoader instanceof ReloadableClassLoader) {
            return ((ReloadableClassLoader)classLoader).getCurrentClassLoader();
        }
        return classLoader;
    }

    protected DeployedObjectEvent createDeployedObjectEvent(String string) {
        ApplicationServer applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
        String string2 = applicationServer.getState();
        this.releaseService(applicationServer);
        DeployedObjectEvent deployedObjectEvent = new DeployedObjectEvent(this, "state", this.state, string, string2);
        return deployedObjectEvent;
    }

    protected void setState(String string) throws RuntimeError, RuntimeWarning {
        DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent(string);
        this.setState(deployedObjectEvent);
    }

    protected void setState(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        this.fireDeployedObjectEvent(deployedObjectEvent);
        try {
            super.setState(deployedObjectEvent.getNewValue().toString());
        }
        catch (WsException wsException) {
            throw new RuntimeError(wsException);
        }
    }

    boolean isOpen() {
        return this.applicationArchive.isOpen();
    }

    List getModules() {
        return this.components;
    }

    DeployedModuleImpl getDeployedModule(ModuleRef moduleRef) {
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            DeployedModuleImpl deployedModuleImpl = (DeployedModuleImpl)this.components.get(i);
            if (deployedModuleImpl.getModuleRef() != moduleRef) continue;
            return deployedModuleImpl;
        }
        return null;
    }

    ClassLoaderManager getClassLoaderManager() {
        return this.classLoaderMgr;
    }

    ClassLoader getClassLoader(ModuleRef moduleRef) {
        if (this.classLoaderMgr == null) {
            return null;
        }
        ReloadableClassLoader reloadableClassLoader = this.classLoaderMgr.lookupClassLoader(moduleRef);
        if (reloadableClassLoader == null) {
            return null;
        }
        return reloadableClassLoader.getCurrentClassLoader();
    }

    void removeClassLoader(ModuleRef moduleRef) {
        if (this.classLoaderMgr != null) {
            this.classLoaderMgr.removeClassLoader(moduleRef);
        }
    }

    void addClassLoaderListener(ClassLoaderListener classLoaderListener) {
        this.classLoaderMgr.addClassLoaderListener(classLoaderListener, null);
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            this.classLoaderMgr.addClassLoaderListener(classLoaderListener, (ModuleRef)((DeployedModuleImpl)this.components.get(i)).getModuleRef());
        }
    }

    public EObject getDeploymentDescriptor() {
        return this.applicationArchive.getDeploymentDescriptor();
    }

    public EObject getBinding() {
        return this.applicationArchive.getBinding();
    }

    public EObject getExtension() {
        return this.applicationArchive.getExtension();
    }

    public ApplicationDeployment getApplicationDeployment() {
        return this.applicationDeployment;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        boolean bl = (Boolean)object;
        this.initialize(bl, false, null);
    }

    private void initialize(boolean bl, boolean bl2, String string) throws ConfigurationWarning, ConfigurationError {
        List list;
        Object object;
        Resource resource;
        ConfigRootImpl configRootImpl;
        String string2;
        String string3;
        String string4;
        Deployment deployment = null;
        Repository repository2 = null;
        try {
            repository2 = (Repository)this.getService(Repository.class);
            string4 = repository2.getServerName();
            string3 = repository2.getNodeName();
            string2 = repository2.getClusterName();
            configRootImpl = (ConfigRootImpl)repository2.getConfigRoot();
            configRootImpl.setValue(1, this.appDeploymentName);
            resource = this.isSystemApp ? configRootImpl.getResourceAbsolute(this.appDeploymentName + '/' + DEPLOYMENT) : configRootImpl.getResource(1, DEPLOYMENT);
            deployment = (Deployment)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " initializing", deployment.getDeployedObject());
            }
        }
        catch (Exception exception) {
            try {
                Tr.error(tc, "WSVR0100W", new Object[]{this.name, exception});
                throw new ConfigurationWarning("Error loading deployment.xml for " + this.name, exception);
            }
            catch (Throwable throwable) {
                this.releaseService(repository2);
                throw throwable;
            }
        }
        this.releaseService(repository2);
        configRootImpl = null;
        resource = null;
        configRootImpl = this.getClusterTarget(deployment, string2);
        resource = this.getServerTarget(deployment, string3, string4);
        if (string2 != null) {
            if (configRootImpl == null) {
                Tr.warning(tc, "WSVR0215W", this.name);
                throw new ConfigurationWarning("No cluster target found for application, " + this.name);
            }
        } else if (resource == null) {
            Tr.warning(tc, "WSVR0215W", this.name);
            throw new ConfigurationWarning("No server target found for application, " + this.name);
        }
        EList eList = deployment.getDeployedObject().getTargetMappings();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            object = (DeploymentTargetMapping)eList.get(i);
            if (object.getTarget() == configRootImpl) {
                this.clusterMap = object;
            }
            if (object.getTarget() != resource) continue;
            this.serverMap = object;
        }
        DeploymentTargetMapping deploymentTargetMapping = this.serverMap;
        if (string2 != null) {
            deploymentTargetMapping = this.clusterMap;
        }
        if (bl && deploymentTargetMapping != null && !deploymentTargetMapping.isEnable()) {
            Tr.info(tc, "WSVR0219I", this.name);
            return;
        }
        this.applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        this.weight = this.applicationDeployment.getStartingWeight();
        this.id = this.getConfigId((EObject)this.applicationDeployment);
        ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
        this.extraProcessing = applicationMgr.getExtraProcessing();
        this.releaseService(applicationMgr);
        object = this.applicationDeployment.getBinariesURL();
        if (this.isSystemApp && ((String)(object = this.appDeploymentName)).endsWith(DEPLOYMENT)) {
            object = ((String)object).substring(0, ((String)object).lastIndexOf(DEPLOYMENT) - 1);
        }
        try {
            object = this.expandVariable((String)object);
            if (!bl2) {
                this.applicationArchive = new MappableContentsArchive((List)this.applicationDeployment.getProperties(), (String)object, this.applicationDeployment.isUseMetadataFromBinaries(), this.extraProcessing);
            }
            this.applicationArchive.open(string, bl2);
        }
        catch (Throwable throwable) {
            throw new ConfigurationWarning("Failed to open " + (String)object, throwable);
        }
        this.applicationDeployment.setBinariesURL((String)object);
        if (!bl2) {
            try {
                this.setState("INITIALIZING");
            }
            catch (WsException wsException) {
                // empty catch block
            }
        }
        if ((list = this.getDeployedModules((DeploymentTarget)resource, (DeploymentTarget)configRootImpl)).size() == 0) {
            if (string2 == null) {
                Tr.warning(tc, "WSVR0210W", new Object[]{this.name, string4});
            } else {
                Tr.warning(tc, "WSVR0218W", new Object[]{this.name, string4, string2});
            }
            throw new ConfigurationWarning("No modules defined for " + this.name);
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            DeployedModuleImpl deployedModuleImpl = (DeployedModuleImpl)list.get(i);
            if (bl2) {
                if (!deployedModuleImpl.getName().trim().equalsIgnoreCase(string.trim())) continue;
                this.initializeModule(deployedModuleImpl);
                continue;
            }
            this.initializeModule(deployedModuleImpl);
        }
        if (this.components.size() == 0) {
            if (string2 == null) {
                Tr.warning(tc, "WSVR0210W", new Object[]{this.name, string4});
            } else {
                Tr.warning(tc, "WSVR0218W", new Object[]{this.name, string4, string2});
            }
            throw new ConfigurationWarning("No enabled modules defined for " + this.name);
        }
        Collections.sort(this.components);
        if (!bl2) {
            try {
                this.setState("INITIALIZED");
            }
            catch (WsException wsException) {
                // empty catch block
            }
        }
    }

    void initializeForUpdateOrAdd(String string) throws ConfigurationWarning, ConfigurationError {
        this.initialize(false, true, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void destroy() {
        block25: {
            try {
                this.setState("DESTROYING");
            }
            catch (WsException wsException) {
                // empty catch block
            }
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DeployedModuleImpl deployedModuleImpl = (DeployedModuleImpl)this.components.get(i);
                deployedModuleImpl.destroy();
                this.remove(deployedModuleImpl);
            }
            this.moduleSharedLibClassPathMap.clear();
            this.moduleSharedLibNativeLibPathMap.clear();
            this.components.clear();
            try {
                this.setState("DESTROYED");
            }
            catch (WsException wsException) {
            }
            Object var4_6 = null;
            try {
                if (this.classLoaderMgr != null) {
                    this.classLoaderMgr.dispose();
                    this.classLoaderMgr = null;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "603", this);
            }
            if (this.applicationArchive != null) {
                try {
                    this.applicationArchive.close(true);
                    this.applicationArchive.dispose();
                    this.applicationArchive = null;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "591", this);
                }
            }
            break block25;
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "580", this);
                    Object var4_7 = null;
                    try {
                        if (this.classLoaderMgr != null) {
                            this.classLoaderMgr.dispose();
                            this.classLoaderMgr = null;
                        }
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException(throwable2, this.getClass().getName(), "603", this);
                    }
                    if (this.applicationArchive != null) {
                        try {
                            this.applicationArchive.close(true);
                            this.applicationArchive.dispose();
                            this.applicationArchive = null;
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException(throwable2, this.getClass().getName(), "591", this);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                try {
                    if (this.classLoaderMgr != null) {
                        this.classLoaderMgr.dispose();
                        this.classLoaderMgr = null;
                    }
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException(throwable3, this.getClass().getName(), "603", this);
                }
                if (this.applicationArchive != null) {
                    try {
                        this.applicationArchive.close(true);
                        this.applicationArchive.dispose();
                        this.applicationArchive = null;
                    }
                    catch (Throwable throwable3) {
                        FFDCFilter.processException(throwable3, this.getClass().getName(), "591", this);
                    }
                }
                throw throwable;
            }
        }
    }

    public void removeModule(DeployedModuleImpl deployedModuleImpl) {
        this.applicationArchive.dispose(deployedModuleImpl);
        deployedModuleImpl.destroy();
        this.remove(deployedModuleImpl);
        this.components.remove(deployedModuleImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        String[] stringArray;
        String[] stringArray2;
        boolean bl2 = false;
        ApplicationServer applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
        boolean bl3 = applicationServer.getClassLoaderPolicy() == 1;
        ClassLoader classLoader = applicationServer.getClassLoader();
        this.releaseService(applicationServer);
        try {
            if (this.isSystemApp || AppManagementHelper.isSystemApp(this.getEARFile().getAbsolutePath())) {
                stringArray2 = this.applicationDeployment.getProperties().iterator();
                stringArray = null;
                while (stringArray2.hasNext()) {
                    stringArray = (String[])stringArray2.next();
                    if (!stringArray.getName().equals(SHAREDLIB_BYPASS)) continue;
                    bl2 = Boolean.valueOf(stringArray.getValue());
                    break;
                }
                if (!bl3 && bl2) {
                    classLoader = ExtClassLoader.getInstance();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, this.getClass().getName(), "685", this);
        }
        stringArray2 = this.getSharedLibClassPaths((DeployedObject)this.applicationDeployment);
        stringArray = this.getSharedLibNativeLibPaths((DeployedObject)this.applicationDeployment);
        this.moduleSharedLibClassPathMap.put(null, stringArray2);
        this.moduleSharedLibNativeLibPathMap.put(null, stringArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adding shared library classpaths='" + PathUtils.arrayToString(stringArray2) + "' for application='" + this.appDeploymentName + "'");
            Tr.debug(tc, "adding shared library native library paths='" + PathUtils.arrayToString(stringArray) + "' for application='" + this.appDeploymentName + "'");
        }
        boolean bl4 = this.components.size();
        for (bl = false; bl < bl4; bl += 1) {
            object3 = (DeployedModuleImpl)this.components.get(bl ? 1 : 0);
            object2 = ((DeployedModuleImpl)object3).getModuleDeployment();
            stringArray2 = this.getSharedLibClassPaths((DeployedObject)object2);
            stringArray = this.getSharedLibNativeLibPaths((DeployedObject)object2);
            object = ((DeployedModuleImpl)object3).getModuleRef().getUri();
            this.moduleSharedLibClassPathMap.put(object, stringArray2);
            this.moduleSharedLibNativeLibPathMap.put(object, stringArray);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "adding shared library classpaths='" + PathUtils.arrayToString(stringArray2) + "' for module='" + (String)object + "'");
            Tr.debug(tc, "adding shared library native library paths='" + PathUtils.arrayToString(stringArray) + "' for module='" + (String)object + "'");
        }
        bl = this.getLibraryDelegationMode();
        Repository repository2 = (Repository)this.getService(Repository.class);
        object3 = repository2.getConfigRoot();
        object2 = null;
        object = object3;
        synchronized (object) {
            object3.setValue(1, this.appDeploymentName);
            if (this.applicationDeployment.isUseMetadataFromBinaries()) {
                object2 = this.applicationDeployment.getBinariesURL();
                object2 = (String)object2 + File.separator + SECURITY_POLICY;
            }
            if (object2 == null) {
                object2 = object3.getAbsolutePath(1, SECURITY_POLICY);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "was.policy being loaded from: ", object2);
        }
        this.releaseService(repository2);
        boolean bl5 = false;
        long l = 0L;
        if (this.applicationDeployment.isReloadEnabled()) {
            bl5 = true;
            l = this.applicationDeployment.getReloadInterval();
        }
        boolean bl6 = this.applicationDeployment.getWarClassLoaderPolicy().getValue() == 1;
        this.classLoaderMgr = new ClassLoaderManager(classLoader, this.applicationArchive.getEARFile(), bl6, this.moduleSharedLibClassPathMap, this.moduleSharedLibNativeLibPathMap, bl, (String)object2, bl5, l, this.extraProcessing);
        boolean bl7 = true;
        try {
            if (!this.isOpen()) {
                try {
                    this.applicationArchive.reopen();
                }
                catch (ReopenException reopenException) {
                    throw new RuntimeError("Reopen failed", reopenException);
                }
            }
            MetaDataFactoryMgr metaDataFactoryMgr = null;
            try {
                DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent("STARTING");
                this.fireDeployedObjectAdjust(deployedObjectEvent);
                metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(MetaDataFactoryMgr.class);
                metaDataFactoryMgr.createMetaData(this);
                this.registerMBean();
                this.setState(deployedObjectEvent);
                bl7 = false;
                this.fireDeployedObjectStart(deployedObjectEvent);
            }
            catch (Throwable throwable) {
                this.releaseService(metaDataFactoryMgr);
                throw throwable;
            }
            this.releaseService(metaDataFactoryMgr);
            for (int i = 0; i < this.components.size(); ++i) {
                DeployedModuleImpl deployedModuleImpl = (DeployedModuleImpl)this.components.get(i);
                try {
                    deployedModuleImpl.start();
                    continue;
                }
                catch (RuntimeWarning runtimeWarning) {
                    Tr.warning(tc, "WSVR0206E", new Object[]{deployedModuleImpl.getName(), this.appDeploymentName});
                    throw runtimeWarning;
                }
                catch (RuntimeError runtimeError) {
                    Tr.warning(tc, "WSVR0206E", new Object[]{deployedModuleImpl.getName(), this.appDeploymentName});
                    throw runtimeError;
                }
            }
            this.setState("STARTED");
        }
        catch (Throwable throwable) {
            try {
                if (bl7) {
                    this.setState("STARTING");
                }
                this.setState("ERROR");
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException(throwable2, this.getClass().getName(), "846", this);
            }
            try {
                this.applicationArchive.close(false);
            }
            catch (Throwable throwable3) {
                FFDCFilter.processException(throwable3, this.getClass().getName(), "852", this);
            }
            if (throwable instanceof RuntimeWarning) {
                throw (RuntimeWarning)throwable;
            }
            if (throwable instanceof RuntimeError) {
                throw (RuntimeError)throwable;
            }
            throw new RuntimeException(throwable);
        }
        this.applicationArchive.close(false);
    }

    public void stop() {
        String string = this.state;
        DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent("STOPPING");
        try {
            this.setState(deployedObjectEvent);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName(), "536");
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DeployedModuleImpl deployedModuleImpl = (DeployedModuleImpl)this.components.get(i);
            try {
                deployedModuleImpl.stop();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "540");
            }
        }
        if (string == "STARTED") {
            try {
                this.fireDeployedObjectStop(deployedObjectEvent);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "549");
            }
        }
        try {
            this.setState("STOPPED");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName(), "556");
        }
        this.deregisterMBean();
        MetaDataFactoryMgr metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(MetaDataFactoryMgr.class);
        metaDataFactoryMgr.destroyMetaData(this);
        this.releaseService(metaDataFactoryMgr);
    }

    private ClusteredTarget getClusterTarget(Deployment deployment, String string) {
        block4: {
            if (string == null) break block4;
            EList eList = deployment.getDeploymentTargets();
            if (!this.isSystemApp) {
                int n = eList.size();
                for (int i = 0; i < n; ++i) {
                    ClusteredTarget clusteredTarget;
                    Object e2 = eList.get(i);
                    if (!(e2 instanceof ClusteredTarget) || !(clusteredTarget = (ClusteredTarget)e2).getName().equals(string)) continue;
                    return clusteredTarget;
                }
            } else {
                int n = eList.size();
                for (int i = 0; i < n; ++i) {
                    Object e3 = eList.get(i);
                    if (!(e3 instanceof ClusteredTarget)) continue;
                    ClusteredTarget clusteredTarget = (ClusteredTarget)e3;
                    clusteredTarget.setName(string);
                    return clusteredTarget;
                }
            }
        }
        return null;
    }

    private ServerTarget getServerTarget(Deployment deployment, String string, String string2) throws ConfigurationWarning {
        EList eList = deployment.getDeploymentTargets();
        if (!this.isSystemApp) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                ServerTarget serverTarget;
                Object e2 = eList.get(i);
                if (!(e2 instanceof ServerTarget) || !(serverTarget = (ServerTarget)e2).getName().equals(string2) || !serverTarget.getNodeName().equals(string)) continue;
                return serverTarget;
            }
        } else {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                Object e3 = eList.get(i);
                if (!(e3 instanceof ServerTarget)) continue;
                ServerTarget serverTarget = (ServerTarget)e3;
                serverTarget.setNodeName(string);
                serverTarget.setName(string2);
                return serverTarget;
            }
        }
        return null;
    }

    private String[] getSharedLibClassPaths(DeployedObject deployedObject) {
        String[] stringArray = new String[]{};
        Classloader classloader = deployedObject.getClassloader();
        if (classloader != null) {
            LibraryMgr libraryMgr = (LibraryMgr)this.getService(LibraryMgr.class);
            stringArray = libraryMgr.getClassPaths(classloader);
            this.releaseService(libraryMgr);
        }
        return stringArray;
    }

    private String[] getSharedLibNativeLibPaths(DeployedObject deployedObject) {
        String[] stringArray = new String[]{};
        Classloader classloader = deployedObject.getClassloader();
        if (classloader != null) {
            LibraryMgr libraryMgr = (LibraryMgr)this.getService(LibraryMgr.class);
            stringArray = libraryMgr.getNativeLibPaths(classloader);
            this.releaseService(libraryMgr);
        }
        return stringArray;
    }

    private boolean getLibraryDelegationMode() {
        Classloader classloader = this.applicationDeployment.getClassloader();
        boolean bl = true;
        if (classloader != null && classloader.getMode().getValue() == 1) {
            bl = false;
        }
        return bl;
    }

    private List getDeployedModules(DeploymentTarget deploymentTarget, DeploymentTarget deploymentTarget2) throws ConfigurationWarning {
        EList eList = this.applicationDeployment.getModules();
        ArrayList<DeployedModule> arrayList = new ArrayList<DeployedModule>(eList.size());
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            DeploymentTargetMapping deploymentTargetMapping;
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            EList eList2 = moduleDeployment.getTargetMappings();
            DeploymentTargetMapping deploymentTargetMapping2 = null;
            DeploymentTargetMapping deploymentTargetMapping3 = null;
            int n2 = eList2.size();
            for (int j = 0; j < n2; ++j) {
                deploymentTargetMapping = (DeploymentTargetMapping)eList2.get(j);
                if (deploymentTargetMapping.getTarget() == deploymentTarget) {
                    deploymentTargetMapping2 = deploymentTargetMapping;
                    continue;
                }
                if (deploymentTargetMapping.getTarget() != deploymentTarget2) continue;
                deploymentTargetMapping3 = deploymentTargetMapping;
            }
            Application application = (Application)this.getDeploymentDescriptor();
            String string = moduleDeployment.getAltDD();
            if (string != null && string.length() == 0) {
                string = null;
            }
            if ((deploymentTargetMapping = application.getModule(moduleDeployment.getUri(), string)) == null) {
                throw new ConfigurationWarning("Module not found");
            }
            if (!this.isSystemApp && (deploymentTarget2 == null || deploymentTargetMapping3 == null) && (deploymentTarget2 != null || deploymentTargetMapping2 == null)) continue;
            arrayList.add(DeployedModuleImpl.getTypeSpecificInstance(this, deploymentTargetMapping2, deploymentTargetMapping3, (Module)deploymentTargetMapping, moduleDeployment));
        }
        return arrayList;
    }

    private void initializeModule(DeployedModuleImpl deployedModuleImpl) throws ConfigurationError, ConfigurationWarning {
        if (!this.isSystemApp && !deployedModuleImpl.isEnabled()) {
            Tr.debug(tc, "Module is disabled", deployedModuleImpl);
            return;
        }
        try {
            this.add(deployedModuleImpl);
            deployedModuleImpl.initialize(null);
        }
        catch (ConfigurationWarning configurationWarning) {
            Tr.warning(tc, "WSVR0205E", new Object[]{deployedModuleImpl.getName(), this.name});
            throw configurationWarning;
        }
        catch (ConfigurationError configurationError) {
            Tr.warning(tc, "WSVR0205E", new Object[]{deployedModuleImpl.getName(), this.name});
            throw configurationError;
        }
        this.components.add(deployedModuleImpl);
    }

    public void addDeployedObjectListener(DeployedObjectListener deployedObjectListener) throws TooManyListenersException {
        if (this.deployedObjectListener != null) {
            throw new TooManyListenersException();
        }
        this.deployedObjectListener = deployedObjectListener;
    }

    public void removeDeployedObjectListener(DeployedObjectListener deployedObjectListener) {
        if (this.deployedObjectListener == deployedObjectListener) {
            this.deployedObjectListener = null;
        }
    }

    void fireDeployedObjectEvent(DeployedObjectEvent deployedObjectEvent) throws RuntimeWarning, RuntimeError {
        if (this.deployedObjectListener != null) {
            this.deployedObjectListener.stateChanged(deployedObjectEvent);
        }
    }

    public void addDeployedObjectHandler(DeployedObjectHandler deployedObjectHandler) throws TooManyListenersException {
        if (this.deployedObjectHandler != null) {
            throw new TooManyListenersException();
        }
        this.deployedObjectHandler = deployedObjectHandler;
    }

    public void removeDeployedObjectHandler(DeployedObjectHandler deployedObjectHandler) {
        if (this.deployedObjectHandler == deployedObjectHandler) {
            this.deployedObjectHandler = null;
        }
    }

    void fireDeployedObjectStart(DeployedObjectEvent deployedObjectEvent) throws RuntimeWarning, RuntimeError {
        if (this.deployedObjectHandler != null) {
            this.deployedObjectHandler.start(deployedObjectEvent);
        }
    }

    void fireDeployedObjectStop(DeployedObjectEvent deployedObjectEvent) throws RuntimeWarning, RuntimeError {
        if (this.deployedObjectHandler != null) {
            this.deployedObjectHandler.stop(deployedObjectEvent);
        }
    }

    public void addDeployedObjectAdjuster(DeployedObjectAdjuster deployedObjectAdjuster) throws TooManyListenersException {
        if (this.deployedObjectAdjuster != null) {
            throw new TooManyListenersException();
        }
        this.deployedObjectAdjuster = deployedObjectAdjuster;
    }

    public void removeDeployedObjectAdjuster(DeployedObjectAdjuster deployedObjectAdjuster) {
        if (this.deployedObjectAdjuster == deployedObjectAdjuster) {
            this.deployedObjectAdjuster = null;
        }
    }

    void fireDeployedObjectAdjust(DeployedObjectEvent deployedObjectEvent) throws RuntimeWarning, RuntimeError {
        if (this.deployedObjectAdjuster != null) {
            this.deployedObjectAdjuster.adjust(deployedObjectEvent);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DeployedApplicationImpl) {
            return this.weight - ((DeployedApplicationImpl)object).weight;
        }
        return 0;
    }

    public MetaData getMetaData() {
        return this.applicationMetadata;
    }

    public void setMetaData(MetaData metaData) {
        this.applicationMetadata = (ApplicationMetaData)metaData;
    }

    public boolean equals(Object object) {
        if (object instanceof DeployedApplication) {
            return this.name.equals(((DeployedApplication)object).getName());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected void registerMBean() {
        Object object;
        Properties properties = new Properties();
        Server server2 = (Server)this.getService(Server.class);
        properties.put("Server", server2.getName());
        this.releaseService(server2);
        properties.put("J2EEName", ((Object)this.applicationMetadata.getJ2EEName()).toString());
        ApplicationCollaborator applicationCollaborator = new ApplicationCollaborator(this);
        if (EditionHelper.isEditionSupportEnabled()) {
            object = this.getAppDeploymentName();
            String string = ((String)object).substring(((String)object).lastIndexOf(File.separatorChar) + 1, ((String)object).length());
            applicationCollaborator.setEdition(EditionHelper.getAppAndEdition(string)[1]);
        } else {
            applicationCollaborator.setEdition("BASE");
        }
        this.registerMBean("Application", (RuntimeCollaborator)applicationCollaborator, this.getName(), this.id, properties);
        try {
            if (AdminServiceFactory.getAdminService().queryNames(new ObjectName("WebSphere:*,j2eeType=J2EEApplication,name=" + ((Object)this.applicationMetadata.getJ2EEName()).toString() + ",process=" + server2.getName() + ",node=" + server2.getNodeName()), null).isEmpty()) {
                object = new J2EEApplication(this.applicationArchive.getAbsolutePath(), this.applicationArchive.getDeploymentDescriptorFileString());
                this.registerMBean("J2EEApplication", (RuntimeCollaborator)object, this.getName(), this.id, properties);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName(), "972");
        }
    }

    protected void deregisterMBean() {
        if (this.applicationMetadata != null) {
            String string = "WebSphere:type=Application,J2EEName=" + ((Object)this.applicationMetadata.getJ2EEName()).toString() + ",*";
            this.deregisterMBeanViaQuery(string);
        }
    }

    public ApplicationConfig getClusterConfiguration() {
        if (this.clusterMap != null) {
            return (ApplicationConfig)this.clusterMap.getConfig();
        }
        return null;
    }

    public ApplicationConfig getServerConfiguration() {
        if (this.serverMap != null) {
            return (ApplicationConfig)this.serverMap.getConfig();
        }
        return null;
    }

    int getWeight() {
        return this.weight;
    }

    boolean isBackgroundApp() {
        return this.applicationDeployment.isBackgroundApplication();
    }

    protected String getAppDeploymentName() {
        return this.appDeploymentName;
    }

    class MappableContentsArchive {
        private boolean applicationIsWrdDeployed = false;
        private String wrdBinariesLocation = null;
        private String binariesURL = null;
        private LooseApplication looseApplication;
        private EARFile earFile = null;
        private boolean useMetaDataFromBinaries = false;
        private boolean processFARModules = false;

        public MappableContentsArchive(List list, String string, boolean bl, boolean bl2) {
            this.processFARModules = bl2;
            this.useMetaDataFromBinaries = bl;
            Property property = null;
            this.binariesURL = string;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                property = (Property)iterator.next();
                if (property == null || !property.getName().equals("was.loose.config")) continue;
                this.applicationIsWrdDeployed = true;
                this.wrdBinariesLocation = property.getValue();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, " WRD Installed App detected: " + DeployedApplicationImpl.this.appDeploymentName);
                break;
            }
        }

        private void createLooseMapping() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " creating looseMapping for: " + DeployedApplicationImpl.this.appDeploymentName);
            }
            LooseConfigRegister.singleton().addLooseMapping(this.binariesURL, this.wrdBinariesLocation);
        }

        public String getResourcesPath(String string) {
            if (this.looseApplication != null) {
                return this.looseApplication.getResourcesPath();
            }
            return string;
        }

        private void createLooseConfig() {
            if (this.useMetaDataFromBinaries) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " creating looseConfig for: " + DeployedApplicationImpl.this.appDeploymentName);
            }
            LooseConfiguration looseConfiguration = LooseConfigRegister.singleton().getLooseConfiguration();
            LooseconfigFactory looseconfigFactory = (LooseconfigFactory)LooseconfigPackage.eINSTANCE.getEFactoryInstance();
            LooseApplication looseApplication = looseconfigFactory.createLooseApplication();
            looseApplication.setBinariesPath(this.binariesURL);
            URI uRI = DeployedApplicationImpl.this.applicationDeployment.eResource().getURI().trimSegments(1);
            String string = uRI.toFileString();
            string = ArchiveUtil.getOSUri((String)string);
            looseApplication.setResourcesPath(string);
            looseApplication.setUri(string);
            this.looseApplication = looseApplication;
            looseConfiguration.getApplications().add((Object)looseApplication);
        }

        private void createModuleLooseConfig(String string) {
            Object object;
            LooseWARFile looseWARFile;
            if (this.looseApplication == null) {
                return;
            }
            LooseConfiguration looseConfiguration = LooseConfigRegister.singleton().getLooseConfiguration();
            LooseconfigFactory looseconfigFactory = (LooseconfigFactory)LooseconfigPackage.eINSTANCE.getEFactoryInstance();
            EList eList = this.earFile.getDeploymentDescriptor().getModules();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                Module module = (Module)eList.get(i);
                if (string != null && (string == null || !module.getUri().equals(string))) continue;
                looseWARFile = module.isWebModule() ? looseconfigFactory.createLooseWARFile() : looseconfigFactory.createLooseModule();
                looseWARFile.setUri(module.getUri());
                looseWARFile.setAltDD(module.getAltDD());
                looseWARFile.setBinariesPath(this.looseApplication.getBinariesPath() + "/" + looseWARFile.getUri());
                object = looseWARFile.getAltDD();
                if (object == null || ((String)object).length() == 0) {
                    object = looseWARFile.getUri();
                }
                looseWARFile.setResourcesPath(this.looseApplication.getResourcesPath() + "/" + (String)object);
                this.looseApplication.getLooseArchives().add((Object)looseWARFile);
            }
            if (this.processFARModules) {
                List list = this.earFile.getFARFiles();
                int n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    looseWARFile = (Archive)list.get(n);
                    if (string != null && (string == null || !looseWARFile.getURI().equals(string))) continue;
                    object = looseconfigFactory.createLooseLibrary();
                    object.setUri(looseWARFile.getURI());
                    object.setBinariesPath(this.looseApplication.getBinariesPath() + "/" + object.getUri());
                    this.looseApplication.getLooseArchives().add(object);
                    looseWARFile.getLoadStrategy().setLooseArchive((LooseArchive)object);
                }
            }
        }

        protected void dispose(DeployedModuleImpl deployedModuleImpl) {
            if (this.looseApplication != null) {
                Iterator iterator = this.looseApplication.getLooseArchives().iterator();
                while (iterator.hasNext()) {
                    LooseModule looseModule = (LooseModule)iterator.next();
                    if (!looseModule.getUri().equals(deployedModuleImpl.getModuleRef().getUri())) continue;
                    this.looseApplication.getLooseArchives().remove((Object)looseModule);
                    break;
                }
            }
        }

        protected void dispose() {
            if (this.looseApplication != null) {
                LooseConfigRegister.singleton().getLooseConfiguration().getApplications().remove((Object)this.looseApplication);
            }
            this.looseApplication = null;
        }

        public EARFile open(String string, boolean bl) throws Throwable {
            if (this.applicationIsWrdDeployed) {
                this.createLooseMapping();
            } else if (!bl) {
                this.createLooseConfig();
            }
            CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            archiveOptions.setDiscriminateNestedArchives(this.processFARModules);
            this.earFile = commonarchiveFactory.openEARFile(archiveOptions, this.getResourcesPath(this.binariesURL));
            try {
                this.earFile.getDeploymentDescriptor();
                this.earFile.getBindings();
                this.earFile.getExtensions();
            }
            catch (Throwable throwable) {
                this.close(true);
                throw throwable;
            }
            if (!this.applicationIsWrdDeployed) {
                if (!bl) {
                    this.createModuleLooseConfig(null);
                } else {
                    this.createModuleLooseConfig(string);
                }
            }
            return this.earFile;
        }

        ModuleFile reopen() throws ReopenException {
            this.earFile.setManifest((ArchiveManifest)null);
            this.earFile.reopen();
            return this.earFile;
        }

        void close(boolean bl) {
            EList eList;
            if (!this.isOpen()) {
                return;
            }
            if (!bl) {
                eList = this.earFile.getModuleRefs();
                for (int i = 0; i < eList.size(); ++i) {
                    if (!((ModuleRef)eList.get(i)).usesAltDD()) continue;
                    return;
                }
            }
            this.earFile.setBindings(null);
            this.earFile.setExtensions(null);
            this.earFile.setDeploymentDescriptor(null);
            eList = this.earFile.getResourceSet();
            EList eList2 = eList.getResources();
            Resource[] resourceArray = eList2.toArray(new Resource[eList2.size()]);
            eList2.clear();
            for (int i = 0; i < resourceArray.length; ++i) {
                resourceArray[i].unload();
            }
            this.earFile.close();
        }

        boolean isOpen() {
            if (this.earFile != null) {
                return this.earFile.isOpen();
            }
            return false;
        }

        public EObject getDeploymentDescriptor() {
            return this.earFile.getDeploymentDescriptor();
        }

        public String getDeploymentDescriptorFileString() throws FileNotFoundException {
            return this.earFile.getDeploymentDescriptorResource().getURI().toFileString();
        }

        public String getAbsolutePath() throws FileNotFoundException {
            return this.earFile.getAbsolutePath();
        }

        public EARFile getEARFile() {
            return this.earFile;
        }

        public EObject getBinding() {
            return this.earFile.getBindings();
        }

        public EObject getExtension() {
            return this.earFile.getExtensions();
        }
    }
}

