/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.classloader.ClassLoadingMode;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.InstalledOptionalPackageMetaData;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.DeployedApplicationImpl;
import com.ibm.ws.runtime.component.DeployedEJBModuleImpl;
import com.ibm.ws.runtime.component.DeployedNonSpecificModuleImpl;
import com.ibm.ws.runtime.component.DeployedWARModuleImpl;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.LibraryMgr;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;

public abstract class DeployedModuleImpl
extends ComponentImpl
implements DeployedModule,
Comparable {
    private static TraceComponent tc = Tr.register(DeployedModuleImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private DeployedApplicationImpl deployedApplication;
    private com.ibm.etools.commonarchive.ModuleRef moduleRef;
    private DeploymentTargetMapping serverMap;
    private DeploymentTargetMapping clusterMap;
    private ModuleDeployment moduleDeployment;
    private ModuleMetaData metadata;
    private int weight;
    private String id;
    private DMIAlarm closeModuleAlarm = null;
    private long closeModuleDelay = DEFAULT_CLOSE_MODULE_DELAY;
    private static long DEFAULT_CLOSE_MODULE_DELAY = 180000L;
    protected static String START_MODULE_REQUEST;
    protected static String STOP_MODULE_REQUEST;

    DeployedModuleImpl(DeployedApplicationImpl deployedApplicationImpl, DeploymentTargetMapping deploymentTargetMapping, DeploymentTargetMapping deploymentTargetMapping2, Module module, ModuleDeployment moduleDeployment) {
        this.moduleRef = (com.ibm.etools.commonarchive.ModuleRef)deployedApplicationImpl.getEARFile().getModuleRef(module);
        this.deployedApplication = deployedApplicationImpl;
        this.serverMap = deploymentTargetMapping;
        this.clusterMap = deploymentTargetMapping2;
        this.moduleDeployment = moduleDeployment;
        ModuleDeployment moduleDeployment2 = this.getModuleDeployment();
        this.id = this.getConfigId((EObject)moduleDeployment2);
        this.weight = moduleDeployment2.getStartingWeight();
        String string = moduleDeployment2.getAltDD();
        if (string == null || string.length() == 0) {
            string = moduleDeployment2.getUri();
        }
        this.setName(string);
    }

    public String getId() {
        return this.id;
    }

    protected DeployedObjectEvent createDeployedObjectEvent(String string) {
        ApplicationServer applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
        String string2 = applicationServer.getState();
        this.releaseService(applicationServer);
        DeployedObjectEvent deployedObjectEvent = new DeployedObjectEvent(this, "state", this.state, string, string2);
        return deployedObjectEvent;
    }

    abstract boolean allowsThisModuleOperation(String var1);

    static DeployedModule getTypeSpecificInstance(DeployedApplicationImpl deployedApplicationImpl, DeploymentTargetMapping deploymentTargetMapping, DeploymentTargetMapping deploymentTargetMapping2, Module module, ModuleDeployment moduleDeployment) {
        com.ibm.etools.commonarchive.ModuleRef moduleRef = (com.ibm.etools.commonarchive.ModuleRef)deployedApplicationImpl.getEARFile().getModuleRef(module);
        if (moduleRef.isWeb()) {
            return new DeployedWARModuleImpl(deployedApplicationImpl, deploymentTargetMapping, deploymentTargetMapping2, module, moduleDeployment);
        }
        if (moduleRef.isEJB()) {
            return new DeployedEJBModuleImpl(deployedApplicationImpl, deploymentTargetMapping, deploymentTargetMapping2, module, moduleDeployment);
        }
        return new DeployedNonSpecificModuleImpl(deployedApplicationImpl, deploymentTargetMapping, deploymentTargetMapping2, module, moduleDeployment);
    }

    protected void setState(String string) throws RuntimeError, RuntimeWarning {
        DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent(string);
        this.setState(deployedObjectEvent);
    }

    protected void setState(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        this.deployedApplication.fireDeployedObjectEvent(deployedObjectEvent);
        try {
            super.setState(deployedObjectEvent.getNewValue().toString());
        }
        catch (WsException wsException) {
            throw new RuntimeError(wsException);
        }
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    boolean isOpen() {
        if (this.moduleRef != null) {
            return this.moduleRef.getModuleFile().isOpen();
        }
        return false;
    }

    protected ModuleFile open() throws Throwable {
        try {
            this.moduleRef.getDeploymentDescriptor();
            this.moduleRef.getBindings();
            this.moduleRef.getExtensions();
        }
        catch (Throwable throwable) {
            this.close(true);
            throw throwable;
        }
        return this.moduleRef.getModuleFile();
    }

    ModuleFile reopen() throws ReopenException, ArchiveWrappedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reopen", this);
        }
        ModuleFile moduleFile = this.moduleRef.getModuleFile();
        moduleFile.setManifest((ArchiveManifest)null);
        moduleFile.reopen((Archive)this.deployedApplication.getEARFile());
        this.moduleRef.getDeploymentDescriptor();
        this.moduleRef.getBindings();
        this.moduleRef.getExtensions();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reopen", this);
        }
        return moduleFile;
    }

    void close(boolean bl) {
        Resource[] resourceArray;
        Resource resource;
        Resource resource2;
        if (!this.isOpen()) {
            return;
        }
        if (this.closeModuleAlarm != null && !bl) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", this);
        }
        ModuleFile moduleFile = this.moduleRef.getModuleFile();
        try {
            resource2 = this.getDeploymentDescriptor().eResource();
            resource = this.getBinding().eResource();
            resourceArray = this.getExtension().eResource();
            EClass eClass = moduleFile.eClass();
            moduleFile.eSet(eClass.getEStructuralFeature("bindings"), null);
            moduleFile.eSet(eClass.getEStructuralFeature("extensions"), null);
            moduleFile.eSet(eClass.getEStructuralFeature("deploymentDescriptor"), null);
            EList eList = resource2.getResourceSet().getResources();
            eList.remove(resource);
            eList.remove(resourceArray);
            eList.remove(resource2);
            resource.unload();
            resourceArray.unload();
            resource2.unload();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName(), "303", this);
        }
        resource2 = moduleFile.getResourceSet();
        resource = resource2.getResources();
        resourceArray = resource.toArray(new Resource[resource.size()]);
        resource.clear();
        for (int i = 0; i < resourceArray.length; ++i) {
            resourceArray[i].unload();
        }
        moduleFile.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close", this);
        }
    }

    public ModuleFile getModuleFile() {
        return this.moduleRef.getModuleFile();
    }

    public ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    public ClassLoader getClassLoader() {
        return this.deployedApplication.getClassLoader(this.moduleRef);
    }

    public EObject getDeploymentDescriptor() {
        try {
            return this.moduleRef.getDeploymentDescriptor();
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            FFDCFilter.processException((Throwable)archiveWrappedException, this.getClass().getName(), "350", this);
            return null;
        }
    }

    public EObject getBinding() {
        try {
            return this.moduleRef.getBindings();
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            FFDCFilter.processException((Throwable)archiveWrappedException, this.getClass().getName(), "364", this);
            return null;
        }
    }

    public EObject getExtension() {
        try {
            return this.moduleRef.getExtensions();
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            FFDCFilter.processException((Throwable)archiveWrappedException, this.getClass().getName(), "378", this);
            return null;
        }
    }

    public ModuleDeployment getModuleDeployment() {
        return this.moduleDeployment;
    }

    public ModuleConfig getServerConfiguration() {
        if (this.serverMap != null) {
            return (ModuleConfig)this.serverMap.getConfig();
        }
        return null;
    }

    public ModuleConfig getClusterConfiguration() {
        if (this.clusterMap != null) {
            return (ModuleConfig)this.clusterMap.getConfig();
        }
        return null;
    }

    boolean isEnabled() {
        DeploymentTargetMapping deploymentTargetMapping = this.serverMap;
        if (this.clusterMap != null) {
            deploymentTargetMapping = this.clusterMap;
        }
        return deploymentTargetMapping.isEnable();
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        try {
            this.setState("INITIALIZING");
        }
        catch (WsException wsException) {
            // empty catch block
        }
        try {
            this.open();
        }
        catch (Throwable throwable) {
            this.close(true);
            throw new ConfigurationWarning("Open failure", throwable);
        }
        try {
            this.setState("INITIALIZED");
        }
        catch (WsException wsException) {
            FFDCFilter.processException((Throwable)wsException, this.getClass().getName(), "435", this);
        }
    }

    public void destroy() {
        try {
            this.setState("DESTROYING");
        }
        catch (WsException wsException) {
            FFDCFilter.processException((Throwable)wsException, this.getClass().getName(), "449", this);
        }
        try {
            this.setState("DESTROYED");
        }
        catch (WsException wsException) {
            // empty catch block
        }
        this.deployedApplication.removeClassLoader(this.moduleRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        boolean bl = true;
        try {
            if (!this.isOpen()) {
                try {
                    this.reopen();
                }
                catch (ReopenException reopenException) {
                    throw new RuntimeWarning("Reopen failed", reopenException);
                }
                catch (ArchiveWrappedException archiveWrappedException) {
                    throw new RuntimeWarning("Reopen failed", archiveWrappedException);
                }
            }
            MetaDataFactoryMgr metaDataFactoryMgr = null;
            LibraryMgr libraryMgr = null;
            try {
                InstalledOptionalPackageMetaData[] installedOptionalPackageMetaDataArray;
                ModuleFile moduleFile = this.moduleRef.getModuleFile();
                if (libraryMgr == null) {
                    libraryMgr = (LibraryMgr)this.getService(LibraryMgr.class);
                }
                if ((installedOptionalPackageMetaDataArray = libraryMgr.processInstalledOptionalPackages(moduleFile)) != null) {
                    for (int i = 0; i < installedOptionalPackageMetaDataArray.length; ++i) {
                        if (!installedOptionalPackageMetaDataArray[i].dependenciesAreSpecified() || installedOptionalPackageMetaDataArray[i].specifiedDependenciesAreResolved()) continue;
                        throw new RuntimeWarning("Unresolved Dependency on specified Installed Optional Package");
                    }
                }
                if (this.moduleRef.isWeb()) {
                    WebModuleDeployment webModuleDeployment = (WebModuleDeployment)this.getModuleDeployment();
                    boolean bl2 = webModuleDeployment.getClassloaderMode().getValue() == 0;
                    Classloader classloader = webModuleDeployment.getClassloader();
                    if (classloader != null && classloader.isSetMode()) {
                        boolean bl3;
                        ClassLoadingMode classLoadingMode = classloader.getMode();
                        boolean bl4 = bl3 = classLoadingMode.getValue() == 0;
                        if (bl3 != bl2) {
                            Tr.warning(tc, "WSVR0320W", new Object[]{bl3 ? "PARENT-FIRST" : "PARENT-LAST", bl2 ? "PARENT-FIRST" : "PARENT-LAST", webModuleDeployment.getUri()});
                            bl2 = bl3;
                        }
                    }
                    this.deployedApplication.getClassLoaderManager().setDelegationMode(this.moduleRef, bl2);
                }
                DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent("STARTING");
                this.deployedApplication.fireDeployedObjectAdjust(deployedObjectEvent);
                metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(MetaDataFactoryMgr.class);
                metaDataFactoryMgr.createMetaData(this);
                this.setState(deployedObjectEvent);
                this.deployedApplication.fireDeployedObjectStart(deployedObjectEvent);
                this.setState("STARTED");
                bl = false;
            }
            catch (Throwable throwable) {
                this.releaseService(metaDataFactoryMgr);
                throw throwable;
            }
            this.releaseService(metaDataFactoryMgr);
        }
        finally {
            this.close(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            String string = this.state;
            DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent("STOPPING");
            try {
                this.setState(deployedObjectEvent);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "358", this);
            }
            if (string == "STARTED") {
                try {
                    this.deployedApplication.fireDeployedObjectStop(deployedObjectEvent);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "366", this);
                }
            }
            try {
                this.setState("STOPPED");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "373", this);
            }
            MetaDataFactoryMgr metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(MetaDataFactoryMgr.class);
            metaDataFactoryMgr.destroyMetaData(this);
            this.releaseService(metaDataFactoryMgr);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Tr.error(tc, "WSVR0233E", new Object[]{this.getModuleFile().getName(), this.getDeployedApplication().getName()});
            FFDCFilter.processException(throwable, this.getClass().getName(), "201", this);
        }
        finally {
            this.close(true);
        }
    }

    public MetaData getMetaData() {
        return this.metadata;
    }

    public void setMetaData(MetaData metaData) {
        this.metadata = (ModuleMetaData)metaData;
    }

    public int compareTo(Object object) {
        if (object instanceof DeployedModuleImpl) {
            return this.weight - ((DeployedModuleImpl)object).weight;
        }
        return 0;
    }

    public synchronized void touch() throws RuntimeError {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "touch", this);
            }
            if (!this.isOpen()) {
                try {
                    final DeployedApplicationImpl deployedApplicationImpl = this.deployedApplication;
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws ReopenException, ArchiveWrappedException, RuntimeError, RuntimeWarning {
                            DeployedModuleImpl.this.reopen();
                            deployedApplicationImpl.fireDeployedObjectAdjust(DeployedModuleImpl.this.createDeployedObjectEvent("STARTING"));
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof ReopenException) {
                        FFDCFilter.processException(throwable, this.getClass().getName(), "562", this);
                        throw new RuntimeError("Couldnt reopen module " + this.getName(), throwable);
                    }
                    if (throwable instanceof RuntimeWarning) {
                        FFDCFilter.processException(throwable, this.getClass().getName(), "594", this);
                        throw new RuntimeError("Couldnt reopen module " + this.getName(), throwable);
                    }
                    if (!(throwable instanceof RuntimeError)) break block8;
                    throw (RuntimeException)throwable;
                }
            }
        }
        if (this.closeModuleAlarm != null) {
            this.closeModuleAlarm.cancel();
            this.closeModuleAlarm = null;
        }
        this.closeModuleAlarm = new DMIAlarm(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "touch");
        }
    }

    long getCloseModuleDelay() {
        return this.closeModuleDelay;
    }

    void setCloseModuleDelay(long l) {
        this.closeModuleDelay = l;
    }

    static {
        String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.ws.runtime.deployedModuleCloseDelay");
            }
        });
        if (string != null) {
            try {
                DEFAULT_CLOSE_MODULE_DELAY = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException(numberFormatException, DeployedModuleImpl.class.getName(), "99");
            }
        }
        START_MODULE_REQUEST = "START";
        STOP_MODULE_REQUEST = "STOP";
    }

    private class DMIAlarm
    implements AlarmListener {
        private DeployedModuleImpl dmi;
        private boolean isCanceled = false;
        private volatile Alarm alarm;

        DMIAlarm(DeployedModuleImpl deployedModuleImpl2) {
            this.dmi = deployedModuleImpl2;
            this.alarm = AlarmManager.createDeferrable(deployedModuleImpl2.closeModuleDelay, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            DeployedModuleImpl deployedModuleImpl = this.dmi;
            synchronized (deployedModuleImpl) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "alarm", this);
                }
                if (!this.isCanceled && DeployedModuleImpl.this.isOpen()) {
                    DeployedModuleImpl.this.closeModuleAlarm = null;
                    DeployedModuleImpl.this.close(true);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "alarm", this);
                }
            }
        }

        private void cancel() {
            this.isCanceled = true;
            this.alarm.cancel();
        }
    }
}

