/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class DeploymentHelper {
    private static final String DEPLOYMENT = "deployment.xml";
    private static final String EAR_EXTENSION = ".ear";
    private static final String SERVERINDEX = "serverindex.xml";
    private static TraceComponent tc = Tr.register(DeploymentHelper.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private Repository repository = null;
    private ConfigRoot configRoot = null;
    private String appName = null;
    private String appDeploymentName = null;
    private Deployment deployment = null;
    private ServerEntry serverEntry = null;

    DeploymentHelper(String string, Repository repository2) {
        this.appName = string;
        this.repository = repository2;
    }

    public String toString() {
        return "DeploymentHelper[appName=" + this.appName + ",repository=" + this.repository + "]";
    }

    Deployment getDeployment() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeployment", this);
        }
        if (this.deployment == null) {
            try {
                this.getConfigRoot().setValue(1, this.getAppDeploymentName());
                Resource resource = this.getConfigRoot().getResource(1, DEPLOYMENT);
                this.deployment = (Deployment)resource.getContents().get(0);
            }
            catch (Exception exception) {
                Tr.error(tc, "WSVR0100W", new Object[]{this.getAppName(), exception});
                throw new ConfigurationWarning("Error loading deployment.xml for " + this.getAppName(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployment", this.deployment);
        }
        return this.deployment;
    }

    private ConfigRoot getConfigRoot() {
        if (this.configRoot == null) {
            this.configRoot = this.getRepository().getConfigRoot();
        }
        return this.configRoot;
    }

    private Repository getRepository() {
        return this.repository;
    }

    String getAppDeploymentName() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentName", this);
        }
        if (this.appDeploymentName == null) {
            ServerEntry serverEntry = this.getServerEntry();
            Resource resource = serverEntry.eResource();
            resource.getResourceSet().getResources().remove((Object)resource);
            resource.unload();
            EList eList = serverEntry.getDeployedApplications();
            int n = eList.size();
            for (int i = 0; this.appDeploymentName == null && i < n; ++i) {
                String string = (String)eList.get(i);
                if (!string.startsWith(this.appName) || !string.regionMatches(this.appName.length(), EAR_EXTENSION, 0, EAR_EXTENSION.length()) || string.charAt(this.appName.length() + EAR_EXTENSION.length()) != '/') continue;
                this.appDeploymentName = string;
            }
            if (this.appDeploymentName == null) {
                Tr.warning(tc, "WSVR0215W", this.appName);
                throw new ConfigurationWarning("Application " + this.appName + " is not installed");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApDeploymentName", this.appDeploymentName);
        }
        return this.appDeploymentName;
    }

    ServerEntry getServerEntry() throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerEntry", this);
        }
        if (this.serverEntry == null) {
            Resource resource;
            String string = this.getRepository().getServerName();
            try {
                resource = this.getRepository().getConfigRoot().getResource(3, SERVERINDEX);
            }
            catch (Exception exception) {
                throw new ConfigurationError("Error loading serverindex.xml", exception);
            }
            EList eList = ((ServerIndex)resource.getContents().get(0)).getServerEntries();
            for (int i = 0; i < eList.size() && this.serverEntry == null; ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!serverEntry.getServerName().equals(string)) continue;
                this.serverEntry = serverEntry;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerEntry", this.serverEntry);
        }
        return this.serverEntry;
    }

    String getAppName() {
        return this.appName;
    }
}

