/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class EndPointMgrImpl
extends ComponentImpl
implements EndPointMgr,
PropertyChangeListener {
    static final String SERVERINDEX = "serverindex.xml";
    private static final TraceComponent tc = Tr.register(EndPointMgrImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected Map nodeEndPoints;
    protected String defaultNodeName;
    protected String defaultServerName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.addService(EndPointMgr.class);
        Server server2 = (Server)this.getService(Server.class);
        server2.addPropertyChangeListener("state", this);
        try {
            this.nodeEndPoints = new HashMap(2);
            this.defaultNodeName = server2.getNodeName();
            this.defaultServerName = server2.getName();
            object2 = this.getNodeEndPoints(this.nodeEndPoints, this.defaultNodeName);
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception);
        }
        finally {
            this.releaseService(server2);
        }
        if (this.getNodeEndPoints(this.defaultNodeName).getServerEndPoints(this.defaultServerName) == null) {
            object2 = null;
            String string = SERVERINDEX;
            try {
                object2 = (Repository)this.getService(Repository.class);
                ConfigRoot configRoot = object2.getConfigRoot();
                string = configRoot.getAbsolutePath(3, SERVERINDEX);
            }
            catch (Throwable throwable) {
            }
            finally {
                this.releaseService(object2);
            }
            Tr.error(tc, "WSVR0150E", new Object[]{this.defaultServerName, string});
            throw new ConfigurationError(this.defaultServerName + " not defined in " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
    }

    public Map getNodeEndPoints() {
        Repository repository2 = (Repository)this.getService(Repository.class);
        String[] stringArray = repository2.getConfigRoot().list(3, null);
        this.releaseService(repository2);
        HashMap hashMap = this.nodeEndPoints;
        if (hashMap == null) {
            hashMap = new HashMap(stringArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.getNodeEndPoints(hashMap, stringArray[i]);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public EndPointMgr.NodeEndPoints getNodeEndPoints(String string) {
        return this.getNodeEndPoints(this.nodeEndPoints, string);
    }

    protected NodeEndPointsImpl getNodeEndPoints(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeEndPoints", string);
        }
        NodeEndPointsImpl nodeEndPointsImpl = null;
        if ("@".equals(string)) {
            string = this.defaultNodeName;
        }
        if (map != null) {
            nodeEndPointsImpl = (NodeEndPointsImpl)map.get(string);
        }
        if (nodeEndPointsImpl == null) {
            try {
                nodeEndPointsImpl = this.parseServerIndex(string);
                if (map != null) {
                    map.put(string, nodeEndPointsImpl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeEndPoints", this.getDebugString(nodeEndPointsImpl));
        }
        return nodeEndPointsImpl;
    }

    protected NodeEndPointsImpl parseServerIndex(String string) throws Exception {
        Repository repository2 = (Repository)this.getService(Repository.class);
        ConfigRoot configRoot = repository2.getConfigRoot();
        Resource resource = null;
        String string2 = null;
        if (this.defaultNodeName.equals(string)) {
            string2 = this.defaultServerName;
        }
        String string3 = configRoot.setValue(3, string);
        try {
            resource = configRoot.getResource(3, SERVERINDEX);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            NodeEndPointsImpl nodeEndPointsImpl = this.parseServerIndex(string, serverIndex, string2);
            return nodeEndPointsImpl;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, configRoot.getAbsolutePath(3, SERVERINDEX) + " was not loaded\n", exception);
            }
            throw exception;
        }
        finally {
            if (resource != null) {
                configRoot.remove(resource);
            }
            configRoot.setValue(3, string3);
            this.releaseService(repository2);
        }
    }

    protected NodeEndPointsImpl parseServerIndex(String string, ServerIndex serverIndex, String string2) {
        Map map = this.parseEndPoints((List)serverIndex.getEndPointRefs());
        EList eList = serverIndex.getServerEntries();
        HashMap<String, ServerEndPointsImpl> hashMap = new HashMap<String, ServerEndPointsImpl>(eList.size());
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            ServerEndPointsImpl serverEndPointsImpl = new ServerEndPointsImpl(serverEntry.getServerName(), serverEntry.getServerType(), this.parseEndPoints((List)serverEntry.getSpecialEndpoints()));
            hashMap.put(serverEndPointsImpl.getName(), serverEndPointsImpl);
        }
        return new NodeEndPointsImpl(string, serverIndex.getHostName(), map, hashMap, string2);
    }

    protected Map parseEndPoints(List list) {
        HashMap<String, EndPoint> hashMap = new HashMap<String, EndPoint>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)list.get(i);
            hashMap.put(namedEndPoint.getEndPointName(), namedEndPoint.getEndPoint());
            EndPoint endPoint = namedEndPoint.getEndPoint();
            String string = null;
            try {
                string = this.expandVariable(endPoint.getHost());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (string != null) {
                endPoint.setHost(string);
            }
            hashMap.put(namedEndPoint.getEndPointName(), endPoint);
        }
        return hashMap;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() == "STARTED") {
            this.nodeEndPoints = null;
            ((Server)propertyChangeEvent.getSource()).removePropertyChangeListener("state", this);
        }
    }

    private String getDebugString(EndPointMgr.NodeEndPoints nodeEndPoints) {
        Object object;
        Object object2;
        Object object3;
        if (nodeEndPoints == null) {
            return "<empty>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NodeEndPoints name=");
        stringBuffer.append(nodeEndPoints.getName());
        Map map = nodeEndPoints.getEndPoints();
        stringBuffer.append("\n  Node End Points:");
        if (map != null && !map.isEmpty()) {
            object3 = map.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = (EndPoint)object2.getValue();
                stringBuffer.append("\n    End Point: ");
                stringBuffer.append(object2.getKey());
                stringBuffer.append("=");
                stringBuffer.append(object.getHost());
                stringBuffer.append(":");
                stringBuffer.append(object.getPort());
            }
        } else {
            stringBuffer.append("\n    <none>");
        }
        object3 = nodeEndPoints.getServerEndPoints();
        stringBuffer.append("\n  Server End Points:");
        if (object3 != null && !object3.isEmpty()) {
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                String string = (String)object.getKey();
                EndPointMgr.ServerEndPoints serverEndPoints = (EndPointMgr.ServerEndPoints)object.getValue();
                stringBuffer.append("\n    Server End Point ");
                stringBuffer.append(serverEndPoints.getName());
                stringBuffer.append(" Type:");
                stringBuffer.append(serverEndPoints.getType());
                map = serverEndPoints.getEndPoints();
                if (map == null) continue;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    EndPoint endPoint = (EndPoint)entry.getValue();
                    stringBuffer.append("\n      End Point : ");
                    stringBuffer.append(entry.getKey());
                    stringBuffer.append(" ");
                    stringBuffer.append(endPoint.getHost());
                    stringBuffer.append(":");
                    stringBuffer.append(endPoint.getPort());
                }
            }
        } else {
            stringBuffer.append("\n    <none>");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getNodeHostName(String var1_1) {
        if (EndPointMgrImpl.tc.isEntryEnabled()) {
            Tr.entry(EndPointMgrImpl.tc, "getNodeHostName", var1_1);
        }
        var2_2 = null;
        if (this.nodeEndPoints != null && (var3_3 = (NodeEndPointsImpl)this.nodeEndPoints.get(var1_1)) != null) {
            var2_2 = var3_3.hostName;
        }
        if (var2_2 == null) {
            block17: {
                if (EndPointMgrImpl.tc.isDebugEnabled()) {
                    Tr.debug(EndPointMgrImpl.tc, "Parsing serverindex.xml file for node " + var1_1);
                }
                var3_3 = null;
                var4_4 = null;
                var5_5 = null;
                var6_6 = null;
                var7_7 = false;
                var8_8 = null;
                try {
                    var3_3 = (Repository)this.getService(Repository.class);
                    var8_8 = var3_3.getConfigRoot();
                    if (this.defaultNodeName.equals(var1_1)) {
                        var5_5 = this.defaultServerName;
                    }
                    var6_6 = var8_8.setValue(3, var1_1);
                    var7_7 = true;
                    var4_4 = var8_8.getResource(3, "serverindex.xml");
                    var9_9 = (ServerIndex)var4_4.getContents().get(0);
                    var2_2 = var9_9.getHostName();
                    if (var4_4 != null) {
                        var8_8.remove(var4_4);
                    }
                    if (!var7_7) break block17;
                    var8_8.setValue(3, var6_6);
                }
                catch (Exception var9_10) {
                    block18: {
                        try {
                            FFDCFilter.processException(var9_10, EndPointMgrImpl.class.getName(), "444");
                            Tr.error(EndPointMgrImpl.tc, "WSVR0120E", new Object[]{"serverindex.xml", var9_10});
                            if (var4_4 != null) {
                                var8_8.remove(var4_4);
                            }
                            if (!var7_7) break block18;
                            var8_8.setValue(3, var6_6);
                        }
                        catch (Throwable var10_11) {
                            if (var4_4 != null) {
                                var8_8.remove(var4_4);
                            }
                            if (var7_7) {
                                var8_8.setValue(3, var6_6);
                            }
                            if (var3_3 != null) {
                                this.releaseService(var3_3);
                            }
                            throw var10_11;
                        }
                    }
                    if (var3_3 != null) {
                        this.releaseService(var3_3);
                    } else {
                        ** GOTO lbl56
                    }
                }
            }
            if (var3_3 != null) {
                this.releaseService(var3_3);
            }
        }
        if (EndPointMgrImpl.tc.isEntryEnabled()) {
            Tr.exit(EndPointMgrImpl.tc, "getNodeHostName", var2_2);
        }
        return var2_2;
    }

    static class NodeEndPointsImpl
    extends EndPointsImpl
    implements EndPointMgr.NodeEndPoints {
        Map serverEndPts;
        String defaultServer;
        String hostName;

        NodeEndPointsImpl(String string, String string2, Map map, Map map2, String string3) {
            super(string, map);
            this.serverEndPts = Collections.unmodifiableMap(map2);
            this.defaultServer = string3;
            this.hostName = string2;
        }

        public EndPointMgr.ServerEndPoints getServerEndPoints(String string) {
            if (this.defaultServer != null && "@".equals(string)) {
                string = this.defaultServer;
            }
            return (EndPointMgr.ServerEndPoints)this.serverEndPts.get(string);
        }

        void putServerEndPoints(String string, EndPointMgr.EndPoints endPoints) {
            this.serverEndPts.put(string, endPoints);
        }

        public Map getServerEndPoints() {
            return this.serverEndPts;
        }
    }

    static class ServerEndPointsImpl
    extends EndPointsImpl
    implements EndPointMgr.ServerEndPoints {
        protected String type;

        ServerEndPointsImpl(String string, String string2, Map map) {
            super(string, map);
            this.type = string2;
        }

        public String getType() {
            return this.type;
        }
    }

    static class EndPointsImpl
    implements EndPointMgr.EndPoints {
        protected String name;
        protected Map endPts;

        EndPointsImpl(String string, Map map) {
            this.name = string;
            this.endPts = Collections.unmodifiableMap(map);
        }

        public EndPoint getEndPoint(String string) {
            return (EndPoint)this.endPts.get(string);
        }

        public Map getEndPoints() {
            return this.endPts;
        }

        public String getName() {
            return this.name;
        }
    }
}

