/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.models.config.loggingservice.http.HTTPAccessLogFormat;
import com.ibm.websphere.models.config.loggingservice.http.HTTPAccessLoggingService;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.ws.http.logging.impl.BaseLogger;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.HttpLogLevel;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class HTTPLoggingServiceImpl
extends WsComponentImpl
implements HTTPLoggingService {
    private static final TraceComponent tc = Tr.register(HTTPLoggingServiceImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private BaseLogger myLogger = null;
    private boolean bRunning = false;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        HTTPAccessLoggingService hTTPAccessLoggingService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (null == (hTTPAccessLoggingService = (HTTPAccessLoggingService)object)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize: no configuration");
            }
            throw new ComponentDisabledException("No configuration found");
        }
        if (!hTTPAccessLoggingService.isEnable()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize: disabled by config");
            }
            throw new ComponentDisabledException("Config disabled");
        }
        this.myLogger = new BaseLogger();
        VariableMap variableMap = null;
        try {
            variableMap = (VariableMap)WsServiceRegistry.getService((Object)this, (Class)VariableMap.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "initialize"), (String)"99", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize: getService failed: " + exception);
            }
            throw new ComponentDisabledException("getService failed");
        }
        this.parseErrorLog(variableMap, hTTPAccessLoggingService);
        this.parseAccessLog(variableMap, hTTPAccessLoggingService);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Registering the logging service now.");
        }
        try {
            WsServiceRegistry.addService((Object)this, (Class)HTTPLoggingService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "initialize"), (String)"117", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize: addService failed: " + exception);
            }
            throw new ComponentDisabledException("addService failed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void parseAccessLog(VariableMap variableMap, HTTPAccessLoggingService hTTPAccessLoggingService) throws ComponentDisabledException {
        int n;
        String string = hTTPAccessLoggingService.getAccessLog().getFilePath();
        if (null == string) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Empty access log filename");
            }
            return;
        }
        try {
            string = variableMap.expand(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Map expansion threw: " + illegalArgumentException.getMessage());
                Tr.debug(tc, "Unable to start with access name: " + string);
            }
            throw new ComponentDisabledException("Unsupported access filename: " + string);
        }
        try {
            this.myLogger.createAccessLogger(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Logging service was unable to open a file: " + string);
                Tr.debug(tc, fileNotFoundException.getMessage());
            }
            this.myLogger = null;
            throw new ComponentDisabledException(fileNotFoundException.getMessage());
        }
        catch (SecurityException securityException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Logging service hit security exception during init");
                Tr.debug(tc, securityException.getMessage());
            }
            this.myLogger = null;
            throw new ComponentDisabledException("Security exception " + securityException.getMessage());
        }
        if (HTTPAccessLogFormat.COMBINED_LITERAL == hTTPAccessLoggingService.getAccessLogFormat()) {
            this.setAccessFormat(1);
        } else if (HTTPAccessLogFormat.COMMON_LITERAL == hTTPAccessLoggingService.getAccessLogFormat()) {
            this.setAccessFormat(0);
        }
        if (hTTPAccessLoggingService.getAccessLog().isSetMaximumSize() && !this.setAccessLogMaximumSize((n = hTTPAccessLoggingService.getAccessLog().getMaximumSize()) * 1000000) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logging service has invalid access log size: " + n);
        }
        if (hTTPAccessLoggingService.isEnableAccessLogging()) {
            this.myLogger.enableAccessLogging();
        } else {
            this.myLogger.disableAccessLogging();
        }
        EList eList = hTTPAccessLoggingService.getProperties();
        if (null != eList) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                int n2;
                Property property = (Property)iterator.next();
                if (!"MaximumAccessBackupFiles".equals(property.getName()) || this.myLogger.setAccessLogMaximumBackupFiles(n2 = Integer.parseInt(property.getValue())) || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Logging service has invalid max access backup logs: " + n2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Access log is " + (this.isAccessLoggingEnabled() ? "enabled." : "disabled."));
        }
    }

    private void parseErrorLog(VariableMap variableMap, HTTPAccessLoggingService hTTPAccessLoggingService) throws ComponentDisabledException {
        EList eList;
        int n;
        String string = hTTPAccessLoggingService.getErrorLog().getFilePath();
        if (null == string) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Empty error log filename");
            }
            return;
        }
        try {
            string = variableMap.expand(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Map expansion threw: " + illegalArgumentException.getMessage());
                Tr.debug(tc, "Unable to start with error name: " + string);
            }
            throw new ComponentDisabledException("Unsupported error filename: " + string);
        }
        try {
            this.myLogger.createErrorLogger(string, hTTPAccessLoggingService.getErrorLogLevel().getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Logging service was unable to open a file: " + string);
                Tr.debug(tc, fileNotFoundException.getMessage());
            }
            this.myLogger = null;
            throw new ComponentDisabledException(fileNotFoundException.getMessage());
        }
        catch (SecurityException securityException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Logging service hit security exception during init");
                Tr.debug(tc, securityException.getMessage());
            }
            this.myLogger = null;
            throw new ComponentDisabledException("Security exception " + securityException.getMessage());
        }
        if (hTTPAccessLoggingService.getErrorLog().isSetMaximumSize() && !this.setErrorLogMaximumSize((n = hTTPAccessLoggingService.getErrorLog().getMaximumSize()) * 1000000) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logging service has invalid error log size: " + n);
        }
        if (null != (eList = hTTPAccessLoggingService.getProperties())) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                int n2;
                Property property = (Property)iterator.next();
                if (!"MaximumErrorBackupFiles".equals(property.getName()) || this.myLogger.setErrorLogMaximumBackupFiles(n2 = Integer.parseInt(property.getValue())) || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Logging service has invalid max error backup logs: " + n2);
            }
        }
        if (hTTPAccessLoggingService.isEnableErrorLogging()) {
            this.myLogger.enableErrorLogging();
        } else {
            this.myLogger.disableErrorLogging();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Error log is " + (this.isErrorLoggingEnabled() ? "enabled." : "disabled."));
        }
    }

    public boolean enableAccessLogging() {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.enableAccessLogging();
    }

    public boolean enableErrorLogging() {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.enableErrorLogging();
    }

    public boolean startAccessLogging() {
        boolean bl = this.isAccessLoggingEnabled();
        if (bl) {
            bl = this.myLogger.startAccessLogging();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Access log start: rc=" + bl);
        }
        return bl;
    }

    public boolean startErrorLogging() {
        boolean bl = this.isErrorLoggingEnabled();
        if (bl) {
            bl = this.myLogger.startErrorLogging();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Error log start: rc=" + bl);
        }
        return bl;
    }

    public boolean disableAccessLogging() {
        if (null == this.myLogger) {
            return true;
        }
        return this.myLogger.disableAccessLogging();
    }

    public boolean disableErrorLogging() {
        if (null == this.myLogger) {
            return true;
        }
        return this.myLogger.disableErrorLogging();
    }

    public boolean stopAccessLogging() {
        if (this.isAccessLoggingEnabled()) {
            return this.myLogger.stopAccessLogging();
        }
        return true;
    }

    public boolean stopErrorLogging() {
        if (this.isErrorLoggingEnabled()) {
            return this.myLogger.stopErrorLogging();
        }
        return true;
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (null == this.myLogger) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "start: error - null logger");
            }
            throw new RuntimeWarning("Unable to start before init");
        }
        if (!this.bRunning) {
            super.start();
            this.startAccessLogging();
            this.startErrorLogging();
            this.bRunning = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        super.stop();
        if (null != this.myLogger && this.bRunning) {
            this.bRunning = false;
            this.myLogger.stopAccessLogging();
            this.myLogger.stopErrorLogging();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.bRunning = false;
        super.destroy();
        if (null != this.myLogger) {
            this.myLogger.destroy();
            this.myLogger = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void log(HttpLogLevel httpLogLevel, String string, HttpServiceContext httpServiceContext) {
        if (this.isErrorLoggingEnabled()) {
            this.myLogger.log(httpLogLevel, string, httpServiceContext);
        }
    }

    public void log(HttpLogLevel httpLogLevel, byte[] byArray, HttpServiceContext httpServiceContext) {
        if (this.isErrorLoggingEnabled()) {
            this.myLogger.log(httpLogLevel, byArray, httpServiceContext);
        }
    }

    public void logAccess(byte[] byArray) {
        if (this.isAccessLoggingEnabled()) {
            this.myLogger.logAccess(byArray);
        }
    }

    public void logAccess(StringBuffer stringBuffer) {
        if (this.isAccessLoggingEnabled()) {
            this.myLogger.logAccess(stringBuffer);
        }
    }

    public void logAccess(int n, HttpRequestMessage httpRequestMessage, HttpResponseMessage httpResponseMessage, String string, String string2, String string3, int n2) {
        if (this.isAccessLoggingEnabled()) {
            this.myLogger.logAccess(n, httpRequestMessage, httpResponseMessage, string, string2, string3, n2);
        }
    }

    public void logAccess(HttpRequestMessage httpRequestMessage, HttpResponseMessage httpResponseMessage, String string, String string2, String string3, int n) {
        if (this.isAccessLoggingEnabled()) {
            this.myLogger.logAccess(httpRequestMessage, httpResponseMessage, string, string2, string3, n);
        }
    }

    public HttpLogLevel getLogLevel() {
        if (this.isErrorLoggingEnabled()) {
            return this.myLogger.getLogLevel();
        }
        return HttpConstants.LOG_DISABLED;
    }

    public boolean isAccessLoggingEnabled() {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.isAccessLoggingEnabled();
    }

    public boolean isErrorLoggingEnabled() {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.isErrorLoggingEnabled();
    }

    public boolean isLoggingLevelEnabled(HttpLogLevel httpLogLevel) {
        if (this.isErrorLoggingEnabled()) {
            return this.myLogger.isLoggingLevelEnabled(httpLogLevel);
        }
        return false;
    }

    public int getAccessFormat() {
        if (null == this.myLogger) {
            return 0;
        }
        return this.myLogger.getAccessFormat();
    }

    public boolean setAccessFormat(int n) {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.setAccessFormat(n);
    }

    public boolean setAccessLogMaximumSize(int n) {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.setAccessLogMaximumSize(n);
    }

    public boolean setErrorLogMaximumSize(int n) {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.setErrorLogMaximumSize(n);
    }

    public boolean setAccessLogMaximumBackupFiles(int n) {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.setAccessLogMaximumBackupFiles(n);
    }

    public boolean setErrorLogMaximumBackupFiles(int n) {
        if (null == this.myLogger) {
            return false;
        }
        return this.myLogger.setErrorLogMaximumBackupFiles(n);
    }
}

