/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ApplicationMetaDataImpl;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaDataFactory;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataFactory;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.MetaDataSlotImpl;
import com.ibm.ws.runtime.metadata.MethodMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.util.ImplFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MetaDataMgrImpl
extends ComponentImpl
implements MetaDataFactoryMgr,
MetaDataService,
MetaDataFactory {
    private static final String FACTORY_COMPONENT_NAME = null;
    private static final TraceComponent tc = Tr.register(MetaDataMgrImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static Class[] metaDataInterfaces = new Class[]{ApplicationMetaData.class, ModuleMetaData.class, ComponentMetaData.class, MethodMetaData.class};
    protected int[] slots;
    protected Map metaDataMap = new HashMap();
    protected J2EENameFactory j2eeNameFactory;
    List metaDataListeners = new ArrayList();
    List metaDataFactories = new ArrayList();

    public MetaDataMgrImpl() {
        this.slots = new int[metaDataInterfaces.length];
    }

    public J2EENameFactory getJ2EENameFactory() {
        return this.j2eeNameFactory;
    }

    public ComponentMetaData getComponentMetaData(J2EEName j2EEName) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getComponentMetaData", j2EEName);
        }
        Map map = (Map)this.metaDataMap.get(j2EEName.getApplication());
        ComponentMetaData componentMetaData = null;
        if (map != null && (map = (Map)map.get(j2EEName.getModule())) != null) {
            String string = j2EEName.getComponent();
            Object v = map.get(string);
            if (v != null) {
                componentMetaData = (ComponentMetaData)v;
            } else {
                ComponentMetaDataFactory componentMetaDataFactory = (ComponentMetaDataFactory)map.get(FACTORY_COMPONENT_NAME);
                if (componentMetaDataFactory != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "factory=" + componentMetaDataFactory);
                    }
                    componentMetaData = componentMetaDataFactory.createComponentMetaData(j2EEName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getComponentMetaData", componentMetaData);
        }
        return componentMetaData;
    }

    public void addMetaDataListener(MetaDataListener metaDataListener) {
        this.metaDataListeners.add(metaDataListener);
    }

    public void removeMetaDataListener(MetaDataListener metaDataListener) {
        this.metaDataListeners.remove(metaDataListener);
    }

    public void addMetaDataFactory(MetaDataFactory metaDataFactory) {
        this.metaDataFactories.add(metaDataFactory);
    }

    public void removeMetaDataFactory(MetaDataFactory metaDataFactory) {
        this.metaDataFactories.remove(metaDataFactory);
    }

    protected MetaData createMetaDataFromFactories(DeployedObject deployedObject) throws RuntimeError, RuntimeWarning {
        MetaData metaData = null;
        for (int i = 0; metaData == null && i < this.metaDataFactories.size(); ++i) {
            metaData = ((MetaDataFactory)this.metaDataFactories.get(i)).createMetaData(this, deployedObject);
        }
        deployedObject.setMetaData(metaData);
        return metaData;
    }

    public void fireMetaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeError, RuntimeWarning {
        RuntimeWarning runtimeWarning = null;
        this.addMetaDataToMap(metaDataEvent.getMetaData());
        for (int i = 0; i < this.metaDataListeners.size(); ++i) {
            try {
                ((MetaDataListener)this.metaDataListeners.get(i)).metaDataCreated(metaDataEvent);
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
                FFDCFilter.processException(runtimeWarning2, this.getClass().getName(), "144");
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    public void fireMetaDataDestroyed(MetaDataEvent metaDataEvent) {
        for (int i = 0; i < this.metaDataListeners.size(); ++i) {
            MetaDataListener metaDataListener = (MetaDataListener)this.metaDataListeners.get(i);
            try {
                metaDataListener.metaDataDestroyed(metaDataEvent);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "161");
                Tr.debug(tc, "MetaDataListener failed, " + metaDataListener, throwable);
            }
        }
        this.removeMetaDataFromMap(metaDataEvent.getMetaData());
    }

    private synchronized void addMetaDataToMap(MetaData metaData) {
        if (metaData instanceof ComponentMetaDataFactory) {
            ComponentMetaDataFactory componentMetaDataFactory = (ComponentMetaDataFactory)metaData;
            this.getModuleMap(componentMetaDataFactory).put(FACTORY_COMPONENT_NAME, componentMetaDataFactory);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addMetaDataToMap: ComponentMetaDataFactory=" + componentMetaDataFactory);
            }
        } else if (metaData instanceof ComponentMetaData) {
            ComponentMetaData componentMetaData = (ComponentMetaData)metaData;
            this.getModuleMap(componentMetaData).put(componentMetaData.getName(), componentMetaData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addMetaDataToMap: ComponentMetaData=" + componentMetaData);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "non-component metadata");
        }
    }

    private synchronized void removeMetaDataFromMap(MetaData metaData) {
        if (metaData instanceof ComponentMetaData) {
            this.getModuleMap((ComponentMetaData)metaData).remove(metaData.getName());
        } else if (metaData instanceof ModuleMetaData) {
            this.getApplicationMap((ModuleMetaData)metaData).remove(metaData.getName());
        } else if (metaData instanceof ApplicationMetaData) {
            this.metaDataMap.remove(metaData.getName());
        }
    }

    private Map getModuleMap(ComponentMetaData componentMetaData) {
        return this.getModuleMap(componentMetaData.getModuleMetaData());
    }

    private synchronized Map getModuleMap(ModuleMetaData moduleMetaData) {
        Map map = this.getApplicationMap(moduleMetaData);
        HashMap hashMap = (HashMap)map.get(moduleMetaData.getName());
        if (hashMap == null) {
            hashMap = new HashMap(2);
            map.put(moduleMetaData.getName(), hashMap);
        }
        return hashMap;
    }

    private synchronized Map getApplicationMap(ModuleMetaData moduleMetaData) {
        ApplicationMetaData applicationMetaData = moduleMetaData.getApplicationMetaData();
        HashMap hashMap = (HashMap)this.metaDataMap.get(applicationMetaData.getName());
        if (hashMap == null) {
            hashMap = new HashMap(2);
            this.metaDataMap.put(applicationMetaData.getName(), hashMap);
        }
        return hashMap;
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.addMetaDataFactory(this);
        this.bindMetaDataService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMetaData(DeployedObject deployedObject) throws RuntimeWarning, RuntimeError {
        MetaData metaData = null;
        try {
            metaData = this.createMetaDataFromFactories(deployedObject);
        }
        finally {
            if (metaData != null) {
                metaData.release();
            }
        }
    }

    public void destroyMetaData(DeployedObject deployedObject) {
        try {
            this.destroyMetaDataFromFactories(deployedObject);
            deployedObject.setMetaData(null);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName(), "249");
        }
    }

    public MetaData createMetaData(MetaDataFactoryMgr metaDataFactoryMgr, DeployedObject deployedObject) throws RuntimeWarning, RuntimeError {
        if (deployedObject.getModuleFile().isEARFile()) {
            DeployedApplication deployedApplication = (DeployedApplication)deployedObject;
            String string = deployedObject.getName();
            ApplicationMetaDataImpl applicationMetaDataImpl = new ApplicationMetaDataImpl(string, this.j2eeNameFactory.create(string, null, null), this.getSlotSize(ApplicationMetaData.class), deployedApplication.getApplicationDeployment().isCreateMBeansForResources());
            this.fireMetaDataCreated(new MetaDataEvent(applicationMetaDataImpl, deployedObject));
            return applicationMetaDataImpl;
        }
        return null;
    }

    public int getSlotSize(Class clazz) {
        for (int i = 0; i < metaDataInterfaces.length; ++i) {
            if (!clazz.isAssignableFrom(metaDataInterfaces[i])) continue;
            return this.slots[i];
        }
        throw new IllegalArgumentException("Invalid meta interface, " + clazz);
    }

    public MetaDataSlot reserveSlot(Class clazz) {
        for (int i = 0; i < metaDataInterfaces.length; ++i) {
            if (!clazz.isAssignableFrom(metaDataInterfaces[i])) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reserveSlot(metaData=" + clazz + ", slot=" + this.slots[i] + ") --> Caller=");
                Exception exception = new Exception("reserveSlot(metaData=" + clazz + ", slot=" + this.slots[i] + ") --> Caller=");
                String string = exception.toString() + '\n';
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                for (int j = 0; j < stackTraceElementArray.length; ++j) {
                    string = string + "\tat " + stackTraceElementArray[j] + '\n';
                }
                Tr.debug(tc, string);
            }
            int n = i;
            int n2 = this.slots[n];
            this.slots[n] = n2 + 1;
            return new MetaDataSlotImpl(metaDataInterfaces[i], n2);
        }
        throw new IllegalArgumentException("Invalid meta interface, " + clazz);
    }

    protected void bindMetaDataService() throws RuntimeError {
        try {
            InitialContext initialContext = new InitialContext();
            JndiHelper.recursiveRebind((Context)initialContext, "services:websphere/MetaData", (Object)this);
        }
        catch (NamingException namingException) {
            throw new RuntimeError(namingException);
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        try {
            this.j2eeNameFactory = (J2EENameFactory)ImplFactory.loadImplFromKey(J2EENameFactory.class);
        }
        catch (Throwable throwable) {
            throw new ConfigurationError(throwable);
        }
        this.addService(MetaDataService.class);
        this.addService(MetaDataFactoryMgr.class);
    }

    public void destroyMetaData(MetaDataFactoryMgr metaDataFactoryMgr, DeployedObject deployedObject) throws RuntimeError, RuntimeWarning {
        if (deployedObject instanceof DeployedApplication) {
            DeployedApplication deployedApplication = (DeployedApplication)deployedObject;
            this.fireMetaDataDestroyed(new MetaDataEvent(deployedApplication.getMetaData(), deployedObject));
        }
    }

    private void destroyMetaDataFromFactories(DeployedObject deployedObject) throws RuntimeError, RuntimeWarning {
        for (int i = 0; i < this.metaDataFactories.size(); ++i) {
            ((MetaDataFactory)this.metaDataFactories.get(i)).destroyMetaData(this, deployedObject);
        }
    }
}

