/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.multibroker.DataReplicationDomain;
import com.ibm.websphere.models.config.multibroker.drsclient.DataReplication;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.drs.DRSDomain;
import com.ibm.ws.drs.DRSGlobals;
import com.ibm.ws.drs.DRSInstance;
import com.ibm.ws.drs.ha.DRSAgentClassEvents;
import com.ibm.ws.drs.utils.DRSBootstrapAdapterImpl;
import com.ibm.ws.drs.utils.DRSConstants;
import com.ibm.ws.drs.utils.DRSOverflowListenerImpl;
import com.ibm.ws.drs.ws390.DRSControllerInstanceFactoryImpl;
import com.ibm.ws.drs.ws390.DRSControllerInstanceWrapper;
import com.ibm.ws.drs.ws390.DRSInstanceFactory;
import com.ibm.ws.drs.ws390.DRSPlatformHelper;
import com.ibm.ws.drs.ws390.DRSServantProxyFactoryImpl;
import com.ibm.ws.drs.ws390.externaldatastore.DRSExternalDataStoreFactoryImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import com.ibm.wsspi.drs.ws390.externaldatastore.DRSExternalDataStoreFactory;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.agent.AgentClass;
import com.ibm.wsspi.hamanager.agent.AgentClassFactory;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class MultibrokerDomainImpl
extends ComponentImpl
implements MultibrokerDomain {
    private static TraceComponent tc = Tr.register(MultibrokerDomainImpl.class.getName(), "DRS", "com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    static String className = "com.ibm.ws.runtime.component.MultibrokerDomainImpl.";
    private boolean _waitedForHAM = false;
    private boolean _detectedOtherServers = false;
    private String _defaultThreadPoolName = "Default";
    private DRSControllerInstanceFactoryImpl instance;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        Resource resource;
        Object object2;
        String string;
        Object object3;
        Object object4;
        String string2;
        String string3 = "initialize: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3 + "Entry.");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "CMVC Version 1.13.3.3 2/2/10 13:10:27");
            _loggedVersion = true;
        }
        if ((string2 = AdminServiceFactory.getAdminService().getProcessType()).equals("NodeAgent") || string2.equals("DeploymentManager")) {
            throw new ComponentDisabledException();
        }
        this.addService(MultibrokerDomain.class);
        DRSGlobals.getSingleton().setMbd(this);
        DRSGlobals.getSingleton().setThreadPool(this.createDRSThreadPool());
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string4 = adminService.getCellName() + "\\" + adminService.getNodeName() + "\\" + adminService.getProcessName();
        DRSGlobals.getSingleton().setHamServerId(string4);
        Repository repository2 = (Repository)this.getService(Repository.class);
        EList eList = null;
        try {
            object4 = repository2.getConfigRoot().getResource(0, "multibroker.xml");
            eList = object4.getContents();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3 + "Warning: Unable to read mbd.xml. Creating new mbd.xml.");
            }
            object3 = new WASResourceSetImpl();
            string = repository2.getConfigRoot().getAbsolutePath(0, "multibroker.xml");
            object2 = URI.createFileURI((String)string);
            resource = object3.createResource(object2);
            try {
                resource.save(new HashMap());
                eList = resource.getContents();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)fileNotFoundException, className + "initialize", "2", this);
                throw new ConfigurationError(fileNotFoundException);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, className + "initialize", "3", this);
            throw new ConfigurationError(exception);
        }
        finally {
            this.releaseService(repository2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string3 + "mbd_list=" + eList);
        }
        object4 = eList.iterator();
        while (object4.hasNext()) {
            try {
                Object object5;
                object3 = object4.next();
                if (object3 instanceof DataReplicationDomain) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string3 + "DRD domain.");
                    }
                    string = (DataReplicationDomain)object3;
                    object2 = string.getName();
                    resource = string.getDefaultDataReplicationSettings();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string3 + "Creating DRD domain. domainName=" + (String)object2 + " dataReplication=" + resource);
                    }
                    object5 = new DRSDomain((String)object2, (DataReplication)resource);
                    DRSGlobals.getSingleton().addDomain((DRSDomain)object5);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3 + "MBD domain.");
                }
                string = (com.ibm.websphere.models.config.multibroker.MultibrokerDomain)object3;
                object2 = string.getName();
                resource = string.getDefaultDataReplicationSettings();
                object5 = resource.getPartition();
                int n = -1;
                if (object5 != null) {
                    n = object5.isPartitionOnEntry() ? 1 : -1;
                }
                resource.setNumberOfReplicas(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3 + "Creating MBD domain. domainName=" + (String)object2 + " dataReplication=" + resource);
                }
                DRSDomain dRSDomain = new DRSDomain((String)object2, (DataReplication)resource);
                DRSGlobals.getSingleton().addDomain(dRSDomain);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, className + "initialize", "4", this);
                throw new ConfigurationError(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3 + "Exit.");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        Object object;
        super.start();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " MultibrokerDomainImpl.start: Entry.");
        }
        if (DRSPlatformHelper.isZOS_Control_Region()) {
            this.instance = DRSControllerInstanceFactoryImpl.createInstance(this);
            object = DRSServantProxyFactoryImpl.createInstance(this);
            DRSExternalDataStoreFactoryImpl dRSExternalDataStoreFactoryImpl = DRSExternalDataStoreFactoryImpl.createInstance(this);
        }
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            object = DRSInstanceFactory.createInstance(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " MultibrokerDomainImpl.start: Exit.");
        }
    }

    public void destroy() {
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            DRSInstanceFactory.getInstance().unregisterServantRegion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (DRSPlatformHelper.isZOS_Servant_Region()) {
            DRSInstanceFactory.getInstance().unregisterServantRegion();
        }
        if (DRSPlatformHelper.isZOS_Control_Region()) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap = this.instance.getDRSWrappers();
            synchronized (hashMap2) {
                Iterator iterator = hashMap.values().iterator();
                while (iterator.hasNext()) {
                    DRSControllerInstanceWrapper dRSControllerInstanceWrapper = (DRSControllerInstanceWrapper)iterator.next();
                    dRSControllerInstanceWrapper.setKeepRunning(false);
                }
            }
        }
    }

    public Identity getIdentity(Map map) {
        String string = "getIdentity: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Identity identity = ClusterServiceFactory.getClusterService().getIdentity(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. identity=" + identity);
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Identity joinWLMCluster(Map map) {
        String string = "joinWLMCluster: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. agentIDMap=" + map);
        }
        Map map2 = this.getNeuteredAgentIDMap(map);
        ClusterMemberService clusterMemberService = null;
        Identity identity = null;
        try {
            clusterMemberService = (ClusterMemberService)this.getService(ClusterMemberService.class);
            ClusterService clusterService = ClusterServiceFactory.getClusterService();
            identity = clusterService.getIdentity(map2);
            clusterMemberService.joinCluster(identity);
        }
        catch (NoClusterDefinedException noClusterDefinedException) {
            this.releaseService(clusterMemberService);
            catch (Throwable throwable) {
                this.releaseService(clusterMemberService);
                throw throwable;
            }
        }
        this.releaseService(clusterMemberService);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. identity=" + identity);
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Identity disjoinWLMCluster(Map map) {
        String string = "disjoinWLMCluster: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. agentIDMap=" + map);
        }
        Map map2 = this.getNeuteredAgentIDMap(map);
        ClusterMemberService clusterMemberService = null;
        Identity identity = null;
        try {
            clusterMemberService = (ClusterMemberService)this.getService(ClusterMemberService.class);
            ClusterService clusterService = ClusterServiceFactory.getClusterService();
            identity = clusterService.getIdentity(map2);
            clusterMemberService.disjoinCluster(identity);
        }
        catch (NoClusterDefinedException noClusterDefinedException) {
            this.releaseService(clusterMemberService);
            catch (Throwable throwable) {
                this.releaseService(clusterMemberService);
                throw throwable;
            }
        }
        this.releaseService(clusterMemberService);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. identity=" + identity);
        }
        return identity;
    }

    public void registerInterestWithWLMCluster(Map map, ClusterObserver clusterObserver) {
        String string = "registerInterestWithWLMCluster: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. agentIDMap=" + map);
        }
        Identity identity = null;
        Map map2 = this.getNeuteredAgentIDMap(map);
        boolean bl = Boolean.getBoolean("DRS_DO_NOT_NOTIFY_CLUSTEROBSERVER");
        if (null != clusterObserver) {
            ClusterService clusterService = ClusterServiceFactory.getClusterService();
            Identity[] identityArray = clusterService.getMemberIdentities(identity = clusterService.getIdentity(map2));
            if (identityArray.length != 0 && !bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error/Warning: Registering interest when members.length!=0. Spoofing a notify.");
                }
                clusterObserver.notify(identity, "member.added", null);
            }
            clusterService.registerInterest(clusterObserver, identity, "member.added");
            clusterService.registerInterest(clusterObserver, identity, "member.removed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. identity=" + identity);
        }
    }

    public DRSDataXfer createInstance(String string, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettings dRSSettings, ClusterObserver clusterObserver, Map map) {
        String string2 = "createInstance: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. id=" + string + " drsSettings=" + dRSSettings);
        }
        if (string == null) {
            throw new IllegalArgumentException("Id parameter is null");
        }
        if (dRSSettings == null) {
            throw new IllegalArgumentException("DRSSettings parameter is null");
        }
        if (dRSSettings.getMessageBrokerDomainName() == null) {
            throw new IllegalArgumentException("In DRSSettings parameter, the MessageBrokerDomainName is null");
        }
        DRSDataXfer dRSDataXfer = null;
        dRSDataXfer = DRSPlatformHelper.shouldCreateZOSDRSServantInstance() ? DRSInstanceFactory.getInstance().createZOSDRSInstanceStub(string, dRSCacheMsgListener, dRSBootstrap, dRSSettings, clusterObserver, map) : (DRSPlatformHelper.shouldCreateZOSDRSControllerInstance() ? this.createDRSInstance(string, dRSCacheMsgListener, dRSBootstrap, dRSSettings, clusterObserver, map) : this.createDRSInstance(string, dRSCacheMsgListener, dRSBootstrap, dRSSettings, clusterObserver, map));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. rc=" + (null == dRSDataXfer ? "null" : "instantiated"));
        }
        return dRSDataXfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DRSDataXfer createDRSInstance(String string, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettings dRSSettings, ClusterObserver clusterObserver, Map map) {
        String string2 = "createDRSInstance(6 parms): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. id=" + string + " drsSettings=" + dRSSettings);
        }
        DRSDataXfer dRSDataXfer = null;
        if (null == dRSBootstrap) {
            dRSBootstrap = new DRSBootstrapAdapterImpl();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "Instantiated DRSBootstrapAdapterImpl for consumer.");
            }
        }
        boolean bl = false;
        if (null != map && map.containsKey("MISC_PARM_WAIT_FOR_HAM")) {
            bl = (Boolean)map.get("MISC_PARM_WAIT_FOR_HAM");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "MiscParm: waitForHAM=" + bl);
            }
        }
        long l = 40000L;
        if (null != map && map.containsKey("MISC_PARM_HAM_TIMEOUT_MS")) {
            l = (Long)map.get("MISC_PARM_HAM_TIMEOUT_MS");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "MiscParm: hamTimeoutMs=" + l);
            }
        }
        MultibrokerDomainImpl multibrokerDomainImpl = this;
        synchronized (multibrokerDomainImpl) {
            DRSDomain dRSDomain;
            block51: {
                String string3 = dRSSettings.getMessageBrokerDomainName();
                dRSDomain = DRSGlobals.getSingleton().getDomain(string3);
                if (dRSDomain == null) {
                    Tr.error(tc, "drs.throwable", "Unable to locate Replication Domain.");
                    return null;
                }
                int n = dRSSettings.getDataReplicationMode().getValue();
                short s = 0;
                if (n == 1) {
                    s = 1;
                } else if (n == 2) {
                    s = 2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + "drsMode=" + DRSConstants.getDrsModeString(s));
                }
                dRSDomain.setMode(s);
                if (!dRSDomain.isInitialized()) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string2 + "Creating HAM resources for domain:" + dRSDomain.getName());
                        }
                        this.createHAMGroupName(dRSDomain.getName());
                        this.registerAgentClass(dRSDomain, dRSSettings);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block51;
                        Tr.debug(tc, string2 + "Warning. Caught exception creating domain HAM resources.\ndomain=" + dRSDomain + "\ne=" + exception);
                    }
                }
            }
            DRSInstance dRSInstance = null;
            DRSDomain dRSDomain2 = dRSDomain;
            synchronized (dRSDomain2) {
                dRSInstance = dRSDomain.getDRSInstance(string);
                if (dRSInstance == null) {
                    Object object = DRSGlobals.getSingleton().getCreateDRSInstancesMutex();
                    synchronized (object) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string2 + "Creating new drs instance.");
                        }
                        dRSInstance = new DRSInstance(string, null, 0, 0, dRSCacheMsgListener, dRSBootstrap, new DRSOverflowListenerImpl(), dRSSettings, map);
                        dRSInstance.getDRSGroups().setClusterObserver(clusterObserver);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string2 + "Saving new instance. dcaName=" + dRSInstance.getName() + " instanceId=" + dRSInstance.getInstanceId());
                        }
                        dRSDomain.addDRSInstance(string, dRSInstance);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "Getting ddx from drs instance.");
                    }
                    dRSDataXfer = dRSInstance.getDRSDataXfer();
                    if (dRSInstance.getDRSMode() == 2) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, string2 + "Exit. Not client-capable. ddx=" + (null == dRSDataXfer ? "null" : "instantiated"));
                        }
                        return dRSDataXfer;
                    }
                    dRSDomain.createPrimaryAgents(dRSInstance);
                    if (!bl) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, string2 + "Exit. No wait requested by consumer. ddx=" + (null == dRSDataXfer ? "null" : "instantiated"));
                        }
                        return dRSDataXfer;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 + l;
                    if (!this._waitedForHAM) {
                        while (0 == dRSDomain.getBuddyManager().getNumberServerListMembers() && l3 > System.currentTimeMillis()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string2 + "Waiting briefly for other servers to be up.");
                            }
                            try {
                                Thread.sleep(1567L);
                            }
                            catch (Exception exception) {}
                        }
                        this._waitedForHAM = true;
                        if (0 == dRSDomain.getBuddyManager().getNumberServerListMembers()) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, string2 + "Exit no servers. ddx=" + (null == dRSDataXfer ? "null" : "instantiated"));
                            }
                            return dRSDataXfer;
                        }
                        this._detectedOtherServers = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string2 + "numServers=" + dRSDomain.getBuddyManager().getNumberServerListMembers());
                        }
                    }
                    if (!this._detectedOtherServers) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, string2 + "Exit no servers. ddx=" + (null == dRSDataXfer ? "null" : "instantiated"));
                        }
                        return dRSDataXfer;
                    }
                    l2 = System.currentTimeMillis();
                    l3 = l2 + l / 2L;
                    while (!dRSInstance.getDRSGroups().isHamUp() && l3 > System.currentTimeMillis()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string2 + "Waiting briefly for replication to be ready.");
                        }
                        try {
                            Thread.sleep(1567L);
                        }
                        catch (Exception exception) {}
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "hamUp=" + dRSInstance.getDRSGroups().isHamUp());
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + "Warning. DRSInstance already exists. Re-using prior drs instance. id=" + string + " prior-drs=" + dRSInstance);
                    }
                    dRSDataXfer = dRSInstance.getDRSDataXfer();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. ddx=" + (null == dRSDataXfer ? "null" : "instantiated"));
        }
        return dRSDataXfer;
    }

    public DRSDataXfer createInstance(String string, DRSCacheMsgListener dRSCacheMsgListener, DRSSettings dRSSettings) {
        String string2 = "createInstance(3 parms): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry.");
        }
        DRSDataXfer dRSDataXfer = this.createInstance(string, dRSCacheMsgListener, null, dRSSettings, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit.");
        }
        return dRSDataXfer;
    }

    public DRSDataXfer createInstance(String string, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettings dRSSettings) {
        String string2 = "createInstance(4 parms): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry.");
        }
        DRSDataXfer dRSDataXfer = this.createInstance(string, dRSCacheMsgListener, dRSBootstrap, dRSSettings, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit.");
        }
        return dRSDataXfer;
    }

    public DRSDataXfer createInstance(String string, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettings dRSSettings, ClusterObserver clusterObserver) {
        String string2 = "createInstance(5 parms): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry.");
        }
        DRSDataXfer dRSDataXfer = this.createInstance(string, dRSCacheMsgListener, dRSBootstrap, dRSSettings, clusterObserver, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit.");
        }
        return dRSDataXfer;
    }

    public DRSDataXfer getInstance(String string, String string2) {
        DRSInstance dRSInstance;
        String string3 = "getInstance: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3 + "Entry. domainId=" + string + " instanceId=" + string2);
        }
        DRSDataXfer dRSDataXfer = null;
        DRSDomain dRSDomain = DRSGlobals.getSingleton().getDomain(string);
        if (null != dRSDomain && (dRSInstance = dRSDomain.getDRSInstance(string2)) != null) {
            dRSDataXfer = dRSInstance.getDRSDataXfer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3 + "Exit. ddx=" + (null == dRSDataXfer ? "null" : "instantiated"));
        }
        return dRSDataXfer;
    }

    public DRSServantProxyFactory getDRSServantProxyFactoryInstance() {
        DRSServantProxyFactory dRSServantProxyFactory = null;
        if (DRSPlatformHelper.shouldCreateDRSServantProxyFactoryInstance()) {
            dRSServantProxyFactory = DRSServantProxyFactoryImpl.getInstance();
        }
        return dRSServantProxyFactory;
    }

    public DRSExternalDataStoreFactory getDRSExternalDataStoreFactoryInstance() {
        DRSExternalDataStoreFactory dRSExternalDataStoreFactory = null;
        if (DRSPlatformHelper.isZOS_Control_Region()) {
            dRSExternalDataStoreFactory = DRSExternalDataStoreFactoryImpl.getInstance();
        }
        return dRSExternalDataStoreFactory;
    }

    private Map getNeuteredAgentIDMap(Map map) {
        String string = "getNeuteredAgentIDMap: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. agentIDMap=" + map);
        }
        HashMap hashMap = new HashMap(map);
        hashMap.remove("_ham.serverid");
        hashMap.remove("ibm_agent.seq");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. newMap=" + hashMap);
        }
        return hashMap;
    }

    private ThreadPool createDRSThreadPool() {
        String string = "createDRSThreadPool: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        ThreadPool threadPool = null;
        ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
        if (null == threadPoolMgr) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Error. Did not get ThreadPoolMgr service.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Got ThreadPoolMgr service.");
            }
            if (null == (threadPool = threadPoolMgr.getThreadPool(this._defaultThreadPoolName))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Error. Did not get a ThreadPool.");
                }
                Tr.error(tc, "drs.throwable", "Thread pool is null.");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Success. Got ThreadPool. PoolName=" + threadPool.getName());
                Tr.debug(tc, string + "CurrentSize=" + threadPool.getPoolSize());
                Tr.debug(tc, string + "MinSize=" + threadPool.getMinimumPoolSize() + " MaxSize=" + threadPool.getMaximumPoolSize());
            }
            this.releaseService(threadPoolMgr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. threadPool=" + (null == threadPool ? "null" : "instantiated"));
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAgentClass(DRSDomain dRSDomain, DRSSettings dRSSettings) {
        String string = "registerAgentClass: ";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Entry. domain=" + dRSDomain + " drsSettings=" + dRSSettings);
        }
        CoreStack coreStack = null;
        String string2 = AdminServiceFactory.getAdminService().getNodeName();
        String string3 = AdminServiceFactory.getAdminService().getProcessName();
        if (dRSDomain.isInitialized()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " Domain is already initialized:" + dRSDomain.getName());
            }
            return;
        }
        int n = dRSSettings.getDataReplicationMode().getValue();
        String string4 = new Integer(n).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "mode=" + DRSConstants.getDrsModeString(new Short(string4)));
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("drs_grp_id", dRSDomain.getName());
            DRSAgentClassEvents dRSAgentClassEvents = dRSDomain.getAgentClassEvents();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("drs_ac_inst_id", string2 + ":" + string3);
            hashMap2.put("drs_mode", string4);
            coreStack = (CoreStack)this.getService(CoreStack.class);
            AgentClassFactory agentClassFactory = coreStack.getAgentClassFactory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "agentClassFactory=" + (null == agentClassFactory ? "null" : "instantiated"));
            }
            boolean bl = true;
            int n2 = dRSDomain.getNumOfReplicas();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Registering with acf. numReplicas=" + n2 + " autoFailover=" + bl);
            }
            AgentClass agentClass = agentClassFactory.registerClass(hashMap, hashMap2, dRSAgentClassEvents, n2, bl, dRSDomain.getName());
            dRSDomain.getBroadcastGroup().setAgentClass(agentClass);
            dRSDomain.markInitialized();
            this.releaseService(coreStack);
        }
        catch (HAException hAException) {
            hAException.printStackTrace();
            FFDCFilter.processException((Throwable)hAException, className + "registerAgentClass", "5", this);
        }
        finally {
            this.releaseService(coreStack);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    private void createHAMGroupName(String string) throws ConfigurationError {
        String string2 = "createHAMGroupName: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. groupName=" + string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CoreStack coreStack = (CoreStack)this.getService(CoreStack.class);
        GroupManager groupManager = coreStack.getGroupManager();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2 + "groupManager=" + (null == groupManager ? "null" : "instantiated"));
        }
        try {
            hashMap.put("drs_group_name", string);
            groupManager.createGroupName(hashMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + "Created group name. map=" + hashMap + " groupName=" + string);
            }
        }
        catch (HAException hAException) {
            hAException.printStackTrace();
            FFDCFilter.processException((Throwable)hAException, className + "createHAMGroupName", "6", this);
            throw new ConfigurationError(hAException);
        }
        finally {
            this.releaseService(coreStack);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + "Exit. ");
        }
    }

    private void logAvailableServices() {
        String string = "logAvailableServices: ";
        Iterator<?> iterator = this.getBeanContextServices().getCurrentServiceClasses();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string + "service=" + obj);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "No services available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHAManagerRunning() {
        String string = "isHAManagerRunning: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        CoreStack coreStack = null;
        boolean bl = true;
        try {
            coreStack = (CoreStack)this.getService(CoreStack.class);
            if (coreStack == null) {
                bl = false;
            } else {
                GroupManager groupManager = coreStack.getGroupManager();
                if (groupManager == null) {
                    bl = false;
                }
            }
        }
        catch (Throwable throwable) {
            bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " caught exception " + throwable);
                throwable.printStackTrace();
            }
        }
        finally {
            if (coreStack != null) {
                this.releaseService(coreStack);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit : rc = " + bl);
        }
        return bl;
    }

    public boolean isReplicationUp(String string) {
        boolean bl;
        DRSInstance dRSInstance;
        String string2 = "isReplicationUp: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + "Entry. drsInstanceName=" + string);
        }
        if (null != (dRSInstance = DRSGlobals.getSingleton().getDRSInstance(string))) {
            bl = dRSInstance.getDRSDataXfer().isReplicationUp();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2 + "Exit. DRS Instance exists. rc=" + bl);
            }
        } else {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2 + "Exit. Warning: DRS Instance does not exist. rc=" + bl);
            }
        }
        return bl;
    }
}

