/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.EJSException;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.oa.LocationService;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.ThreadPoolStrategy;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.models.config.orb.Interceptor;
import com.ibm.websphere.models.config.orb.ORBPlugin;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.orb.OrbPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.csi.CORBAORBMethodAccessControl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ORBCollaborator;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.TraceService;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.omg.CORBA.SystemException;

public class ORBImpl
extends ComponentImpl
implements ORB,
SecurityServiceListener {
    private static TraceComponent tc = Tr.register(ORBImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static final String LOCALHOST = "com.ibm.CORBA.LocalHost";
    public static String ORB_THREAD_POOL_KEY = "ORB.thread.pool";
    private static final String USER_KEY_VERSION = "com.ibm.websphere.ObjectIDVersionCompatibility";
    private static final String UNIQUE_SERVER_NAME = "com.ibm.websphere.orb.uniqueServerName";
    private static final String THREADPOOL_TIMEOUT = "com.ibm.websphere.orb.threadPoolTimeout";
    private String configId;
    private Properties orbProps;
    private boolean lsdEnabled = false;
    private com.ibm.CORBA.iiop.ORB orb;
    private com.ibm.CORBA.iiop.ThreadPool orbThreadPool = null;
    private boolean isZOS = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationError, ComponentDisabledException {
        String string;
        String string2;
        EndPointMgr endPointMgr;
        String string3;
        Object object2;
        int n;
        int n2;
        ThreadPool threadPool;
        ObjectRequestBroker objectRequestBroker;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        if (!(objectRequestBroker = (ObjectRequestBroker)object).isEnable()) {
            throw new ComponentDisabledException();
        }
        this.configId = this.getConfigId((EObject)objectRequestBroker);
        this.addService(ORB.class);
        ThreadPoolMgr threadPoolMgr = null;
        this.isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        try {
            threadPoolMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
            threadPool = threadPoolMgr.getThreadPool(ORB_THREAD_POOL_KEY, objectRequestBroker.getThreadPool());
            if (this.isZOS) {
                n2 = Integer.getInteger("com.ibm.ws390.orb.orb.thread.pool.count", 1);
                threadPool.setMinimumPoolSize(n2);
                threadPool.setMaximumPoolSize(n2);
            }
        }
        catch (Throwable throwable) {
            this.releaseService(threadPoolMgr);
            throw throwable;
        }
        this.releaseService(threadPoolMgr);
        this.orbProps = new Properties();
        threadPool = objectRequestBroker.getProperties();
        if (threadPool != null) {
            for (n2 = 0; n2 < threadPool.size(); ++n2) {
                Property property = (Property)threadPool.get(n2);
                this.orbProps.put(property.getName(), this.expandVariable(property.getValue()));
            }
        }
        EList eList = objectRequestBroker.getPlugins();
        for (n = 0; n < eList.size(); ++n) {
            object2 = (ORBPlugin)eList.get(n);
            string3 = object2.getName();
            if (!StatsFactory.isPMIEnabled() && string3.equals("com.ibm.ws.pmi.server.modules.OrbPerfModule")) continue;
            this.orbProps.setProperty("com.ibm.CORBA.ORBPluginClass." + string3, "");
        }
        eList = objectRequestBroker.getInterceptors();
        for (n = 0; n < eList.size(); ++n) {
            object2 = (Interceptor)eList.get(n);
            this.orbProps.setProperty("org.omg.PortableInterceptor.ORBInitializerClass." + object2.getName(), "");
        }
        if (objectRequestBroker.isCommTraceEnabled()) {
            this.orbProps.setProperty("com.ibm.CORBA.CommTrace", "true");
            this.orbProps.setProperty("com.ibm.CORBA.Debug", "trace");
            TraceService traceService = (TraceService)this.getService(TraceService.class);
            if (traceService != null) {
                traceService.appendTraceString("ORBRas=all=enabled");
                this.releaseService(traceService);
            }
        }
        if (objectRequestBroker.eIsSet((EStructuralFeature)OrbPackage.eINSTANCE.getObjectRequestBroker_ConnectionCacheMaximum())) {
            this.orbProps.setProperty("com.ibm.CORBA.MaxOpenConnections", String.valueOf(objectRequestBroker.getConnectionCacheMaximum()));
        }
        if (objectRequestBroker.eIsSet((EStructuralFeature)OrbPackage.eINSTANCE.getObjectRequestBroker_ConnectionCacheMinimum())) {
            this.orbProps.setProperty("com.ibm.CORBA.MinOpenConnections", String.valueOf(objectRequestBroker.getConnectionCacheMinimum()));
        }
        if (objectRequestBroker.eIsSet((EStructuralFeature)OrbPackage.eINSTANCE.getObjectRequestBroker_ForceTunnel())) {
            this.orbProps.setProperty("com.ibm.CORBA.ForceTunnel", objectRequestBroker.getForceTunnel());
        }
        if ((string3 = (object2 = (endPointMgr = (EndPointMgr)this.getService(EndPointMgr.class)).getNodeEndPoints("@")).getServerEndPoints("@").getEndPoint("ORB_LISTENER_ADDRESS")) != null) {
            this.orbProps.setProperty("com.ibm.CORBA.ListenerPort", String.valueOf(string3.getPort()));
            string2 = string3.getHost();
            if (string2.equals("*")) {
                try {
                    string2 = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "UnknownHostException retrieving LocalHost", unknownHostException);
                    }
                    string2 = "";
                }
            }
            this.orbProps.setProperty(LOCALHOST, string2);
        }
        string2 = AdminServiceFactory.getAdminService().getProcessType();
        String string4 = AdminServiceFactory.getAdminService().getNodeName();
        if (string2.equals("NodeAgent")) {
            this.orbProps.setProperty("com.ibm.ws.orb.services.lsd.LSDListenerPort", String.valueOf(string3.getPort()));
            this.lsdEnabled = true;
        } else if (string2.equals("ManagedProcess")) {
            string = AdminHelper.getInstance().getNodeAgentName(string4);
            string3 = object2.getServerEndPoints(string).getEndPoint("ORB_LISTENER_ADDRESS");
            if (string3 == null) {
                throw new ConfigurationError("No ORB_LISTENER_ADDRESS found in the nodeagent.");
            }
            if (!this.isZOS) {
                String string5 = string3.getHost().toString();
                if (string5.indexOf(58) != -1) {
                    string5 = "[" + string5 + "]";
                }
                this.orbProps.setProperty("com.ibm.CORBA.ORBInitRef.LocationService", "corbaloc::" + string5 + ":" + String.valueOf(string3.getPort()) + "/LocationService");
            }
            this.lsdEnabled = true;
        }
        this.releaseService(endPointMgr);
        if (objectRequestBroker.eIsSet((EStructuralFeature)OrbPackage.eINSTANCE.getObjectRequestBroker_LocateRequestTimeout())) {
            this.orbProps.setProperty("com.ibm.CORBA.LocateRequestTimeout", String.valueOf(objectRequestBroker.getLocateRequestTimeout()));
        }
        if (objectRequestBroker.isNoLocalCopies()) {
            this.orbProps.setProperty("com.ibm.CORBA.iiop.noLocalCopies", "true");
        }
        if (objectRequestBroker.eIsSet((EStructuralFeature)OrbPackage.eINSTANCE.getObjectRequestBroker_RequestRetriesCount())) {
            this.orbProps.setProperty("com.ibm.CORBA.requestRetriesCount", String.valueOf(objectRequestBroker.getRequestRetriesCount()));
        }
        if (objectRequestBroker.eIsSet((EStructuralFeature)OrbPackage.eINSTANCE.getObjectRequestBroker_RequestRetriesDelay())) {
            this.orbProps.setProperty("com.ibm.CORBA.requestRetriesDelay", String.valueOf(objectRequestBroker.getRequestRetriesDelay()));
        }
        if (objectRequestBroker.eIsSet((EStructuralFeature)OrbPackage.eINSTANCE.getObjectRequestBroker_RequestTimeout())) {
            this.orbProps.setProperty("com.ibm.CORBA.RequestTimeout", String.valueOf(objectRequestBroker.getRequestTimeout()));
        }
        if (objectRequestBroker.getTunnelAgentURL() != null) {
            this.orbProps.setProperty("com.ibm.CORBA.TunnelAgentURL", objectRequestBroker.getTunnelAgentURL());
        }
        if ((string = this.orbProps.getProperty(USER_KEY_VERSION)) != null && string.equals("1")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObjectIDVersionCompatibility = " + string);
            }
            UserKey.enableVersion1CompatibilityMode();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        Object object;
        int n;
        Object object2;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        Server server2 = null;
        EndPointMgr endPointMgr = null;
        String string2 = null;
        String string3 = "";
        if (EJSORB.globalORB() != null) {
            throw new RuntimeError("ORB already created");
        }
        try {
            server2 = (Server)this.getService(Server.class);
            string2 = server2.getClusterName();
            string = Boolean.getBoolean(UNIQUE_SERVER_NAME) ? server2.getCellName() + "_" + server2.getNodeName() + "_" + server2.getName() : server2.getName();
            endPointMgr = (EndPointMgr)this.getService(EndPointMgr.class);
            object2 = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("BOOTSTRAP_ADDRESS");
            if (object2 == null) {
                throw new RuntimeError("No BOOTSTRAP_ADDRESS found");
            }
            if (!this.isZOS || PlatformHelperFactory.getPlatformHelper().runningWhereConfigured()) {
                string3 = object2.getHost();
            }
            n = object2.getPort();
        }
        catch (Throwable throwable) {
            this.releaseService(server2);
            this.releaseService(endPointMgr);
            throw throwable;
        }
        this.releaseService(server2);
        this.releaseService(endPointMgr);
        object2 = null;
        try {
            Object object3;
            String string4;
            object = (String)this.orbProps.get(THREADPOOL_TIMEOUT);
            long l = 0L;
            if (object != null) {
                try {
                    l = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException(numberFormatException, this.getClass().getName(), "325");
                }
            }
            object2 = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
            com.ibm.ejs.oa.pool.ThreadPool threadPool = null;
            com.ibm.ejs.oa.pool.ThreadPool threadPool2 = threadPool = new com.ibm.ejs.oa.pool.ThreadPool(object2.getThreadPool(ORB_THREAD_POOL_KEY), l);
            String string5 = (String)this.orbProps.get("com.ibm.websphere.threadpool.strategy.implementation");
            if (string5 != null) {
                try {
                    threadPool2 = (com.ibm.CORBA.iiop.ThreadPool)ExtClassLoader.getInstance().loadClass(string5).newInstance();
                    string4 = null;
                    ((ThreadPoolStrategy)((Object)threadPool2)).init(object2.getThreadPool(ORB_THREAD_POOL_KEY), this.orbProps, (Object[])string4);
                }
                catch (Exception exception) {
                    threadPool2 = threadPool;
                }
            }
            threadPool = threadPool2;
            this.orbThreadPool = threadPool;
            string4 = AdminServiceFactory.getAdminService().getProcessType();
            if (string4.equals("ManagedProcess")) {
                object3 = null;
                try {
                    object3 = (SecurityService)this.getService(SecurityService.class);
                    object3.addListener(this);
                }
                catch (Throwable throwable) {
                    this.releaseService(object3);
                    throw throwable;
                }
                this.releaseService(object3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializing ORB", new Object[]{"cluster=" + string2, "server=" + string, "bootstrapHost=" + string3, "bootstrapPort=" + n, "threadPool=" + threadPool});
                object3 = this.orbProps.propertyNames();
                while (object3.hasMoreElements()) {
                    String string6 = (String)object3.nextElement();
                    Tr.debug(tc, "ORB property " + string6 + " = " + this.orbProps.getProperty(string6));
                }
            }
            this.orb = EJSORB.init(string2, string, string3, n, threadPool, this.orbProps);
        }
        catch (EJSException eJSException) {
            throw new RuntimeError(eJSException);
        }
        catch (SystemException systemException) {
            throw new RuntimeError(systemException);
        }
        finally {
            this.orbProps = null;
            this.releaseService(object2);
        }
        object = new ORBCollaborator(this.orb);
        this.registerMBean("ORB", (RuntimeCollaborator)object, "ObjectRequestBroker", this.configId, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        CORBAORBMethodAccessControl cORBAORBMethodAccessControl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if ((cORBAORBMethodAccessControl = CORBAORBMethodAccessControl.getInstance()) != null) {
            cORBAORBMethodAccessControl.setORBServiceShutdown();
        }
        EJSORB.terminate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
    }

    public Properties getOrbProps() {
        return this.orbProps;
    }

    public com.ibm.CORBA.iiop.ORB getORB() {
        return this.orb;
    }

    public com.ibm.CORBA.iiop.ThreadPool getThreadPool() {
        return this.orbThreadPool;
    }

    public boolean isLSDEnabled() {
        return this.lsdEnabled;
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged", securityServiceEvent);
        }
        if (securityServiceEvent.getState() == 1) {
            Tr.debug(tc, "ORBImpl: SecuritService is started.");
            LocationService.setSecurityServiceStarted(true);
        } else if (securityServiceEvent.getState() == 2) {
            Tr.debug(tc, "ORBImpl: SecuritService is stopped.");
            LocationService.setSecurityServiceStarted(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }
}

