/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.pmirm.PMIRMFilter;
import com.ibm.websphere.models.config.pmirm.PMIRMFilterValue;
import com.ibm.websphere.models.config.pmirm.PMIRequestMetrics;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.asynchbeans.AsynchBeansServiceCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfigImpl;
import com.ibm.ws.pmi.reqmetrics.ReqMetricsAsyncBeanServiceImpl;
import com.ibm.ws.pmi.reqmetrics.dynamicproxy.PmiRmMBeanState;
import com.ibm.ws.pmi.reqmetrics.extensibleFilter.ExtensibleFilterContainer;
import com.ibm.ws.pmi.reqmetrics.jms.JmsFilterCfg;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterCfg;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.Repository;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class PmiRmImpl
extends ComponentImpl
implements ConfigChangeListener {
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiRMImpl";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private boolean disabled = false;
    public static final String CONFIGFILE = "pmirm.xml";
    protected PmiReqMetricsImpl _impl = null;
    protected AsynchBeansServiceCollaborator abSvc = null;
    private static final TraceComponent tc = Tr.register(PmiRmImpl.class, "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private static String[] CONFIG_URI_SUFFIXES = new String[]{"/pmirm.xml"};
    private boolean trDebug = false;

    public void initialize(Object object) {
        Object object2;
        String string;
        this.trDebug = tc.isDebugEnabled();
        if (this.trDebug) {
            Tr.entry(tc, "initialize ***** PMI Request Metrics *****");
        }
        if ((string = AdminServiceFactory.getAdminService().getProcessType()).equals("NodeAgent") || string.equals("DeploymentManager")) {
            if (this.trDebug) {
                Tr.debug(tc, "initialize, in dMgr or NodeAgent, return");
            }
            this.disabled = true;
            return;
        }
        String string2 = AdminServiceFactory.getAdminService().getServerType();
        if (string2.equals("APPLICATION_SERVER") && AdminHelper.getPlatformHelper().isControlJvm()) {
            if (this.trDebug) {
                Tr.debug(tc, "initialize: in CR, addConfigChangeListener and return");
            }
            Admin admin2 = (Admin)this.getService(Admin.class);
            admin2.addConfigChangeListener(this);
            this.releaseService(admin2);
            if (this.trDebug) {
                Tr.exit(tc, "initialize, in CR");
            }
            return;
        }
        Repository repository2 = (Repository)this.getService(Repository.class);
        ConfigRoot configRoot = repository2.getConfigRoot();
        try {
            object2 = configRoot.getResource(0, CONFIGFILE);
            if (!this.isReadyToEnable((Resource)object2)) {
                this.disabled = true;
                if (this.trDebug) {
                    Tr.exit(tc, "initialize, dynamicEnable=false, do not instantiate PmiReqMetricsImpl");
                }
                return;
            }
            this._impl = new PmiReqMetricsImpl();
            this.configure(configRoot.getResource(0, CONFIGFILE));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRMImpl.PmiRMImpl", FFDC_ID_3, this);
            Tr.debug(tc, "Cell level pmirm.xml not found\n", throwable);
        }
        object2 = this.getWasVersion();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)object2).append("/");
        stringBuffer.append(repository2.getCellName());
        stringBuffer.append("/");
        stringBuffer.append(repository2.getNodeName());
        stringBuffer.append("/");
        stringBuffer.append(repository2.getServerName());
        stringBuffer.append("/");
        stringBuffer.append(AdminServiceFactory.getAdminService().getServerType());
        EJBContainer eJBContainer = (EJBContainer)this.getService(EJBContainer.class);
        this._impl.init(stringBuffer.toString(), eJBContainer);
        this.releaseService(eJBContainer);
        this.releaseService(repository2);
        Admin admin3 = (Admin)this.getService(Admin.class);
        admin3.addConfigChangeListener(this);
        this.releaseService(admin3);
        if (this.trDebug) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        if (this.trDebug) {
            Tr.debug(tc, "START ***** PMI Request Metrics ***** ");
        }
        if (this.disabled) {
            if (this.trDebug) {
                Tr.debug(tc, "start, dMgr or NodeAgent, return");
            }
            return;
        }
        String string = AdminServiceFactory.getAdminService().getServerType();
        if (string.equals("APPLICATION_SERVER") && AdminHelper.getPlatformHelper().isControlJvm()) {
            if (this.trDebug) {
                Tr.debug(tc, "start, in application server CR, do nothing");
            }
            return;
        }
        if (this._impl != null) {
            this._impl.start();
        }
        if (string.equals("PROXY_SERVER") && AdminHelper.getPlatformHelper().isControlJvm()) {
            Tr.debug(tc, "Control region of proxy server, asynchbeans service not available.");
            return;
        }
        AsynchBeansServiceCollaborator asynchBeansServiceCollaborator = (AsynchBeansServiceCollaborator)this.getService(AsynchBeansService.class);
        if (asynchBeansServiceCollaborator != null) {
            if (PmiReqMetricsImpl.isReqMetricsEnabled()) {
                PmiReqMetricsImpl.setABSvc(asynchBeansServiceCollaborator, true);
                asynchBeansServiceCollaborator.register(new ReqMetricsAsyncBeanServiceImpl(), true);
                if (this.trDebug) {
                    Tr.debug(tc, "start, register ReqMetricsAsyncBeanServiceImpl");
                }
            } else {
                PmiReqMetricsImpl.setABSvc(asynchBeansServiceCollaborator, false);
            }
        } else {
            Tr.error(tc, "start, getService on AsynchBeansService returns null");
        }
    }

    public void stop() {
        this.trDebug = tc.isDebugEnabled();
        if (this.trDebug) {
            Tr.debug(tc, "STOP ***** PMI Request Metrics ***** ");
        }
        if (this.disabled) {
            if (this.trDebug) {
                Tr.debug(tc, "stop, dMgr or NodeAgent or dynamicEnable=false, return");
            }
            return;
        }
        if (AdminHelper.getPlatformHelper().isControlJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stop, in CR, do nothing");
            }
            return;
        }
        if (this._impl != null) {
            this._impl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.trDebug = tc.isDebugEnabled();
        if (this.trDebug) {
            Tr.debug(tc, "DESTROY ***** PMI Request Metrics ***** ");
        }
        if (this.disabled) {
            if (this.trDebug) {
                Tr.debug(tc, "destroy, dMgr or NodeAgent or dynamicEnable=false, return");
            }
            return;
        }
        Admin admin2 = null;
        try {
            admin2 = (Admin)this.getService(Admin.class);
            admin2.removeConfigChangeListener(this);
        }
        finally {
            if (admin2 != null) {
                this.releaseService(admin2);
            }
        }
        if (AdminHelper.getPlatformHelper().isControlJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "destroy, in CR");
            }
            return;
        }
        if (this._impl != null) {
            this._impl.end();
        }
    }

    private String getWasVersion() {
        WASProduct wASProduct = new WASProduct();
        Iterator iterator = wASProduct.getProducts();
        String string = null;
        while (iterator.hasNext()) {
            product product2 = (product)iterator.next();
            String string2 = product2.getId();
            if (!string2.equalsIgnoreCase("BASE") && !string2.equalsIgnoreCase("ND")) continue;
            string = product2.getVersion();
            Tr.debug(tc, "WebSphere product id is " + string2 + ", version is " + string);
            break;
        }
        return string;
    }

    protected boolean isReadyToEnable(Resource resource) {
        Tr.entry(tc, "isReadyToEnable");
        try {
            this.trDebug = tc.isDebugEnabled();
            EList eList = resource.getContents();
            PMIRequestMetrics pMIRequestMetrics = (PMIRequestMetrics)eList.get(0);
            boolean bl = pMIRequestMetrics.isDynamicEnable();
            Tr.exit(tc, "isReadyToEnable, return " + bl);
            return bl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRMImpl.PmiRMImpl", FFDC_ID_3, this);
            if (tc.isDebugEnabled()) {
                throwable.printStackTrace();
            }
            Tr.error(tc, "PMRM0116E");
            Tr.exit(tc, "isReadyToEnable, exception, return false");
            return false;
        }
    }

    protected void configure(Resource resource) {
        Tr.entry(tc, "configure");
        try {
            int n;
            int n2;
            this.trDebug = tc.isDebugEnabled();
            EList eList = resource.getContents();
            PMIRequestMetrics pMIRequestMetrics = (PMIRequestMetrics)eList.get(0);
            boolean bl = pMIRequestMetrics.isEnable();
            boolean bl2 = pMIRequestMetrics.isEnableARM();
            boolean bl3 = pMIRequestMetrics.isEnableLog();
            int n3 = pMIRequestMetrics.getArmType().getValue();
            String string = pMIRequestMetrics.getArmTransactionFactory();
            ExtensibleFilterContainer extensibleFilterContainer = new ExtensibleFilterContainer();
            String string2 = null;
            EList eList2 = pMIRequestMetrics.getEnabledComponents();
            EList eList3 = pMIRequestMetrics.getInstrumentedComponents();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n2 = 0; n2 < eList3.size(); ++n2) {
                arrayList.add((String)eList3.get(n2));
                if (!this.trDebug) continue;
                Tr.debug(tc, "configure: instrumented component=" + (String)eList3.get(n2));
            }
            n2 = 0;
            String string3 = null;
            for (n = 0; n < eList2.size(); ++n) {
                string3 = (String)eList2.get(n);
                if (this.trDebug) {
                    Tr.debug(tc, "configure: enabled component=" + string3);
                }
                if (string3.equalsIgnoreCase("all")) {
                    n2 = 1;
                    break;
                }
                if (string3.equalsIgnoreCase("EJB")) {
                    arrayList2.add(PmiReqMetrics.COMP_NAMES[0]);
                    continue;
                }
                if (string3.equalsIgnoreCase("Servlet")) {
                    arrayList2.add(PmiReqMetrics.COMP_NAMES[1]);
                    continue;
                }
                if (string3.equalsIgnoreCase("JDBC")) {
                    arrayList2.add(PmiReqMetrics.COMP_NAMES[2]);
                    continue;
                }
                if (string3.equalsIgnoreCase("WebServices")) {
                    arrayList2.add(PmiReqMetrics.COMP_NAMES[3]);
                    continue;
                }
                if (string3.equalsIgnoreCase("JMS")) {
                    arrayList2.add(PmiReqMetrics.COMP_NAMES[8]);
                    continue;
                }
                if (string3.equalsIgnoreCase("AsyncBeans")) {
                    arrayList2.add(PmiReqMetrics.COMP_NAMES[5]);
                    continue;
                }
                arrayList2.add(string3);
            }
            if (n2 != 0) {
                arrayList2.clear();
                for (n = 0; n < eList3.size(); ++n) {
                    string3 = (String)eList3.get(n);
                    if (string3.equalsIgnoreCase("EJB")) {
                        arrayList2.add(PmiReqMetrics.COMP_NAMES[0]);
                    } else if (string3.equalsIgnoreCase("Servlet")) {
                        arrayList2.add(PmiReqMetrics.COMP_NAMES[1]);
                    } else if (string3.equalsIgnoreCase("JDBC")) {
                        arrayList2.add(PmiReqMetrics.COMP_NAMES[2]);
                    } else if (string3.equalsIgnoreCase("WebServices")) {
                        arrayList2.add(PmiReqMetrics.COMP_NAMES[3]);
                    } else if (string3.equalsIgnoreCase("JMS")) {
                        arrayList2.add(PmiReqMetrics.COMP_NAMES[8]);
                    } else if (string3.equalsIgnoreCase("AsyncBeans")) {
                        arrayList2.add(PmiReqMetrics.COMP_NAMES[5]);
                    } else {
                        arrayList2.add(string3);
                    }
                    if (!this.trDebug) continue;
                    Tr.debug(tc, "configure: enabled all components, add component=" + (String)arrayList2.get(n));
                }
            }
            n = pMIRequestMetrics.getTraceLevel().getValue();
            if (this.trDebug) {
                Tr.debug(tc, "enabled: " + bl);
                Tr.debug(tc, "ARM enabled: " + bl2);
                Tr.debug(tc, "tracelevel: " + n);
            }
            PmiRmFilterConfigImpl pmiRmFilterConfigImpl = new PmiRmFilterConfigImpl("URI");
            PmiRmFilterConfigImpl pmiRmFilterConfigImpl2 = new PmiRmFilterConfigImpl("EJB");
            PmiRmFilterConfigImpl pmiRmFilterConfigImpl3 = new PmiRmFilterConfigImpl("SOURCE_IP");
            JmsFilterCfg jmsFilterCfg = new JmsFilterCfg();
            WsFilterCfg wsFilterCfg = new WsFilterCfg();
            String string4 = null;
            EList eList4 = pMIRequestMetrics.getFilters();
            for (int i = 0; i < eList4.size(); ++i) {
                PmiRmFilterConfigImpl pmiRmFilterConfigImpl4 = null;
                PMIRMFilter pMIRMFilter = (PMIRMFilter)eList4.get(i);
                boolean bl4 = pMIRMFilter.isEnable();
                boolean bl5 = false;
                if (pMIRMFilter.getExtendedType() != null && pMIRMFilter.getExtendedType().length() != 0) {
                    string2 = pMIRMFilter.getExtendedType();
                    bl5 = true;
                    pmiRmFilterConfigImpl4 = new PmiRmFilterConfigImpl(string2);
                } else {
                    string4 = pMIRMFilter.getType().getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "filter type: " + string4);
                        Tr.debug(tc, "\tenabled: " + bl4);
                    }
                    if (string4.equals("URI")) {
                        pmiRmFilterConfigImpl4 = pmiRmFilterConfigImpl;
                    } else if (string4.equals("EJB")) {
                        pmiRmFilterConfigImpl4 = pmiRmFilterConfigImpl2;
                    } else if (string4.equals("SOURCE_IP")) {
                        pmiRmFilterConfigImpl4 = pmiRmFilterConfigImpl3;
                    } else if (string4.equals("WEB_SERVICES")) {
                        pmiRmFilterConfigImpl4 = wsFilterCfg;
                    } else if (string4.equals("JMS")) {
                        pmiRmFilterConfigImpl4 = jmsFilterCfg;
                    }
                }
                pmiRmFilterConfigImpl4.enableFilters(bl4);
                EList eList5 = pMIRMFilter.getFilterValues();
                Boolean[] booleanArray = new Boolean[eList5.size()];
                String[] stringArray = new String[eList5.size()];
                for (int j = 0; j < eList5.size(); ++j) {
                    PMIRMFilterValue pMIRMFilterValue = (PMIRMFilterValue)eList5.get(j);
                    Tr.debug(tc, "\t\t" + pMIRMFilterValue.getValue() + " is " + (pMIRMFilterValue.isEnable() ? "enabled" : "not enabled"));
                    booleanArray[j] = new Boolean(pMIRMFilterValue.isEnable());
                    stringArray[j] = pMIRMFilterValue.getValue();
                }
                if (!bl5) {
                    pmiRmFilterConfigImpl4.addFilters(booleanArray, stringArray);
                    extensibleFilterContainer.addFilterConfigObject(string4, pmiRmFilterConfigImpl4);
                    continue;
                }
                extensibleFilterContainer.createAndPopulateNewFilterConfig(string2, booleanArray, stringArray);
            }
            PmiReqMetricsImpl.updateConfig(bl, bl2, n, bl3, n3, string, arrayList2, arrayList, pmiRmFilterConfigImpl, pmiRmFilterConfigImpl2, pmiRmFilterConfigImpl3, jmsFilterCfg, wsFilterCfg, extensibleFilterContainer);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRMImpl.PmiRMImpl", FFDC_ID_3, this);
            if (tc.isDebugEnabled()) {
                throwable.printStackTrace();
            }
            Tr.error(tc, "PMRM0116E");
        }
        Tr.exit(tc, "configure");
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        Object object;
        this.trDebug = tc.isDebugEnabled();
        if (this.trDebug) {
            Tr.entry(tc, "configChanged");
        }
        boolean bl = false;
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        block2: for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            object = configChangeNotifierArray[i].getUri();
            for (int j = 0; j < CONFIG_URI_SUFFIXES.length; ++j) {
                if (!((String)object).toLowerCase().endsWith(CONFIG_URI_SUFFIXES[j])) continue;
                Tr.event(tc, "Config file has changed, requiring PMIRM config update:", object);
                bl = true;
                continue block2;
            }
        }
        if (bl) {
            if (AdminHelper.getPlatformHelper().isControlJvm()) {
                PmiRmMBeanState pmiRmMBeanState;
                if (this.trDebug) {
                    Tr.debug(tc, "PmiRmImpl.configChanged: in CR");
                }
                if ((pmiRmMBeanState = PmiRmMBeanState.getInstance()) == null) {
                    if (this.trDebug) {
                        Tr.debug(tc, "PmiRmImpl: configChanged, null stateObj");
                    }
                } else {
                    if (this.trDebug) {
                        Tr.debug(tc, "PmiRmImpl: configChanged, got stateObj, calling stateObj.configRepositoryChanged");
                    }
                    pmiRmMBeanState.configRepositoryChanged();
                }
                return;
            }
            Repository repository2 = (Repository)this.getService(Repository.class);
            object = repository2.getConfigRoot();
            try {
                this.configure(object.getResource(0, CONFIGFILE));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRMImpl.PmiRMImpl", FFDC_ID_3, this);
                Tr.debug(tc, "Cell level pmirm.xml not found\n", throwable);
            }
            if (this._impl != null) {
                this._impl.start();
            }
            this.releaseService(repository2);
            if (PmiReqMetricsImpl.isReqMetricsEnabled()) {
                AsynchBeansServiceCollaborator asynchBeansServiceCollaborator = (AsynchBeansServiceCollaborator)this.getService(AsynchBeansService.class);
                if (asynchBeansServiceCollaborator != null) {
                    boolean bl2 = PmiReqMetricsImpl.registerABSvc(asynchBeansServiceCollaborator);
                    if (bl2 && tc.isDebugEnabled()) {
                        Tr.debug(tc, "configChanged, register ReqMetricsAsyncBeanServiceImpl");
                    }
                } else {
                    Tr.error(tc, "configChanged, getService on AsynchBeansService returns null");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }
}

