/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.debug.ThreadDump;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.product.VersionInfo;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.management.launcher.ProcessTerminator;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.component.RuntimeBundleActivator;
import com.ibm.ws.runtime.component.ServerImpl;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.WLC;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.DataOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ServerCollaborator
extends J2EEManagedObjectCollaborator
implements PropertyChangeListener {
    private static final TraceComponent tc = Tr.register(ServerCollaborator.class, "Runtime", "com.ibm.ws.runtime.runtime");
    static final String[] RESOURCE_TYPES = new String[]{"JCAResource", "JDBCResource", "JMSResource", "JavaMailResource", "URLResource", "JNDIResource", "RMI_IIOPResource", "JTAResource"};
    private static final boolean DUMP_SHUTDOWN = Boolean.getBoolean("com.ibm.ws.runtime.dumpShutdown");
    private ServerImpl server;
    private long ntfySeqNum = 0L;
    private int lastStatus = 1;
    private Integer statusPort = null;
    protected ShutdownHook shutdownHook;
    private WASProduct wasproduct = new WASProduct();
    private boolean restarting = false;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$WLC;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    public ServerCollaborator(ServerImpl serverImpl) {
        this.server = serverImpl;
        if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
            serverImpl.addPropertyChangeListener("state", this);
        }
        this.statusPort = Integer.getInteger("was.status.socket");
        this.shutdownHook = new ShutdownHook();
    }

    public void setThreadMonitorInterval(int n) {
        this.server.setThreadMonitorInterval(n);
    }

    public void setThreadMonitorThreshold(int n) {
        this.server.setThreadMonitorThreshold(n);
    }

    public void setThreadMonitorAdjustmentThreshold(int n) {
        this.server.setThreadMonitorAdjustmentThreshold(n);
    }

    public int getThreadMonitorInterval() {
        return this.server.getThreadMonitorInterval();
    }

    public int getThreadMonitorThreshold() {
        return this.server.getThreadMonitorThreshold();
    }

    public int getThreadMonitorAdjustmentThreshold() {
        return this.server.getThreadMonitorAdjustmentThreshold();
    }

    public String getName() {
        return this.getObjectName().getKeyProperty("name");
    }

    public String getShortName() {
        return this.server.getShortName();
    }

    public void stop() {
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stop operation not permitted in the Servant");
            }
            return;
        }
        AdminHelper.getInstance().audit("ADMN1020I", "ADMN1021I", new Object[]{this.getName(), null});
        this.stop(false);
    }

    public void stopImmediate() {
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stopImmediate operation not permitted in the Servant");
            }
            return;
        }
        AdminHelper.getInstance().audit("ADMN1022I", "ADMN1023I", new Object[]{this.getName(), null});
        this.stop(true);
    }

    public void stop(Boolean bl, Integer n) {
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stop operation not permitted in the Servant");
            }
            return;
        }
        this.statusPort = n;
        this.stop();
    }

    protected void stop(boolean bl) {
        if (DUMP_SHUTDOWN) {
            new Exception(this + ": stop stack trace").printStackTrace();
        }
        AlarmManager.createNonDeferrable(50L, new StopAction(bl));
    }

    public void restart() {
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "restart operation not permitted in the Servant");
            }
            return;
        }
        AdminHelper.getInstance().audit("ADMN1020I", "ADMN1021I", new Object[]{this.getName(), null});
        this.restarting = true;
        this.stop(false);
    }

    private void sendStatus(int n) {
        this.sendStatus(this.statusPort, n);
    }

    public String getPid() {
        String string = null;
        Process process = null;
        try {
            process = ProcessFactory.createSelf();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (process != null) {
            try {
                string = process.id();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public String getCellName() {
        String string = this.getObjectName().getKeyProperty("cell");
        return string;
    }

    public String getCellShortName() {
        return this.server.getShortCellName();
    }

    public String getNodeName() {
        String string = this.getObjectName().getKeyProperty("node");
        return string;
    }

    public String getNodeShortName() {
        return this.server.getShortNodeName();
    }

    public String getProcessType() {
        String string = AdminServiceFactory.getAdminService().getProcessType();
        return string;
    }

    public String[] getDeployedObjects() {
        Set set = this.lookupMBeans("WebSphere:j2eeType=J2EEApplication,process=" + this.server.getName() + ",node=" + this.server.getNodeName() + ",*");
        ArrayList<String> arrayList = new ArrayList<String>();
        MBeanServer mBeanServer = AdminServiceFactory.getMBeanFactory().getMBeanServer();
        String[] stringArray = set.iterator();
        while (stringArray.hasNext()) {
            try {
                ObjectName objectName = (ObjectName)stringArray.next();
                arrayList.add(objectName.getCanonicalName());
                String[] stringArray2 = (String[])mBeanServer.getAttribute(objectName, "modules");
                if (stringArray2 == null) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    arrayList.add(stringArray2[i]);
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanException mBeanException) {
            }
            catch (ReflectionException reflectionException) {
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getJavaVMs() {
        Set set = this.lookupMBeans("WebSphere:type=JVM,process=" + this.server.getName() + ",node=" + this.server.getNodeName() + ",*");
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iterator.next().toString();
        }
        return stringArray;
    }

    public String getInternalClassAccessMode() {
        return this.server.getInternalClassAccessMode();
    }

    public String[] getResources() {
        StringBuffer stringBuffer = new StringBuffer("WebSphere:*,j2eeType=");
        int n = stringBuffer.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < RESOURCE_TYPES.length; ++i) {
            stringBuffer.setLength(n);
            stringBuffer.append(RESOURCE_TYPES[i]);
            Set set = this.lookupMBeans(stringBuffer.toString());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().toString());
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getServerVersion() {
        VersionInfo versionInfo = new VersionInfo();
        StringWriter stringWriter = new StringWriter(2048);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        versionInfo.runReport("text", printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public String getServerVendor() {
        return "IBM";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        String string2 = null;
        if (string.equals("STARTING")) {
            string2 = "j2ee.state.starting";
        } else if (string.equals("STARTED")) {
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            string2 = "j2ee.state.running";
            this.lastStatus = 0;
            this.sendStatus(this.lastStatus);
            if (this.server.getServerMode() != 1) {
                this.statusPort = null;
            }
        } else if (string.equals("STOPPING")) {
            string2 = "j2ee.state.stopping";
        } else if (string.equals("STOPPED")) {
            string2 = "j2ee.state.stopped";
        } else if (string.equals("DESTROYED")) {
            int n = this.lastStatus = this.lastStatus == 0 ? 0 : -1;
            if (this.server.getServerMode() == 1 && !Boolean.getBoolean("com.ibm.ws.server.recovery.nostop")) {
                this.lastStatus = this.server.recoverySuccessful ? 0 : -1;
            }
            this.sendStatus(this.lastStatus);
            if (this.restarting) {
                this.server.reLaunchSelf();
            }
        }
        if (!PlatformHelperFactory.getPlatformHelper().isZOS() && string2 != null) {
            this.sendStateNotification(string2);
        }
    }

    private void sendStateNotification(String string) {
        try {
            this.sendNotification(new Notification(string, this.getObjectName(), this.ntfySeqNum++));
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
    }

    public String getState() {
        return this.server.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStatus(Integer n, int n2) {
        Socket socket;
        Socket socket2 = socket = n == null ? null : this.getStatusSocket(n);
        if (socket != null) {
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeInt(n2);
                dataOutputStream.flush();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Tr.service(tc, "WSVR0120E", new Object[]{this.server.getName(), throwable});
            }
            finally {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private synchronized Socket getStatusSocket(Integer n) {
        Socket socket = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            socket = new Socket(inetAddress, (int)n);
            return socket;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.ServerCollaborator.getStatusPort", "530", this);
            try {
                socket = new Socket("localhost", (int)n);
                return socket;
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.runtime.component.ServerCollaborator.getStatusPort", "540", this);
                try {
                    socket = new Socket((String)null, (int)n);
                    return socket;
                }
                catch (Exception exception3) {
                    FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.runtime.component.ServerCollaborator.getStatusPort", "550", this);
                    try {
                        InetAddress inetAddress = InetAddress.getLocalHost();
                        Tr.error(tc, "WSVR0121E", new Object[]{n, inetAddress.getHostName(), inetAddress.getHostAddress(), null});
                    }
                    catch (Exception exception4) {
                        FFDCFilter.processException((Throwable)exception4, "com.ibm.ws.runtime.component.ServerCollaborator.getStatusPort", "536", this);
                    }
                    return null;
                }
            }
        }
    }

    protected Set lookupMBeans(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            return this.lookupMBeans(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.service(tc, "WSVR0402W", new Object[]{string, malformedObjectNameException});
            return null;
        }
    }

    protected Set lookupMBeans(ObjectName objectName) {
        return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(objectName, null);
    }

    public String getPlatformName() {
        return this.wasproduct.getPlatform().getName();
    }

    public String getPlatformVersion() {
        return this.wasproduct.getPlatform().getVersion();
    }

    private String buildProductVersionXML(WASProductInfo wASProductInfo) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE product PUBLIC \"productId\" \"product.dtd\">\r\n<product name=\"" + wASProductInfo.getName() + "\">\r\n" + "  <id>" + wASProductInfo.getId() + "</id>\r\n" + "  <version>" + wASProductInfo.getVersion() + "</version>\r\n" + "  <build-info date=\"" + wASProductInfo.getBuildDate() + "\" level=\"" + wASProductInfo.getBuildLevel() + "\"/>\r\n" + "</product>\r\n";
    }

    public String getProductVersion(String string) {
        WASDirectory wASDirectory = new WASDirectory(System.getProperty("was.install.root"));
        WASProductInfo wASProductInfo = wASDirectory.getWASProductInfo(string);
        if (wASProductInfo == null) {
            return "";
        }
        return this.buildProductVersionXML(wASProductInfo);
    }

    public String getComponentVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".component");
    }

    public String getEFixVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".efix");
    }

    public String getPTFVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".ptf");
    }

    public String getExtensionVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".extension");
    }

    public String[] getVersionsForAllProducts() {
        return this.wasproduct.loadAllVersionInfoByType("product");
    }

    public String[] getVersionsForAllComponents() {
        return this.wasproduct.loadAllVersionInfoByType("component");
    }

    public String[] getVersionsForAllEFixes() {
        return this.wasproduct.loadAllVersionInfoByType("efix");
    }

    public String[] getVersionsForAllPTFs() {
        return this.wasproduct.loadAllVersionInfoByType("ptf");
    }

    public String[] getVersionsForAllExtensions() {
        return this.wasproduct.loadAllVersionInfoByType("extension");
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            this.run(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(final boolean bl) {
            Object object;
            if (DUMP_SHUTDOWN) {
                new Exception(this + ": shutdown hook stack trace").printStackTrace();
                ThreadDump.invoke();
            }
            Object object2 = this;
            synchronized (object2) {
                object = ServerCollaborator.this.shutdownHook;
                ServerCollaborator.this.shutdownHook = null;
                if (object == null) {
                    return;
                }
            }
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                try {
                    ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public Object run() throws Exception {
                            block18: {
                                block16: {
                                    WLC wLC;
                                    if (bl && (wLC = (WLC)WsServiceRegistry.getService((Object)this, (Class)(class$com$ibm$ws$runtime$service$WLC == null ? (class$com$ibm$ws$runtime$service$WLC = ServerCollaborator.class$("com.ibm.ws.runtime.service.WLC")) : class$com$ibm$ws$runtime$service$WLC))) != null) {
                                        wLC.stopImmediate();
                                    }
                                    try {
                                        try {
                                            ServerCollaborator.this.server.stop();
                                            ServerCollaborator.this.server.destroy();
                                        }
                                        catch (Throwable throwable) {
                                            throwable.printStackTrace();
                                            Object var3_4 = null;
                                            if (ServerCollaborator.this.server.getServerMode() == 0) {
                                                Tr.audit(tc, "WSVR0024I", ServerCollaborator.this.server.getName());
                                            } else if (((ServerCollaborator)((ShutdownHook)ShutdownHook.this).ServerCollaborator.this).server.recoverySuccessful) {
                                                Tr.audit(tc, "WSVR0624I", ServerCollaborator.this.server.getName());
                                            } else {
                                                Tr.warning(tc, "WSVR0625W", ServerCollaborator.this.server.getName());
                                            }
                                            RuntimeBundleActivator.instance().shutdownEclipse();
                                            return null;
                                        }
                                        Object var3_3 = null;
                                        if (ServerCollaborator.this.server.getServerMode() != 0) break block16;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_5 = null;
                                        if (ServerCollaborator.this.server.getServerMode() == 0) {
                                            Tr.audit(tc, "WSVR0024I", ServerCollaborator.this.server.getName());
                                        } else if (((ServerCollaborator)((ShutdownHook)ShutdownHook.this).ServerCollaborator.this).server.recoverySuccessful) {
                                            Tr.audit(tc, "WSVR0624I", ServerCollaborator.this.server.getName());
                                        } else {
                                            Tr.warning(tc, "WSVR0625W", ServerCollaborator.this.server.getName());
                                        }
                                        RuntimeBundleActivator.instance().shutdownEclipse();
                                        throw throwable;
                                    }
                                    Tr.audit(tc, "WSVR0024I", ServerCollaborator.this.server.getName());
                                    break block18;
                                }
                                if (((ServerCollaborator)((ShutdownHook)ShutdownHook.this).ServerCollaborator.this).server.recoverySuccessful) {
                                    Tr.audit(tc, "WSVR0624I", ServerCollaborator.this.server.getName());
                                } else {
                                    Tr.warning(tc, "WSVR0625W", ServerCollaborator.this.server.getName());
                                }
                            }
                            RuntimeBundleActivator.instance().shutdownEclipse();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    privilegedActionException.getException().printStackTrace();
                }
            } else {
                object2 = new ServerIdentifiers();
                ((ServerIdentifiers)object2).setConfigRoot(ServerCollaborator.this.server.getRepRootURI());
                ((ServerIdentifiers)object2).setServerName(ServerCollaborator.this.server.getName());
                ((ServerIdentifiers)object2).setNodeName(ServerCollaborator.this.server.getNodeName());
                ((ServerIdentifiers)object2).setCellName(ServerCollaborator.this.server.getCellName());
                try {
                    object = new BeanContextServicesSupport();
                    RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", ((ServerIdentifiers)object2).getConfigRoot(), ((ServerIdentifiers)object2).getCellName(), ((ServerIdentifiers)object2).getNodeName(), ((ServerIdentifiers)object2).getServerName());
                    object.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = ServerCollaborator.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, repositoryImpl);
                    VariableMapImpl variableMapImpl = new VariableMapImpl();
                    object.add(variableMapImpl);
                    variableMapImpl.initialize(null);
                    ProcessTerminator processTerminator = new ProcessTerminator((ServerIdentifiers)object2);
                    processTerminator.setStopMode(bl);
                    processTerminator.terminate();
                }
                catch (Exception exception) {
                    Tr.error(tc, "Failed to stop the process:", exception);
                }
            }
        }
    }

    class StopAction
    implements AlarmListener {
        boolean immediate;

        StopAction(boolean bl) {
            this.immediate = bl;
        }

        public void alarm(Object object) {
            if (ServerCollaborator.this.shutdownHook != null) {
                ServerCollaborator.this.shutdownHook.run(this.immediate);
                if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    System.exit(0);
                }
            }
        }
    }
}

