/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import java.io.File;
import java.io.FileFilter;

public final class StatefulBeanFileReaper
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(StatefulBeanFileReaper.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private String serverName;
    private String clusterName;
    private String passivationDirectory;
    private long ivSweepInterval;
    private static final long DEFAULT_MIN_CLEANUP_INTERVAL = 60000L;
    private static final long DEFAULT_CLEANUP_INTERVAL = 4200000L;
    private long currentTime;

    public StatefulBeanFileReaper(String string, String string2, String string3, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>: Passivation Directory: " + string + " Server Name: " + string2 + " Cluster Name: " + string3);
        }
        this.ivSweepInterval = l == 0L ? 4200000L : (l < 60000L ? 60000L : l);
        this.passivationDirectory = string;
        this.serverName = string2;
        this.clusterName = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> : sweep = " + this.ivSweepInterval + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        this.currentTime = System.currentTimeMillis();
        try {
            File[] fileArray = null;
            File file = new File(this.passivationDirectory);
            StatefulBeanFileFilter statefulBeanFileFilter = new StatefulBeanFileFilter();
            fileArray = file.listFiles(statefulBeanFileFilter);
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        fileArray[i].delete();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "alarm: Removed Stateful Session Bean file: " + fileArray[i].getAbsoluteFile());
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "alarm: Exception removing Stateful Session Bean file: " + fileArray[i].getAbsoluteFile() + " exception: " + throwable);
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", new Object[]{this, exception});
        }
        finally {
            AlarmManager.create(this.ivSweepInterval, this, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    private class StatefulBeanFileFilter
    implements FileFilter {
        private StatefulBeanFileFilter() {
        }

        public boolean accept(File file) {
            String string;
            boolean bl = false;
            long l = file.lastModified();
            if (l != 0L && l < StatefulBeanFileReaper.this.currentTime && (string = file.getName()).startsWith("BeanId_") && (string.endsWith(StatefulBeanFileReaper.this.serverName) || StatefulBeanFileReaper.this.clusterName != null && string.endsWith(StatefulBeanFileReaper.this.clusterName))) {
                bl = true;
            }
            return bl;
        }
    }
}

