/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.models.config.tperfviewer.TPVService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.tpv.advisor.AdvisorCollaborator;
import com.ibm.ws.tpv.engine.TPVCollaborator;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.util.PlatformHelper;

public class TPVServiceImpl
extends ComponentImpl {
    private boolean enabled = true;
    private static Repository repository = null;
    private static TraceComponent tc = Tr.register(TPVServiceImpl.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");
    private boolean isMbeanNeeded = false;
    protected static final String TPV_MBEAN_TYPE = "TivoliPerfEngine";
    protected static final String TPV_MBEAN_CONFIGID = "TPVEngineMBean";
    protected static final String TPA_MBEAN_TYPE = "TivoliPerfAdvisor";
    protected static final String TPA_MBEAN_CONFIGID = "TPVAdvisorMBean";

    public void initialize(Object object) {
        TPVService tPVService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if ((tPVService = (TPVService)object).isSetEnable()) {
            this.enabled = tPVService.isEnable();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize: enabled=" + this.enabled);
        }
        if (!this.enabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - not enabled");
            }
            return;
        }
        repository = (Repository)this.getService(Repository.class);
        TPVEngine.setRepository(repository);
        PlatformHelper platformHelper = AdminHelper.getPlatformHelper();
        String string = AdminServiceFactory.getAdminService().getProcessType();
        if (string.equals("NodeAgent")) {
            this.isMbeanNeeded = true;
        } else if (string.equals("UnManagedProcess")) {
            boolean bl = platformHelper.isZOS() ? !platformHelper.isControlJvm() : (this.isMbeanNeeded = true);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tpv service : isMbeanNeeded = " + this.isMbeanNeeded);
        }
        if (this.isMbeanNeeded) {
            TPVCollaborator tPVCollaborator = new TPVCollaborator();
            if (this.startMBean(TPV_MBEAN_TYPE, TPV_MBEAN_CONFIGID, tPVCollaborator)) {
                Tr.debug(tc, "Successfully started TPV MBean.");
            } else {
                Tr.error(tc, "TPVE0017E");
            }
            AdvisorCollaborator advisorCollaborator = new AdvisorCollaborator(repository);
            if (this.startMBean(TPA_MBEAN_TYPE, TPA_MBEAN_CONFIGID, advisorCollaborator)) {
                Tr.debug(tc, "Successfully started Advisor MBean.");
            } else {
                Tr.error(tc, "TPVE0018E");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    protected boolean startMBean(String string, String string2, RuntimeCollaborator runtimeCollaborator) {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            mBeanFactory.activateMBean(string, runtimeCollaborator, string2, null);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.tpv.engine.TPVServiceImpl.startMBean", "52", this);
            return false;
        }
        return true;
    }

    public void start() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Start issued on Tivoli Performance Viewer service");
        }
    }

    public void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stop issued on Tivoli Performance Viewer service");
        }
        if (this.isMbeanNeeded) {
            TPVEngine tPVEngine = TPVEngine.getEngine();
            tPVEngine.shutdown();
        }
    }

    public void destroy() {
        Object var1_1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroy called for Tivoli Performance Viewer service");
        }
        if ((var1_1 = null) != null) {
            this.releaseService(var1_1);
        }
        if (this.isMbeanNeeded) {
            TPVEngine.getEngine().shutdown();
        }
    }

    public static Repository getRepository() {
        return repository;
    }
}

