/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.debug.ThreadDump;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ServerCollaborator;
import com.ibm.ws.runtime.component.ServerImpl;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadMonitor;
import com.ibm.ws.util.PlatformHelperFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.Notification;
import org.eclipse.emf.common.util.EList;

public class ThreadMonitorImpl
extends ComponentImpl
implements ThreadMonitor,
ThreadMonitor.Listener,
PropertyChangeListener {
    private static TraceComponent tc = Tr.register(ThreadMonitorImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static final String INTERVAL_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.interval";
    private static final String THRESHOLD_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.threshold";
    private static final String ADJUSTMENT_THRESHOLD_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.false.alarm.threshold";
    private static final String DUMP_JAVA_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.dump.java";
    private static final String DUMP_STACK_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.dump.stack";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Map groupPolicyMap = Collections.synchronizedMap(new HashMap());
    private ThreadMonitor.DetectionPolicy defaultPolicy = null;
    private ServerCollaborator jmxCollaborator = null;
    private long threshold = 600000L;
    private long interval = 180000L;
    private int numberOfHungThreads = 0;
    private int numberOfClearedThreads = 0;
    private int adjustmentThreshold = 100;
    private boolean dumpJava = false;
    private boolean dumpStack = true;
    private Vector listeners = new Vector();
    private int numHungThreads = 0;
    private AlarmBasedNotification notifier = null;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        try {
            this.defaultPolicy = new SimplePolicy(this.getThreshold());
            this.listeners.add(new RasListener());
            this.addService(ThreadMonitor.class);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        try {
            boolean bl = tc.isDebugEnabled();
            if (bl) {
                Tr.debug(tc, "starting ThreadMonitor");
            }
            Server server2 = (Server)this.getService(Server.class);
            server2.addPropertyChangeListener("threadMonitorInterval", this);
            server2.addPropertyChangeListener("threadMonitorThreshold", this);
            server2.addPropertyChangeListener("threadMonitorAdjustmentThreshold", this);
            this.jmxCollaborator = ((ServerImpl)server2).getCollaborator();
            this.releaseService(server2);
            ApplicationServer applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
            if (applicationServer != null) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5 = applicationServer.getCustomProperty(INTERVAL_CUSTOM_PROPERTY_NAME);
                if (string5 != null) {
                    this.jmxCollaborator.setThreadMonitorInterval(Integer.parseInt(string5));
                    if (bl) {
                        Tr.debug(tc, "configured interval : " + string5 + " seconds");
                    }
                }
                if ((string4 = applicationServer.getCustomProperty(THRESHOLD_CUSTOM_PROPERTY_NAME)) != null) {
                    this.jmxCollaborator.setThreadMonitorThreshold(Integer.parseInt(string4));
                    ((SimplePolicy)this.defaultPolicy).setThreshold(this.threshold);
                    if (bl) {
                        Tr.debug(tc, "configured threshold : " + string4 + " seconds");
                    }
                }
                if ((string3 = applicationServer.getCustomProperty(ADJUSTMENT_THRESHOLD_CUSTOM_PROPERTY_NAME)) != null) {
                    this.adjustmentThreshold = Integer.parseInt(string3);
                    if (bl) {
                        Tr.debug(tc, "configured adjustment threshold : " + string3);
                    }
                }
                if ((string2 = applicationServer.getCustomProperty(DUMP_JAVA_CUSTOM_PROPERTY_NAME)) != null) {
                    this.dumpJava = Boolean.valueOf(string2);
                    if (bl) {
                        Tr.debug(tc, "configured dump java : " + string2);
                    }
                }
                if ((string = applicationServer.getCustomProperty(DUMP_STACK_CUSTOM_PROPERTY_NAME)) != null) {
                    this.dumpStack = Boolean.valueOf(string);
                    if (bl) {
                        Tr.debug(tc, "configured dump stack : " + string);
                    }
                }
            } else if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
                Object object;
                EList eList;
                Object object2;
                Repository repository2 = null;
                com.ibm.websphere.models.config.applicationserver.ApplicationServer applicationServer2 = null;
                try {
                    repository2 = (Repository)this.getService(Repository.class);
                    object2 = (com.ibm.websphere.models.config.process.Server)repository2.getConfigRoot().getResource(4, "server.xml").getContents().get(0);
                    eList = object2.getComponents();
                    object = eList.iterator();
                    Object var9_16 = null;
                    while (object.hasNext()) {
                        var9_16 = object.next();
                        if (!(var9_16 instanceof com.ibm.websphere.models.config.applicationserver.ApplicationServer)) continue;
                        applicationServer2 = var9_16;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.runtime.component.ThreadMonitorImpl", "191", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Could not lookup ApplicationServer in config", throwable);
                    }
                }
                finally {
                    if (repository2 != null) {
                        this.releaseService(repository2);
                    }
                }
                if (applicationServer2 != null) {
                    object2 = applicationServer2.getProperties().iterator();
                    eList = null;
                    server2 = (Server)this.getService(Server.class);
                    while (object2.hasNext()) {
                        eList = (Property)object2.next();
                        if (eList.getName().equals(INTERVAL_CUSTOM_PROPERTY_NAME)) {
                            object = eList.getValue();
                            if (object == null) continue;
                            ((ServerImpl)server2).setThreadMonitorInterval(Integer.parseInt((String)object));
                            if (!bl) continue;
                            Tr.debug(tc, "configured interval in CR: " + (String)object + " seconds");
                            continue;
                        }
                        if (eList.getName().equals(THRESHOLD_CUSTOM_PROPERTY_NAME)) {
                            object = eList.getValue();
                            if (object == null) continue;
                            ((ServerImpl)server2).setThreadMonitorThreshold(Integer.parseInt((String)object));
                            ((SimplePolicy)this.defaultPolicy).setThreshold(this.threshold);
                            if (!bl) continue;
                            Tr.debug(tc, "configured threshold in CR: " + (String)object + " seconds");
                            continue;
                        }
                        if (!eList.getName().equals(ADJUSTMENT_THRESHOLD_CUSTOM_PROPERTY_NAME) || (object = eList.getValue()) == null) continue;
                        ((ServerImpl)server2).setThreadMonitorAdjustmentThreshold(Integer.parseInt((String)object));
                        if (!bl) continue;
                        Tr.debug(tc, "configured adjustment threshold in CR: " + (String)object);
                    }
                    this.releaseService(server2);
                }
            }
            this.releaseService(applicationServer);
            if (this.isEnabled()) {
                this.notifier = new AlarmBasedNotification();
            }
            this.listeners.add(new JmxListener());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.interval > 0L;
    }

    public void checkAllThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAllThreads");
        }
        boolean bl = tc.isDebugEnabled();
        try {
            Iterator iterator = this.groupPolicyMap.keySet().iterator();
            while (iterator.hasNext()) {
                ThreadMonitor.ThreadGroup threadGroup = (ThreadMonitor.ThreadGroup)iterator.next();
                try {
                    ThreadMonitor.DetectionPolicy detectionPolicy = (ThreadMonitor.DetectionPolicy)this.groupPolicyMap.get(threadGroup);
                    if (detectionPolicy == null) {
                        detectionPolicy = this.defaultPolicy;
                    }
                    threadGroup.checkAllThreads(detectionPolicy);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "232");
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            FFDCFilter.processException(concurrentModificationException, this.getClass().getName(), "235");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAllThreads");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("threadMonitorInterval".equals(propertyChangeEvent.getPropertyName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "interval changed " + propertyChangeEvent.getNewValue());
            }
            long l = this.interval;
            this.interval = (long)((Integer)propertyChangeEvent.getNewValue()).intValue() * 1000L;
            if (this.notifier != null) {
                this.notifier.cancel();
                if (this.interval >= 0L) {
                    this.notifier.scheduleNext();
                }
            }
            boolean bl = false;
            bl |= l <= 0L && this.interval > 0L;
            if (bl |= l > 0L && this.interval <= 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "monitor has changed state  enabled=" + this.isEnabled());
                }
                Iterator iterator = this.groupPolicyMap.keySet().iterator();
                while (iterator.hasNext()) {
                    ThreadMonitor.ThreadGroup threadGroup = (ThreadMonitor.ThreadGroup)iterator.next();
                    threadGroup.monitorStateChanged(this.isEnabled());
                }
            }
        } else if ("threadMonitorThreshold".equals(propertyChangeEvent.getPropertyName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threshold changed " + propertyChangeEvent.getNewValue());
            }
            this.threshold = (long)((Integer)propertyChangeEvent.getNewValue()).intValue() * 1000L;
            ((SimplePolicy)this.defaultPolicy).setThreshold(this.threshold);
        } else if ("threadMonitorAdjustmentThreshold".equals(propertyChangeEvent.getPropertyName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adjustment threshold changed " + propertyChangeEvent.getNewValue());
            }
            this.adjustmentThreshold = (Integer)propertyChangeEvent.getNewValue();
            this.numberOfClearedThreads = 0;
        }
    }

    public long getThreshold() {
        return this.threshold;
    }

    public synchronized long getInterval() {
        return this.interval;
    }

    public void addThreadMonitorListener(ThreadMonitor.Listener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addThreadMonitorListener", listener);
        }
        this.listeners.add(listener);
    }

    public void removeThreadMonitorListener(ThreadMonitor.Listener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeThreadMonitorListener", listener);
        }
        this.listeners.remove(listener);
    }

    public void setDetectionPolicy(ThreadMonitor.DetectionPolicy detectionPolicy, ThreadMonitor.ThreadGroup threadGroup) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void threadIsClear(String string, String string2, long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadIsClear", new Object[]{string, new Long(l)});
        }
        this.decrementNumberOfHungThreads();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ThreadMonitor.Listener listener = (ThreadMonitor.Listener)iterator.next();
                listener.threadIsClear(string, string2, l);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "439");
            }
        }
        this.incrementNumberOfClearedThreads();
        if (this.adjustmentThreshold > 0 && this.getNumberOfClearedThreads() % this.adjustmentThreshold == 0) {
            long l2 = this.threshold / 1000L;
            long l3 = 0L;
            l3 = l2 % 2L != 0L ? (l2 + 1L) / 2L : l2 / 2L;
            long l4 = l2 + l3;
            this.jmxCollaborator.setThreadMonitorThreshold((int)l4);
            Tr.warning(tc, "WSVR0607W", new Long(l4));
        }
    }

    public void threadIsHung(String string, String string2, long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadIsHung", new Object[]{string, string2, new Long(l)});
        }
        this.incrementNumberOfHungThreads();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ThreadMonitor.Listener listener = (ThreadMonitor.Listener)iterator.next();
                listener.threadIsHung(string, string2, l);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "487");
            }
        }
        if (this.dumpJava) {
            ThreadDump.invoke();
        }
    }

    public void addThreadGroup(ThreadMonitor.ThreadGroup threadGroup) throws ComponentDisabledException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addThreadGroup", threadGroup);
        }
        if (!this.isEnabled()) {
            throw new ComponentDisabledException("The thread monitor is disabled.");
        }
        try {
            threadGroup.setThreadMonitorListener(this);
            this.groupPolicyMap.put(threadGroup, null);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public void removeThreadGroup(ThreadMonitor.ThreadGroup threadGroup) throws ComponentDisabledException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeThreadGroup", threadGroup);
        }
        if (!this.isEnabled()) {
            throw new ComponentDisabledException("The thread monitor is disabled.");
        }
        try {
            threadGroup.setThreadMonitorListener(null);
            this.groupPolicyMap.remove(threadGroup);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    private synchronized int getNumberOfHungThreads() {
        return this.numHungThreads;
    }

    private synchronized void incrementNumberOfHungThreads() {
        ++this.numHungThreads;
    }

    private synchronized void decrementNumberOfHungThreads() {
        --this.numHungThreads;
    }

    private int getNumberOfClearedThreads() {
        return this.numberOfClearedThreads;
    }

    private synchronized void incrementNumberOfClearedThreads() {
        ++this.numberOfClearedThreads;
    }

    private class JmxListener
    implements ThreadMonitor.Listener {
        private JmxListener() {
        }

        public void threadIsHung(String string, String string2, long l) {
            try {
                String string3 = MessageFormat.format("Thread \"{0}\" has been active for {1} milliseconds and may be hung.  There is/are {2} thread(s) in total that may be hung.", string, new Long(l), new Integer(ThreadMonitorImpl.this.getNumberOfHungThreads()));
                Notification notification = new Notification("websphere.thread.hung", (Object)ThreadMonitorImpl.this.jmxCollaborator.getObjectName(), 0L, string3);
                Properties properties = new Properties();
                properties.setProperty("threadName", string);
                properties.setProperty("processId", ThreadMonitorImpl.this.jmxCollaborator.getPid());
                properties.setProperty("processName", ThreadMonitorImpl.this.jmxCollaborator.getName());
                notification.setUserData(properties);
                ThreadMonitorImpl.this.jmxCollaborator.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException(mBeanException, this.getClass().getName(), "366");
            }
        }

        public void threadIsClear(String string, String string2, long l) {
            try {
                String string3 = MessageFormat.format("Thread \"{0}\" was previously reported to be hung but has completed.  It was active for approximately {1} milliseconds. There is/are now {2} thread(s) in total that may be hung.", string, new Long(l), new Integer(ThreadMonitorImpl.this.getNumberOfHungThreads()));
                Notification notification = new Notification("websphere.thread.clear", (Object)ThreadMonitorImpl.this.jmxCollaborator.getObjectName(), 0L, string3);
                Properties properties = new Properties();
                properties.setProperty("threadName", string);
                notification.setUserData(properties);
                ThreadMonitorImpl.this.jmxCollaborator.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException(mBeanException, this.getClass().getName(), "380");
            }
        }
    }

    private class RasListener
    implements ThreadMonitor.Listener {
        private RasListener() {
        }

        public void threadIsClear(String string, String string2, long l) {
            Tr.warning(tc, "WSVR0606W", new Object[]{string, string2, new Long(l), new Integer(ThreadMonitorImpl.this.getNumberOfHungThreads())});
        }

        public void threadIsHung(String string, String string2, long l) {
            String string3 = " ";
            if (ThreadMonitorImpl.this.dumpStack) {
                try {
                    ThreadInfo threadInfo;
                    ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                    ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds());
                    long l2 = -1L;
                    for (int i = 0; i < threadInfoArray.length; ++i) {
                        if (threadInfoArray[i] == null || !threadInfoArray[i].getThreadName().equals(string)) continue;
                        l2 = threadInfoArray[i].getThreadId();
                        break;
                    }
                    if (l2 != -1L && (threadInfo = threadMXBean.getThreadInfo(l2, Integer.MAX_VALUE)) != null) {
                        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            stringBuilder.append(LINE_SEPARATOR).append("\tat ").append(stackTraceElementArray[i]);
                        }
                        string3 = stringBuilder.toString();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, this.getClass().getName(), "507");
                }
            }
            Tr.warning(tc, "WSVR0605W", new Object[]{string, string2, new Long(l), new Integer(ThreadMonitorImpl.this.getNumberOfHungThreads()), string3});
        }
    }

    private static class SimplePolicy
    implements ThreadMonitor.DetectionPolicy {
        private long threshold = 0L;

        SimplePolicy(long l) {
            this.threshold = l;
        }

        public boolean isThreadHung(String string, String string2, long l) {
            return l > this.threshold;
        }

        public long getThreshold() {
            return this.threshold;
        }

        public void setThreshold(long l) {
            this.threshold = l;
        }
    }

    private class AlarmBasedNotification
    implements AlarmListener {
        Alarm current = null;

        AlarmBasedNotification() {
            this.current = AlarmManager.create(ThreadMonitorImpl.this.getInterval(), this);
        }

        public void alarm(Object object) {
            try {
                ThreadMonitorImpl.this.checkAllThreads();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "295");
            }
            this.scheduleNext();
        }

        void cancel() {
            if (this.current != null) {
                this.current.cancel();
                this.current = null;
            }
        }

        void scheduleNext() {
            if (ThreadMonitorImpl.this.getInterval() > 0L) {
                this.current = AlarmManager.create(ThreadMonitorImpl.this.getInterval(), this);
            }
        }
    }
}

