/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.threadpoolmanager.ThreadPoolManager;
import com.ibm.websphere.pmi.ThreadPoolPerf;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.component.PMI;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ORBImpl;
import com.ibm.ws.runtime.service.ThreadMonitor;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.ws.util.WSUtil;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TooManyListenersException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ThreadPoolMgrImpl
extends ComponentImpl
implements ThreadPoolMgr,
ThreadPoolListener {
    private static TraceComponent tc = Tr.register(ThreadPoolMgrImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private Map configuredThreadPools = Collections.synchronizedMap(new HashMap(16));
    private Map unnamedThreadPools = null;
    private int unnamedPoolIndex = 0;
    private ThreadPoolListener[] threadPoolListeners = new ThreadPoolListener[0];
    private boolean pmiEnabled = false;
    private static final String CLEAR_THREAD_LOCALS_PROP_NAME = "com.ibm.websphere.threadpool.clearThreadLocal";
    private boolean overrideTPM = false;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ThreadMonitor;
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter;

    public void initialize(Object object) {
        try {
            Object object2;
            Object object3;
            Object object4;
            ThreadPoolManager threadPoolManager = (ThreadPoolManager)object;
            EList eList = threadPoolManager.getThreadPools();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                object4 = (com.ibm.websphere.models.config.process.ThreadPool)iterator.next();
                object3 = this.getThreadPoolName((com.ibm.websphere.models.config.process.ThreadPool)object4);
                int n = object4.getMaximumSize();
                int n2 = object4.getMinimumSize();
                if (n > 0 && n >= n2) {
                    object2 = new ThreadPoolProxy((String)object3, n, n2, this);
                    ((ThreadPoolProxy)object2).processThreadPoolConfig((com.ibm.websphere.models.config.process.ThreadPool)object4);
                    this.configuredThreadPools.put(object3, object2);
                    if (!"server.startup".equals(object3)) continue;
                    ((ThreadPoolProxy)object2).inhibitPMI();
                    continue;
                }
                Tr.error(tc, "WSVR0315E", new Object[]{object3});
            }
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                object4 = null;
                object3 = threadPoolManager.eContainer();
                if (object3 instanceof Server) {
                    EList eList2 = ((Server)object3).getServices();
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        object2 = (Service)iterator2.next();
                        if (!(object2 instanceof ObjectRequestBroker)) continue;
                        ObjectRequestBroker objectRequestBroker = (ObjectRequestBroker)object2;
                        if (objectRequestBroker.isUseServerThreadPool()) break;
                        this.overrideTPM = true;
                        object4 = objectRequestBroker.getThreadPool();
                        if (object4 == null) break;
                        int n = object4.getMaximumSize();
                        int n3 = object4.getMinimumSize();
                        if (n <= 0 || n < n3) break;
                        ThreadPoolProxy threadPoolProxy = new ThreadPoolProxy(ORBImpl.ORB_THREAD_POOL_KEY, n, n3, this);
                        threadPoolProxy.processThreadPoolConfig((com.ibm.websphere.models.config.process.ThreadPool)object4);
                        this.configuredThreadPools.put(ORBImpl.ORB_THREAD_POOL_KEY, threadPoolProxy);
                        break;
                    }
                }
            }
            if ((object4 = this.getThreadPool("Default")) == null) {
                com.ibm.websphere.models.config.process.ThreadPool threadPool = ProcessFactory.eINSTANCE.createThreadPool();
                threadPool.setName("Default");
                threadPool.setMinimumSize(5);
                threadPool.setMaximumSize(20);
                object2 = new ThreadPoolProxy("Default", 20, 5, this);
                ((ThreadPoolProxy)object2).processThreadPoolConfig(threadPool);
                this.configuredThreadPools.put("Default", object2);
            }
            if ((object3 = this.getThreadPool("server.startup")) == null) {
                Tr.warning(tc, "WSVR0622W", "server.startup");
                object3 = new ThreadPool("_server.startup", 0, 10);
                ((ThreadPool)object3).setKeepAliveTime(30000L);
            }
            ComponentImpl._setStartupThreadPool((ThreadPool)object3);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName(), "119");
            throwable.printStackTrace();
        }
        this.addService(ThreadPoolMgr.class);
    }

    public void start() throws RuntimeWarning, RuntimeError {
        ThreadPoolProxy threadPoolProxy;
        this.pmiEnabled = false;
        PMI pMI = (PMI)this.getService(PMI.class);
        if (pMI != null) {
            this.pmiEnabled = pMI.isEnabled();
        }
        Iterator<Object> iterator = this.configuredThreadPools.values().iterator();
        while (iterator.hasNext()) {
            threadPoolProxy = (ThreadPoolProxy)iterator.next();
            threadPoolProxy.setPmiEnabled(this.pmiEnabled);
            threadPoolProxy.convertAndReleaseConfigRef();
        }
        if (this.unnamedThreadPools != null) {
            iterator = this.unnamedThreadPools.keySet().iterator();
            while (iterator.hasNext()) {
                threadPoolProxy = (com.ibm.websphere.models.config.process.ThreadPool)iterator.next();
                String string = this.getThreadPoolName((com.ibm.websphere.models.config.process.ThreadPool)threadPoolProxy);
                this.getThreadPool(null, (com.ibm.websphere.models.config.process.ThreadPool)threadPoolProxy);
            }
        }
        if (this.overrideTPM) {
            Tr.warning(tc, "WSVR0626W");
        }
    }

    public ThreadPool getThreadPool(String string) {
        ThreadPool threadPool = null;
        ThreadPoolProxy threadPoolProxy = (ThreadPoolProxy)this.configuredThreadPools.get(string);
        if (threadPoolProxy != null) {
            threadPool = threadPoolProxy.getInstance();
        }
        return threadPool;
    }

    public ThreadPool getThreadPool(String string, com.ibm.websphere.models.config.process.ThreadPool threadPool) {
        ThreadPool threadPool2;
        if (string == null) {
            string = this.getThreadPoolName(threadPool);
        }
        if ((threadPool2 = this.getThreadPool(string)) == null) {
            ThreadPoolProxy threadPoolProxy = null;
            if (threadPool == null) {
                threadPoolProxy = new ThreadPoolProxy(string, 5, 1, this);
                threadPoolProxy.setConfigId(string);
                this.configuredThreadPools.put(string, threadPoolProxy);
                threadPool2 = threadPoolProxy.getInstance();
            } else {
                int n = threadPool.getMaximumSize();
                int n2 = threadPool.getMinimumSize();
                if (n > 0 && n >= n2) {
                    threadPoolProxy = new ThreadPoolProxy(string, n, n2, this);
                    threadPoolProxy.processThreadPoolConfig(threadPool);
                    this.configuredThreadPools.put(string, threadPoolProxy);
                    threadPool2 = threadPoolProxy.getInstance();
                } else {
                    Tr.error(tc, "WSVR0315E", new Object[]{string});
                }
            }
        }
        return threadPool2;
    }

    public void addThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n = this.threadPoolListeners.length + 1;
        ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n];
        System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n - 1);
        threadPoolListenerArray[n - 1] = threadPoolListener;
        this.threadPoolListeners = threadPoolListenerArray;
    }

    public void removeThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n;
        for (n = 0; n < this.threadPoolListeners.length && this.threadPoolListeners[n] != threadPoolListener; ++n) {
        }
        if (n < this.threadPoolListeners.length) {
            int n2 = this.threadPoolListeners.length - 1;
            ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n2];
            System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n);
            System.arraycopy(this.threadPoolListeners, n + 1, threadPoolListenerArray, n, n2 - n - 1);
            this.threadPoolListeners = threadPoolListenerArray;
        }
    }

    public void threadPoolCreated(ThreadPool threadPool) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadPoolCreated(threadPool);
        }
    }

    public void threadCreated(ThreadPool threadPool, int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadCreated(threadPool, n);
        }
    }

    public void threadStarted(ThreadPool threadPool, int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadStarted(threadPool, n, n2);
        }
    }

    public void threadReturned(ThreadPool threadPool, int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadReturned(threadPool, n, n2);
        }
    }

    public void threadDestroyed(ThreadPool threadPool, int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadDestroyed(threadPool, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getThreadPoolName(com.ibm.websphere.models.config.process.ThreadPool threadPool) {
        if (threadPool == null) {
            return null;
        }
        String string = threadPool.getName();
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        ThreadPoolMgrImpl threadPoolMgrImpl = this;
        synchronized (threadPoolMgrImpl) {
            if (this.unnamedThreadPools == null) {
                this.unnamedThreadPools = Collections.synchronizedMap(new HashMap());
            }
            if ((string = (String)this.unnamedThreadPools.get(threadPool)) == null) {
                string = "Unnamed.Pool." + this.unnamedPoolIndex;
                ++this.unnamedPoolIndex;
                this.unnamedThreadPools.put(threadPool, string);
            }
            return string;
        }
    }

    public void setRequestBufferSize(String string, int n) {
        ThreadPoolProxy threadPoolProxy = (ThreadPoolProxy)this.configuredThreadPools.get(string);
        if (threadPoolProxy == null) {
            throw new IllegalArgumentException("Thread pool \"" + string + "\" is unknown.");
        }
        threadPoolProxy.setRequestBufferSize(n);
        if (threadPoolProxy.threadPoolInstance != null) {
            threadPoolProxy.threadPoolInstance.setRequestBufferSize(n);
        }
    }

    private static class ThreadPoolMonitorAdapter
    implements ThreadPool.MonitorPlugin,
    ThreadMonitor.ThreadGroup {
        private ThreadMonitor.DetectionPolicy policy = null;
        private ThreadPool threadPool = null;
        private ThreadMonitor.Listener listener = null;
        private PmiThreadPoolAdapter pmiAdapter = null;

        ThreadPoolMonitorAdapter(ThreadPool threadPool, ThreadMonitor threadMonitor, PmiThreadPoolAdapter pmiThreadPoolAdapter) {
            this.threadPool = threadPool;
            this.pmiAdapter = pmiThreadPoolAdapter;
            try {
                threadMonitor.addThreadGroup(this);
                this.threadPool.setMonitorPlugin(this);
                if (pmiThreadPoolAdapter != null) {
                    pmiThreadPoolAdapter.monitorStateChanged(threadMonitor.isEnabled());
                }
            }
            catch (ComponentDisabledException componentDisabledException) {
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace(System.out);
                FFDCFilter.processException(tooManyListenersException, (class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter == null ? (class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter = ThreadPoolMgrImpl.class$("com.ibm.ws.runtime.component.ThreadPoolMgrImpl$ThreadPoolMonitorAdapter")) : class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter).getName(), "198");
            }
        }

        public boolean checkThread(String string, String string2, long l) {
            if (this.policy.isThreadHung(string, string2, l)) {
                if (this.pmiAdapter != null) {
                    this.pmiAdapter.threadIsHung(string);
                }
                this.listener.threadIsHung(string, string2, l);
                return true;
            }
            return false;
        }

        public void clearThread(String string, String string2, long l) {
            if (this.pmiAdapter != null) {
                this.pmiAdapter.threadIsClear(string, l);
            }
            this.listener.threadIsClear(string, string2, l);
        }

        public void checkAllThreads(ThreadMonitor.DetectionPolicy detectionPolicy) {
            this.policy = detectionPolicy;
            this.threadPool.checkAllThreads();
        }

        public void setThreadMonitorListener(ThreadMonitor.Listener listener) {
            if (this.listener != null && !this.listener.equals(listener)) {
                throw new IllegalStateException("Listener already registered");
            }
            this.listener = listener;
        }

        public String toString() {
            return "ThreadPoolMonitorAdapter[pool=" + this.threadPool.getName() + "]";
        }

        public void monitorStateChanged(boolean bl) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "monitorStateChanged", new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
            }
            if (this.pmiAdapter != null) {
                this.pmiAdapter.monitorStateChanged(bl);
            }
        }

        void setPmiAdapter(PmiThreadPoolAdapter pmiThreadPoolAdapter) {
            this.pmiAdapter = pmiThreadPoolAdapter;
        }
    }

    private class ThreadPoolProxy {
        private com.ibm.websphere.models.config.process.ThreadPool threadPoolConfig;
        private String configId = null;
        private String name;
        private int maximumSize;
        private int minimumSize;
        private Integer inactivityTimeOut = null;
        private Boolean growable = null;
        private Integer requestBufferSize = null;
        private Boolean clearThreadLocals = null;
        private ThreadPool threadPoolInstance;
        private ThreadPoolListener owningThreadPoolManager;
        private PmiThreadPoolAdapter pmiAdapter = null;
        private ThreadPoolMonitorAdapter threadMonitorAdapter = null;
        private boolean pmiInhibited = false;

        public ThreadPoolProxy(String string, int n, int n2, ThreadPoolListener threadPoolListener) {
            this.name = string;
            this.maximumSize = n;
            this.minimumSize = n2;
            this.owningThreadPoolManager = threadPoolListener;
        }

        void setThreadPoolConfig(com.ibm.websphere.models.config.process.ThreadPool threadPool) {
            this.threadPoolConfig = threadPool;
        }

        void setConfigId(String string) {
            this.configId = string;
        }

        void setInactivityTimeout(int n) {
            this.inactivityTimeOut = new Integer(n);
        }

        void setGrowable(boolean bl) {
            this.growable = new Boolean(bl);
        }

        void processThreadPoolConfig(com.ibm.websphere.models.config.process.ThreadPool threadPool) {
            this.setThreadPoolConfig(threadPool);
            if (threadPool.isSetIsGrowable()) {
                this.setGrowable(this.threadPoolConfig.isIsGrowable());
            }
            if (threadPool.isSetInactivityTimeout()) {
                this.setInactivityTimeout(this.threadPoolConfig.getInactivityTimeout());
            }
            Iterator iterator = threadPool.getCustomProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (ThreadPoolMgrImpl.CLEAR_THREAD_LOCALS_PROP_NAME.equals(property.getName())) {
                    this.setClearThreadLocals(Boolean.valueOf(property.getValue()));
                    continue;
                }
                if (!"com.ibm.websphere.threadpool.requestBufferSize".equals(property.getName())) continue;
                try {
                    this.setRequestBufferSize(Integer.valueOf(property.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException(numberFormatException, this.getClass().getName(), "396");
                    Tr.warning(tc, "WSVR0315E", this.name);
                }
            }
        }

        void setRequestBufferSize(int n) {
            this.requestBufferSize = new Integer(n);
        }

        void setClearThreadLocals(boolean bl) {
            this.clearThreadLocals = new Boolean(bl);
        }

        void setPmiEnabled(boolean bl) {
            boolean bl2;
            if (this.pmiInhibited) {
                return;
            }
            boolean bl3 = bl2 = this.pmiAdapter != null;
            if (this.threadPoolInstance != null) {
                if (!bl2 && bl) {
                    this.pmiAdapter = new PmiThreadPoolAdapter(this.threadPoolInstance);
                    this.threadPoolInstance.addThreadPoolListener(this.pmiAdapter);
                    this.threadMonitorAdapter.setPmiAdapter(this.pmiAdapter);
                } else if (bl2 && !bl) {
                    this.threadPoolInstance.removeThreadPoolListener(this.pmiAdapter);
                    this.threadMonitorAdapter.setPmiAdapter(null);
                    this.pmiAdapter = null;
                }
            }
        }

        void inhibitPMI() {
            if (this.pmiAdapter != null) {
                throw new IllegalStateException("Internal error: PMI cannot be inhibted after it has been enabled.");
            }
            this.pmiInhibited = true;
        }

        void convertAndReleaseConfigRef() {
            if (this.configId == null) {
                this.configId = ThreadPoolMgrImpl.this.getConfigId((EObject)this.threadPoolConfig);
                this.threadPoolConfig = null;
            }
        }

        ThreadPool getInstance() {
            if (this.threadPoolInstance == null) {
                ThreadPoolListener[] threadPoolListenerArray = null;
                if (ThreadPoolMgrImpl.this.pmiEnabled) {
                    this.pmiAdapter = new PmiThreadPoolAdapter();
                    threadPoolListenerArray = new ThreadPoolListener[]{this.pmiAdapter, this.owningThreadPoolManager};
                } else {
                    threadPoolListenerArray = new ThreadPoolListener[]{this.owningThreadPoolManager};
                }
                this.threadPoolInstance = new ThreadPool(this.name, this.minimumSize, this.maximumSize, threadPoolListenerArray);
                if (this.inactivityTimeOut != null) {
                    this.threadPoolInstance.setKeepAliveTime(this.inactivityTimeOut.intValue());
                }
                if (this.growable != null) {
                    this.threadPoolInstance.setGrowAsNeeded(this.growable);
                }
                if (this.requestBufferSize != null) {
                    this.threadPoolInstance.setRequestBufferSize(this.requestBufferSize);
                }
                if (this.clearThreadLocals != null) {
                    this.threadPoolInstance.setClearThreadLocals(this.clearThreadLocals);
                }
                if (this.configId == null) {
                    this.configId = ThreadPoolMgrImpl.this.getConfigId((EObject)this.threadPoolConfig);
                }
                final DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this.threadPoolInstance, this.name);
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        ThreadPoolMgrImpl.this.registerMBean("ThreadPool", defaultRuntimeCollaborator, WSUtil.convertToMbeanCompliantString(ThreadPoolProxy.this.name), WSUtil.convertToMbeanCompliantString(ThreadPoolProxy.this.configId), null);
                        return null;
                    }
                });
                this.threadPoolConfig = null;
                ThreadMonitor threadMonitor = (ThreadMonitor)ThreadPoolMgrImpl.this.getService(class$com$ibm$ws$runtime$service$ThreadMonitor == null ? (class$com$ibm$ws$runtime$service$ThreadMonitor = ThreadPoolMgrImpl.class$("com.ibm.ws.runtime.service.ThreadMonitor")) : class$com$ibm$ws$runtime$service$ThreadMonitor);
                this.threadMonitorAdapter = new ThreadPoolMonitorAdapter(this.threadPoolInstance, threadMonitor, this.pmiAdapter);
                ThreadPoolMgrImpl.this.releaseService(threadMonitor);
            }
            return this.threadPoolInstance;
        }
    }

    private static class PmiThreadPoolAdapter
    implements ThreadPoolListener {
        ThreadPoolPerf pmiInterface;

        PmiThreadPoolAdapter() {
        }

        PmiThreadPoolAdapter(ThreadPool threadPool) {
            this.pmiInterface = PmiFactory.createThreadPoolPerf(threadPool.getName(), threadPool.getMinimumPoolSize(), threadPool.getMaximumPoolSize());
        }

        public void threadPoolCreated(ThreadPool threadPool) {
            this.pmiInterface = PmiFactory.createThreadPoolPerf(WSUtil.convertToMbeanCompliantString(threadPool.getName()), threadPool.getMinimumPoolSize(), threadPool.getMaximumPoolSize());
        }

        public void threadCreated(ThreadPool threadPool, int n) {
            if (this.pmiInterface != null) {
                this.pmiInterface.threadCreated(n);
            }
        }

        public void threadStarted(ThreadPool threadPool, int n, int n2) {
            if (this.pmiInterface != null) {
                this.pmiInterface.threadStarted(n2);
            }
        }

        public void threadReturned(ThreadPool threadPool, int n, int n2) {
            if (this.pmiInterface != null) {
                this.pmiInterface.threadReturned(n2);
            }
        }

        public void threadDestroyed(ThreadPool threadPool, int n) {
            if (this.pmiInterface != null) {
                this.pmiInterface.threadDestroyed(n);
            }
        }

        void threadIsHung(String string) {
            if (this.pmiInterface != null) {
                this.pmiInterface.threadHangDetected();
            }
        }

        void threadIsClear(String string, long l) {
            if (this.pmiInterface != null) {
                this.pmiInterface.threadHangCleared(l);
            }
        }

        void monitorStateChanged(boolean bl) {
            if (this.pmiInterface != null) {
                this.pmiInterface.setThreadMonitorServiceEnabled(bl);
            }
        }
    }
}

