/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.LocalTIDTable;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.runtime.component.TransactionServiceMetaData;
import com.ibm.ws.runtime.service.EJBContainer;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TransactionServiceMBean
extends J2EEManagedObjectCollaborator {
    private TraceComponent tc = Tr.register(TransactionServiceMBean.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionServiceMetaData metaData;
    private EJBContainer ejbContainer;
    private static final String SEPARATOR = ", ";

    public TransactionServiceMBean(TransactionServiceMetaData transactionServiceMetaData) {
        this.metaData = transactionServiceMetaData;
    }

    public Integer getTotalTranLifetimeTimeout() {
        return this.metaData.getTotalTranLifetimeTimeout();
    }

    public Integer getAsyncResponseTimeout() {
        return this.metaData.getAsyncResponseTimeout();
    }

    public Boolean getEnableFileLocking() {
        return this.metaData.getEnableFileLocking();
    }

    public Boolean getEnableProtocolSecurity() {
        return this.metaData.getEnableProtocolSecurity();
    }

    public void setTotalTranLifetimeTimeout(Integer n) {
        block4: {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "setTotalTranLifetimeTimeout", n);
            }
            try {
                this.getEJBContainer().setTotalTranLifetimeTimeout(n);
                Configuration.setTotalTransactionTimeout(n);
                this.metaData.setTotalTranLifetimeTimeout(n);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.runtime.component.TransactionServiceMBean.setTotalTranLifetimeTimeout", "93", this);
                if (!this.tc.isEventEnabled()) break block4;
                Tr.event(this.tc, "Failed to get EJBContainer service reference. Could not update timeout");
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "setTotalTranLifetimeTimeout");
        }
    }

    public void setAsyncResponseTimeout(Integer n) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "setAsyncResponseTimeout", n);
        }
        Configuration.setAsyncResponseTimeout(n);
        this.metaData.setAsyncResponseTimeout(n);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "setAsyncResponseTimeout");
        }
    }

    public Integer getClientInactivityTimeout() {
        return this.metaData.getClientInactivityTimeout();
    }

    private EJBContainer getEJBContainer() throws NamingException {
        if (this.ejbContainer == null) {
            if (this.tc.isEventEnabled()) {
                Tr.event(this.tc, "EJB Container reference not initialized. Performing lookup.");
            }
            this.ejbContainer = (EJBContainer)new InitialContext().lookup("services:websphere/EJBContainer");
        }
        return this.ejbContainer;
    }

    public void setClientInactivityTimeout(Integer n) {
        block4: {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "setClientInactivityTimeout", n);
            }
            try {
                this.getEJBContainer().setClientInactivityTimeout(n);
                Configuration.setInactivityTimeout(n);
                this.metaData.setClientInactivityTimeout(n);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.runtime.component.TransactionServiceMBean.setClientInactivityTimeout", "130", this);
                if (!this.tc.isEventEnabled()) break block4;
                Tr.event(this.tc, "Failed to get EJBContainer service reference. Could not update timeout");
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "setClientInactivityTimeout");
        }
    }

    public String getTransactionLogDirectory() {
        return this.metaData.getTransactionLogConfiguration().expandedLogDirectory();
    }

    public Integer getHeuristicRetryLimit() {
        return this.metaData.getHeuristicRetryLimit();
    }

    public Integer getHeuristicRetryWait() {
        return this.metaData.getHeuristicRetryWait();
    }

    public String getHttpProxyPrefix() {
        return this.metaData.getHttpProxyPrefix();
    }

    public String getHttpsProxyPrefix() {
        return this.metaData.getHttpsProxyPrefix();
    }

    public Integer getMaximumTransactionTimeout() {
        return this.metaData.getMaximumTransactionTimeout();
    }

    public void setMaximumTransactionTimeout(Integer n) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "setMaximumTransactionTimeout", n);
        }
        Configuration.setMaximumTransactionTimeout(n);
        this.metaData.setMaximumTransactionTimeout(n);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "setMaximumTransactionTimeout");
        }
    }

    public String getLPSHeuristicCompletion() {
        return this.metaData.getLPSHeuristicCompletion().getName();
    }

    public String printableListOfTransactions() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "printableListOfTransactions");
        }
        String[] stringArray = this.listOfTransactions();
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(stringArray[i]);
        }
        String string = stringBuffer.toString();
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "printableListOfTransactions", string);
        }
        return string;
    }

    public String[] listOfTransactions() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listOfTransactions");
        }
        TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
        String[] stringArray = new String[transactionImplArray.length];
        for (int i = 0; i < transactionImplArray.length; ++i) {
            stringArray[i] = this.getTxAsString(transactionImplArray[i]);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "listOfTransactions", stringArray);
        }
        return stringArray;
    }

    public String[] listImportedPreparedTransactions() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listImportedPreparedTransactions");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
        for (int i = 0; i < transactionImplArray.length; ++i) {
            TransactionImpl transactionImpl = transactionImplArray[i];
            if (!transactionImpl.isImportedAndPrepared()) continue;
            arrayList.add(this.getTxAsString(transactionImpl));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listImportedPreparedTransactions", stringArray);
        }
        return stringArray;
    }

    public String[] listManualTransactions() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listManualTransactions");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
        for (int i = 0; i < transactionImplArray.length; ++i) {
            TransactionImpl transactionImpl = transactionImplArray[i];
            if (!transactionImpl.needsManualCompletion()) continue;
            arrayList.add(this.getTxAsString(transactionImpl));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listManualTransactions", stringArray);
        }
        return stringArray;
    }

    public String[] listRetryTransactions() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listRetryTransactions");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
        for (int i = 0; i < transactionImplArray.length; ++i) {
            TransactionImpl transactionImpl = transactionImplArray[i];
            if (!transactionImpl.requireRetry()) continue;
            arrayList.add(this.getTxAsString(transactionImpl));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listRetryTransactions", stringArray);
        }
        return stringArray;
    }

    public String[] listHeuristicTransactions() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listHeuristicTransactions");
        }
        TransactionImpl[] transactionImplArray = TransactionImpl.listHeuristicallyCompletedTransactions();
        String[] stringArray = new String[transactionImplArray.length];
        for (int i = 0; i < transactionImplArray.length; ++i) {
            stringArray[i] = this.getTxAsString(transactionImplArray[i]);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listHeuristicTransactions", stringArray);
        }
        return stringArray;
    }

    public String[] listSummaryInformation() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "listSummaryInformation");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
        for (int i = 0; i < transactionImplArray.length; ++i) {
            TransactionImpl transactionImpl = transactionImplArray[i];
            if (transactionImpl.needsManualCompletion()) {
                ++n;
            }
            if (transactionImpl.requireRetry()) {
                ++n2;
            }
            if (!transactionImpl.isImportedAndPrepared()) continue;
            ++n3;
        }
        String[] stringArray = new String[]{Integer.toString(transactionImplArray.length), Integer.toString(n), Integer.toString(n2), Integer.toString(TransactionImpl.heuristicTxnsCount()), Integer.toString(n3)};
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "listSummaryInformation", stringArray);
        }
        return stringArray;
    }

    private String getTxAsString(TransactionImpl transactionImpl) {
        String string = Long.toString(transactionImpl.getLocalTID());
        String string2 = Util.toHexString(transactionImpl.getTID()).toUpperCase();
        int n = transactionImpl.getStatus();
        int n2 = transactionImpl.getResources().getHeuristicOutcome();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(SEPARATOR).append(n);
        stringBuffer.append(SEPARATOR).append(string2);
        stringBuffer.append(SEPARATOR).append(n2);
        return stringBuffer.toString();
    }
}

