/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.StrUtils;
import com.ibm.websphere.models.config.applicationserver.LPSHeuristicCompletionKind;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.serverindex.RecoveryLog;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.utils.DirUtils;
import com.ibm.ws.runtime.component.TranLogConfiguration;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.transaction.SystemException;

public final class TransactionServiceMetaData {
    private static final TraceComponent tc = Tr.register(TransactionServiceMetaData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static long minimumLogFileSize = 65536L;
    private static long defaultLogFileSize = 0x100000L;
    private TranLogConfiguration oldTransactionLogConfig;
    private final HashMap transactionLogConfigMap = new HashMap();
    private Integer clientInactivityTimeout;
    private Integer totalTranLifetimeTimeout;
    private Integer asyncResponseTimeout;
    private Boolean enableFileLocking;
    private Boolean enableProtocolSecurity;
    private Integer heuristicRetryLimit;
    private Integer heuristicRetryWait;
    private Integer maximumTransactionTimeout;
    private LPSHeuristicCompletionKind lpsHeuristicCompletion;
    private final WsComponentImpl txServiceImpl;
    private RecoveryDirector recDirector;
    private String httpProxyPrefix;
    private String httpsProxyPrefix;

    public TransactionServiceMetaData(WsComponentImpl wsComponentImpl, TransactionService transactionService) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionServiceMetaData", new Object[]{wsComponentImpl, transactionService});
        }
        try {
            this.recDirector = RecoveryDirectorFactory.recoveryDirector();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TransactionServiceMetaData.TransactionServiceMetaData", "100", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "TransactionServiceMetaData", exception);
            }
            throw new SystemException(exception.toString());
        }
        this.txServiceImpl = wsComponentImpl;
        if (transactionService != null) {
            String string = transactionService.getTransactionLogDirectory();
            if (string != null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Located WAS5 format recovery log configuration setting");
                }
                this.oldTransactionLogConfig = this.expandLogSetting(string, this.recDirector.currentFailureScope());
            }
            this.clientInactivityTimeout = new Integer(transactionService.getClientInactivityTimeout());
            this.totalTranLifetimeTimeout = new Integer(transactionService.getTotalTranLifetimeTimeout());
            this.asyncResponseTimeout = new Integer(transactionService.getAsyncResponseTimeout());
            this.enableFileLocking = transactionService.isEnableFileLocking();
            this.enableProtocolSecurity = transactionService.isEnableProtocolSecurity();
            this.heuristicRetryLimit = new Integer(transactionService.getHeuristicRetryLimit());
            this.heuristicRetryWait = new Integer(transactionService.getHeuristicRetryWait());
            this.maximumTransactionTimeout = new Integer(transactionService.getPropogatedOrBMTTranLifetimeTimeout());
            this.lpsHeuristicCompletion = transactionService.getLPSHeuristicCompletion();
            this.httpProxyPrefix = transactionService.getHttpProxyPrefix();
            this.httpsProxyPrefix = transactionService.getHttpsProxyPrefix();
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            this.enableProtocolSecurity = Boolean.FALSE;
        }
        Tr.exit(tc, "TransactionServiceMetaData");
    }

    public TranLogConfiguration getTransactionLogConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionLogConfiguration");
        }
        TranLogConfiguration tranLogConfiguration = this.resolveTranLogConfiguration(this.recDirector.currentFailureScope());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionLogConfiguration", tranLogConfiguration);
        }
        return tranLogConfiguration;
    }

    public TranLogConfiguration getTransactionLogConfiguration(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionLogConfiguration", failureScope);
        }
        TranLogConfiguration tranLogConfiguration = null;
        tranLogConfiguration = this.oldTransactionLogConfig != null && !this.recDirector.isHAEnabled() && failureScope.equals(this.recDirector.currentFailureScope()) ? this.oldTransactionLogConfig : this.resolveTranLogConfiguration(failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionLogConfiguration", tranLogConfiguration);
        }
        return tranLogConfiguration;
    }

    public Integer getClientInactivityTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientInactivityTimeout");
            Tr.exit(tc, "getClientInactivityTimeout", this.clientInactivityTimeout);
        }
        return this.clientInactivityTimeout;
    }

    public void setClientInactivityTimeout(Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientInactivityTimeout", new Object[]{n, this});
        }
        this.clientInactivityTimeout = n;
        Tr.exit(tc, "setClientInactivityTimeout");
    }

    public Integer getTotalTranLifetimeTimeout() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTotalTranLifetimeTimeout", this.totalTranLifetimeTimeout);
        }
        return this.totalTranLifetimeTimeout;
    }

    public Integer getAsyncResponseTimeout() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAsyncResponseTimeout", this.asyncResponseTimeout);
        }
        return this.asyncResponseTimeout;
    }

    public Boolean getEnableFileLocking() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEnableFileLocking", this.enableFileLocking);
        }
        return this.enableFileLocking;
    }

    public Boolean getEnableProtocolSecurity() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEnableProtocolSecurity", this.enableProtocolSecurity);
        }
        return this.enableProtocolSecurity;
    }

    public void setTotalTranLifetimeTimeout(Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTotalTranLifetimeTimeout", new Object[]{n, this});
        }
        this.totalTranLifetimeTimeout = n;
        Tr.exit(tc, "setTotalTranLifetimeTimeout");
    }

    public void setAsyncResponseTimeout(Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAsyncResponseTimeout", new Object[]{n, this});
        }
        this.asyncResponseTimeout = n;
        Tr.exit(tc, "setAsyncResponseTimeout");
    }

    public Integer getHeuristicRetryLimit() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeuristicRetryLimit", this.heuristicRetryLimit);
        }
        return this.heuristicRetryLimit;
    }

    public Integer getHeuristicRetryWait() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeuristicRetryWait", this.heuristicRetryWait);
        }
        return this.heuristicRetryWait;
    }

    public String getHttpProxyPrefix() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHttpProxyPrefix", this.httpProxyPrefix);
        }
        return this.httpProxyPrefix;
    }

    public String getHttpsProxyPrefix() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHttpsProxyPrefix", this.httpsProxyPrefix);
        }
        return this.httpsProxyPrefix;
    }

    public Integer getMaximumTransactionTimeout() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMaximumTransactionTimeout", this.maximumTransactionTimeout);
        }
        return this.maximumTransactionTimeout;
    }

    public void setMaximumTransactionTimeout(Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaximumTransactionTimeout", new Object[]{n, this});
        }
        this.maximumTransactionTimeout = n;
        Tr.exit(tc, "setMaximumTransactionTimeout");
    }

    public LPSHeuristicCompletionKind getLPSHeuristicCompletion() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLPSHeuristicCompletion", this.lpsHeuristicCompletion);
        }
        return this.lpsHeuristicCompletion;
    }

    private TranLogConfiguration resolveTranLogConfiguration(FailureScope failureScope) {
        TranLogConfiguration tranLogConfiguration;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveTranLogConfiguration", failureScope);
        }
        if ((tranLogConfiguration = (TranLogConfiguration)this.transactionLogConfigMap.get(failureScope)) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Retrieving transaction log configuration for server '" + failureScope.serverName() + "'");
            }
            RecoveryLog recoveryLog = this.recDirector.getRecoveryLogConfiguration(failureScope);
            String string = "";
            if (recoveryLog != null) {
                string = recoveryLog.getTransactionLogDirectory();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resolved transaction log directory '" + string + "'");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No transaction log directory defined. Default will be used");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RLSHA: Using log directory " + string);
            }
            tranLogConfiguration = this.expandLogSetting(string, failureScope);
            this.transactionLogConfigMap.put(failureScope, tranLogConfiguration);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveTranLogConfiguration", tranLogConfiguration);
        }
        return tranLogConfiguration;
    }

    public TranLogConfiguration expandLogSetting(String string, FailureScope failureScope) {
        String string2;
        boolean bl;
        String string3;
        URI uRI;
        TranLogConfiguration tranLogConfiguration;
        String string4;
        block44: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "expandLogSetting", new Object[]{string, failureScope});
            }
            string4 = string;
            tranLogConfiguration = null;
            uRI = null;
            string3 = null;
            bl = false;
            string2 = System.getProperty("os.name");
            if (string != null) {
                try {
                    uRI = new URI(string);
                    string3 = uRI.getScheme();
                }
                catch (Throwable throwable) {
                    if (!PlatformHelperFactory.getPlatformHelper().isZOS() && throwable instanceof URISyntaxException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "URI parse failure, assume non-zOS pathname");
                        }
                    }
                    Tr.warning(tc, "WTRN0116_UNEXPECTED_LOGFILE_SPECIFICATION", new Object[]{string4, failureScope.serverName()});
                    string = null;
                    if (!tc.isEventEnabled()) break block44;
                    Tr.event(tc, "Could not parse the logfile spec into a URI", throwable);
                }
            }
        }
        if (string3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scheme read from URI", string3);
            }
            if (string3.equalsIgnoreCase(new String("logstream")) || string3.equalsIgnoreCase(new String("stream"))) {
                string = uRI.getAuthority();
                if (string != null) {
                    bl = true;
                } else {
                    Tr.warning(tc, "WTRN0116_UNEXPECTED_LOGFILE_SPECIFICATION", new Object[]{string4, failureScope.serverName()});
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "No HLQ was specified for logstream");
                    }
                }
            } else if (string3.equalsIgnoreCase(new String("file")) || string3.equalsIgnoreCase(new String("dir"))) {
                string = uRI.getPath();
            } else if (string2 != null && string2.startsWith("Windows ") && string3.length() == 1) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Take scheme as windows drive letter", string3);
                }
            } else {
                Tr.warning(tc, "WTRN0116_UNEXPECTED_LOGFILE_SPECIFICATION", new Object[]{string4, failureScope.serverName()});
                string = null;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "The scheme was invalid", string3);
                }
            }
        }
        if (bl) {
            if (string == null || string.length() < 1 || string.length() > 8) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Logstream name length is invalid", string);
                }
                Tr.warning(tc, "WTRN0116_UNEXPECTED_LOGFILE_SPECIFICATION", new Object[]{string4, failureScope.serverName()});
                tranLogConfiguration = new TranLogConfiguration();
            } else {
                tranLogConfiguration = new TranLogConfiguration(string);
            }
        } else {
            if (string == null) {
                string = "";
            }
            if (string.equals(";0")) {
                Tr.warning(tc, "WTRN0013_LOGGING_IN_MEMORY");
                tranLogConfiguration = new TranLogConfiguration();
            } else {
                Object object;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                if (string.lastIndexOf(59) == -1) {
                    string5 = string;
                } else {
                    object = StrUtils.split(string, 59);
                    string5 = object[0];
                    string7 = object[1];
                }
                if (string5.equals("")) {
                    object = "$(USER_INSTALL_ROOT)" + File.separator + "tranlog";
                    string5 = (String)object + File.separator + DirUtils.createDirectoryPath(failureScope.serverName()) + File.separator + "transaction";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logFile path before var expand: " + string5);
                }
                try {
                    object = (VariableMap)WsServiceRegistry.getService((Object)this.txServiceImpl, (Class)VariableMap.class);
                    string6 = object.expand(string5);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TransactionServiceMetaData.expandLogSetting", "441", this);
                    Tr.warning(tc, "WTRN0116_UNEXPECTED_LOGFILE_SPECIFICATION", new Object[]{string4, failureScope.serverName()});
                    tranLogConfiguration = new TranLogConfiguration();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "expandLogSetting", tranLogConfiguration);
                    }
                    return tranLogConfiguration;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logFile path after var expand: " + string6);
                }
                long l = defaultLogFileSize;
                if (string7 != null && !string7.equals("")) {
                    string7.trim();
                    try {
                        if (string7.endsWith("M")) {
                            l = Long.parseLong(string7.substring(0, string7.length() - 1));
                            l *= 0x100000L;
                        } else if (string7.endsWith("K")) {
                            l = Long.parseLong(string7.substring(0, string7.length() - 1));
                            l *= 1024L;
                        } else {
                            l = Long.parseLong(string7);
                        }
                        if (l < minimumLogFileSize) {
                            Tr.warning(tc, "WTRN0117_DEFAULT_AND_MINIMUM_LOG_SIZE", new Object[]{string7, failureScope.serverName()});
                            l = defaultLogFileSize;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.runtime.component.TransactionServiceMetaData.expandLogSetting", "514", this);
                        Tr.warning(tc, "WTRN0117_DEFAULT_AND_MINIMUM_LOG_SIZE", new Object[]{string7, failureScope.serverName()});
                    }
                }
                int n = (int)(l / 1024L);
                tranLogConfiguration = new TranLogConfiguration(string5, string6, n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandLogSetting", tranLogConfiguration);
        }
        return tranLogConfiguration;
    }
}

