/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.HTTPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.wsspi.runtime.component.TransportMap;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class TransportMapImpl
extends WsComponentImpl
implements TransportMap {
    private static final TraceComponent tc = Tr.register(TransportMapImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private HashMap virtualHostsPortsMap = null;
    private ArrayList httpPortsList = null;
    private ArrayList sslPortsList = null;
    private static Class type_sslChannel = SSLInboundChannel.class;
    private static Class type_httpChannel = HTTPInboundChannel.class;
    private static Class type_tcpChannel = TCPInboundChannel.class;
    private static Class transportChannelServicetype = TransportChannelService.class;
    private static Class webContainerType = WebContainer.class;
    private static Class applicationServerType = ApplicationServer.class;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        block3: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            try {
                WsServiceRegistry.addService((Object)this, (Class)TransportMap.class);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Failed to register TransportMap: " + exception.toString());
            }
        }
        this.httpPortsList = new ArrayList();
        this.sslPortsList = new ArrayList();
        this.listWebTransports(this.httpPortsList, this.sslPortsList);
        this.virtualHostsPortsMap = new HashMap();
        this.mapVirtualHostsToPorts(this.virtualHostsPortsMap);
    }

    private void listWebTransports(ArrayList arrayList, ArrayList arrayList2) {
        Server server2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listWebTransports");
        }
        if ((server2 = this.getServer()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listWebTransports", "Server resource is null");
            }
            return;
        }
        this.listChannelTransports(server2, arrayList, arrayList2);
        this.listWebContainerTransports(server2, arrayList, arrayList2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listWebTransports");
        }
    }

    private Server getServer() {
        Server server2;
        block2: {
            server2 = null;
            try {
                Repository repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
                Resource resource = repository2.getConfigRoot().getResource(4, "server.xml");
                Server server3 = (Server)resource.getContents().get(0);
                EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
                server2 = (Server)etoolsCopyUtility.copy((EObject)server3);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Failed to load resource server.xml from process: " + exception.toString());
            }
        }
        return server2;
    }

    private void listChannelTransports(Server server2, ArrayList arrayList, ArrayList arrayList2) {
        block24: {
            TransportChannelService transportChannelService;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listChannelTransports", server2);
            }
            if ((transportChannelService = this.getTransportChannelService(server2)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "listChannelTransports", "TransportChannelService is null");
                }
                return;
            }
            EndPointMgr endPointMgr = null;
            try {
                endPointMgr = (EndPointMgr)WsServiceRegistry.getService((Object)this, (Class)EndPointMgr.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (endPointMgr == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "listChannelTransports", "EndPointMgr is null");
                }
                return;
            }
            try {
                EList eList = transportChannelService.getChains();
                if (eList != null && eList.size() > 0) {
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        EList eList2;
                        Chain chain = (Chain)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking at chain: " + chain.getName());
                        }
                        if ((eList2 = chain.getTransportChannels()) == null || eList2.size() <= 0) continue;
                        SSLInboundChannel sSLInboundChannel = null;
                        HTTPInboundChannel hTTPInboundChannel = null;
                        TCPInboundChannel tCPInboundChannel = null;
                        EndPoint endPoint = eList2.iterator();
                        while (endPoint.hasNext()) {
                            object = endPoint.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking at channel: " + ((TransportChannel)object).getName());
                            }
                            if (type_sslChannel.isInstance(object)) {
                                sSLInboundChannel = (SSLInboundChannel)object;
                            }
                            if (type_httpChannel.isInstance(object)) {
                                hTTPInboundChannel = (HTTPInboundChannel)object;
                            }
                            if (!type_tcpChannel.isInstance(object)) continue;
                            tCPInboundChannel = (TCPInboundChannel)object;
                        }
                        if (hTTPInboundChannel == null || tCPInboundChannel == null) continue;
                        if (sSLInboundChannel != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SSL endpoint: " + tCPInboundChannel.getEndPointName());
                            }
                            if ((endPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(tCPInboundChannel.getEndPointName())) == null) continue;
                            object = new Integer(endPoint.getPort());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SSL port: " + object);
                            }
                            arrayList2.add(object);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found HTTP endpoint: " + tCPInboundChannel.getEndPointName());
                        }
                        if ((endPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(tCPInboundChannel.getEndPointName())) == null) continue;
                        object = new Integer(endPoint.getPort());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found HTTP port: " + object);
                        }
                        arrayList.add(object);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No chains found in TransportChannelService in server.xml.");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block24;
                Tr.debug(tc, "Exception getting channel framework transports: ", new Object[]{exception.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listChannelTransports", server2);
        }
    }

    private TransportChannelService getTransportChannelService(Server server2) {
        EList eList = server2.getServices();
        Object var3_3 = null;
        if (eList != null && eList.size() > 0) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                var3_3 = iterator.next();
                if (!transportChannelServicetype.isInstance(var3_3)) continue;
                return var3_3;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TransportChannelService not found in server: " + server2);
        }
        return null;
    }

    public void listWebContainerTransports(Server server2, ArrayList arrayList, ArrayList arrayList2) {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listWebContainerTransports", server2);
        }
        if ((list = this.getWebContainerTransports(server2)) == null || list.size() <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listWebContainerTransports", "HTTP transports is null");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HTTPTransport hTTPTransport = (HTTPTransport)iterator.next();
            if (hTTPTransport == null) continue;
            EndPoint endPoint = hTTPTransport.getAddress();
            if (endPoint != null) {
                Integer n = new Integer(endPoint.getPort());
                if (hTTPTransport.isSslEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found SSL port: " + n);
                    }
                    arrayList2.add(n);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found HTTP port: " + n);
                }
                arrayList.add(n);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "HTTP transport endpoint is null: " + hTTPTransport);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listWebContainerTransports");
        }
    }

    private List getWebContainerTransports(Server server2) {
        WebContainer webContainer = this.getWebContainer(server2);
        if (webContainer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebContainerTransports", "WebContainer is null in server: " + server2);
            }
            return null;
        }
        EList eList = webContainer.getTransports();
        if (eList == null || eList.size() <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebContainerTransports", "HTTP Transports is null in WebContainer: " + webContainer);
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebContainerTransports", eList);
        }
        return eList;
    }

    private WebContainer getWebContainer(Server server2) {
        ApplicationServer applicationServer = this.getApplicationServer(server2);
        if (applicationServer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebContainer", "ApplicationServer is null in server: " + server2);
            }
            return null;
        }
        EList eList = applicationServer.getComponents();
        if (eList != null && eList.size() > 0) {
            Object var4_4 = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                var4_4 = iterator.next();
                if (!webContainerType.isInstance(var4_4)) continue;
                return var4_4;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebContainer not found in ApplicationServer: " + applicationServer);
        }
        return null;
    }

    private ApplicationServer getApplicationServer(Server server2) {
        EList eList = server2.getComponents();
        if (eList != null && eList.size() > 0) {
            Object var3_3 = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                var3_3 = iterator.next();
                if (!applicationServerType.isInstance(var3_3)) continue;
                return var3_3;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebContainer not found in Server: " + server2);
        }
        return null;
    }

    private void mapVirtualHostsToPorts(HashMap hashMap) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "mapVirtualHostsToPorts");
            }
            VirtualHostMgr virtualHostMgr = null;
            try {
                virtualHostMgr = (VirtualHostMgr)WsServiceRegistry.getService((Object)this, (Class)VirtualHostMgr.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (virtualHostMgr == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapVirtualHostsToPorts", "VirtualHostMgr is null");
                }
                return;
            }
            try {
                VirtualHost virtualHost = null;
                VirtualHost[] virtualHostArray = virtualHostMgr.getVirtualHosts();
                for (int i = 0; i < virtualHostArray.length; ++i) {
                    virtualHost = virtualHostArray[i];
                    String string = virtualHost.getName();
                    Alias[] aliasArray = virtualHost.getAliases();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int j = 0; j < aliasArray.length; ++j) {
                        Alias alias = aliasArray[j];
                        String string2 = alias.getPort();
                        arrayList.add(string2);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Adding port " + string2 + " to vHost " + string);
                    }
                    hashMap.put(string, arrayList.clone());
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "An exception occurred composing vHostMap: " + exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapVirtualHostsToPorts");
        }
    }

    public int getHttpsPort(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHttpsPort: " + new Integer(n));
        }
        int n2 = this.getPort(n, this.sslPortsList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHttpsPort", new Integer(n2));
        }
        return n2;
    }

    public int getHttpPort(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHttpPort: " + new Integer(n));
        }
        int n2 = this.getPort(n, this.httpPortsList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHttpPort", new Integer(n2));
        }
        return n2;
    }

    private int getPort(int n, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPort", new Object[]{new Integer(n), arrayList});
        }
        ArrayList arrayList2 = null;
        String string = null;
        int n2 = -1;
        Iterator iterator = this.virtualHostsPortsMap.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            arrayList2 = (ArrayList)this.virtualHostsPortsMap.get(string);
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                String string2 = (String)arrayList2.get(i);
                if (tc.isDebugEnabled() && string2 != null) {
                    Tr.debug(tc, "Port " + string2 + " in virtual host " + string);
                }
                n2 = -1;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (string2 == null || n2 != n) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found domainPort " + string2 + " in virtual host " + string);
                }
                for (int j = arrayList.size() - 1; j >= 0; --j) {
                    Integer n3 = (Integer)arrayList.get(j);
                    if (n3 == null) continue;
                    int n4 = n3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking if port " + n4 + " is in the same virtual host.");
                    }
                    for (int k = arrayList2.size() - 1; k >= 0; --k) {
                        String string3 = (String)arrayList2.get(k);
                        n2 = -1;
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (string3 != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Port " + string3 + " in virtual host " + string);
                        }
                        if (string3 == null || n2 != n4) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.exit(tc, "getPort", "Found range port " + n4 + " in virtual host " + string);
                        }
                        return n4;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPort");
        }
        return -1;
    }
}

