/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.csi.TransactionControlImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.tran.SyncDriverFactory;
import com.ibm.websphere.csi.UOWControl;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.LPSHeuristicCompletionKind;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.RecoveryLog;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.Transaction.JTA.EpochFailureScope;
import com.ibm.ws.Transaction.JTA.EpochFailureScopeFactory;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxExecutionContextHandler;
import com.ibm.ws.Transaction.JTA.TxMetaDataListener;
import com.ibm.ws.Transaction.JTA.UtxJNDIFactory;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.CurrentImpl;
import com.ibm.ws.Transaction.JTS.TransactionDiagnosticModule;
import com.ibm.ws.Transaction.JTS.TransactionWorkloadRegulator;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.Transaction.test.XAFlowCallbackControl;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATSOAPRequestMonitor;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.RALifeCycleManagerFactory;
import com.ibm.ws.j2c.work.WorkManagerServiceFactory;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.ScalableFailureScope;
import com.ibm.ws.recoverylog.spi.StreamLogProperties;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import com.ibm.ws.runtime.component.TranLogConfiguration;
import com.ibm.ws.runtime.component.TransactionMBean;
import com.ibm.ws.runtime.component.TransactionServiceMBean;
import com.ibm.ws.runtime.component.TransactionServiceMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.TxService;
import com.ibm.ws.runtime.service.WLM;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.runtime.workloadcontroller.WorkloadRegulator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.wccm.services.pme.metadata.MetaDataHelperService;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.NativeTransactionContext;
import com.ibm.ws390.tx.TranAttributeCollector;
import com.ibm.ws390.tx.TransactionHARecoveryAlarm;
import com.ibm.ws390.tx.TransactionResolver;
import com.ibm.ws390.wscoor.WSCoorSoapRequestMonitor;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.SystemException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public final class TxServiceImpl
extends WsComponentImpl
implements TxService,
RecoveryAgent {
    private static TraceComponent tc = Tr.register(TxServiceImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int TRANSACTION_RECOVERYLOG_FORMAT_VERSION = 1;
    private static final String SNAPSHOT_SAFE_NAME = "SNAPSHOT_SAFE";
    private boolean _isSnapshotSafe;
    private static final String DISABLE_FILE_LOCKING_NAME = "DISABLE_FILE_LOCKING";
    private static final String DISABLE_PROTOCOL_SECURITY = "DISABLE_PROTOCOL_SECURITY";
    private static final String DISABLE_ISSAMERM = "DISABLE_ISSAMERM_OPTIMIZATION";
    private boolean _disableIsSameRM;
    private static final String WSTX_SECURE_TRANSPORT_CHAIN = "WSTX_SECURE_TRANSPORT_CHAIN";
    private static final String DISABLE_WSTX_DEFERRED_REGISTRATION = "DISABLE_WSTX_DEFERRED_REGISTRATION";
    private static final String DISABLE_WSTX_RMFAIL_LOGGING = "DISABLE_WSTX_RMFAIL_LOGGING";
    private boolean _disableRmfailLogging = false;
    private static final String ACCEPT_HEURISTIC_HAZARD = "ACCEPT_HEURISTIC_HAZARD";
    private boolean _acceptHeuristicHazard = false;
    private static final String DISABLE_WSTX_HEURISTICS = "DISABLE_WSTX_HEURISTICS";
    private static final String GRACE_PERIOD_NAME = new String("DISABLE_TRANSACTION_TIMEOUT_GRACE_PERIOD");
    private static final String SHAREABLE_LTC_NAME = "ENABLE_SHAREABLE_LTC";
    private WebSphereTransactionManager txService;
    private SyncDriverFactory sdFactory;
    private TransactionServiceMetaData metaData;
    private TransactionService txServiceConfig;
    private final HashMap failureScopeControllerTable = new HashMap();
    private static final int transactionLogRLI = 1;
    private static final int partnerLogRLI = 2;
    private ThreadPool _defaultThreadPool;
    private boolean isZOS;
    private boolean peerRestartMode;
    private ApplicationMgr _applicationManager;
    private MetaDataService _metaDataService;
    private MetaDataHelperService _metaDataHelperService;
    private PlatformHelper _helper;
    private static boolean _disableFileLocking;
    private static final String CLUSTER_XML = "cluster.xml";
    private static final String SERVERINDEX_XML = "serverindex.xml";

    public boolean isPeerRestartMode() {
        return this.peerRestartMode;
    }

    private TransactionService lookupTranService() throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupTranService");
        }
        TransactionService transactionService = null;
        Repository repository2 = null;
        try {
            java.lang.Object e2;
            repository2 = (Repository)WsServiceRegistry.getService((java.lang.Object)this, (Class)Repository.class);
            com.ibm.websphere.models.config.process.Server server2 = (com.ibm.websphere.models.config.process.Server)repository2.getConfigRoot().getResource(4, "server.xml").getContents().get(0);
            EList eList = server2.getComponents();
            ApplicationServer applicationServer = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                e2 = iterator.next();
                if (!(e2 instanceof ApplicationServer)) continue;
                applicationServer = (ApplicationServer)e2;
            }
            if (applicationServer == null) {
                throw new ConfigurationError("No ApplicationServer defined");
            }
            eList = applicationServer.getServices();
            iterator = eList.iterator();
            while (iterator.hasNext()) {
                e2 = iterator.next();
                if (!(e2 instanceof TransactionService)) continue;
                transactionService = (TransactionService)e2;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.runtime.component.TxServiceImpl.lookupTranService", "259", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Could not lookup tranService in config", throwable);
            }
            throw new ConfigurationError(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupTranService", transactionService);
        }
        return transactionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHAConfigurationValid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHAConfigurationValid");
        }
        HashMap hashMap = new HashMap();
        boolean bl = true;
        try {
            Repository repository2 = (Repository)WsServiceRegistry.getService((java.lang.Object)this, (Class)Repository.class);
            String string = repository2.getClusterName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localClustername = " + string);
            }
            if (string != null) {
                String string2 = repository2.getCellName();
                ConfigRoot configRoot = repository2.getConfigRoot();
                this.gatherServerConfig(configRoot, string2, hashMap);
                bl = this.validateClusterConfig(configRoot, string2, string, hashMap);
                return bl;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getService() threw an exception: " + exception);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isHAConfigurationValid", new Boolean(bl));
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherServerConfig(ConfigRoot configRoot, String string, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processServerConfig", new java.lang.Object[]{configRoot});
        }
        String string2 = configRoot.getValue(3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Preserving current NODE identity '" + string2 + "'");
        }
        try {
            Resource resource = null;
            String[] stringArray = configRoot.list(3, null);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        configRoot.setValue(3, stringArray[i]);
                        resource = configRoot.getResource(3, SERVERINDEX_XML);
                        EList eList = ((ServerIndex)resource.getContents().get(0)).getServerEntries();
                        for (int j = 0; j < eList.size(); ++j) {
                            ServerEntry serverEntry = (ServerEntry)eList.get(j);
                            String string3 = this.FQHAMCompatibleServerName(string, stringArray[i], serverEntry.getServerName());
                            RecoveryLog recoveryLog = serverEntry.getRecoveryLog();
                            if (recoveryLog != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "transactionLogDirectory for " + string3 + ": " + recoveryLog.getTransactionLogDirectory());
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "transactionLogDirectory unavailable for " + string3);
                            }
                            hashMap.put(string3, recoveryLog);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "While processing " + stringArray[i] + " caught the following exception " + exception);
                    }
                }
            }
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Restoring previous NODE identity '" + string2 + "'");
            }
            configRoot.setValue(3, string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processServerConfig");
            }
        }
    }

    private String FQHAMCompatibleServerName(String string, String string2, String string3) {
        return string + "\\" + string2 + "\\" + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateClusterConfig(ConfigRoot configRoot, String string, String string2, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClusterConfig", new java.lang.Object[]{configRoot, string, string2, hashMap});
        }
        String string3 = configRoot.getValue(2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Preserved original cluster setting of '" + string3 + "'");
        }
        int n = 1;
        try {
            int n2;
            Resource resource = null;
            String[] stringArray = configRoot.list(2, null);
            if (stringArray != null) {
                boolean bl = false;
                for (n2 = 0; n2 < stringArray.length && !bl; ++n2) {
                    try {
                        configRoot.setValue(2, stringArray[n2]);
                        resource = configRoot.getResource(2, CLUSTER_XML);
                        ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
                        String string4 = serverCluster.getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cluster = " + string4);
                        }
                        if (!string4.equals(string2)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking cluster configuration for cluster " + string4);
                        }
                        bl = true;
                        if (serverCluster.isSetEnableHA() && serverCluster.isEnableHA()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cluster is HAEnabled");
                            }
                            Iterator iterator = serverCluster.getMembers().iterator();
                            while (iterator.hasNext()) {
                                RecoveryLog recoveryLog;
                                ClusterMember clusterMember = (ClusterMember)iterator.next();
                                String string5 = clusterMember.getMemberName();
                                String string6 = clusterMember.getNodeName();
                                String string7 = this.FQHAMCompatibleServerName(string, string6, string5);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "processing " + string7);
                                }
                                if ((recoveryLog = (RecoveryLog)hashMap.get(string7)) != null) {
                                    String string8 = recoveryLog.getTransactionLogDirectory();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "transactionLogDirectory = " + string8);
                                    }
                                    if (!";0".equals(string8)) continue;
                                    String string9 = "HA enabled cluster " + string4 + " contains server " + string7 + " defined with a transaction log directory specification of ;0 which is invalid";
                                    Tr.warning(tc, "WTRN0100_GENERIC_ERROR", string9);
                                    n = 0;
                                    continue;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "No recovery log configuration available");
                            }
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Cluster is not HAEnabled");
                        continue;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "While processing " + stringArray[n2] + " caught the following exception " + exception);
                    }
                }
            }
            n2 = n;
            return n2 != 0;
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Restoring previous cluster setting of '" + string3 + "'");
            }
            configRoot.setValue(2, string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateClusterConfig", new Boolean(n != 0));
            }
        }
    }

    public void initialize(java.lang.Object object) throws ConfigurationError {
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        LPSHeuristicCompletionKind lPSHeuristicCompletionKind;
        Server server2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = adminService.getProcessType();
        this._helper = PlatformHelperFactory.getPlatformHelper();
        this.isZOS = this._helper.isZOS();
        boolean bl = false;
        if (string.equals("NodeAgent")) {
            if (this.isZOS) {
                try {
                    ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
                    controllerTransactionManagerSet.restartWithRRS();
                }
                catch (Throwable throwable) {
                    throw new ConfigurationError(throwable);
                }
            }
            this.txServiceConfig = null;
            return;
        }
        Configuration.setTxServiceImpl(this);
        try {
            server2 = (Server)WsServiceRegistry.getService((java.lang.Object)this, (Class)Server.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.initialize", "399", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", exception);
            }
            throw new ConfigurationError(exception);
        }
        server2.registerRecoveryCollaborator(this);
        if (server2.getServerMode() == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server starting in RECOVERY_MODE");
            }
            RecoveryManager.recoveryOnlyMode = true;
        }
        if (!this.isHAConfigurationValid()) {
            Tr.warning(tc, "WTRN0100_GENERIC_ERROR", "Invalid HA Configuration detected - server will terminate");
            throw new ConfigurationError("Invalid HA Configuration detected - server will terminate");
        }
        if (object instanceof TransactionService) {
            this.txServiceConfig = (TransactionService)object;
        } else {
            if (!this._helper.isControlJvm()) {
                this.peerRestartMode = true;
            }
            this.txServiceConfig = this.lookupTranService();
        }
        EList eList = this.txServiceConfig.getProperties();
        if (eList != null && !eList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Located transaction service custom properties. Examining");
            }
            lPSHeuristicCompletionKind = eList.iterator();
            while (lPSHeuristicCompletionKind.hasNext()) {
                try {
                    object4 = (Property)lPSHeuristicCompletionKind.next();
                    if (object4 == null) continue;
                    String string2 = object4.getName();
                    object3 = object4.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property name is " + string2);
                        Tr.debug(tc, "Property value is " + (String)object3);
                    }
                    if (SNAPSHOT_SAFE_NAME.equalsIgnoreCase(string2)) {
                        this._isSnapshotSafe = new Boolean((String)object3);
                        continue;
                    }
                    if ("AUTH_FAILURE_MESSAGE_INTERVAL".equalsIgnoreCase(string2)) continue;
                    if (DISABLE_ISSAMERM.equalsIgnoreCase(string2)) {
                        this._disableIsSameRM = new Boolean((String)object3);
                        continue;
                    }
                    if (StreamLogProperties.COMPRESS_INTERVAL_NAME.equalsIgnoreCase(string2)) continue;
                    if (DISABLE_WSTX_DEFERRED_REGISTRATION.equalsIgnoreCase(string2)) {
                        if (!new Boolean((String)object3).booleanValue()) continue;
                        WSATControlSet.disableDeferredRegistration();
                        continue;
                    }
                    if (DISABLE_WSTX_RMFAIL_LOGGING.equalsIgnoreCase(string2)) {
                        this._disableRmfailLogging = new Boolean((String)object3);
                        continue;
                    }
                    if (ACCEPT_HEURISTIC_HAZARD.equalsIgnoreCase(string2)) {
                        this._acceptHeuristicHazard = new Boolean((String)object3);
                        continue;
                    }
                    if (DISABLE_FILE_LOCKING_NAME.equalsIgnoreCase(string2)) {
                        Tr.warning(tc, "WTRN0118_DEPRECATED_CUSTOM_PROPERTY", string2);
                        this.txServiceConfig.setEnableFileLocking(new Boolean((String)object3) == false);
                        continue;
                    }
                    if (DISABLE_PROTOCOL_SECURITY.equalsIgnoreCase(string2)) {
                        Tr.warning(tc, "WTRN0118_DEPRECATED_CUSTOM_PROPERTY", string2);
                        this.txServiceConfig.setEnableProtocolSecurity(new Boolean((String)object3) == false);
                        continue;
                    }
                    if (GRACE_PERIOD_NAME.equalsIgnoreCase(string2)) {
                        bl = Boolean.valueOf((String)object3);
                        continue;
                    }
                    if (WSTX_SECURE_TRANSPORT_CHAIN.equalsIgnoreCase(string2)) {
                        ServiceHelper.setSecureTransportChain((String)object3);
                        continue;
                    }
                    if (SHAREABLE_LTC_NAME.equalsIgnoreCase(string2)) {
                        TxProperties.SHAREABLE_LTC = true;
                        continue;
                    }
                    if (DISABLE_WSTX_HEURISTICS.equalsIgnoreCase(string2)) {
                        WSATControlSet.setHeuristicsSupport(new Boolean((String)object3) == false);
                        continue;
                    }
                    Tr.warning(tc, "WTRN0110_BAD_CUSTOM_PROPERTY", string2);
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unable to decode transaction service custom property. Check the format", throwable);
                }
            }
        }
        TransactionImpl.LPSLoggingEnabled = this.txServiceConfig.isEnableLoggingForHeuristicReporting();
        TransactionImpl.heuristicRetryLimit = this.txServiceConfig.getHeuristicRetryLimit();
        TransactionImpl.heuristicRetryWait = this.txServiceConfig.getHeuristicRetryWait();
        ServiceHelper.setHttpProxyPrefix(this.txServiceConfig.getHttpProxyPrefix());
        ServiceHelper.setHttpsProxyPrefix(this.txServiceConfig.getHttpsProxyPrefix());
        lPSHeuristicCompletionKind = this.txServiceConfig.getLPSHeuristicCompletion();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lpsHeuristicCompletion", lPSHeuristicCompletionKind);
        }
        if (lPSHeuristicCompletionKind == LPSHeuristicCompletionKind.COMMIT_LITERAL) {
            TransactionImpl.lpsHeuristicCompletion = 1;
        } else if (lPSHeuristicCompletionKind == LPSHeuristicCompletionKind.MANUAL_LITERAL) {
            TransactionImpl.lpsHeuristicCompletion = 2;
        }
        Configuration.setAsyncResponseTimeout(this.txServiceConfig.getAsyncResponseTimeout());
        _disableFileLocking = !this.txServiceConfig.isEnableFileLocking();
        System.setProperty("com.ibm.ejs.jts.processType", "server");
        if (this.isZOS) {
            System.setProperty("com.ibm.db2.java.TMClassName", "com.ibm.ws390.tx.rrs.RRSConnectorTxManager");
            System.setProperty("com.ibm.ws390.jta.TransactionManager", "com.ibm.ws390.tx.rrs.RRSConnectorTxManager");
            try {
                object4 = System.getProperty("com.ibm.vm.bitmode");
                int n = Integer.parseInt((String)object4);
                if (n == 64) {
                    System.loadLibrary("bbgtots");
                } else {
                    System.loadLibrary("bbotots");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                FFDCFilter.processException((Throwable)unsatisfiedLinkError, "com.ibm.ws.runtime.component.TxServiceImpl.initialize", "338", this);
                Tr.debug(tc, "Unable to load native library", unsatisfiedLinkError);
            }
            if (this._helper.isControlJvm()) {
                try {
                    object4 = ControllerTransactionManagerSet.instance();
                    ((ControllerTransactionManagerSet)object4).restartWithRRS();
                }
                catch (Throwable throwable) {
                    throw new ConfigurationError(throwable);
                }
                WSCoorSoapRequestMonitor.setWSRequestMonitor(new WSATSOAPRequestMonitor());
            } else if (this._helper.isServantJvm() && !string.equals("DeploymentManager")) {
                ServiceHelper.setSRPortData(NativeTransactionContext.getWsTxPortData());
            }
            Configuration.setMaximumTransactionTimeout(NativeServerInstanceData.getMaximumTransactionTimeout());
            Configuration.setTotalTransactionTimeout(NativeServerInstanceData.getDefaultTransactionTimeout());
            if (bl) {
                TransactionResolver.disableGracePeriod();
            }
        } else {
            Configuration.setMaximumTransactionTimeout(this.txServiceConfig.getPropogatedOrBMTTranLifetimeTimeout());
            Configuration.setTotalTransactionTimeout(this.txServiceConfig.getTotalTranLifetimeTimeout());
        }
        Configuration.setInactivityTimeout(this.txServiceConfig.getClientInactivityTimeout());
        try {
            WsServiceRegistry.addService((java.lang.Object)this, (Class)TxService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.initialize", "551", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", exception);
            }
            throw new ConfigurationError(exception);
        }
        object4 = ExtClassLoader.getInstance();
        Configuration.setClassLoader((ExtClassLoader)object4);
        if (tc.isDebugEnabled()) {
            ClassLoader classLoader;
            Tr.debug(tc, "This class classloader", this.getClass().getClassLoader());
            Tr.debug(tc, "System classloader", ClassLoader.getSystemClassLoader());
            Tr.debug(tc, "java.class.path", System.getProperty("java.class.path"));
            Tr.debug(tc, "Gateway extclassloader", object4);
            Tr.debug(tc, "Current thread context classloader", classLoader);
            Tr.debug(tc, "Walk the extclassloader stack");
            for (classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
                if (classLoader instanceof ExtClassLoader) {
                    object3 = (ExtClassLoader)classLoader;
                    RecoveryManager.traceDebugClassPath(tc, "ExtClassLoader Classpath:", object3.getClassPath());
                } else if (classLoader instanceof URLClassLoader) {
                    object3 = (URLClassLoader)classLoader;
                    URL[] uRLArray = ((URLClassLoader)object3).getURLs();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        try {
                            File file = new File(uRLArray[i].getFile());
                            stringBuffer.append(file.getCanonicalPath());
                            stringBuffer.append(File.pathSeparator);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    RecoveryManager.traceDebugClassPath(tc, "URLClassLoader Classpath:", stringBuffer.toString());
                }
                Tr.debug(tc, "Parent classloader", classLoader);
            }
        }
        TransactionDiagnosticModule.instance().registerWithFFDCService();
        try {
            object2 = WorkManagerServiceFactory.getWorkManagerService();
            object2.register(new TxExecutionContextHandler());
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Registered TxExecutionContextHandler");
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.runtime.component.TxServiceImpl.initialize", "403", this);
            if (tc.isEventEnabled()) {
                Tr.error(tc, "WTRN0001_ERR_INT_ERROR", runtimeException);
            }
            throw new ConfigurationError(runtimeException);
        }
        object2 = null;
        try {
            object2 = (ClusterMemberService)WsServiceRegistry.getService((java.lang.Object)this, (Class)ClusterMemberService.class);
            Configuration.setClusterMemberService((ClusterMemberService)object2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.initialize", "664", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", exception);
            }
            throw new ConfigurationError(exception);
        }
        ProtocolSecurityHelper.initialize(this.txServiceConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        java.lang.Object object;
        java.lang.Object object2;
        java.lang.Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            this.metaData = new TransactionServiceMetaData(this, this.txServiceConfig);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.runtime.component.TxServiceImpl.start", "428", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Error encountered accessing TransactionServiceMetaData: ", (java.lang.Object)systemException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
            throw new RuntimeError(systemException);
        }
        this.registerWithRecoveryDirector();
        this.accessOrbService();
        String string = this.getCompoundServerName();
        Configuration.setServerName(string);
        try {
            object3 = RecoveryDirectorFactory.recoveryDirector().currentFailureScope();
            object2 = new FailureScopeController((FailureScope)object3);
            this.failureScopeControllerTable.put(object3.serverName(), object2);
            Configuration.setFailureScopeController((FailureScopeController)object2);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.runtime.component.TxServiceImpl.start", "457", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to create a failure scope controller for the home server: ", internalLogException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
            throw new RuntimeError(internalLogException);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.runtime.component.TxServiceImpl.start", "464", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to create a failure scope controller for the home server: ", (java.lang.Object)systemException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
            throw new RuntimeError(systemException);
        }
        if (this.isZOS) {
            Configuration.setApplId(NativeTransactionContext.getServerUUID());
            this.initializeZOSLogging();
        } else {
            Configuration.setApplId(this.createApplicationId(string));
        }
        this.txService = TransactionManagerFactory.getTransactionManager();
        XAFlowCallbackControl.initialize();
        this.sdFactory = new SyncDriverFactory();
        PmiFactory.createTransactionPerf(this.txService);
        if (!this.isZOS) {
            this.registerWithWLM();
        }
        if (!this.isZOS || !this._helper.isControlJvm()) {
            this.activateMBeans();
        }
        if (!(!"ManagedProcess".equals(object2 = (object3 = AdminServiceFactory.getAdminService()).getProcessType()) && !"UnManagedProcess".equals(object2) || this.isZOS && this.isPeerRestartMode())) {
            this.exportUserTx();
        }
        if (!(this.isZOS && this._helper.isControlJvm() || this.isPeerRestartMode())) {
            try {
                this._metaDataService = (MetaDataService)WsServiceRegistry.getService((java.lang.Object)this, (Class)MetaDataService.class);
                this._metaDataHelperService = (MetaDataHelperService)WsServiceRegistry.getService((java.lang.Object)this, (Class)MetaDataHelperService.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.start", "794", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", exception);
                }
                throw new RuntimeError(exception);
            }
            TxMetaDataListener.instance().start(this._metaDataService, this._metaDataHelperService);
            if (this.isZOS) {
                this._metaDataService.addMetaDataListener(new TranAttributeCollector());
            }
        }
        this.txServiceConfig = null;
        if (!this.isZOS) {
            object = new TransactionWorkloadRegulator();
            WorkloadController.registerRegulator((WorkloadRegulator)object);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "TransactionWorkloadRegulator registered");
            }
        }
        if (!this.isZOS) {
            try {
                this._applicationManager = (ApplicationMgr)WsServiceRegistry.getService((java.lang.Object)this, (Class)ApplicationMgr.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.start", "856", this);
                RuntimeError runtimeError = new RuntimeError("ApplicationMgr unavailable");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", runtimeError);
                }
                throw runtimeError;
            }
            if (this._applicationManager != null) {
                this._applicationManager.waitForService(TxServiceImpl.class);
            } else {
                object = new RuntimeError("ApplicationMgr unavailable");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", object);
                }
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stop");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (!this.isZOS) {
            boolean bl = true;
            if (this.txService != null) {
                bl = ((TranManagerSet)this.txService).isReplayComplete() && !((TranManagerSet)this.txService).isQuiesced();
            }
            Collection collection = this.failureScopeControllerTable.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FailureScopeController failureScopeController = (FailureScopeController)iterator.next();
                failureScopeController.shutdown(bl);
            }
        } else if (this._helper.isControlJvm()) {
            ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
            controllerTransactionManagerSet.shutdown();
        }
        this.txService = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public ThreadPool getThreadPool() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool");
        }
        if (this._defaultThreadPool == null) {
            ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)WsServiceRegistry.getService((java.lang.Object)this, (Class)ThreadPoolMgr.class);
            this._defaultThreadPool = threadPoolMgr.getThreadPool("Default");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool", this._defaultThreadPool);
        }
        return this._defaultThreadPool;
    }

    public SyncDriverFactory getSyncDriverFactory() {
        return this.sdFactory;
    }

    public UOWControl createTransactionControl() {
        return new TransactionControlImpl(this.txService, this.sdFactory, this.metaData.getTotalTranLifetimeTimeout(), this.metaData.getClientInactivityTimeout() * 1000);
    }

    void exportUserTx() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportUserTx");
        }
        try {
            InitialContext initialContext = new InitialContext();
            Reference reference = new Reference(java.lang.Object.class.getName(), UtxJNDIFactory.class.getName(), null);
            JndiHelper.recursiveRebind((Context)initialContext, "jta/usertransaction", (java.lang.Object)reference);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.runtime.component.TxServiceImpl.exportUserTx", "234", this);
            RuntimeError runtimeError = new RuntimeError("Failed to bind UtxFactory into JNDI", namingException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportUserTx", runtimeError);
            }
            throw runtimeError;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportUserTx");
        }
    }

    void registerWithRecoveryDirector() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerWithRecoveryDirector");
        }
        try {
            RecoveryLogManager recoveryLogManager = RecoveryDirectorFactory.recoveryDirector().registerService(this, 2);
            Configuration.setLogManager(recoveryLogManager);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.registerWithRecoveryDirector", "410", this);
            RuntimeException runtimeException = new RuntimeException("Failed to register with RecoveryDirector", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerWithRecoveryDirector", runtimeException);
            }
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerWithRecoveryDirector");
        }
    }

    void activateMBeans() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBeans");
        }
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        TransactionMBean transactionMBean = new TransactionMBean();
        TransactionServiceMBean transactionServiceMBean = new TransactionServiceMBean(this.metaData);
        try {
            mBeanFactory.activateMBean("TransactionService", transactionServiceMBean, mBeanFactory.getConfigId(this.txServiceConfig), null);
            mBeanFactory.activateMBean("Transaction", transactionMBean, "Transaction", null);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.runtime.component.TxServiceImpl.activateMBeans", "446", this);
            Tr.warning(tc, "WTRN0109_MBEAN_ACTIVATE", adminException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateMBeans");
        }
    }

    private void registerWithWLM() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerWithWLM");
        }
        try {
            WsServiceRegistry.getService((java.lang.Object)this, (Class)WLM.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.registerWithWLM", "249", this);
            RuntimeError runtimeError = new RuntimeError("Failed to set WLM Affinity Manager", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerWithWLM", runtimeError);
            }
            throw runtimeError;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerWithWLM");
        }
    }

    private void accessOrbService() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "accessOrbService");
        }
        com.ibm.ws.runtime.service.ORB oRB = null;
        try {
            oRB = (com.ibm.ws.runtime.service.ORB)WsServiceRegistry.getService((java.lang.Object)this, (Class)com.ibm.ws.runtime.service.ORB.class);
            if (oRB == null) {
                throw new NullPointerException();
            }
            Configuration.setORB((ORB)oRB.getORB());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.accessOrbService", "649", this);
            RuntimeError runtimeError = new RuntimeError("TransactionService requires ORB service", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "accessOrbService", runtimeError);
            }
            throw runtimeError;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "accessOrbService");
        }
    }

    private void initializeZOSLogging() throws RuntimeError {
        java.lang.Object object;
        java.lang.Object object2;
        boolean bl;
        FailureScopeController failureScopeController;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeZOSLogging");
        }
        if ((failureScopeController = Configuration.getFailureScopeController()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeZOSLogging", "No failure scope controller for local failure scope");
            }
            throw new RuntimeError("No local failure scope controller");
        }
        TranLogConfiguration tranLogConfiguration = null;
        try {
            tranLogConfiguration = this.metaData.getTransactionLogConfiguration(RecoveryDirectorFactory.recoveryDirector().currentFailureScope());
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.runtime.component.TxServiceImpl.initializeZOSLogging", "847", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeZOSLogging", "No configuration for local failure scope");
            }
            throw new RuntimeError("No configuration available for local failure scope");
        }
        if (this._helper.isCRAJvm() && (bl = Boolean.getBoolean("com.ibm.ws.Transaction.JTA.disableCRArecovery"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CRA running without partner log");
            }
            tranLogConfiguration = null;
        }
        LogProperties logProperties = null;
        if (tranLogConfiguration != null) {
            if (tranLogConfiguration.type() == 1) {
                logProperties = new StreamLogProperties(2, "partnerlog", tranLogConfiguration.streamName());
            } else if (tranLogConfiguration.type() == 2) {
                logProperties = new FileLogProperties(2, "partnerlog", tranLogConfiguration.expandedLogDirectory() + File.separator + "partnerlog", tranLogConfiguration.logFileSize());
            }
        }
        byte[] byArray = Configuration.getApplId();
        int n = NativeServerInstanceData.getRestartEpoch();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Trace ApplID", byArray);
            Tr.debug(tc, "Trace Epoch", new Integer(n));
        }
        com.ibm.ws.recoverylog.spi.RecoveryLog recoveryLog = null;
        com.ibm.ws.recoverylog.spi.RecoveryLog recoveryLog2 = null;
        if (logProperties != null) {
            FailureScopeManager.registerFailureScopeFactory(FailureScopeFactory.EPOCH_FAILURE_SCOPE_ID, EpochFailureScope.class, new EpochFailureScopeFactory());
            object2 = Configuration.getServerName();
            object = new EpochFailureScope(n, false, (String)object2);
            EpochFailureScope epochFailureScope = new EpochFailureScope(n, true, (String)object2);
            RecoveryLogManager recoveryLogManager = Configuration.getLogManager();
            try {
                recoveryLog = recoveryLogManager.getRecoveryLog((FailureScope)object, logProperties);
                recoveryLog2 = recoveryLogManager.getRecoveryLog(epochFailureScope, logProperties);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".initializeZOSLogging", "586", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Could not create Partner Log", exception);
                }
                throw new RuntimeException(exception);
            }
        }
        object2 = failureScopeController.createRecoveryManager(null, null, recoveryLog, recoveryLog2, byArray, n);
        if (this._helper.isControlJvm()) {
            try {
                object = ControllerTransactionManagerSet.instance();
                ((ControllerTransactionManagerSet)object).resync((RecoveryManager)object2);
            }
            catch (Throwable throwable) {
                throw new RuntimeError(throwable);
            }
        } else {
            ((RecoveryManager)object2).runWithEnq();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeZOSLogging");
        }
    }

    private String getCompoundServerName() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompoundServerName");
        }
        String string = null;
        Server server2 = null;
        try {
            server2 = (Server)WsServiceRegistry.getService((java.lang.Object)this, (Class)Server.class);
            String string2 = server2.getName();
            if (string2 == null || string2.equals("")) {
                throw new ConfigurationError("TxServiceImpl serverName was not set by superclass");
            }
            string = server2.getCellName() + "\\" + server2.getNodeName() + "\\" + string2;
        }
        catch (ConfigurationError configurationError) {
            FFDCFilter.processException((Throwable)configurationError, "com.ibm.ws.runtime.component.TxServiceImpl.getCompoundServerName", "1041", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught exception during recovery log initialization", configurationError);
            }
            throw new RuntimeError(configurationError);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.getCompoundServerName", "1335", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompoundServerName", "RuntimeError");
            }
            throw new RuntimeError(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompoundServerName", string);
        }
        return string;
    }

    public void prepareForRecovery(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareForRecovery", failureScope);
            Tr.exit(tc, "prepareForRecovery");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initiateRecovery(FailureScope failureScope) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initiateRecovery", failureScope);
        }
        boolean bl = RecoveryManager.recoveryOnlyMode;
        try {
            block45: {
                block43: {
                    void var11_24;
                    byte[] byArray;
                    RecoveryManager recoveryManager;
                    block47: {
                        block46: {
                            int n;
                            byte[] byArray2;
                            FailureScopeController failureScopeController;
                            TranLogConfiguration tranLogConfiguration;
                            block44: {
                                String string = failureScope.serverName();
                                boolean bl2 = string.equals(Configuration.getServerName());
                                if (this.isZOS && this._helper.isServantJvm() || this.isZOS && bl2) break block43;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Recovery initiated for server '" + string + "'");
                                }
                                tranLogConfiguration = this.metaData.getTransactionLogConfiguration(failureScope);
                                failureScopeController = (FailureScopeController)this.failureScopeControllerTable.get(string);
                                if (failureScopeController != null) {
                                    if (failureScopeController.getRecoveryManager() != null) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "initiateRecovery", "already recovering failure scope " + failureScope);
                                        }
                                        throw new RecoveryFailedException();
                                    }
                                } else {
                                    try {
                                        failureScopeController = new FailureScopeController(failureScope);
                                    }
                                    catch (SystemException systemException) {
                                        FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", "1177", this);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception caught whist creating FailureScopeController", (java.lang.Object)systemException);
                                        }
                                        throw new RecoveryFailedException(systemException);
                                    }
                                    this.failureScopeControllerTable.put(string, failureScopeController);
                                }
                                byArray2 = null;
                                n = 0;
                                if (this.isZOS) break block44;
                                if (bl2) {
                                    byArray2 = Configuration.getApplId();
                                    n = Configuration.getCurrentEpoch();
                                }
                                com.ibm.ws.recoverylog.spi.RecoveryLog recoveryLog = null;
                                com.ibm.ws.recoverylog.spi.RecoveryLog recoveryLog2 = null;
                                if (tranLogConfiguration != null && tranLogConfiguration.enabled()) {
                                    FileLogProperties fileLogProperties = new FileLogProperties(1, "tranlog", tranLogConfiguration.expandedLogDirectory() + File.separator + "tranlog", tranLogConfiguration.logFileSize());
                                    FileLogProperties fileLogProperties2 = new FileLogProperties(2, "partnerlog", tranLogConfiguration.expandedLogDirectory() + File.separator + "partnerlog", tranLogConfiguration.logFileSize());
                                    RecoveryLogManager recoveryLogManager = Configuration.getLogManager();
                                    recoveryLog = recoveryLogManager.getRecoveryLog(failureScope, fileLogProperties);
                                    recoveryLog2 = recoveryLogManager.getRecoveryLog(failureScope, fileLogProperties2);
                                }
                                RecoveryManager recoveryManager2 = failureScopeController.createRecoveryManager(this, recoveryLog, recoveryLog2, null, byArray2, n);
                                this.getThreadPool().executeOnDaemon(recoveryManager2);
                                bl = false;
                                break block45;
                            }
                            if (!(failureScope instanceof ScalableFailureScope)) {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Bad failure scope.");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "initiateRecovery");
                                }
                                throw new RecoveryFailedException();
                            }
                            recoveryManager = failureScopeController.createRecoveryManager(this, null, null, null, byArray2, n);
                            byArray = FailureScopeManager.toByteArray(failureScope);
                            java.lang.Object var11_21 = null;
                            if (tranLogConfiguration == null) break block46;
                            if (tranLogConfiguration.type() == 1) {
                                StreamLogProperties streamLogProperties = new StreamLogProperties(2, "partnerlog", tranLogConfiguration.streamName());
                                break block47;
                            } else if (tranLogConfiguration.type() == 2) {
                                FileLogProperties fileLogProperties = new FileLogProperties(2, "partnerlog", tranLogConfiguration.expandedLogDirectory() + File.separator + "partnerlog", tranLogConfiguration.logFileSize());
                            }
                            break block47;
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Null log configuration");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "initiateRecovery");
                        }
                        throw new RecoveryFailedException();
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(var11_24);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    String string = ((ScalableFailureScope)failureScope).uuid();
                    String string2 = ((ScalableFailureScope)failureScope).serverShortName();
                    if (string == null || string2 == null) {
                        if (string == null && tc.isEventEnabled()) {
                            Tr.event(tc, "Null server string UUID.");
                        } else if (tc.isEventEnabled()) {
                            Tr.event(tc, "Null server string name.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "initiateRecovery");
                        }
                        throw new RecoveryFailedException();
                    }
                    TransactionHARecoveryAlarm.startRecovery(byArray, byArray3, string2, string, recoveryManager);
                    break block45;
                }
                if (this.isZOS && this._helper.isControlJvm() && failureScope != null && failureScope instanceof ScalableFailureScope) {
                    ScalableFailureScope scalableFailureScope = (ScalableFailureScope)failureScope;
                    byte[] byArray = scalableFailureScope.stoken();
                    if (byArray != null) {
                        if (byArray.length == 8) {
                            try {
                                ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
                                controllerTransactionManagerSet.startServantRecovery(byArray);
                            }
                            catch (Throwable throwable) {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "initiateRecovery RecoveryFailedException", new java.lang.Object[]{byArray, throwable});
                                }
                                throw new RecoveryFailedException(throwable);
                            }
                        } else {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "InitiateRecovery RecoveryFailedException", new java.lang.Object[]{byArray, new Integer(byArray.length)});
                            }
                            throw new RecoveryFailedException();
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.event(tc, "CR local recovery. Nothing to do.");
                    }
                    RecoveryDirectorFactory.recoveryDirector().initialRecoveryComplete(this, failureScope);
                } else {
                    RecoveryDirectorFactory.recoveryDirector().initialRecoveryComplete(this, failureScope);
                }
            }
            RecoveryDirectorFactory.recoveryDirector().serialRecoveryComplete(this, failureScope);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", "1599", this);
            Tr.error(tc, "WTRN0016_EXC_DURING_RECOVERY", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initiateRecovery", exception);
            }
            throw new RecoveryFailedException();
        }
        finally {
            if (bl) {
                this.recoveryComplete();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initiateRecovery");
        }
    }

    public void terminateRecovery(FailureScope failureScope) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateRecovery", failureScope);
        }
        String string = failureScope.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The transaction service has received a request to terminate recovery processing for server " + string);
        }
        RecoveryDirector recoveryDirector = null;
        try {
            recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.runtime.component.TxServiceImpl.terminateRecovery", "1274", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "terminateRecovery");
            }
            throw new TerminationFailedException(internalLogException);
        }
        boolean bl = string.equals(Configuration.getServerName());
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received unexpected request to terminate recovery processing for local failure scope");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "terminateRecovery");
            }
            throw new TerminationFailedException();
        }
        FailureScopeController failureScopeController = (FailureScopeController)this.failureScopeControllerTable.remove(string);
        if (failureScopeController != null) {
            failureScopeController.shutdown(false);
        }
        try {
            recoveryDirector.terminationComplete(this, failureScope);
        }
        catch (InvalidFailureScopeException invalidFailureScopeException) {
            FFDCFilter.processException((Throwable)invalidFailureScopeException, "com.ibm.ws.runtime.component.TxServiceImpl.terminateRecovery", "1308", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to indicate termination completion to recovery director: " + invalidFailureScopeException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "terminateRecovery");
            }
            throw new TerminationFailedException(invalidFailureScopeException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateRecovery");
        }
    }

    public int clientIdentifier() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clientIdentifier", new Integer(1));
        }
        return 1;
    }

    public String clientName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clientName", "transaction");
        }
        return "transaction";
    }

    public int clientVersion() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clientVersion", new Integer(1));
        }
        return 1;
    }

    public void recoveryComplete() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "recoveryComplete");
            }
            if (!this.isZOS) {
                try {
                    Server server2 = (Server)WsServiceRegistry.getService((java.lang.Object)this, (Class)Server.class);
                    server2.recoveryCollaboratorComplete(this);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.TxServiceImpl.recoveryComplete", "1747", this);
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "recoveryComplete", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryComplete");
        }
    }

    private byte[] createApplicationId(String string) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationId", string);
        }
        try {
            String string2 = Configuration.getORB().object_to_string((Object)CurrentImpl.instance());
            string2 = string2 + string + System.currentTimeMillis();
            byArray = MessageDigest.getInstance("SHA").digest(Util.byteArray(string2));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.runtime.component.TxServiceImpl.createApplicationId", "608", this);
            byArray = Util.byteArray("j" + System.currentTimeMillis() % 9997L + ":" + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationId", Util.toHexString(byArray));
        }
        return byArray;
    }

    public String[] logDirectories(FailureScope failureScope) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logDirectories", failureScope);
        }
        String[] stringArray = null;
        TranLogConfiguration tranLogConfiguration = this.metaData.getTransactionLogConfiguration(failureScope);
        if (tranLogConfiguration != null && (string = tranLogConfiguration.expandedLogDirectory()) != null) {
            stringArray = new String[]{string};
        }
        if (stringArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "logDirectories", "null");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logDirectories", stringArray[0]);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchRecoveryProcessingComplete(Throwable throwable) {
        if (this._applicationManager != null) {
            try {
                RuntimeError runtimeError = null;
                if (throwable != null) {
                    runtimeError = new RuntimeError(throwable);
                }
                this._applicationManager.serviceIsReady(TxServiceImpl.class, runtimeError);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Asynch recovery processing complete: runtime notified", runtimeError);
                }
            }
            finally {
                this._applicationManager = null;
            }
        }
    }

    public void agentReportedFailure(int n, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "agentReportedFailure", new java.lang.Object[]{new Integer(n), failureScope});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "agentReportedFailure");
        }
    }

    public boolean disableFileLocking() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableFileLocking");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableFileLocking", new Boolean(_disableFileLocking));
        }
        return _disableFileLocking;
    }

    public boolean isSnapshotSafe() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSnapshotSafe");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSnapshotSafe", new Boolean(this._isSnapshotSafe));
        }
        return this._isSnapshotSafe;
    }

    public static java.lang.Object runAsSystemOrSpecified(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runAsSystemOrSpecified", privilegedExceptionAction);
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        try {
            java.lang.Object object = contextManager.runAsSystemOrSpecified(privilegedExceptionAction);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runAsSystemOrSpecified", object);
            }
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof PrivilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nested PrivilegedActionException", privilegedActionException);
                }
                PrivilegedActionException privilegedActionException2 = (PrivilegedActionException)privilegedActionException.getCause();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "runAsSystemOrSpecified", privilegedActionException2);
                }
                throw privilegedActionException2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runAsSystemOrSpecified", privilegedActionException);
            }
            throw privilegedActionException;
        }
    }

    public static java.lang.Object runAsSystem(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runAsSystem", privilegedExceptionAction);
        }
        final PrivilegedExceptionAction privilegedExceptionAction2 = privilegedExceptionAction;
        try {
            java.lang.Object object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public java.lang.Object run() throws PrivilegedActionException {
                    return SecurityContext.runAsSystem(privilegedExceptionAction2);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runAsSystem", object);
            }
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof PrivilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nested PrivilegedActionException", privilegedActionException);
                }
                PrivilegedActionException privilegedActionException2 = (PrivilegedActionException)privilegedActionException.getCause();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "runAsSystem", privilegedActionException2);
                }
                throw privilegedActionException2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runAsSystem", privilegedActionException);
            }
            throw privilegedActionException;
        }
    }

    public static boolean isProviderInstalled(String string) {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isProviderInstalled", string);
            }
            final String string2 = string;
            bl = true;
            try {
                if (string2 != null) {
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            return new Boolean(RALifeCycleManagerFactory.getInstance().isProviderInstalled(string2));
                        }
                    };
                    bl = (Boolean)TxServiceImpl.runAsSystem(privilegedExceptionAction);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ws.runtime.component.TxServiceImpl.isProviderInstalled", "2012");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "PrivilegedActionException", privilegedActionException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProviderInstalled", new Boolean(bl));
        }
        return bl;
    }

    public boolean disableIsSameRM() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableIsSameRM", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableIsSameRM", new Boolean(this._disableIsSameRM));
        }
        return this._disableIsSameRM;
    }

    public boolean disableRmfailLogging() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableRmfailLogging", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableRmfailLogging", new Boolean(this._disableRmfailLogging));
        }
        return this._disableRmfailLogging;
    }

    public boolean acceptHeuristicHazard() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptHeuristicHazard", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "acceptHeuristicHazard", new Boolean(this._acceptHeuristicHazard));
        }
        return this._acceptHeuristicHazard;
    }

    public void logFileWarning(String string, int n, int n2) {
        Tr.info(tc, "WTRN0122_LOG_FREE_SPACE", new java.lang.Object[]{string, n, n2});
    }
}

