/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.config.ResourceLocator;
import com.ibm.ws.runtime.config.ResourceLocatorImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class VariableMapImpl
extends ComponentImpl
implements com.ibm.ws.runtime.service.VariableMap {
    private static TraceComponent tc = Tr.register(VariableMapImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    public static final String VARIABLE_CONFIG = "variables.xml";
    static final String EXTERNAL_MAP = "was.variable.map";
    private Map variables;
    protected ResourceLocator varMapLocator = new ResourceLocatorImpl("variables.xml");
    private long lastAccessTime = 0L;
    private Repository preConfiguredRepository = null;
    private static boolean isRegisteredAsService = false;

    public VariableMapImpl() {
        this.register();
    }

    public VariableMapImpl(Map map) {
        this.variables = map;
        this.register();
    }

    public VariableMapImpl(Repository repository2) {
        this.preConfiguredRepository = repository2;
    }

    private void register() {
        if (!isRegisteredAsService) {
            try {
                WsServiceRegistry.addService((Object)this, (Class)com.ibm.ws.runtime.service.VariableMap.class);
                isRegisteredAsService = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, VariableMapImpl.class.getName(), "69", this);
            }
        }
    }

    private Repository getRepositoryService() throws Exception {
        if (this.preConfiguredRepository == null) {
            return (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
        }
        return this.preConfiguredRepository;
    }

    public void initialize(Object object) {
        this.register();
        this.reload(false);
    }

    public synchronized boolean refresh() {
        return this.reload(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reload(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reload", new Boolean(bl));
        }
        long l = System.currentTimeMillis();
        try {
            boolean bl2;
            Repository repository2 = this.getRepositoryService();
            ConfigRoot configRoot = repository2.getConfigRoot();
            String string = repository2.getClusterName();
            boolean bl3 = string != null && string.length() != 0;
            boolean bl4 = bl2 = !bl;
            if (bl) {
                bl2 = this.varMapLocator.isResourceUpdated(this.lastAccessTime, configRoot, 0);
                bl2 |= this.varMapLocator.isResourceUpdated(this.lastAccessTime, configRoot, 3);
                bl2 |= bl3 && this.varMapLocator.isResourceUpdated(this.lastAccessTime, configRoot, 2);
                bl2 |= this.varMapLocator.isResourceUpdated(this.lastAccessTime, configRoot, 4);
            }
            if (this.variables == null) {
                bl2 = true;
            }
            if (!bl2) {
                boolean bl5 = false;
                return bl5;
            }
            this.lastAccessTime = l;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(13);
            VariableMapImpl.addVariableMap(this.varMapLocator.getResource(configRoot, 0), hashMap);
            VariableMapImpl.addVariableMap(this.varMapLocator.getResource(configRoot, 3), hashMap);
            if (bl3) {
                VariableMapImpl.addVariableMap(this.varMapLocator.getResource(configRoot, 2), hashMap);
            }
            VariableMapImpl.addVariableMap(this.varMapLocator.getResource(configRoot, 4), hashMap);
            hashMap.put("CELL", repository2.getCellName());
            hashMap.put("NODE", repository2.getNodeName());
            hashMap.put("CLUSTER", repository2.getClusterName());
            hashMap.put("SERVER", repository2.getServerName());
            String string2 = System.getProperty(EXTERNAL_MAP);
            FileInputStream fileInputStream = null;
            try {
                if (string2 != null) {
                    Properties properties = new Properties();
                    fileInputStream = new FileInputStream(string2);
                    properties.load(fileInputStream);
                    hashMap.putAll(properties);
                }
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " not found", iOException);
                }
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.variables = hashMap;
            boolean bl6 = true;
            return bl6;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, VariableMapImpl.class.getName(), "144", this);
            boolean bl7 = false;
            return bl7;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reload", this.variables);
            }
        }
    }

    public void addVariableMap(Resource resource) {
        VariableMapImpl.addVariableMap(resource, this.variables);
    }

    public Object addVariable(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addVariable", new Object[]{string, string2});
        }
        return this.variables.put(string, string2);
    }

    protected static void addVariableMap(Resource resource, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addVariableMap", new Object[]{resource, map});
        }
        if (resource == null) {
            return;
        }
        EList eList = resource.getContents();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            VariableMap variableMap = (VariableMap)eList.get(i);
            EList eList2 = variableMap.getEntries();
            int n2 = eList2.size();
            for (int j = 0; j < n2; ++j) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)eList2.get(j);
                map.put(variableSubstitutionEntry.getSymbolicName(), variableSubstitutionEntry.getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addVariableMap", map);
        }
    }

    public String expand(String string) throws IllegalArgumentException {
        try {
            return VariableMapImpl.substitute(string, this.variables);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, illegalArgumentException.toString());
                illegalArgumentException.printStackTrace();
            }
            throw illegalArgumentException;
        }
    }

    static void append(StringBuffer stringBuffer, String string, int n, int n2) {
        if (n2 < 0) {
            n2 = string.length() - n;
        }
        stringBuffer.ensureCapacity(stringBuffer.length() + n2);
        stringBuffer.append(string.substring(n, n2 += n));
    }

    /*
     * Unable to fully structure code
     */
    static String expand(String var0, int var1_1, int var2_2, Map var3_3, Map var4_4) throws IllegalArgumentException {
        var5_5 = new StringBuffer();
        block4: for (var7_6 = var1_1; var7_6 < var2_2; ++var7_6) {
            var6_7 = var0.indexOf(36, var7_6);
            VariableMapImpl.append(var5_5, var0, var7_6, var6_7 - var7_6);
            if (var6_7 == -1) break;
            var7_6 = var6_7 + 1;
            if (var7_6 >= var2_2) continue;
            switch (var0.charAt(var7_6)) {
                case '$': {
                    var5_5.append('$');
                    continue block4;
                }
                case '(': 
                case '{': {
                    var8_8 = var0.charAt(var7_6);
                    var9_9 = var8_8 == '(' ? ')' : '}';
                    var10_10 = var7_6 + 1;
                    var11_11 = var0.indexOf(var9_9, var10_10);
                    if (var11_11 == -1) {
                        Tr.error(VariableMapImpl.tc, "WSVR0242E", var0);
                        throw new IllegalArgumentException("unterminated variable reference when parsing '" + var0 + '\'');
                    }
                    var7_6 = VariableMapImpl.indexOf(var0, '$', var10_10, var11_11);
                    if (var7_6 == -1) ** GOTO lbl35
                    var10_10 = var7_6 + 1;
                    var12_12 = 0;
                    var13_13 = var0.length();
                    for (var7_6 = var10_10; var7_6 < var13_13; ++var7_6) {
                        var14_14 = var0.charAt(var7_6);
                        if (var14_14 == var8_8) {
                            ++var12_12;
                            continue;
                        }
                        if (var14_14 != var9_9 || --var12_12 >= 0) {
                            continue;
                        }
                        ** GOTO lbl36
                    }
                    ** GOTO lbl36
lbl35:
                    // 1 sources

                    var7_6 = var11_11;
lbl36:
                    // 3 sources

                    VariableMapImpl.referenceVariable(var5_5, var0, var10_10, var11_11 - var10_10, var3_3, var4_4);
                    continue block4;
                }
                default: {
                    var8_8 = var0.charAt(var7_6);
                    if (Character.isWhitespace(var8_8)) continue block4;
                    VariableMapImpl.referenceVariable(var5_5, var0, var7_6, 1, var3_3, var4_4);
                }
            }
        }
        return var5_5.toString();
    }

    static String expand(String string, Map map, Map map2) throws IllegalArgumentException {
        return VariableMapImpl.expand(string, 0, string.length(), map, map2);
    }

    void expandIt(String string, Map map) {
        try {
            System.out.println(string + " ---> " + VariableMapImpl.substitute(string, map));
        }
        catch (Throwable throwable) {
            System.out.println(string + " failed");
            throwable.printStackTrace();
        }
    }

    static int indexOf(String string, char c, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    static String recursivelyExpand(String string, Map map, Map map2) throws IllegalArgumentException {
        if (map2.get(string) != null) {
            Tr.error(tc, "WSVR0243E", string);
            throw new IllegalArgumentException("Recursive variable: " + string);
        }
        map2.put(string, string);
        String string2 = (String)map.get(string);
        if (string2 == null) {
            string2 = "";
        }
        String string3 = VariableMapImpl.expand(string2, map, map2);
        map2.remove(string);
        return string3;
    }

    static void referenceVariable(StringBuffer stringBuffer, String string, int n, int n2, Map map, Map map2) throws IllegalArgumentException {
        String string2 = string.substring(n, n + n2);
        if (!map.containsKey(string2)) {
            throw new IllegalArgumentException("undefined variable: " + string2);
        }
        String string3 = VariableMapImpl.recursivelyExpand(string2, map, map2);
        stringBuffer.append(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String substitute(String string, Map map) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "substitute", new Object[]{string, map});
        }
        String string2 = null;
        try {
            if (string != null) {
                string2 = VariableMapImpl.expand(string, 0, string.length(), map, new HashMap());
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "substitute", string2);
            }
        }
        return string2;
    }
}

