/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.wsbytebufferservice.WSByteBufferService;
import com.ibm.ws.buffermgmt.impl.WsBBConfigException;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.channel.common.PlatformConstants;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.WSBBPoolListener;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.objectpool.TwoTierObjectPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class WsByteBufferPoolManagerServiceImpl
extends WsComponentImpl
implements WsByteBufferPoolManager {
    private static final TraceComponent tc = Tr.register(WsByteBufferPoolManagerServiceImpl.class, "WSByteBufferService", "com.ibm.ws.tcp.channel.resources.wsbytebuffermessages");
    private static String managerName = System.getProperty("com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl");
    private static String defaultzOSManagerName = "com.ibm.ws.buffermgmt.impl.ZOSWsByteBufferPoolManagerImpl";
    public static final String CLEAN_UP = "cleanUp";
    protected Context _context;
    protected WsByteBufferPoolManager _delegate = null;
    protected boolean _started;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        WSByteBufferService wSByteBufferService = this.getConfig();
        if (wSByteBufferService != null && null != (eList = wSByteBufferService.getProperties())) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                hashMap.put(property.getName(), property.getValue());
            }
        }
        try {
            if (!PlatformConstants.isZOS) {
                this._delegate = new WsByteBufferPoolManagerImpl(hashMap);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configured pool manager class: ", managerName);
                }
                if (managerName != null) {
                    this._delegate = this.instantiateManagerClass(managerName, hashMap);
                }
                if (this._delegate == null && managerName != defaultzOSManagerName) {
                    this._delegate = this.instantiateManagerClass(defaultzOSManagerName, hashMap);
                }
                if (this._delegate == null) {
                    this._delegate = new WsByteBufferPoolManagerImpl(hashMap);
                }
            }
        }
        catch (WsBBConfigException wsBBConfigException) {
            throw new ConfigurationError("WsByteBuffer has not been configured correctly", wsBBConfigException);
        }
        try {
            WsServiceRegistry.addService((Object)this, (Class)WsByteBufferPoolManager.class);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName() + ".initialize", "159");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception adding service to registry; " + throwable);
            }
            throw new ComponentDisabledException(throwable);
        }
        this.checkPoolListener();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    protected void checkPoolListener() {
        block4: {
            try {
                ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)WsServiceRegistry.getService((Object)this, (Class)ThreadPoolMgr.class);
                if (null != threadPoolMgr && null != TwoTierObjectPool.class.getMethod("purgeThreadLocal", null)) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Adding thread pool listener");
                    }
                    threadPoolMgr.addThreadPoolListener(new WSBBPoolListener((WsByteBufferPoolManagerImpl)this._delegate));
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Error configuring the thread pool listener code; " + throwable);
            }
        }
    }

    private final WsByteBufferPoolManagerImpl instantiateManagerClass(String string, HashMap hashMap) throws WsBBConfigException {
        WsByteBufferPoolManagerImpl wsByteBufferPoolManagerImpl;
        block12: {
            Object object;
            Class<?> clazz = null;
            wsByteBufferPoolManagerImpl = null;
            try {
                object = Thread.currentThread().getContextClassLoader();
                if (object != null) {
                    clazz = ((ClassLoader)object).loadClass(string);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class load failed using context class loader", exception);
                }
                try {
                    clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception exception2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Class load failed using Class.forName", exception2);
                    }
                    clazz = null;
                }
            }
            if (clazz != null) {
                try {
                    hashMap.put(CLEAN_UP, "true");
                    object = clazz.getConstructor(Map.class);
                    wsByteBufferPoolManagerImpl = (WsByteBufferPoolManagerImpl)((Constructor)object).newInstance(hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using custom pool manager: " + managerName);
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The creation of a new instance of class " + clazz + "failed", exception);
                    }
                    if (!(exception instanceof WsBBConfigException)) break block12;
                    throw (WsBBConfigException)((Object)exception);
                }
            }
        }
        return wsByteBufferPoolManagerImpl;
    }

    public void start() throws RuntimeError, RuntimeWarning {
    }

    public void stop() {
        this._started = false;
    }

    public void destroy() {
    }

    public WsByteBuffer allocate(int n) {
        return this._delegate.allocate(n);
    }

    public WsByteBuffer allocateDirect(int n) {
        return this._delegate.allocateDirect(n);
    }

    public WsByteBuffer wrap(byte[] byArray) {
        return this._delegate.wrap(byArray);
    }

    public WsByteBuffer wrap(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException {
        return this._delegate.wrap(byArray, n, n2);
    }

    public WsByteBuffer duplicate(WsByteBuffer wsByteBuffer) {
        return this._delegate.duplicate(wsByteBuffer);
    }

    public WsByteBuffer slice(WsByteBuffer wsByteBuffer) {
        return this._delegate.slice(wsByteBuffer);
    }

    private WSByteBufferService getConfig() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConfig");
            }
            try {
                Repository repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
                if (repository2 != null) {
                    Resource resource = repository2.getConfigRoot().getResource(4, "server.xml");
                    Iterator iterator = resource.getContents().iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        if (!(e2 instanceof Server)) continue;
                        Server server2 = (Server)e2;
                        Iterator iterator2 = server2.getServices().iterator();
                        while (iterator2.hasNext()) {
                            e2 = iterator2.next();
                            if (!(e2 instanceof WSByteBufferService)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found WSByteBufferService Configuration Data");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getConfig");
                            }
                            return (WSByteBufferService)e2;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Caught Exception will processing configuration data" + exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not find WSByteBufferService Configuration Data");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfig");
        }
        return null;
    }

    public WsByteBuffer wrap(ByteBuffer byteBuffer) {
        return this._delegate.wrap(byteBuffer);
    }
}

