/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.env.EnvPackage;
import com.ibm.ejs.models.base.resources.env.Referenceable;
import com.ibm.ejs.models.base.resources.env.ResourceEnvEntry;
import com.ibm.ejs.models.base.resources.env.ResourceEnvironmentProvider;
import com.ibm.ws.runtime.component.binder.ResourceBinderImpl;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.security.util.PasswordUtil;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

public class ResourceEnvBinder
extends ResourceBinderImpl {
    EClass resourceEnvEntryClass;

    public ResourceEnvBinder() {
        EnvPackage envPackage = (EnvPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.env.xmi");
        this.resourceEnvEntryClass = envPackage.getResourceEnvEntry();
    }

    public boolean isUsedFor(J2EEResourceFactory j2EEResourceFactory) {
        return j2EEResourceFactory.eClass().equals(this.resourceEnvEntryClass);
    }

    public String getNamePrefix() {
        return "";
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        ResourceEnvEntry resourceEnvEntry = (ResourceEnvEntry)j2EEResourceFactory;
        ResourceEnvironmentProvider resourceEnvironmentProvider = (ResourceEnvironmentProvider)resourceEnvEntry.getProvider();
        Referenceable referenceable = resourceEnvEntry.getReferenceable();
        this.checkRequiredProperty(referenceable, "Invalid Configuration! The Resource: " + j2EEResourceFactory.getName() + " has a null Referenceable property.");
        String string = referenceable.getFactoryClassname();
        this.checkRequiredProperty(string, "Invalid Configuration! The Resource: " + j2EEResourceFactory.getName() + " has a null FactoryClassname property.");
        String string2 = referenceable.getClassname();
        this.checkRequiredProperty(string2, "Invalid Configuration! The Resource: " + j2EEResourceFactory.getName() + " has a null Classname property.");
        Reference reference = new Reference(string2, string, null);
        this.addPropertySet(j2EEResourceFactory, j2EEResourceFactory.getPropertySet(), reference);
        this.addPropertySet(j2EEResourceFactory, resourceEnvironmentProvider.getPropertySet(), reference);
        return reference;
    }

    public void addPropertySet(J2EEResourceFactory j2EEResourceFactory, J2EEResourcePropertySet j2EEResourcePropertySet, Reference reference) throws ResourceBindingException {
        if (j2EEResourcePropertySet != null) {
            EList eList = j2EEResourcePropertySet.getResourceProperties();
            for (int i = 0; i < eList.size(); ++i) {
                J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)eList.get(i);
                if (j2EEResourceProperty == null) continue;
                String string = j2EEResourceProperty.getName();
                String string2 = j2EEResourceProperty.getValue();
                if (string == null || string2 == null) continue;
                if (string.indexOf("password") != -1 || string.indexOf("Password") != -1) {
                    string2 = PasswordUtil.passwordDecode(string2);
                } else {
                    try {
                        string2 = this.expandVariable(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ResourceBindingException(j2EEResourceFactory, "Failed to expand variable, " + string2, illegalArgumentException);
                    }
                }
                reference.add(new StringRefAddr(string, string2));
            }
        }
    }

    public void activateProviderMBean(J2EEResourceProvider j2EEResourceProvider, String string) {
    }
}

