/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.collaborator;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.j2ee.J2EEDeployedObjectProxy;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public class J2EEApplication
extends J2EEDeployedObjectProxy
implements NotificationListener {
    static final String WEB_MODULE = "WebModule";
    static final String EJB_MODULE = "EJBModule";
    static final String RESOURCE_ADAPTER_MODULE = "ResourceAdapterModule";
    static final String J2EE_SERVER = "J2EEServer";
    static final String J2EE_APPLICATION = "J2EEApplication";
    static final String J2EE_TYPE = "j2eeType";
    static final String NAME = "name";
    private ObjectName appMgr;
    private ObjectName appQueryName;
    private String earPath = null;
    private String ddUri = null;

    public J2EEApplication(String string, String string2) {
        this(string, string2, 3);
    }

    public J2EEApplication(String string, String string2, int n) {
        super(string + File.separator + string2, n);
        this.earPath = string;
        this.ddUri = string2;
    }

    public void mbeanActivated() {
        super.mbeanActivated();
        this.addNotificationListener();
    }

    private void addNotificationListener() {
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("j2ee.state");
        AdminServiceFactory.getAdminService().addNotificationListenerExtended(this.getWebSphereMBeanQueryName(), this, notificationFilterSupport, null);
    }

    public String[] getModules() {
        if (this.getJ2EEState() == 1) {
            return this.getModulesWhenRunning();
        }
        return this.getModulesWhenStopped();
    }

    private String[] getModulesWhenRunning() {
        StringBuffer stringBuffer = new StringBuffer("WebSphere:J2EEApplication=");
        stringBuffer.append(this.getObjectName().getKeyProperty(NAME));
        stringBuffer.append(",*,type=");
        int n = stringBuffer.length();
        stringBuffer.append(WEB_MODULE);
        String[] stringArray = this.getObjectNames(stringBuffer.toString());
        stringBuffer.setLength(n);
        stringBuffer.append(EJB_MODULE);
        String[] stringArray2 = this.getObjectNames(stringBuffer.toString());
        stringBuffer.setLength(n);
        stringBuffer.append(RESOURCE_ADAPTER_MODULE);
        String[] stringArray3 = this.getObjectNames(stringBuffer.toString());
        int n2 = stringArray.length + stringArray2.length + stringArray3.length;
        String[] stringArray4 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray4, stringArray.length, stringArray2.length);
        System.arraycopy(stringArray3, 0, stringArray4, stringArray.length + stringArray2.length, stringArray3.length);
        return stringArray4;
    }

    private String[] getModulesWhenStopped() {
        String[] stringArray = null;
        try {
            WARFile wARFile;
            CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            EARFile eARFile = commonarchiveFactory.openEARFile(archiveOptions, this.earPath);
            Properties properties = new Properties();
            properties.setProperty(J2EE_SERVER, this.getObjectName().getKeyProperty(J2EE_SERVER));
            properties.setProperty(J2EE_APPLICATION, this.getObjectName().getKeyProperty(NAME));
            MBeanFactory mBeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
            int n = eARFile.getWARFiles().size() + eARFile.getEJBJarFiles().size() + eARFile.getRARFiles().size();
            int n2 = 0;
            stringArray = new String[n];
            properties.setProperty(J2EE_TYPE, WEB_MODULE);
            Iterator iterator = eARFile.getWARFiles().iterator();
            while (iterator.hasNext()) {
                wARFile = (WARFile)iterator.next();
                properties.setProperty(NAME, wARFile.getName());
                stringArray[n2++] = mBeanFactory.createObjectName(WEB_MODULE, mBeanFactory.getConfigId(wARFile), null, properties).toString();
            }
            properties.setProperty(J2EE_TYPE, EJB_MODULE);
            iterator = eARFile.getEJBJarFiles().iterator();
            while (iterator.hasNext()) {
                wARFile = (EJBJarFile)iterator.next();
                properties.setProperty(NAME, wARFile.getName());
                stringArray[n2++] = mBeanFactory.createObjectName(EJB_MODULE, mBeanFactory.getConfigId(wARFile), null, properties).toString();
            }
            properties.setProperty(J2EE_TYPE, RESOURCE_ADAPTER_MODULE);
            iterator = eARFile.getRARFiles().iterator();
            while (iterator.hasNext()) {
                wARFile = (RARFile)iterator.next();
                stringArray[n2++] = mBeanFactory.createObjectName(RESOURCE_ADAPTER_MODULE, mBeanFactory.getConfigId(wARFile), null, properties).toString();
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, J2EEApplication.class.getName() + ".getModulesWhenStopped", "227", this);
        }
        catch (OpenFailureException openFailureException) {
            FFDCFilter.processException((Throwable)openFailureException, J2EEApplication.class.getName() + ".getModulesWhenStopped", "238", this);
        }
        return stringArray;
    }

    public void start() throws InstanceNotFoundException, MBeanException, ReflectionException, AdminException {
        if (this.getJ2EEState() != 3 && this.getJ2EEState() != 4) {
            throw new AdminException("Cannot call start() when in state " + STATE_NAMES[this.getJ2EEState()]);
        }
        try {
            AdminServiceFactory.getAdminService().invoke(this.getApplicationManager(), "startApplication", new Object[]{this.getJ2EEName()}, new String[]{"java.lang.String"});
        }
        catch (MBeanException mBeanException) {
            if (this.getJ2EEState() == 3) {
                this.changeState(0);
            }
            this.changeState(4);
            throw mBeanException;
        }
    }

    public void startRecursive() throws InstanceNotFoundException, MBeanException, ReflectionException, AdminException {
        this.start();
    }

    public void stop() throws InstanceNotFoundException, MBeanException, ReflectionException, AdminException {
        if (this.getJ2EEState() != 1 && this.getJ2EEState() != 0 && this.getJ2EEState() != 4) {
            throw new AdminException("Cannot call stop() when in state " + STATE_NAMES[this.getJ2EEState()]);
        }
        try {
            AdminServiceFactory.getAdminService().invoke(this.getApplicationManager(), "stopApplication", new Object[]{this.getJ2EEName()}, new String[]{"java.lang.String"});
        }
        catch (MBeanException mBeanException) {
            this.changeState(4);
            throw mBeanException;
        }
    }

    private ObjectName getApplicationManager() {
        if (this.appMgr == null) {
            try {
                ObjectName objectName = new ObjectName("WebSphere:*,type=ApplicationManager," + this.getLocationKeyProperties());
                this.appMgr = this.getFirstObjectName(objectName);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.j2ee.J2EEApplicationProxy.getApplicationManager", "135", this);
            }
        }
        return this.appMgr;
    }

    protected ObjectName getWebSphereMBeanQueryName() {
        if (this.appQueryName == null) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("WebSphere:*,type=Application,name=");
                stringBuffer.append(this.getJ2EEName());
                stringBuffer.append(",");
                stringBuffer.append(this.getLocationKeyProperties());
                this.appQueryName = new ObjectName(stringBuffer.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.j2ee.J2EEApplication.getWebSphereMBeanQueryName", "156", this);
            }
        }
        return this.appQueryName;
    }

    public void handleNotification(Notification notification, Object object) {
        String string = notification.getType();
        if (string.equals("j2ee.state.starting")) {
            this.changeState(0);
        } else if (string.equals("j2ee.state.running")) {
            this.changeState(1);
        } else if (string.equals("j2ee.state.stopping")) {
            this.changeState(2);
        } else if (string.equals("j2ee.state.stopped")) {
            this.changeState(3);
        } else if (string.equals("j2ee.state.failed")) {
            this.changeState(4);
        }
    }

    protected Set lookupMBeans(String string, QueryExp queryExp) {
        try {
            ObjectName objectName = new ObjectName(string);
            return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(objectName, queryExp);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    protected String[] getObjectNames(String string) {
        return this.getObjectNames(string, null);
    }

    protected String[] getObjectNames(String string, QueryExp queryExp) {
        Set set = this.lookupMBeans(string, queryExp);
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next().toString();
        }
        return stringArray;
    }

    protected String getObjectName(String string) {
        Set set = this.lookupMBeans(string, null);
        if (set.size() == 0) {
            return null;
        }
        return set.iterator().next().toString();
    }
}

