/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.collaborator;

import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.RALifeCycleManager;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.runtime.component.collaborator.J2EEResourceMBean;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.resource.ResourceException;

public class JCAResourceMBean
extends J2EEResourceMBean {
    private static final TraceComponent tc = Tr.register(JCAResourceMBean.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private String archivePath;
    private String name;
    private String description;
    private RALifeCycleManager raLifecycleManager;
    private String raKey;
    private boolean paused = false;

    public void activeMBean(J2CResourceAdapter j2CResourceAdapter, String string, String string2, RALifeCycleManager rALifeCycleManager, String string3) {
        String string4;
        MBeanFactory mBeanFactory;
        try {
            this.name = j2CResourceAdapter.getName();
            this.description = j2CResourceAdapter.getDescription();
            this.raLifecycleManager = rALifeCycleManager;
            this.raKey = string3;
            mBeanFactory = AdminServiceFactory.getMBeanFactory();
            string4 = mBeanFactory.getConfigId(j2CResourceAdapter);
            Properties properties = new Properties();
            if (string2 != null) {
                properties.setProperty("ResourceAdapter", string2);
            }
            properties.setProperty("name", j2CResourceAdapter.getName());
            properties.setProperty("Server", string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activateMBean started for " + j2CResourceAdapter.getName() + " Type " + this.getResourceType());
            }
            mBeanFactory.activateMBean(this.getResourceType(), this, string4, null, properties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activateMBean completed for " + j2CResourceAdapter.getName());
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException(adminException, this.getClass().getName(), "60");
        }
        if (j2CResourceAdapter != null) {
            this.archivePath = j2CResourceAdapter.getArchivePath();
            this.name = j2CResourceAdapter.getName();
            mBeanFactory = j2CResourceAdapter.getDeploymentDescriptor();
            if (mBeanFactory != null) {
                string4 = mBeanFactory.getDescription();
                if (string4 != null && !string4.equals("")) {
                    this.description = string4;
                }
            } else if (this.description == null) {
                this.description = "";
            }
        }
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    protected String getResourceType() {
        return "J2CResourceAdapter";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getConnectionFactories() {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:type=J2CConnectionFactory,JCAResource=" + this.getObjectName().getKeyProperty("name") + ",Server=" + this.getObjectName().getKeyProperty("Server") + ",*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ((ObjectName)iterator.next()).getCanonicalName();
        }
        return stringArray;
    }

    public void start() throws Exception {
        this.raLifecycleManager.restartRA(this.raKey);
    }

    public void startRecursive() throws Exception {
        this.start();
    }

    public void stop() throws Exception {
        List list = null;
        list = J2CAppUtils.getAppRefs(this.raKey);
        Object object = AdminServiceFactory.getAdminService().getNodeName();
        String string = AdminServiceFactory.getAdminService().getProcessName();
        Iterator iterator = list.iterator();
        boolean bl = false;
        StringBuffer stringBuffer = null;
        String string2 = System.getProperty("line.separator");
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ObjectName objectName = new ObjectName("WebSphere:type=Application,name=" + string3 + ",node=" + object + ",process=" + string + ",*");
            Iterator iterator2 = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator2.hasNext()) continue;
            bl = true;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("ResourceAdapter <");
                stringBuffer.append(this.raKey);
                stringBuffer.append("> could not be stopped because applications which use it are still running.");
                stringBuffer.append(string2);
                stringBuffer.append("The applications are:");
            }
            stringBuffer.append(string2);
            stringBuffer.append("  ");
            stringBuffer.append(string3);
        }
        if (bl) {
            object = new ResourceException(stringBuffer.toString());
            throw object;
        }
        this.raLifecycleManager.stopRA(this.raKey);
    }

    public void changeState(int n) {
        super.changeState(n);
    }

    public void pause() throws Exception {
        this.raLifecycleManager.pauseRA(this.raKey);
        this.paused = true;
    }

    public void resume() throws Exception {
        this.raLifecycleManager.resumeRA(this.raKey);
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getStatus() {
        return this.raLifecycleManager.getStatus(this.raKey);
    }
}

