/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.File;
import org.eclipse.emf.common.util.URI;

public class RelativeURIContextResolver {
    static TraceComponent tc = Tr.register(RelativeURIContextResolver.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private int owningResourceType;
    private ConfigRoot thisResourcesConfigRoot;
    private int maximumAllowableContextPops = 0;
    private int numberOfContextPopsPerformed = 0;
    private String uriOfResourceBeingProcessed = null;
    private boolean heirachicalSearchAllowed = true;

    public void setOwningResourceType(int n, ConfigRoot configRoot, String string) {
        this.owningResourceType = n;
        this.thisResourcesConfigRoot = configRoot;
        this.numberOfContextPopsPerformed = 0;
        this.uriOfResourceBeingProcessed = string;
        switch (n) {
            case 2: {
                this.maximumAllowableContextPops = 0;
                break;
            }
            case 0: {
                this.maximumAllowableContextPops = 0;
                break;
            }
            case 3: {
                this.maximumAllowableContextPops = 1;
                break;
            }
            case 4: {
                this.maximumAllowableContextPops = 2;
                break;
            }
            case 1: {
                this.maximumAllowableContextPops = 0;
                break;
            }
        }
    }

    public URI resolveRelativeURI(URI uRI) {
        URI uRI2 = null;
        String string = this.thisResourcesConfigRoot.getConfigRootPath();
        StringBuffer stringBuffer = null;
        int n = 0;
        if (uRI.hasTrailingPathSeparator()) {
            n = 1;
        }
        switch (this.owningResourceType) {
            case 1: {
                if (uRI.segmentCount() == n + 1) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uRI);
                break;
            }
            case 2: {
                if (uRI.segmentCount() == n + 1) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uRI);
                break;
            }
            case 0: {
                if (uRI.segmentCount() == n + 1) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uRI);
                break;
            }
            case 3: {
                if (uRI.segmentCount() == n + 1) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    break;
                }
                if (uRI.segmentCount() == n + 3) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(0);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uRI);
                break;
            }
            case 4: {
                if (uRI.segmentCount() == n + 1) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    break;
                }
                this.heirachicalSearchAllowed = false;
                if (uRI.segmentCount() == n + 3) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(3);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    break;
                }
                if (uRI.segmentCount() == n + 5) {
                    stringBuffer = this.thisResourcesConfigRoot.getURIBaseForType(0);
                    uRI2 = URI.createFileURI((String)(string + stringBuffer.toString() + File.separator));
                    break;
                }
                this.invalidURISegmentCount(uRI);
                break;
            }
            default: {
                this.invalidResourceType(this.owningResourceType);
            }
        }
        URI uRI3 = null;
        if (this.heirachicalSearchAllowed) {
            if (this.numberOfContextPopsPerformed > 0) {
                if (uRI2.hasTrailingPathSeparator()) {
                    uRI2 = uRI2.trimSegments(this.numberOfContextPopsPerformed * 2 + 1);
                    uRI2 = URI.createFileURI((String)(uRI2.path() + File.separator));
                } else {
                    uRI2 = uRI2.trimSegments(this.numberOfContextPopsPerformed * 2);
                }
            }
            uRI3 = uRI;
        } else {
            int n2 = uRI.segmentCount();
            String string2 = null;
            string2 = uRI.segment(n2 - (n + 1));
            uRI3 = uRI.trimSegments(n2);
            uRI3 = uRI3.appendSegment(string2);
            if (n > 0) {
                uRI2 = URI.createFileURI((String)(uRI2.path() + File.separator));
            }
        }
        URI uRI4 = uRI3.resolve(uRI2);
        return uRI4;
    }

    private void invalidURISegmentCount(URI uRI) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSVR0230E", new Object[]{uRI.toString()});
        }
        throw new WsRuntimeException();
    }

    private void invalidResourceType(int n) {
        Tr.error(tc, "WSVR0231E", new Object[]{new Integer(n)});
        throw new WsRuntimeException();
    }

    public boolean popSearchContext() {
        if (this.heirachicalSearchAllowed) {
            if (this.numberOfContextPopsPerformed < this.maximumAllowableContextPops) {
                ++this.numberOfContextPopsPerformed;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getURIOfResourceBeingProcessed() {
        return this.uriOfResourceBeingProcessed;
    }
}

