/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentFactory;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ServiceProviderImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.component.WsComponent;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentManagerImpl
extends ServiceProviderImpl
implements ComponentManager {
    private static final TraceComponent tc = Tr.register(ComponentManagerImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected Map components = new HashMap();
    protected ClassLoader classLoader;
    private PlatformCheck platformCheck = new PlatformCheck();

    public ComponentManagerImpl(String string, ClassLoader classLoader) throws ConfigurationError {
        this.classLoader = classLoader;
        this.load(string, classLoader);
    }

    protected void load(String string, ClassLoader classLoader) throws ConfigurationError {
        String string2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Loading resources from: " + string);
        }
        String string3 = "META-INF/ws-";
        int n = string.indexOf(string3);
        String string4 = string;
        if (n == 0) {
            string4 = string.substring(string3.length());
        }
        if (string4.endsWith(".xml")) {
            string4 = string4.substring(0, string4.length() - 4);
        }
        string4 = string4.replaceFirst("recovery-mode-", "");
        string4 = string4.replaceFirst("control-region-", "");
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string2 = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + string4);
        if (iExtensionPoint == null) {
            throw new ConfigurationError("extension point, " + string2 + ", is null");
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IConfigurationElement[] iConfigurationElementArray;
            IExtension iExtension = iExtensionArray[i];
            IConfigurationElement[] iConfigurationElementArray2 = iExtension.getConfigurationElements();
            if (iConfigurationElementArray2.length != 1) continue;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[0];
            if (!iConfigurationElement.getName().equals("components")) {
                iConfigurationElementArray = iConfigurationElement.getName();
                continue;
            }
            iConfigurationElementArray = iConfigurationElement.getChildren();
            for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                Object object;
                String string5;
                String string6;
                String string7;
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[j];
                if (!iConfigurationElement2.getName().equals("component")) continue;
                ComponentInfo componentInfo = new ComponentInfo();
                String string8 = iConfigurationElement2.getAttribute("platform");
                if (!this.platformCheck.validOn(string8, string7 = iConfigurationElement2.getAttribute("processType"), string6 = iConfigurationElement2.getAttribute("recoveryType")) || (string5 = iConfigurationElement2.getAttribute("name")) == null) continue;
                componentInfo.setName(string5);
                String string9 = iConfigurationElement2.getAttribute("factory");
                if (string9 != null) {
                    object = new StringTokenizer(string9, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        componentInfo.factories.add(((StringTokenizer)object).nextToken().trim().toLowerCase());
                    }
                }
                if ((object = iConfigurationElement2.getAttribute("prefix")) != null) {
                    componentInfo.setNamespacePrefix((String)object);
                } else {
                    componentInfo.setNamespacePrefix("http://www.ibm.com/websphere/appserver/schemas/6.0/");
                }
                String string10 = iConfigurationElement2.getAttribute("class");
                if (string10 != null) {
                    componentInfo.setImplementationClass(iConfigurationElement2.getAttribute("class"));
                    componentInfo.setConfigElement(iConfigurationElement2);
                }
                componentInfo.namespaceUri = iConfigurationElement2.getAttribute("namespaceUri");
                try {
                    this.addComponent(componentInfo);
                    continue;
                }
                catch (ConfigurationWarning configurationWarning) {
                    Tr.error(tc, "WSVR0501E", new Object[]{componentInfo.componentName, configurationWarning});
                }
            }
        }
        this.loadLegacyPlugins(string, classLoader);
    }

    private void loadLegacyPlugins(String string, ClassLoader classLoader) throws ConfigurationError {
        Object object;
        Enumeration<URL> enumeration;
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationError(iOException);
        }
        XMLReader xMLReader = null;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new ConfigurationError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationError(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigurationError(factoryConfigurationError);
        }
        object = new ComponentHandler();
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        xMLReader.setEntityResolver((EntityResolver)object);
        xMLReader.setErrorHandler((ErrorHandler)object);
        Object var6_10 = null;
        while (enumeration.hasMoreElements()) {
            Object object2;
            URL uRL = enumeration.nextElement();
            try {
                xMLReader.parse(new InputSource(uRL.openStream()));
            }
            catch (SAXParseException sAXParseException) {
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException});
            }
            catch (SAXException sAXException) {
                object2 = sAXException.getException();
                if (object2 == null) {
                    object2 = sAXException;
                }
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", object2});
            }
            catch (IOException iOException) {
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", iOException});
            }
            Iterator iterator = ((ComponentHandler)object).getComponents().values().iterator();
            while (iterator.hasNext()) {
                object2 = (ComponentInfo)iterator.next();
                try {
                    this.addComponent((ComponentInfo)object2);
                }
                catch (ConfigurationWarning configurationWarning) {
                    Tr.error(tc, "WSVR0501E", new Object[]{((ComponentInfo)object2).componentName, configurationWarning});
                }
            }
        }
    }

    private void addComponent(ComponentInfo componentInfo) throws ConfigurationWarning {
        Object object;
        EClass eClass = null;
        String string = componentInfo.componentName;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            object = string.substring(0, n);
            String string2 = string.substring(n + 1);
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(componentInfo.getPackageUri((String)object));
            if (ePackage == null) {
                ePackage = EPackage.Registry.INSTANCE.getEPackage(componentInfo.getOldPackageUri((String)object));
            }
            if (ePackage == null) {
                throw new ConfigurationWarning("Invalid namespace, " + (String)object + ", for " + string, null);
            }
            eClass = (EClass)ePackage.getEClassifier(string2);
        }
        if (eClass == null) {
            throw new ConfigurationWarning("Invalid component name, " + string);
        }
        object = (ComponentInfo)this.components.get(eClass);
        if (object == null) {
            this.components.put(eClass, componentInfo);
        } else {
            if (componentInfo.implementationClass != null) {
                ((ComponentInfo)object).setImplementationClass(componentInfo.implementationClass);
            }
            if (componentInfo.factories != null) {
                ((ComponentInfo)object).addFactories(componentInfo.factories);
            }
        }
    }

    public Object getComponent(EObject eObject) {
        Object object = null;
        EClass eClass = eObject.eClass();
        object = this.createInstance((EObject)eClass);
        if (object == null) {
            EList eList = eClass.getEAllSuperTypes();
            int n = eList.size();
            for (int i = 0; object == null && i < n; ++i) {
                object = this.createInstance((EObject)eList.get(i));
            }
        }
        return object;
    }

    public Object getInstance(Object object) {
        if (object instanceof EObject) {
            return this.getComponent((EObject)object);
        }
        try {
            Class<?> clazz = this.classLoader.loadClass(object.toString());
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0501E", new Object[]{object, throwable});
            return null;
        }
    }

    protected Object createInstance(EObject eObject) {
        ComponentInfo componentInfo = (ComponentInfo)this.components.get(eObject);
        if (componentInfo != null) {
            return componentInfo.instantiate(this.classLoader, eObject);
        }
        return null;
    }

    static class ComponentHandler
    extends DefaultHandler {
        Locator locator = null;
        Map components = new HashMap();
        ComponentInfo currentComponent = null;
        StringBuffer characterBuffer = new StringBuffer();
        static final String DEFAULT_NAMESPACE_PREFIX = "http://www.ibm.com/websphere/appserver/schemas/6.0/";
        String currentPrefix = null;
        static String platformString = null;

        public Map getComponents() {
            return this.components;
        }

        public void startDocument() throws SAXException {
            this.components.clear();
            this.currentPrefix = DEFAULT_NAMESPACE_PREFIX;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
            this.characterBuffer.setLength(0);
            if (string3.equals("component")) {
                this.currentComponent = new ComponentInfo();
                if (attributes2 != null) {
                    for (int i = 0; i < attributes2.getLength(); ++i) {
                        if (attributes2.getQName(i).equals("platform")) {
                            this.currentComponent.platforms = attributes2.getValue(i).split(",");
                            continue;
                        }
                        Tr.warning(tc, "WSVR0108W", new Object[]{attributes2.getQName(i), this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentComponent == null) {
                if (!string3.equals("prefix")) return;
                this.currentPrefix = this.characterBuffer.toString();
                return;
            }
            if (string3.equals("component")) {
                if (this.currentComponent.componentName != null) {
                    ComponentInfo componentInfo;
                    if (this.currentComponent.platforms != null) {
                        boolean bl = false;
                        for (int i = 0; i < this.currentComponent.platforms.length; ++i) {
                            String string4 = this.currentComponent.platforms[i].trim().toLowerCase();
                            if (!string4.equals("all") && !string4.equals(platformString)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            if (tc.isDebugEnabled()) {
                                Tr.info(tc, "WSVR0109I", new Object[]{this.currentComponent.componentName, this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
                            }
                            this.currentComponent = null;
                            this.characterBuffer.setLength(0);
                            return;
                        }
                    }
                    if (this.currentComponent.namespacePrefix == null) {
                        this.currentComponent.namespacePrefix = this.currentPrefix;
                    }
                    if ((componentInfo = this.components.put(this.currentComponent.componentName, this.currentComponent)) != null) {
                        System.out.println("Duplicate component entry, " + this.currentComponent.componentName + ", found in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber());
                    }
                } else {
                    System.out.println("Missing name in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber());
                }
                this.currentComponent = null;
            } else if (string3.equals("name")) {
                if (this.currentComponent.componentName != null) throw new SAXParseException("Name already defined", this.locator);
                this.currentComponent.componentName = this.characterBuffer.toString();
            } else if (string3.equals("prefix")) {
                if (this.currentComponent.namespacePrefix != null) throw new SAXParseException("Prefix already defined", this.locator);
                this.currentComponent.namespacePrefix = this.characterBuffer.toString();
            } else if (string3.equals("namespaceUri")) {
                if (this.currentComponent.namespaceUri != null) throw new SAXParseException("namespaceUri already defined", this.locator);
                this.currentComponent.namespaceUri = this.characterBuffer.toString();
            } else if (string3.equals("class")) {
                if (this.currentComponent.implementationClass != null) throw new SAXParseException("Class already defined", this.locator);
                this.currentComponent.implementationClass = this.characterBuffer.toString();
            } else {
                if (!string3.equals("factory")) throw new SAXParseException("Invalid tag: " + string3, this.locator);
                this.currentComponent.addFactory(this.characterBuffer.toString());
            }
            this.characterBuffer.setLength(0);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.components.clear();
            this.currentComponent = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.characterBuffer.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        static {
            platformString = "distributed";
            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                platformString = "zos";
            } else if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
                platformString = "os400";
            }
        }
    }

    static class PlatformCheck {
        static final String DISTRIBUTED = "distributed";
        static final String ZSERIES = "zos";
        static final String ISERIES = "os400";
        static final String ALL = "all";
        static final String ADJUNCT = "adjunct";
        static final String CONTROL = "control";
        static final String SERVANT = "servant";
        static final String CLIENT = "client";
        private static String actualPlatformString = null;
        private static String processType = null;
        private static boolean recoveryMode = false;

        PlatformCheck() {
        }

        private boolean validOn(String string, String string2, String string3) {
            String string4;
            StringTokenizer stringTokenizer;
            boolean bl = false;
            if (string == null) {
                bl = true;
            } else {
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().trim().toLowerCase();
                    if (string4.equals(ALL)) {
                        bl = true;
                        break;
                    }
                    if (!string4.equals(actualPlatformString)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && actualPlatformString.equals(ZSERIES)) {
                bl = false;
                if (recoveryMode && (string2 = string3) == null) {
                    string2 = "";
                }
                if (string2 == null) {
                    bl = true;
                } else {
                    stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken().trim().toLowerCase();
                        if (string4.equals(ALL)) {
                            bl = true;
                            break;
                        }
                        if (!string4.equalsIgnoreCase(processType)) continue;
                        bl = true;
                        break;
                    }
                }
            }
            return bl;
        }

        static {
            actualPlatformString = DISTRIBUTED;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isZOS()) {
                actualPlatformString = ZSERIES;
                processType = CONTROL;
                if (platformHelper.isCRAJvm()) {
                    processType = ADJUNCT;
                } else if (platformHelper.isServantJvm()) {
                    processType = SERVANT;
                } else if (platformHelper.isClientJvm()) {
                    processType = CLIENT;
                }
                if (processType != CLIENT && !platformHelper.runningWhereConfigured()) {
                    recoveryMode = true;
                }
            } else if (platformHelper.isOS400()) {
                actualPlatformString = ISERIES;
            }
        }
    }

    static class ComponentInfo {
        public String componentName;
        public Object implementationClass;
        public IConfigurationElement configElement;
        List factories;
        String namespacePrefix;
        String namespaceUri = null;
        protected String[] platforms = null;

        ComponentInfo() {
        }

        public String toString() {
            String string = "ComponentInfo{name=" + this.componentName + ", class=" + this.implementationClass + ", prefix=" + this.namespacePrefix + ", namespaceURI=" + this.namespaceUri;
            if (this.platforms != null) {
                string = string + ", platforms=" + this.platforms[0].trim().toLowerCase();
                for (int i = 1; i < this.platforms.length; ++i) {
                    string = string + "," + this.platforms[i].trim().toLowerCase();
                }
            }
            string = string + "}";
            return string;
        }

        public void setName(String string) {
            this.componentName = string;
        }

        public void setImplementationClass(Object object) {
            this.implementationClass = object;
        }

        public void setConfigElement(IConfigurationElement iConfigurationElement) {
            this.configElement = iConfigurationElement;
        }

        public void setNamespacePrefix(String string) {
            this.namespacePrefix = string;
        }

        public String getPackageUri(String string) {
            if (this.namespaceUri != null) {
                return this.namespaceUri;
            }
            return this.namespacePrefix + string + ".xmi";
        }

        public String getOldPackageUri(String string) {
            return "http://www.ibm.com/websphere/appserver/schemas/5.0/" + string + ".xmi";
        }

        public void addFactories(Collection collection) {
            if (collection == null) {
                this.factories = new ArrayList(collection.size());
            }
            this.factories.addAll(collection);
        }

        public void addFactory(String string) {
            if (this.factories == null) {
                this.factories = new ArrayList(1);
            }
            this.factories.add(string);
        }

        public WsComponent instantiate(ClassLoader classLoader, EObject eObject) {
            Class clazz = null;
            try {
                Object object;
                if (this.implementationClass instanceof Class) {
                    clazz = (Class)this.implementationClass;
                } else if (this.configElement != null) {
                    try {
                        object = this.configElement.getAttribute("class");
                        String string = this.configElement.getNamespace();
                        final Bundle bundle = Platform.getBundle((String)string);
                        clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object){
                            private final /* synthetic */ String val$className;
                            {
                                this.val$className = string;
                            }

                            public Object run() throws ClassNotFoundException {
                                return bundle.loadClass(this.val$className);
                            }
                        });
                    }
                    catch (Exception exception) {
                        Tr.error(tc, "WSVR0501E", new Object[]{this.componentName, exception});
                    }
                    this.implementationClass = clazz;
                } else if (this.implementationClass != null) {
                    this.implementationClass = clazz = classLoader.loadClass((String)this.implementationClass);
                } else {
                    throw new ConfigurationError("<class> not specified for component " + this);
                }
                object = (WsComponent)clazz.newInstance();
                return object;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "289");
                Tr.error(tc, "WSVR0501E", new Object[]{this.implementationClass, throwable});
                if (this.factories != null) {
                    for (int i = 0; i < this.factories.size(); ++i) {
                        Object object;
                        Object e2 = this.factories.get(i);
                        if (e2 instanceof String) {
                            try {
                                object = classLoader.loadClass((String)e2);
                                ComponentFactory componentFactory = (ComponentFactory)((Class)object).newInstance();
                                this.factories.set(i, componentFactory);
                            }
                            catch (Throwable throwable2) {
                                this.factories.set(i, null);
                            }
                        }
                        if (!(e2 instanceof ComponentFactory) || (object = ((ComponentFactory)e2).createComponent(eObject)) == null) continue;
                        return object;
                    }
                }
                return null;
            }
        }
    }
}

