/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.runtime.config.RelativeURIContextResolver;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.util.WSThreadLocal;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.xml.sax.SAXParseException;

public class ConfigRootImpl
implements ConfigRoot {
    static TraceComponent tc = Tr.register(ConfigRootImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    static final String[] pathName = new String[]{"cells", "applications", "clusters", "nodes", "servers", "buses"};
    static final int[][] pathComposition = new int[][]{{0}, {0, 1}, {0, 2}, {0, 3}, {0, 3, 4}, {0, 5}};
    URI rootURI;
    String[] typeValues = new String[6];
    StringBuffer[] cachedPaths = new StringBuffer[6];
    WASResourceSetImpl resourceSet;
    private static WSThreadLocal threadLocal_RelativeURIContextResolver = new WSThreadLocal(){

        protected Object initialValue() {
            return new RelativeURIContextResolver();
        }
    };

    ConfigRootImpl(String string, String string2, String string3, String string4, String string5) {
        File file = new File(string);
        this.rootURI = URI.createFileURI((String)(file.getAbsolutePath() + File.separator));
        this.setValue(0, string2);
        this.setValue(3, string3);
        this.setValue(4, string4);
        this.setValue(2, string5);
        this.resourceSet = (WASResourceSetImpl)this.createResourceSet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public String toString() {
        return super.toString() + "[rootURI=" + this.rootURI + ",typeValues" + this.arrayToString(this.typeValues) + "]";
    }

    private String arrayToString(Object[] objectArray) {
        String string = "{";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + objectArray[i] + ",";
        }
        string = string + "}";
        return string;
    }

    public StringBuffer getURIBaseForType(int n) {
        StringBuffer stringBuffer = this.cachedPaths[n];
        if (stringBuffer == null) {
            boolean bl = false;
            stringBuffer = new StringBuffer();
            int[] nArray = pathComposition[n];
            for (int i = 0; i < nArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(pathName[nArray[i]]).append('/');
                String string = this.getValue(nArray[i]);
                if (string == null) {
                    bl = true;
                    continue;
                }
                stringBuffer.append(string);
            }
            if (!bl) {
                this.cachedPaths[n] = stringBuffer;
            }
        }
        return stringBuffer;
    }

    synchronized String getRelativePath(int n, String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelativePath", new Object[]{pathName[n], string, this});
        }
        StringBuffer stringBuffer = this.getURIBaseForType(n);
        int n2 = stringBuffer.length();
        if (string == null) {
            String string3 = this.getValue(n);
            int n3 = string3 == null ? 0 : string3.length();
            int n4 = stringBuffer.length() - n3 - 1;
            string2 = stringBuffer.substring(0, n4);
        } else {
            if (string.length() > 0) {
                stringBuffer.append('/').append(string);
            }
            string2 = stringBuffer.toString();
        }
        stringBuffer.setLength(n2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelativePath", string2);
        }
        return string2;
    }

    URI getRelativeURI(int n, String string) {
        return URI.createURI((String)this.getRelativePath(n, string));
    }

    public String getConfigRootPath() {
        return this.rootURI.toFileString();
    }

    public String getAbsolutePath(int n, String string) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getAbsolutePath", new Object[]{pathName[n], string, this});
        }
        String string2 = this.rootURI.toFileString() + this.getRelativePath(n, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAbsolutePath", string2);
        }
        return string2;
    }

    URI getAbsoluteURI(int n, String string) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getAbsoluteURI", new Object[]{pathName[n], string, this});
        }
        URI uRI = URI.createFileURI((String)this.getAbsolutePath(n, string));
        if (bl) {
            Tr.exit(tc, "getAbsoluteURI", uRI);
        }
        return uRI;
    }

    public InputStream getInputStream(int n, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.getAbsolutePath(n, string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream", new Object[]{pathName[n], string, this, fileInputStream});
        }
        return fileInputStream;
    }

    public Resource getResource(int n, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{pathName[n], string, this});
        }
        Resource resource = this.getResource(n, string, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    private void setOwningResourceType(int n, String string) {
        RelativeURIContextResolver relativeURIContextResolver = (RelativeURIContextResolver)threadLocal_RelativeURIContextResolver.get();
        relativeURIContextResolver.setOwningResourceType(n, this, string);
    }

    public Resource getResource(int n, String string, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{pathName[n], string, new Boolean(bl), this});
        }
        this.setOwningResourceType(n, string);
        Resource resource = this.getResource(this.getAbsoluteURI(n, string), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    private Resource getResource(URI uRI, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{uRI, new Boolean(bl), this});
        }
        int n = 4;
        Resource resource = null;
        while (true) {
            try {
                resource = this.resourceSet.getResource(uRI, true, bl);
                if (!tc.isEntryEnabled()) break;
                Tr.exit(tc, "getResource", resource);
            }
            catch (WrappedException wrappedException) {
                if (wrappedException.exception() instanceof SAXParseException) {
                    if (n == 0) {
                        throw wrappedException.exception();
                    }
                    bl = true;
                    --n;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught, trying to load again: " + wrappedException.exception());
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw wrappedException.exception();
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    public List getResourceElements(int n, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceElements", new Object[]{pathName[n], string, this});
        }
        this.setOwningResourceType(n, string);
        List list = this.resourceSet.getResourceElements(this.getAbsoluteURI(n, string), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceElements");
        }
        return list;
    }

    public Resource getResourceAbsolute(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceAbsolute", new Object[]{string, this});
        }
        Resource resource = this.getResource(URI.createFileURI((String)string), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    public String getValue(int n) {
        String string = this.typeValues[n];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValue", new Object[]{pathName[n], this, string});
        }
        return string;
    }

    public String setValue(int n, String string) {
        String string2 = this.typeValues[n];
        this.typeValues[n] = string;
        block0: for (int i = 0; i < pathComposition.length; ++i) {
            int[] nArray = pathComposition[i];
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != n) continue;
                this.cachedPaths[i] = null;
                continue block0;
            }
        }
        return string2;
    }

    public String[] list(int n, String string) {
        File file;
        File[] fileArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list", new Object[]{pathName[n], string, this});
        }
        if ((fileArray = (file = new File(this.getAbsolutePath(n, string))).listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "list", null);
            }
            return null;
        }
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list", stringArray);
        }
        return stringArray;
    }

    public void remove(Resource resource) {
        this.resourceSet.removeResource(resource, true);
    }

    public void removeAll() {
        this.resourceSet.removeAllResources(true);
    }

    protected ResourceSet createResourceSet() {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    URI uRI2 = null;
                    boolean bl = true;
                    boolean bl2 = true;
                    RelativeURIContextResolver relativeURIContextResolver = (RelativeURIContextResolver)threadLocal_RelativeURIContextResolver.get();
                    WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                    while (bl && bl2) {
                        uRI2 = relativeURIContextResolver.resolveRelativeURI(uRI);
                        if (uRI2.hasFragment()) {
                            EObject eObject = null;
                            try {
                                eObject = wASResourceSetImpl.getEObject(uRI2, true);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (eObject != null && !eObject.eIsProxy()) {
                                bl = false;
                                continue;
                            }
                            bl2 = relativeURIContextResolver.popSearchContext();
                            continue;
                        }
                        bl2 = false;
                    }
                    if (bl) {
                        Tr.error(tc, "WSVR0232E", new Object[]{uRI.toString(), relativeURIContextResolver.getURIOfResourceBeingProcessed()});
                    }
                    return uRI2;
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    public ConfigRoot createConfigRoot(String string, String string2, String string3, String string4, String string5) {
        return new ConfigRootImpl(string, string2, string3, string4, string5);
    }
}

