/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.service;

import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.ConfigRootFactory;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ServiceProviderImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;

public class RepositoryImpl
extends ServiceProviderImpl
implements Repository {
    protected String root;
    protected String cell;
    protected String node;
    protected String cluster;
    protected String server;
    protected ConfigRoot sharedRoot = null;
    private static boolean isRegisteredAsService = false;

    public RepositoryImpl(String string, String string2, String string3, String string4) {
        this("ws-server", string, string2, string3, string4, null);
    }

    public RepositoryImpl(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, string5, null);
    }

    public RepositoryImpl(String string, String string2, String string3, String string4, String string5, String string6) {
        this.root = string2;
        this.cell = string3;
        this.node = string4;
        this.server = string5;
        this.cluster = string6;
        ModelMgr.initialize(string);
        this.sharedRoot = this.createConfigRoot(string2);
        if (!isRegisteredAsService) {
            try {
                WsServiceRegistry.addService((Object)this, (Class)Repository.class);
                isRegisteredAsService = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, RepositoryImpl.class.getName(), "57", this);
            }
        }
    }

    public void stopSharing() {
        if (this.sharedRoot != null) {
            this.sharedRoot.removeAll();
        }
        this.sharedRoot = null;
    }

    protected ConfigRoot createConfigRoot(String string) {
        ConfigRoot configRoot = ConfigRootFactory.createConfigRoot(string, this.cell, this.node, this.server, this.cluster);
        return configRoot;
    }

    public String getCellName() {
        return this.cell;
    }

    public String getNodeName() {
        return this.node;
    }

    public void setClusterName(String string) {
        this.cluster = string;
        if (this.sharedRoot != null) {
            this.sharedRoot.setValue(2, this.cluster);
        }
    }

    public String getClusterName() {
        return this.cluster;
    }

    public String getServerName() {
        return this.server;
    }

    public String getRootURI() {
        return this.root;
    }

    public ConfigRoot getConfigRoot() {
        ConfigRoot configRoot = this.sharedRoot;
        if (configRoot == null) {
            configRoot = this.createConfigRoot(this.root);
        }
        return configRoot;
    }
}

