/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.util.URLHandlerFactory;
import com.ibm.ws.runtime.util.URLStreamHandlerAdapter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public final class StreamHandlerUtils {
    private static final String DEFAULT_STREAM_HANDLER_CLASS_NAME = "com.ibm.resources.URLResourceProvider";
    private static Object urlHandlerSynch = new Object();
    private static URLHandlerFactory urlHandlerFactory = null;
    private static boolean runningInOSGi;
    private static Map streamHandlerAdapters;
    private static TraceComponent tc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryHandler() {
        if (runningInOSGi) {
            return true;
        }
        Object object = urlHandlerSynch;
        synchronized (object) {
            return urlHandlerFactory != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProvider(URLProvider uRLProvider, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", new Object[]{uRLProvider, string});
        }
        if (runningInOSGi) {
            URLStreamHandlerAdapter uRLStreamHandlerAdapter = new URLStreamHandlerAdapter(uRLProvider.getProtocol(), uRLProvider.getStreamHandlerClassName(), string);
            streamHandlerAdapters.put(uRLProvider.getProtocol(), uRLStreamHandlerAdapter);
        } else {
            Object object = urlHandlerSynch;
            synchronized (object) {
                try {
                    if (urlHandlerFactory == null) {
                        StreamHandlerUtils.createStreamHandler();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registering provider: " + uRLProvider.getProtocol() + " classpath: " + string);
                    }
                    urlHandlerFactory.registerProvider(uRLProvider, string);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "failure " + exception.getMessage() + " registering provider " + string);
                    throw exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProvider(String string, String string2) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", new Object[]{string, string2});
        }
        if (runningInOSGi) {
            URLStreamHandlerAdapter uRLStreamHandlerAdapter = new URLStreamHandlerAdapter(string, string2, null);
            streamHandlerAdapters.put(string, uRLStreamHandlerAdapter);
        } else {
            Object object = urlHandlerSynch;
            synchronized (object) {
                try {
                    if (urlHandlerFactory == null) {
                        StreamHandlerUtils.createStreamHandler();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registering protocol: " + string + " classpath: " + string2);
                    }
                    urlHandlerFactory.registerProvider(string, string2);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "failure " + exception.getMessage() + " registering protocol with class " + string2);
                    throw exception;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProvider", new Object[]{string, string2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProvider(URLProvider uRLProvider) throws Throwable {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", uRLProvider);
        }
        if ((string = uRLProvider.getStreamHandlerClassName()) == null || string.length() == 0 || string.equals("unused") || string.equals(DEFAULT_STREAM_HANDLER_CLASS_NAME)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "skipping URL stream handler for " + uRLProvider.getProtocol() + " with class name " + string);
            }
        } else if (runningInOSGi) {
            URLStreamHandlerAdapter uRLStreamHandlerAdapter = new URLStreamHandlerAdapter(uRLProvider.getProtocol(), string, StreamHandlerUtils.getProviderClasspath(uRLProvider.getClasspath()));
            streamHandlerAdapters.put(uRLProvider.getProtocol(), uRLStreamHandlerAdapter);
        } else {
            Object object = urlHandlerSynch;
            synchronized (object) {
                try {
                    if (urlHandlerFactory == null) {
                        StreamHandlerUtils.createStreamHandler();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registering provider " + uRLProvider);
                    }
                    urlHandlerFactory.registerProvider(uRLProvider);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "failure " + exception.getMessage() + " registering provider ");
                    throw exception;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProvider", uRLProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProvider", string);
        }
        if (runningInOSGi) {
            URLStreamHandlerAdapter uRLStreamHandlerAdapter = (URLStreamHandlerAdapter)streamHandlerAdapters.get(string);
            if (uRLStreamHandlerAdapter != null) {
                uRLStreamHandlerAdapter.destroy();
                streamHandlerAdapters.remove(string);
            }
        } else {
            Object object = urlHandlerSynch;
            synchronized (object) {
                try {
                    if (urlHandlerFactory == null) {
                        return;
                    }
                    urlHandlerFactory.deregisterProvider(string);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "failure " + exception.getMessage() + " deregistering provider " + string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProvider", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryProvider(String string) {
        if (runningInOSGi) {
            return streamHandlerAdapters.containsKey(string);
        }
        Object object = urlHandlerSynch;
        synchronized (object) {
            if (urlHandlerFactory == null) {
                return false;
            }
            return urlHandlerFactory.queryProvider(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStreamHandler() throws Throwable {
        if (runningInOSGi) {
            return;
        }
        Object object = urlHandlerSynch;
        synchronized (object) {
            block8: {
                if (urlHandlerFactory == null) {
                    urlHandlerFactory = new URLHandlerFactory();
                    try {
                        URL.setURLStreamHandlerFactory(urlHandlerFactory);
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block8;
                        if (throwable instanceof Error) {
                            Tr.debug(tc, "Exception " + throwable.toString() + " occurred.");
                            Tr.debug(tc, "Exception " + throwable.toString() + " if a URL Stream handler has already been set, add the safkeyring and safkeyringhw providers to it");
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    static boolean isStringEmpty(String string) {
        return string == null || string.length() <= 0;
    }

    static String appendClasspathStrings(String string, String string2) {
        if (!StreamHandlerUtils.isStringEmpty(string)) {
            string = string.trim();
        }
        if (!StreamHandlerUtils.isStringEmpty(string2)) {
            string2 = string2.trim();
        }
        if (!StreamHandlerUtils.isStringEmpty(string2)) {
            if (StreamHandlerUtils.isStringEmpty(string)) {
                return string2;
            }
            if (string.endsWith(File.pathSeparator)) {
                return string + string2;
            }
            return string + File.pathSeparator + string2;
        }
        return string;
    }

    static String getProviderClasspath(EList eList) {
        ListIterator listIterator = eList.listIterator();
        String string = new String();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            string = StreamHandlerUtils.appendClasspathStrings(string, string2);
        }
        return string;
    }

    static String getClassName(String string) {
        String string2 = new String(string);
        string2 = string2.replace(File.pathSeparatorChar, '.');
        return string2;
    }

    static ClassLoader getResourceClassLoader(String string, ClassLoader classLoader) throws MalformedURLException {
        ClassLoader classLoader2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceClassLoader " + string + " : " + classLoader);
        }
        if (string == null || string.equalsIgnoreCase("")) {
            classLoader2 = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    return classLoader;
                }
            });
        } else {
            Object object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parsing urls classpath=" + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), File.pathSeparator);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (((String)object).equals("")) continue;
                arrayList.add(object);
            }
            object = arrayList;
            URL[] uRLArray = (URL[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((List)object){
                private final /* synthetic */ List val$entriesF;
                {
                    this.val$entriesF = list;
                }

                public Object run() {
                    return ArchiveUtil.toLocalURLs((List)this.val$entriesF, (String)File.separator);
                }
            });
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append("\n       " + uRLArray[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadingurls: " + stringBuffer.toString());
            }
            final ClassLoader classLoader3 = classLoader;
            final URL[] uRLArray2 = uRLArray;
            classLoader2 = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    if (classLoader3 == null) {
                        return new URLClassLoader(uRLArray2, Thread.currentThread().getContextClassLoader());
                    }
                    return new URLClassLoader(uRLArray2, classLoader3);
                }
            });
        }
        return classLoader2;
    }

    static {
        streamHandlerAdapters = Collections.synchronizedMap(new HashMap());
        tc = Tr.register(StreamHandlerUtils.class.getName(), "StreamHandler", "com.ibm.ws.runtime.runtime");
        try {
            runningInOSGi = ExtensionRegistryFactory.instance().isEclipse();
        }
        catch (Exception exception) {
            runningInOSGi = false;
        }
    }
}

