/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.scheduler.NotificationSinkHome;
import com.ibm.websphere.scheduler.NotificationSinkInvalid;
import com.ibm.websphere.scheduler.SchedulerException;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.UserCalendarInvalid;
import com.ibm.websphere.scheduler.UserCalendarPeriodInvalid;
import com.ibm.websphere.scheduler.UserCalendarSpecifierInvalid;
import com.ibm.ws.scheduler.LazyTaskHolder;
import com.ibm.ws.scheduler.LazyTaskHolderI;
import com.ibm.ws.scheduler.NotificationSinkHolder;
import com.ibm.ws.scheduler.NotificationSinkHolderI;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.scheduler.TaskHolder;
import com.ibm.ws.scheduler.TaskHolderI;
import com.ibm.ws.scheduler.TaskInfoBinaryData;
import com.ibm.ws.scheduler.TaskStatusImpl;
import com.ibm.ws.scheduler.ThreadContextHolderI;
import com.ibm.ws.scheduler.UserCalendarHolder;
import com.ibm.ws.scheduler.UserCalendarHolderI;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.scheduler.spi.TaskStatus;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public abstract class AbstractTask
extends TaskStatusImpl
implements TaskInfo,
TaskStatus,
Serializable {
    private static final TraceComponent tc = Tr.register(AbstractTask.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    static final long serialVersionUID = 50L;
    protected String VERSION = "60";
    protected int ROW_VERSION = 0;
    protected boolean TASKSUSPENDED = false;
    protected boolean TASKCANCELLED = false;
    protected String STARTBYINTERVAL = null;
    protected Date STARTBYTIME = null;
    protected Date STARTTIME = null;
    protected Date VALIDTOTIME = null;
    protected String REPEATINTERVAL = null;
    protected int MAXREPEATS = 1;
    protected boolean AUTOPURGE = true;
    protected int FAILUREACTION = 0;
    protected int MAXATTEMPTS = 0;
    protected int QOS = 1;
    protected int PARTITION = 0;
    protected String startTimeDelta = null;
    protected int initialState;
    protected long processingModes = 0L;
    protected int failureCount = 0;
    private LazyTaskHolderI lazyTaskHolder = null;
    private TaskInfoBinaryData binaryData = null;
    byte taskSuspendedOrRunning = 0;

    public AbstractTask() {
        this.CREATETIME = new Date();
        this.initialState = 1;
        this.REPEATSLEFT = this.MAXREPEATS;
        this.processingModes = 0L;
    }

    public void initialize(String string, String string2, int n, byte by, boolean bl, Date date, String string3, Date date2, Date date3, Date date4, String string4, int n2, int n3, LazyTaskHolderI lazyTaskHolderI, String string5, boolean bl2, int n4, int n5, int n6, int n7, Date date5) {
        this.TASKID = string;
        this.VERSION = string2;
        this.ROW_VERSION = n;
        this.taskSuspendedOrRunning = by;
        this.TASKCANCELLED = bl;
        this.NEXTFIRETIME = date;
        this.STARTBYINTERVAL = string3;
        this.STARTBYTIME = date2;
        this.STARTTIME = date3;
        this.VALIDTOTIME = date4;
        this.REPEATINTERVAL = string4;
        this.MAXREPEATS = n2;
        this.REPEATSLEFT = n3;
        this.setLazyTaskHolder(lazyTaskHolderI);
        this.NAME = string5;
        this.AUTOPURGE = bl2;
        this.FAILUREACTION = n4;
        this.MAXATTEMPTS = n5;
        this.QOS = n6 == 0 ? 1 : n6;
        this.PARTITION = n7;
        this.CREATETIME = date5;
        this.setStatus(this);
        this.processingModes = 0L;
    }

    public void initialize(String string, String string2, int n, byte by, boolean bl, Date date, String string3, Date date2, Date date3, Date date4, String string4, int n2, int n3, TaskInfoBinaryData taskInfoBinaryData, String string5, boolean bl2, int n4, int n5, int n6, int n7, Date date5) {
        this.TASKID = string;
        this.VERSION = string2;
        this.ROW_VERSION = n;
        this.taskSuspendedOrRunning = by;
        this.TASKCANCELLED = bl;
        this.NEXTFIRETIME = date;
        this.STARTBYINTERVAL = string3;
        this.STARTBYTIME = date2;
        this.STARTTIME = date3;
        this.VALIDTOTIME = date4;
        this.REPEATINTERVAL = string4;
        this.MAXREPEATS = n2;
        this.REPEATSLEFT = n3;
        this.binaryData = taskInfoBinaryData;
        this.NAME = string5;
        this.AUTOPURGE = bl2;
        this.FAILUREACTION = n4;
        this.MAXATTEMPTS = n5;
        this.QOS = n6 == 0 ? 1 : n6;
        this.PARTITION = n7;
        this.CREATETIME = date5;
        this.setStatus(this);
        this.processingModes = 0L;
    }

    public void setStartTime(Date date) {
        this.STARTTIME = date;
        this.setNextFireTime(date);
    }

    public Date getStartTime() {
        return this.STARTTIME;
    }

    public void setStartTimeInterval(String string) {
        this.startTimeDelta = string;
    }

    public String getStartTimeInterval() {
        return this.startTimeDelta;
    }

    public void setStartByInterval(String string) {
        this.STARTBYINTERVAL = string;
    }

    public String getStartByInterval() {
        return this.STARTBYINTERVAL;
    }

    public void setRepeatInterval(String string) {
        this.REPEATINTERVAL = string;
    }

    public String getRepeatInterval() {
        return this.REPEATINTERVAL;
    }

    public void setNumberOfRepeats(int n) {
        this.setMaximumRepeats(n);
    }

    public int getNumberOfRepeats() {
        return this.MAXREPEATS;
    }

    public void setUserCalendar(String string, String string2) throws UserCalendarInvalid {
        this.getTaskHolder().setUserCalendarHolder(new UserCalendarHolder(string, string2));
    }

    public String getUserCalendarJNDIName() {
        String string = null;
        if (this.getTaskHolder().getUserCalendarHolder() != null) {
            string = this.getTaskHolder().getUserCalendarHolder().getCalendarSessionBeanJNDI();
        }
        return string;
    }

    public String getUserCalendarSpecifier() {
        String string = null;
        if (this.getTaskHolder().getUserCalendarHolder() != null) {
            string = this.getTaskHolder().getUserCalendarHolder().getCalendarSpecifier();
        }
        return string;
    }

    public void setAutoPurge(boolean bl) {
        this.AUTOPURGE = bl;
    }

    public boolean getAutoPurge() {
        return this.AUTOPURGE;
    }

    public void setNotificationSink(NotificationSinkHome notificationSinkHome) throws NotificationSinkInvalid {
        this.setNotificationSink(notificationSinkHome, Integer.MAX_VALUE);
    }

    public void setNotificationSink(NotificationSinkHome notificationSinkHome, int n) throws NotificationSinkInvalid {
        NotificationSinkHolderI notificationSinkHolderI = this.getTaskHolder().getNotificationSinkHolder();
        if (notificationSinkHolderI == null) {
            notificationSinkHolderI = new NotificationSinkHolder();
        }
        notificationSinkHolderI.setNotificationListener(notificationSinkHome, n);
        this.getTaskHolder().setNotificationSinkHolder(notificationSinkHolderI);
    }

    public NotificationSinkHome getNotificationSink() throws NotificationSinkInvalid {
        NotificationSinkHolderI notificationSinkHolderI = this.getTaskHolder().getNotificationSinkHolder();
        if (notificationSinkHolderI != null) {
            return notificationSinkHolderI.getNotificationListener();
        }
        return null;
    }

    public void setNotificationSink(String string, int n) {
        NotificationSinkHolderI notificationSinkHolderI = this.getTaskHolder().getNotificationSinkHolder();
        if (notificationSinkHolderI == null) {
            notificationSinkHolderI = new NotificationSinkHolder();
        }
        notificationSinkHolderI.setNotificationListener(string, n);
        this.getTaskHolder().setNotificationSinkHolder(notificationSinkHolderI);
    }

    public void setNotificationSink(String string) {
        this.setNotificationSink(string, Integer.MAX_VALUE);
    }

    public String getNotificationSinkJNDIName() {
        NotificationSinkHolderI notificationSinkHolderI = this.getTaskHolder().getNotificationSinkHolder();
        if (notificationSinkHolderI != null) {
            return notificationSinkHolderI.getNotificationListenerJNDIName();
        }
        return null;
    }

    public void setName(String string) {
        this.NAME = string;
    }

    public void validate() throws UserCalendarSpecifierInvalid, UserCalendarPeriodInvalid, UserCalendarInvalid, TaskInvalid, NotificationSinkInvalid {
        if (this.startTimeDelta == null && this.NEXTFIRETIME == null) {
            throw new TaskInvalid(Messages.getMessage("SCHD0017E", new String[]{"StartTime", "TaskInfo"}));
        }
        if (this.MAXREPEATS != 1 && this.REPEATINTERVAL == null) {
            throw new TaskInvalid(Messages.getMessage("SCHD0122E", new String[]{"RepeatInterval", "NumberOfRepeats", "TaskInfo"}));
        }
        if (this.initialState != 1 && this.initialState != 2) {
            throw new TaskInvalid(Messages.getMessage("SCHD0123E", new String[]{"InitialState", "TaskStatus.SCHEDULED, TaskStatus.SUSPENDED"}));
        }
        if (this.MAXREPEATS == 0) {
            throw new TaskInvalid(Messages.getMessage("SCHD0048E"));
        }
        if (this.QOS != 2 && this.QOS != 1) {
            throw new TaskInvalid(Messages.getMessage("SCHD0123E", new String[]{"QOS", "TaskInfo.QOS_ATLEASTONCE, TaskInfo.QOS_ONLYONCE"}));
        }
        int n = this.getTaskExecutionOptions();
        if (n != 0 && n != 1) {
            throw new TaskInvalid(Messages.getMessage("SCHD0123E", new String[]{"TaskExecutionOptions", "TaskInfo.EXECUTION_OPTIMIZED, TaskInfo.EXECUTION_DELAYEDUPDATE"}));
        }
        if (this.getTaskHolder().getExpectedDuration() < 0) {
            throw new TaskInvalid(Messages.getMessage("SCHD0123E", new String[]{"ExpectedDuration", ">=0"}));
        }
        if (this.getTaskHolder().getUserCalendarHolder() == null) {
            UserCalendarHolder userCalendarHolder = new UserCalendarHolder();
            userCalendarHolder.validate(new String[]{this.STARTBYINTERVAL, this.REPEATINTERVAL, this.startTimeDelta});
        } else {
            this.getTaskHolder().getUserCalendarHolder().validate(new String[]{this.STARTBYINTERVAL, this.REPEATINTERVAL, this.startTimeDelta});
        }
    }

    public void setInitialState(int n) {
        this.initialState = n;
    }

    public String getTaskId() {
        return this.TASKID;
    }

    public Date getNextFireTime() {
        return this.NEXTFIRETIME;
    }

    public int getRepeatsLeft() {
        return this.REPEATSLEFT;
    }

    public void setVersion(String string) {
        this.VERSION = string;
    }

    public String getVersion() {
        return this.VERSION;
    }

    public void setRowVersion(int n) {
        this.ROW_VERSION = n;
    }

    public int getRowVersion() {
        return this.ROW_VERSION;
    }

    public void setCancelled(boolean bl) {
        this.TASKCANCELLED = bl;
        this.setStatus(this);
    }

    public boolean getCancelled() {
        return this.TASKCANCELLED;
    }

    public void setFailureAction(int n) {
        this.FAILUREACTION = n;
    }

    public int getFailureAction() {
        return this.FAILUREACTION;
    }

    public void setQOS(int n) {
        this.QOS = n;
    }

    public int getQOS() {
        return this.QOS;
    }

    public void setPartition(int n) {
        this.PARTITION = n;
    }

    public int getPartition() {
        return this.PARTITION;
    }

    public void setTaskId(String string) {
        this.TASKID = string;
    }

    public void setNextFireTime(Date date) {
        this.NEXTFIRETIME = date;
    }

    public void setMaximumRepeats(int n) {
        this.MAXREPEATS = n;
        this.setRepeatsLeft(n);
    }

    public void setRepeatsLeft(int n) {
        this.REPEATSLEFT = n;
        this.setStatus(this);
    }

    public void setMaximumAttempts(int n) {
        this.MAXATTEMPTS = n;
    }

    public void setSuspended(boolean bl) {
        this.taskSuspendedOrRunning = AbstractTask.setSuspendedBit(this.taskSuspendedOrRunning, bl);
        this.taskSuspendedOrRunning = AbstractTask.setRunningBit(this.taskSuspendedOrRunning, false);
        this.setStatus(this);
    }

    public boolean getSuspended() {
        return AbstractTask.isSuspended(this.taskSuspendedOrRunning);
    }

    public void setRunning(boolean bl) {
        this.taskSuspendedOrRunning = AbstractTask.setRunningBit(this.taskSuspendedOrRunning, bl);
        this.setStatus(this);
    }

    public boolean getRunning() {
        return AbstractTask.isRunning(this.taskSuspendedOrRunning);
    }

    public byte getStateBits() {
        return this.taskSuspendedOrRunning;
    }

    public void setSuspendedBits(byte by) {
        this.taskSuspendedOrRunning = by;
        this.setStatus(this);
    }

    public String getStartTimeAsDelta() {
        return this.startTimeDelta;
    }

    public Date getStartByTime() {
        return this.STARTBYTIME;
    }

    void setValidToTime(Date date) {
        this.VALIDTOTIME = date;
    }

    public Date getValidToTime() {
        return this.VALIDTOTIME;
    }

    public int getMaximumRepeats() {
        return this.MAXREPEATS;
    }

    public int getMaximumAttempts() {
        return this.MAXATTEMPTS;
    }

    public UserCalendarHolderI getUserCalendarHolder() throws IOException, ClassNotFoundException {
        return this.getTaskHolder().getUserCalendarHolder();
    }

    public NotificationSinkHolderI getNotificationSinkHolder() throws IOException, ClassNotFoundException {
        return this.getTaskHolder().getNotificationSinkHolder();
    }

    public void setStartByTime(Date date) {
        this.STARTBYTIME = date;
    }

    public void setTargetRunnable(Runnable runnable) {
        this.getTaskHolder().setTargetRunnable(runnable);
    }

    public Runnable getTargetRunnable() {
        return this.getTaskHolder().getTargetRunnable();
    }

    public void setCreateTime(Date date) {
        this.CREATETIME = date;
    }

    public Date getCreateTime() {
        return this.CREATETIME;
    }

    public int getInitialState() {
        return this.initialState;
    }

    public synchronized TaskHolderI getTaskHolder() {
        if (this.getVersion().equals("60")) {
            return this.getTaskInfoBinaryData();
        }
        if (this.lazyTaskHolder == null) {
            this.lazyTaskHolder = new LazyTaskHolder(new TaskHolder());
        }
        return this.lazyTaskHolder.getTaskHolder();
    }

    public synchronized void setLazyTaskHolder(LazyTaskHolderI lazyTaskHolderI) {
        this.lazyTaskHolder = lazyTaskHolderI;
    }

    private synchronized TaskInfoBinaryData getTaskInfoBinaryData() {
        if (this.binaryData == null) {
            this.binaryData = new TaskInfoBinaryData();
        }
        return this.binaryData;
    }

    public String toString() {
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" AbstractTask: [");
            stringBuffer.append("VERSION=");
            stringBuffer.append(this.VERSION);
            stringBuffer.append(", ");
            stringBuffer.append("ROW_VERSION=");
            stringBuffer.append(this.ROW_VERSION);
            stringBuffer.append(", ");
            stringBuffer.append("TASKSUSPENDED=");
            stringBuffer.append(this.TASKSUSPENDED);
            stringBuffer.append(", ");
            stringBuffer.append("TASKCANCELLED=");
            stringBuffer.append(this.TASKCANCELLED);
            stringBuffer.append(", ");
            stringBuffer.append("STARTBYINTERVAL=");
            stringBuffer.append(this.STARTBYINTERVAL);
            stringBuffer.append(", ");
            stringBuffer.append("STARTBYTIME=");
            stringBuffer.append(this.STARTBYTIME);
            stringBuffer.append(", ");
            stringBuffer.append("REPEATINTERVAL=");
            stringBuffer.append(this.REPEATINTERVAL);
            stringBuffer.append(", ");
            stringBuffer.append("MAXREPEATS=");
            stringBuffer.append(this.MAXREPEATS);
            stringBuffer.append(", ");
            stringBuffer.append("AUTOPURGE=");
            stringBuffer.append(this.AUTOPURGE);
            stringBuffer.append(", ");
            stringBuffer.append("PARTITION=");
            stringBuffer.append(this.PARTITION);
            stringBuffer.append(", ");
            stringBuffer.append("PROCMODES=");
            stringBuffer.append(this.processingModes);
            stringBuffer.append(", ");
            stringBuffer.append("FAILCT=");
            stringBuffer.append(this.failureCount);
            stringBuffer.append(", ");
            stringBuffer.append("TASKHOLDER=");
            stringBuffer.append(this.lazyTaskHolder);
            stringBuffer.append(", ");
            stringBuffer.append("BINDTA=");
            stringBuffer.append(this.binaryData);
            stringBuffer.append(", ");
            stringBuffer.append("QOS=");
            stringBuffer.append(this.QOS);
            stringBuffer.append(", ");
            stringBuffer.append("DIRTY=");
            stringBuffer.append(this.isDirty());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return super.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AbstractTask)) {
            return super.equals(object);
        }
        AbstractTask abstractTask = (AbstractTask)object;
        return super.equals(object) && abstractTask.AUTOPURGE == this.AUTOPURGE && abstractTask.FAILUREACTION == this.FAILUREACTION && (abstractTask.lazyTaskHolder == null && this.lazyTaskHolder == null || abstractTask.lazyTaskHolder.equals(this.lazyTaskHolder)) && abstractTask.MAXATTEMPTS == this.MAXATTEMPTS && abstractTask.MAXREPEATS == this.MAXREPEATS && abstractTask.PARTITION == this.PARTITION && abstractTask.QOS == this.QOS && (abstractTask.REPEATINTERVAL == null && this.REPEATINTERVAL == null || abstractTask.REPEATINTERVAL.equals(this.REPEATINTERVAL)) && abstractTask.ROW_VERSION == this.ROW_VERSION && (abstractTask.STARTBYINTERVAL == null && this.STARTBYINTERVAL == null || abstractTask.STARTBYINTERVAL.equals(this.STARTBYINTERVAL)) && (abstractTask.STARTBYTIME == null && this.STARTBYTIME == null || abstractTask.STARTBYTIME.equals(this.STARTBYTIME)) && (abstractTask.startTimeDelta == null && this.startTimeDelta == null || abstractTask.startTimeDelta.equals(this.startTimeDelta)) && abstractTask.TASKCANCELLED == this.TASKCANCELLED && abstractTask.TASKSUSPENDED == this.TASKSUSPENDED && (abstractTask.STARTTIME == null && this.STARTTIME == null || abstractTask.STARTTIME.equals(this.STARTTIME)) && (abstractTask.VALIDTOTIME == null && this.VALIDTOTIME == null || abstractTask.VALIDTOTIME.equals(this.VALIDTOTIME)) && (abstractTask.VERSION == null && this.VERSION == null || abstractTask.VERSION.equals(this.VERSION)) && abstractTask.processingModes == this.processingModes && abstractTask.failureCount == this.failureCount;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public byte[] getUserInfo() {
        return this.getTaskHolder().getUserInfo();
    }

    public void setUserInfo(byte[] byArray) {
        this.getTaskHolder().setUserInfo(byArray);
    }

    public int getRecoveryOption() {
        return this.getTaskHolder().getRecoveryOption();
    }

    public int getTimeCalcMethod() {
        return this.getTaskHolder().getTimeCalcMethod();
    }

    public void setRecoveryOption(int n) {
        this.getTaskHolder().setRecoveryOption(n);
    }

    public void setTimeCalcMethod(int n) {
        this.getTaskHolder().setTimeCalcMethod(n);
    }

    public long getProcessingModes() {
        return this.processingModes;
    }

    public void setProcessingModes(long l) {
        this.processingModes = l;
    }

    public void preSerialize() throws SchedulerException {
        UserCalendarHolderI userCalendarHolderI;
        TaskHolderI taskHolderI = this.getTaskHolder();
        NotificationSinkHolderI notificationSinkHolderI = taskHolderI.getNotificationSinkHolder();
        if (notificationSinkHolderI != null) {
            notificationSinkHolderI.resolveHome();
        }
        if ((userCalendarHolderI = taskHolderI.getUserCalendarHolder()) != null) {
            userCalendarHolderI.resolveHome();
        }
    }

    public ThreadContextHolderI getThreadContextHolder() {
        return this.getTaskHolder().getThreadContextHolder();
    }

    public void setThreadContextHolder(ThreadContextHolderI threadContextHolderI) {
        this.getTaskHolder().setThreadContextHolder(threadContextHolderI);
    }

    public int getTaskExecutionOptions() {
        return this.getTaskHolder().getTaskExecutionOptions();
    }

    public void setTaskExecutionOptions(int n) {
        this.getTaskHolder().setTaskExecutionOptions(n);
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int n) {
        this.failureCount = n;
    }

    public boolean isDirty() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean canRun() {
        return super.canRun();
    }

    public void setAuthenticationAlias(String string) {
        this.getTaskHolder().setAuthenticationAlias(string);
    }

    public String getAuthenticationAlias() {
        return this.getTaskHolder().getAuthenticationAlias();
    }

    public J2EEName getJ2EEName() {
        return this.getTaskHolder().getJ2EEName();
    }

    public void setJ2EEName(J2EEName j2EEName) {
        this.getTaskHolder().setJ2EEName(j2EEName);
    }

    public static String getQOSString(int n) {
        switch (n) {
            case 2: {
                return "QOS_ATLEASTONCE";
            }
            case 1: {
                return "QOS_ONLYONCE";
            }
        }
        return "UNKNOWN(" + n + ")";
    }

    public void setStatus(int n) {
        super.setStatus(n);
        this.setRunning(n == 5);
    }

    public int getExpectedDuration() {
        return this.getTaskHolder().getExpectedDuration();
    }

    public void setExpectedDuration(int n) {
        this.getTaskHolder().setExpectedDuration(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.VERSION == "50" || this.VERSION == "502") {
            this.setSuspended(this.TASKSUSPENDED);
        }
    }
}

