/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.csi.DefaultComponentMetaData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.asynchbeans.Alarm;
import com.ibm.websphere.asynchbeans.EventSource;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.scheduler.MessageTaskInfo;
import com.ibm.websphere.scheduler.NotificationException;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskPending;
import com.ibm.websphere.scheduler.UserCalendarException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.WorkManagerImpl;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaDataImpl;
import com.ibm.ws.scheduler.AbstractTask;
import com.ibm.ws.scheduler.AlarmContext;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.scheduler.SchedulerDaemonImpl;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.TaskStatusImpl;
import com.ibm.ws.scheduler.TaskStore;
import com.ibm.ws.scheduler.ThreadContextHolderI;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.Scheduler;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.scheduler.spi.TaskStatus;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.cred.Credential;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ThreadPool;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.security.auth.Subject;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;

class AlarmListener
implements com.ibm.websphere.asynchbeans.AlarmListener {
    private static final TraceComponent tc = Tr.register(AlarmListener.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    SchedulerDaemonImpl daemon;
    TransactionControl tranControl;
    private static final ComponentMetaDataAccessorImpl cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeTaskWithNotification(Scheduler scheduler, TaskInfo taskInfo, Date date, boolean bl) throws NotificationException, Throwable {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "About to run work.");
        }
        Throwable throwable = null;
        long l = System.currentTimeMillis();
        try {
            scheduler.fireNotification(taskInfo, taskInfo.getStatus(), 512, false);
        }
        catch (NotificationException notificationException) {
            FFDCFilter.processException((Throwable)notificationException, "com.ibm.ws.scheduler.AlarmListener.executeTaskWithNotification", "330", this);
            Tr.error(tc, "SCHD0076E", new Object[]{this.daemon.getScheduler().getSchedulerConfiguration().getName(), this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), "FIRING", taskInfo.getTaskId(), notificationException.getLocalizedMessage()});
            throw notificationException;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            final Runnable runnable = taskInfo.getTargetRunnable();
            TaskStatusImpl taskStatusImpl = new TaskStatusImpl(taskInfo);
            runnable.setTaskStatus(taskStatusImpl);
            String string = taskInfo.getAuthenticationAlias();
            if (string != null && string.length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication alias is: " + string);
                }
                object3 = Utils.getAuthDataCredentialFromAlias(string);
                object2 = ContextManagerFactory.getInstance();
                object = ((Credential)object3).getRealm();
                if (object == null || ((String)object).length() == 0) {
                    object = object2.getDefaultRealm();
                }
                Subject subject = object2.login((String)object, ((Credential)object3).getUserName(), ((Credential)object3).getPassword());
                if (taskInfo instanceof MessageTaskInfo) {
                    ((MessageTaskInfo)((Object)taskInfo)).setUsername(((Credential)object3).getUserName());
                    ((MessageTaskInfo)((Object)taskInfo)).setPassword(((Credential)object3).getPassword());
                }
                object2.runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            runnable.doWork();
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof Exception) {
                                throw (Exception)throwable;
                            }
                            throw new Exception(throwable.getLocalizedMessage(), throwable);
                        }
                        return null;
                    }
                });
            } else {
                runnable.doWork();
            }
            if (!bl && (object2 = (object3 = TransactionManagerFactory.getUOWCurrent()).getUOWCoord()).getRollbackOnly()) {
                object = new RollbackTransaction("Global transaction was marked rollback-only.");
                ((RollbackTransaction)object).silent = true;
                throw object;
            }
        }
        catch (Throwable throwable2) {
            if (throwable2 instanceof PrivilegedActionException) {
                throw throwable2.getCause();
            }
            throwable = throwable2;
        }
        int n = (int)(System.currentTimeMillis() - l);
        int n2 = (int)((l - date.getTime()) / 1000L);
        this.daemon.taskCompleted(n2, n);
        if (throwable == null) {
            try {
                scheduler.fireNotification(taskInfo, taskInfo.getStatus(), 64, false);
                return;
            }
            catch (NotificationException notificationException) {
                FFDCFilter.processException((Throwable)notificationException, "com.ibm.ws.scheduler.AlarmListener.executeTaskWithNotification", "340", this);
                Tr.error(tc, "SCHD0076E", new Object[]{this.daemon.getScheduler().getSchedulerConfiguration().getName(), this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), "FIRED", taskInfo.getTaskId(), notificationException.getLocalizedMessage()});
                if (bl) return;
                throw notificationException;
            }
        }
        try {
            scheduler.fireNotification(taskInfo, taskInfo.getStatus(), 128, true);
            throw throwable;
        }
        catch (NotificationException notificationException) {
            FFDCFilter.processException((Throwable)notificationException, "com.ibm.ws.scheduler.AlarmListener.executeTaskWithNotification", "360", this);
            Tr.error(tc, "SCHD0076E", new Object[]{this.daemon.getScheduler().getSchedulerConfiguration().getName(), this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), "FIRE_FAILED", taskInfo.getTaskId(), notificationException.getLocalizedMessage()});
            if (bl) throw throwable;
            throw notificationException;
        }
        finally {
            this.daemon.taskFailed();
        }
    }

    private TaskInfo processNextTaskState(Scheduler scheduler, TaskInfo taskInfo, Date date) throws UserCalendarException {
        int n;
        boolean bl = tc.isDebugEnabled();
        if (!taskInfo.getCancelled() && !taskInfo.getSuspended() && (n = taskInfo.getRepeatsLeft()) > 0) {
            taskInfo.setRepeatsLeft(--n);
        }
        if (taskInfo.getRepeatsLeft() != 0) {
            Date date2 = scheduler.getNextFireTime(taskInfo, date);
            if (date2 != null) {
                taskInfo.setNextFireTime(date2);
            } else {
                taskInfo.setNumberOfRepeats(0);
                if (bl) {
                    Tr.debug(tc, "The UserCalendar returned a null date.  Completing the task.");
                }
            }
        }
        return taskInfo;
    }

    private Date getStartByTime(Scheduler scheduler, TaskInfo taskInfo, Date date) throws UserCalendarException, RollbackTransaction {
        boolean bl = tc.isDebugEnabled();
        String string = taskInfo.getStartByInterval();
        Date date2 = taskInfo.getStartByTime();
        if (date2 == null) {
            if (string != null) {
                if ((taskInfo.getProcessingModes() & 1L) == 0L) {
                    date2 = scheduler.applyUserCalendar(taskInfo, string, date);
                    if (date2 == null) {
                        throw new RollbackTransaction(Messages.getMessage("SCHD0067E"));
                    }
                } else if (bl) {
                    Tr.debug(tc, "Ignoring StartByInterval");
                }
            }
        } else {
            taskInfo.setStartByTime(null);
        }
        return date2;
    }

    private boolean validateStartByTime(TaskInfo taskInfo, Date date, boolean bl, Date date2) throws NotificationException {
        boolean bl2 = tc.isDebugEnabled();
        if (date2 != null && date2.before(date)) {
            block4: {
                if (bl2) {
                    Tr.debug(tc, "Firing FIRE_DELAYED");
                }
                try {
                    this.daemon.getScheduler().fireNotification(taskInfo, taskInfo.getStatus(), 256, false);
                }
                catch (NotificationException notificationException) {
                    FFDCFilter.processException((Throwable)notificationException, "com.ibm.ws.scheduler.AlarmListener.TaskWork.doWork", "290", this);
                    Tr.error(tc, "SCHD0076E", new Object[]{this.daemon.getScheduler().getSchedulerConfiguration().getName(), this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), "FIRE_DELAYED", taskInfo.getTaskId(), notificationException.getLocalizedMessage()});
                    if (bl) break block4;
                    throw notificationException;
                }
            }
            return false;
        }
        return true;
    }

    private void updateTask(Connection connection, TaskStore taskStore, TaskInfo taskInfo, boolean bl) throws Throwable {
        TxHandle txHandle = null;
        try {
            if (bl) {
                txHandle = this.tranControl.preinvoke(true, false);
                connection = taskStore.getDBHelper().getConnection(txHandle, 2, false);
            }
            switch (taskInfo.getStatus()) {
                case 0: {
                    taskStore.create(connection, taskInfo);
                    break;
                }
                case -1: {
                    taskStore.remove(connection, taskInfo);
                    break;
                }
                default: {
                    taskStore.update(connection, taskInfo);
                }
            }
            this.handleUpdateCommit(connection, taskStore, bl, txHandle);
        }
        catch (Throwable throwable) {
            this.handleUpdateException(throwable, connection, taskStore, bl, txHandle);
            throw throwable;
        }
    }

    private void fireResultNotification(Scheduler scheduler, TaskInfo taskInfo, boolean bl) throws NotificationException {
        block9: {
            String string = "UNKNOWN";
            int n = taskInfo.getStatus();
            try {
                switch (n) {
                    case -1: {
                        string = "PURGED";
                        scheduler.fireNotification(taskInfo, 4, 16, false);
                        scheduler.fireNotification(taskInfo, -1, 2, false);
                        break;
                    }
                    case 4: {
                        string = "COMPLETE";
                        scheduler.fireNotification(taskInfo, 4, 16, false);
                        break;
                    }
                    case 3: {
                        string = "CANCELLED";
                        scheduler.fireNotification(taskInfo, 3, 32, false);
                        break;
                    }
                    case 1: {
                        string = "SCHEDULED";
                        scheduler.fireNotification(taskInfo, 1, 1, false);
                        break;
                    }
                    case 2: {
                        string = "SUSPENDED";
                        scheduler.fireNotification(taskInfo, 2, 4, false);
                        break;
                    }
                }
            }
            catch (NotificationException notificationException) {
                FFDCFilter.processException((Throwable)notificationException, "com.ibm.ws.scheduler.AlarmListener.fireNotification", "520", this);
                Tr.error(tc, "SCHD0076E", new Object[]{this.daemon.getScheduler().getSchedulerConfiguration().getName(), this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), string, taskInfo.getTaskId(), notificationException.getLocalizedMessage()});
                if (bl) break block9;
                throw notificationException;
            }
        }
    }

    protected int getNextState(TaskInfo taskInfo) {
        int n;
        boolean bl = tc.isDebugEnabled();
        if (taskInfo.getRepeatsLeft() == 0) {
            if (taskInfo.getAutoPurge()) {
                if (bl) {
                    Tr.debug(tc, "Purging task");
                }
                n = -1;
            } else {
                if (bl) {
                    Tr.debug(tc, "Completing task");
                }
                n = 4;
            }
        } else if (taskInfo.getCancelled() || taskInfo.getSuspended()) {
            if (bl) {
                Tr.debug(tc, "Task is suspended.");
            }
            n = 2;
        } else {
            if (bl) {
                Tr.debug(tc, "Scheduling task");
            }
            n = 1;
        }
        return n;
    }

    protected void handleUpdateCommit(Connection connection, TaskStore taskStore, boolean bl, TxHandle txHandle) {
        if (bl) {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.AlarmListener.handleUpdateCommit", "660", this);
            }
            try {
                this.tranControl.postinvoke(txHandle);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.AlarmListener.handleUpdateCommit", "670", this);
            }
            try {
                taskStore.getDBHelper().returnConnection(connection);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.AlarmListener.handleUpdateCommit", "680", this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateException(Throwable throwable, Connection connection, TaskStore taskStore, boolean bl, TxHandle txHandle) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleUpdateException", new Object[]{throwable, txHandle});
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.AlarmListener.handleUpdateException", "700", this);
            try {
                if (!bl) break block12;
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.AlarmListener.handleUpdateException", "730", this);
                    }
                }
                try {
                    this.tranControl.postinvoke(txHandle);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.AlarmListener.handleUpdateException", "740", this);
                }
                try {
                    taskStore.getDBHelper().returnConnection(connection);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.AlarmListener.handleUpdateException", "750", this);
                }
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleUpdateException");
                }
            }
        }
    }

    public AlarmListener() {
    }

    public AlarmListener(SchedulerDaemonImpl schedulerDaemonImpl, TransactionControl transactionControl) {
        this.daemon = schedulerDaemonImpl;
        this.tranControl = transactionControl;
    }

    public void fired(Alarm alarm) {
        AlarmContext alarmContext = (AlarmContext)alarm.getContext();
        TaskInfo taskInfo = alarmContext.getAbstractTask();
        int n = taskInfo.getExpectedDuration();
        long l = SchedulerServiceImpl._instance.getHungThreadThreshold();
        if (n == Integer.MAX_VALUE || (long)n > l) {
            Thread thread = Thread.currentThread();
            if (thread instanceof ThreadPool.WorkerThread) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Disabling hang detection: Task=" + taskInfo.getTaskId() + ", expDuration=" + n + ", hangThreshold=" + l);
                }
                ((ThreadPool.WorkerThread)((Object)thread)).disableHangDetectionForCurrentDispatch();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "THIS IS NOT A ThreadPool.WorkerThread!");
            }
        }
        this.fireTask(alarmContext.getTaskStore(), alarmContext.getWorkManager(), taskInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTask(TaskStore taskStore, WorkManager workManager, TaskInfo taskInfo) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "fireTask", taskInfo);
        }
        String string = taskInfo.getTaskId();
        try {
            EventSource eventSource = ((WorkManagerImpl)workManager).createEventSource();
            AsynchContextDescriptor asynchContextDescriptor = ((WorkManagerImpl)workManager).getContextDescriptor();
            ComponentMetaDataAccessorImpl componentMetaDataAccessorImpl = null;
            try {
                if (!this.daemon.isTaskRunning(string)) {
                    J2EEName j2EEName = taskInfo.getJ2EEName();
                    int n = 1;
                    if (j2EEName != null) {
                        n = this.daemon.appTracker.getAvailability(this.daemon.daemonCoordinator, j2EEName, string);
                    }
                    if (n == 1) {
                        Object object;
                        this.daemon.setTaskRunning(string);
                        this.daemon.setThreadRunning(Thread.currentThread().getName(), taskInfo);
                        if (bl2) {
                            Tr.debug(tc, "Running task: " + taskInfo);
                        }
                        TaskWork taskWork = new TaskWork(taskStore, taskInfo);
                        ThreadContextHolderI threadContextHolderI = taskInfo.getThreadContextHolder();
                        if (threadContextHolderI != null) {
                            threadContextHolderI.getExecutionContext().go(eventSource, asynchContextDescriptor, taskWork);
                        } else {
                            object = DefaultComponentMetaData.getInstance();
                            if (componentMetaDataAccessorImpl == null) {
                                componentMetaDataAccessorImpl = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
                            }
                            componentMetaDataAccessorImpl.beginContext((ComponentMetaData)object);
                            taskWork.run();
                        }
                        object = taskWork.getThrowable();
                        if (object != null) {
                            throw object;
                        }
                    } else if (n == 2) {
                        if (bl2) {
                            Tr.debug(tc, "Unable to fire task...APPLICATION_UNAVAILABLE");
                        }
                        Tr.warning(tc, "SCHD0103W", new Object[]{this.daemon.daemonCoordinator.schedConfig.getName(), this.daemon.daemonCoordinator.schedConfig.getJndiName(), string, j2EEName});
                    } else if (n == 3) {
                        if (bl2) {
                            Tr.debug(tc, "Unable to fire task...APPLICATION_STILL_UNAVAILABLE");
                        }
                    } else if (bl2) {
                        Tr.debug(tc, "ApplicationTracker returned an unexpected status: " + n);
                    }
                } else if (bl2) {
                    Tr.debug(tc, "Task already running.  Skipping: " + string);
                }
            }
            finally {
                if (componentMetaDataAccessorImpl != null) {
                    componentMetaDataAccessorImpl.endContext();
                }
                if (bl2) {
                    Tr.debug(tc, "Result Task : " + taskInfo);
                }
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "SCHD0063E", new Object[]{string, this.daemon.getScheduler().getSchedulerConfiguration().getName(), this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), Utils.getExceptionMessageWithType(throwable)});
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.AlarmListener.TaskWork.fireTask", "1785", this);
        }
        finally {
            this.daemon.setThreadStopped(Thread.currentThread().getName());
            if (bl) {
                Tr.exit(tc, "fireTask");
            }
        }
    }

    protected String getTranStatus(int n) {
        switch (n) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxHandle startGlobalTransaction(int n, CustomContainerComponentMetaData customContainerComponentMetaData) throws SystemException, NotSupportedException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "startGlobalTransaction", new Object[]{new Integer(n)});
        }
        try {
            Object object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting the transaction timeout: " + n + " seconds.");
            }
            CustomContainerComponentMetaData.CustomGlobalTranCfg customGlobalTranCfg = customContainerComponentMetaData.getCustomGlobalTranConfigData();
            customGlobalTranCfg.setTransactionTimeout(n);
            TxHandle txHandle = this.tranControl.preinvoke(false, true);
            if (tc.isDebugEnabled()) {
                object = TransactionManagerFactory.getUOWCurrent();
                UOWCoordinator uOWCoordinator = object.getUOWCoord();
                byte[] byArray = uOWCoordinator.getTID();
                String string = Util.toHexString(byArray).toUpperCase();
                Tr.debug(tc, "Started Tx: " + string);
            }
            object = txHandle;
            return object;
        }
        finally {
            if (bl) {
                Tr.exit(tc, "startGlobalTransaction");
            }
        }
    }

    static {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Loading AlarmListener.class");
        }
    }

    class TaskWork
    implements Work {
        boolean isEntryEnabled = AlarmListener.access$000().isEntryEnabled();
        boolean isDebugEnabled = AlarmListener.access$000().isDebugEnabled();
        TaskStore store = null;
        TaskInfo task = null;
        Throwable t = null;

        public TaskWork(TaskStore taskStore, TaskInfo taskInfo) {
            this.store = taskStore;
            this.task = taskInfo;
        }

        public void run() {
            try {
                this.doWork();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.AlarmListener#TaskWork.run", "45", this);
                this.t = throwable;
            }
        }

        public void doWork() {
            TaskInfo taskInfo;
            TaskInfo taskInfo2;
            boolean bl;
            boolean bl2;
            long l;
            String string;
            Connection connection;
            int n;
            boolean bl3;
            block65: {
                boolean bl4;
                TxHandle txHandle;
                block64: {
                    Scheduler scheduler;
                    Throwable throwable;
                    block63: {
                        boolean bl5;
                        block62: {
                            if (this.isEntryEnabled) {
                                Tr.entry(tc, "doWork");
                            }
                            bl3 = true;
                            throwable = null;
                            n = 0;
                            txHandle = null;
                            connection = null;
                            string = this.task.getTaskId();
                            bl5 = (this.task.getTaskExecutionOptions() & 1) != 0;
                            bl4 = this.task.getQOS() == 2;
                            scheduler = AlarmListener.this.daemon.getScheduler();
                            l = System.currentTimeMillis();
                            Date date = new Date(l);
                            Date date2 = this.task.getStartByTime();
                            Date date3 = this.task.getNextFireTime();
                            bl2 = false;
                            bl = false;
                            taskInfo2 = null;
                            taskInfo = this.task;
                            try {
                                boolean bl6;
                                taskInfo2 = (TaskInfo)this.task.clone();
                                if (this.isDebugEnabled) {
                                    Tr.debug(tc, "Firing alarm on task " + this.task.getTaskId());
                                    Tr.debug(tc, "       scheduler:    " + AlarmListener.this.daemon.getScheduler());
                                    Tr.debug(tc, "       nextFire:     " + date3);
                                    Tr.debug(tc, "       repeatsLeft:  " + this.task.getRepeatsLeft());
                                    Tr.debug(tc, "       currentState: " + TaskStatusImpl.getStatusAsString(this.task.getStatus()));
                                    Tr.debug(tc, "       QOS:          " + AbstractTask.getQOSString(this.task.getQOS()));
                                    Tr.debug(tc, "       useDelayUpd:  " + bl5);
                                    Tr.debug(tc, this.task.toString());
                                }
                                if (!((TaskStatusImpl)((Object)this.task)).canRun()) {
                                    if (this.isDebugEnabled) {
                                        Tr.debug(tc, "No repeats left.  Aborting.");
                                    }
                                    return;
                                }
                                CustomContainerComponentMetaDataImpl customContainerComponentMetaDataImpl = new CustomContainerComponentMetaDataImpl(cmda.getComponentMetaData());
                                CustomContainerComponentMetaData.CustomLocalTranCfg customLocalTranCfg = customContainerComponentMetaDataImpl.getCustomLocalTranConfigData();
                                customLocalTranCfg.setValueBoundary(0);
                                customLocalTranCfg.setValueResolver(0);
                                customLocalTranCfg.setValueUnresolvedAction(0);
                                CustomContainerComponentMetaData.CustomResRefList customResRefList = customContainerComponentMetaDataImpl.getCustomResourceRefList();
                                customResRefList.addResRef("Scheduler Custom JDBC Res-Ref", scheduler.getSchedulerConfiguration().getDataSourceJndiName(), scheduler.getSchedulerConfiguration().getDataSourceJndiName(), "javax.resource.cci.ConnectionFactory", 1, 0, 2);
                                cmda.beginContext(customContainerComponentMetaDataImpl);
                                bl = true;
                                if (!bl4) {
                                    if (this.isDebugEnabled) {
                                        Tr.debug(tc, "Starting a global transaction");
                                    }
                                    txHandle = AlarmListener.this.startGlobalTransaction(this.task.getExpectedDuration(), customContainerComponentMetaDataImpl);
                                    connection = this.store.getDBHelper().getConnection(txHandle, 2, false);
                                }
                                boolean bl7 = bl6 = bl5 || bl4;
                                if (bl6) {
                                    if (this.isDebugEnabled) {
                                        if (bl5) {
                                            Tr.debug(tc, "Using SCHED_EXECUTION_DELAYEDUPDATE");
                                        } else {
                                            Tr.debug(tc, "Updating task in QOS_ATLEASTONCE mode.");
                                        }
                                    }
                                    this.task.setRunning(true);
                                    AlarmListener.this.updateTask(connection, this.store, this.task, bl4);
                                    taskInfo = taskInfo2;
                                } else if (this.isDebugEnabled) {
                                    Tr.debug(tc, "Using SCHED_EXECUTION_OPTIMIZED");
                                }
                                date2 = AlarmListener.this.getStartByTime(scheduler, this.task, date3);
                                AlarmListener.this.processNextTaskState(scheduler, this.task, date);
                                if (!bl6) {
                                    ((TaskStatus)((Object)this.task)).setStatus(AlarmListener.this.getNextState(this.task));
                                    if (bl4) {
                                        this.task.setRunning(true);
                                    }
                                    AlarmListener.this.updateTask(connection, this.store, this.task, bl4);
                                    taskInfo = this.task;
                                }
                                if (AlarmListener.this.validateStartByTime(this.task, date, bl4, date2)) {
                                    AlarmListener.this.executeTaskWithNotification(scheduler, this.task, date3, bl4);
                                } else if (this.isDebugEnabled) {
                                    Tr.debug(tc, "Work is being skipped.  It was suspended, cancelled, etc.");
                                }
                            }
                            catch (Throwable throwable2) {
                                bl3 = false;
                                if (throwable2 instanceof TaskInvalid || throwable2 instanceof TaskPending) {
                                    AlarmListener.this.daemon.taskCollided();
                                    bl2 = true;
                                    if (this.isDebugEnabled) {
                                        Tr.debug(tc, "Collision exception detected for TaskID=" + string + "," + this.task.getRowVersion(), throwable2);
                                    }
                                }
                                FFDCFilter.processException(throwable2, "com.ibm.ws.scheduler.AlarmListener.TaskWork.fireTask", "390", this);
                                if (throwable2 instanceof RollbackTransaction) {
                                    if (!((RollbackTransaction)throwable2).silent) {
                                        Tr.error(tc, "SCHD0063E", new Object[]{string, AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getName(), AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), Utils.getExceptionMessageWithType(throwable2.getCause())});
                                    }
                                } else {
                                    Tr.error(tc, "SCHD0063E", new Object[]{string, AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getName(), AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), Utils.getExceptionMessageWithType(throwable2)});
                                }
                                if (throwable == null) {
                                    throwable = throwable2.getCause();
                                    n = AlarmListener.this.daemon.daemonCoordinator.setTaskFailure(string, throwable2.getCause());
                                }
                                if (!this.isDebugEnabled) break block62;
                                Tr.debug(tc, "Task Failure Exception detected for TaskID=" + string + "," + this.task.getRowVersion() + ". TotalFailures=" + n, throwable2);
                            }
                        }
                        this.task.setRunning(false);
                        if (!bl2 && (bl5 && bl3 || bl4)) {
                            try {
                                if (bl3) {
                                    if (this.isDebugEnabled) {
                                        Tr.debug(tc, "Updating the result of the task in the database.");
                                    }
                                    ((TaskStatus)((Object)this.task)).setStatus(AlarmListener.this.getNextState(this.task));
                                    AlarmListener.this.updateTask(connection, this.store, this.task, bl4);
                                    taskInfo = this.task;
                                } else {
                                    if (this.isDebugEnabled) {
                                        Tr.debug(tc, "Updating the PREVIOUS result of the task in the database.");
                                    }
                                    taskInfo2.setRowVersion(this.task.getRowVersion());
                                    AlarmListener.this.updateTask(null, this.store, taskInfo2, true);
                                    taskInfo = taskInfo2;
                                }
                            }
                            catch (Throwable throwable3) {
                                FFDCFilter.processException(throwable3, "com.ibm.ws.scheduler.AlarmListener.TaskWork.doWork", "1180", this);
                                if (throwable3 instanceof TaskPending || throwable3 instanceof TaskInvalid) {
                                    AlarmListener.this.daemon.taskCollided();
                                    bl2 = true;
                                    if (this.isDebugEnabled) {
                                        Tr.debug(tc, "TaskPending Exception detected when rescheduling on failure for TaskID=" + string + "," + taskInfo2.getRowVersion() + ", totTaskFailures=" + n, throwable3);
                                    }
                                    if (SchedulerServiceImpl._instance.getTaskIDFromTaskInfoImplementation(this.task.getClass()) != 8448) {
                                        Tr.warning(tc, "SCHD0057W", new Object[]{string, AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getName(), AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getJndiName()});
                                    }
                                } else {
                                    Tr.warning(tc, "SCHD0057W", new Object[]{string, AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getName(), AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getJndiName()});
                                    Tr.error(tc, "SCHD0007E", throwable3);
                                    if (this.isDebugEnabled) {
                                        Tr.debug(tc, "Unexpected Exception detected while updating the task.", throwable3);
                                    }
                                    bl3 = false;
                                }
                                if (throwable != null) break block63;
                                throwable = throwable3;
                                n = AlarmListener.this.daemon.daemonCoordinator.setTaskFailure(string, throwable3);
                            }
                        }
                    }
                    if (bl3) {
                        try {
                            AlarmListener.this.fireResultNotification(scheduler, this.task, bl4);
                        }
                        catch (NotificationException notificationException) {
                            FFDCFilter.processException((Throwable)notificationException, "com.ibm.ws.scheduler.AlarmListener.TaskWork.doWork", "1185", this);
                            bl3 = false;
                            if (throwable != null) break block64;
                            throwable = notificationException;
                            n = AlarmListener.this.daemon.daemonCoordinator.setTaskFailure(string, notificationException);
                        }
                    }
                }
                AlarmListener.this.daemon.setTaskStopped(string);
                if (!bl4) {
                    if (bl3) {
                        try {
                            long l2 = 0L;
                            if (this.isDebugEnabled) {
                                l2 = System.currentTimeMillis();
                            }
                            AlarmListener.this.tranControl.postinvoke(txHandle);
                            if (this.isDebugEnabled) {
                                Tr.debug(tc, "Tran Commit Time= " + (System.currentTimeMillis() - l2) + "ms");
                            }
                            break block65;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.AlarmListener.TaskWork.fireTask", "440", this);
                            Tr.error(tc, "SCHD0064E", new Object[]{AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getName(), AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), throwable});
                            if (this.isDebugEnabled) {
                                Tr.debug(tc, "Exception detected during commit for Task Batch", throwable);
                            }
                            try {
                                AlarmListener.this.tranControl.handleException(txHandle);
                                break block65;
                            }
                            catch (Throwable throwable4) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.AlarmListener.TaskWork.fireTask", "450", this);
                                Tr.error(tc, "SCHD0065E", new Object[]{AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getName(), AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), throwable4});
                                if (this.isDebugEnabled) {
                                    Tr.debug(tc, "Unexpected Exception detected during rollback for Task Batch", throwable4);
                                }
                                break block65;
                            }
                        }
                    }
                    try {
                        AlarmListener.this.tranControl.handleException(txHandle);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.AlarmListener.TaskWork.fireTask", "480", this);
                        Tr.error(tc, "SCHD0065E", new Object[]{AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getName(), AlarmListener.this.daemon.getScheduler().getSchedulerConfiguration().getJndiName(), throwable});
                        if (!this.isDebugEnabled) break block65;
                        Tr.debug(tc, "Unexpected Exception detected during rollback for Task Batch", throwable);
                    }
                }
            }
            if (bl3) {
                AlarmListener.this.daemon.daemonCoordinator.clearTaskFailure(string);
                if (!bl2) {
                    if (this.isDebugEnabled) {
                        Tr.debug(tc, "Task succeeded: " + string + ".  Rescheduling.");
                    }
                    this.task.setFailureCount(0);
                    AlarmListener.this.daemon.getDaemonCoordinator().scheduleTaskAlarm(this.task);
                }
            }
            if (this.isDebugEnabled) {
                Tr.debug(tc, "Task processing complete on " + taskInfo.getTaskId());
                Tr.debug(tc, "       nextFire:     " + taskInfo.getNextFireTime());
                Tr.debug(tc, "       repeatsLeft:  " + taskInfo.getRepeatsLeft());
                Tr.debug(tc, "       timetorun:    " + (System.currentTimeMillis() - l) + "ms");
                Tr.debug(tc, "       nextState:    " + TaskStatusImpl.getStatusAsString(taskInfo.getStatus()));
                Tr.debug(tc, taskInfo.toString());
            }
            if (!bl3 && n == 1 && !bl2) {
                if (this.isDebugEnabled) {
                    Tr.debug(tc, "Task failed: " + string + ".  Rescheduling.  totTaskFailures is: " + n);
                }
                AlarmListener.this.daemon.getDaemonCoordinator().scheduleTaskAlarm(taskInfo2);
            }
            try {
                this.store.getDBHelper().returnConnection(connection);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.AlarmListener.TaskWork.doWork", "419", this);
            }
            if (bl) {
                cmda.endContext();
            }
            if (this.isEntryEnabled) {
                Tr.exit(tc, "doWork");
            }
        }

        public void release() {
        }

        public Throwable getThrowable() {
            return this.t;
        }
    }

    class RollbackTransaction
    extends Exception {
        private static final long serialVersionUID = 1487006269277521598L;
        public boolean silent;

        public RollbackTransaction() {
            this.silent = false;
        }

        public RollbackTransaction(String string) {
            super(string);
            this.silent = false;
        }

        public RollbackTransaction(Throwable throwable) {
            super(throwable);
            this.silent = false;
        }

        public RollbackTransaction(String string, Throwable throwable) {
            super(string, throwable);
            this.silent = false;
        }
    }
}

