/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.scheduler.ApplicationStateListener;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ApplicationTracker
implements DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(ApplicationTracker.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private Map inactiveAppsToModules = new HashMap();
    private Map activeAppsToModules = new HashMap();
    private WriterPriorityReadersWriterLock activeAppsToModulesLock = new WriterPriorityReadersWriterLock();
    private Set listenerInfos = new HashSet();
    public static final int APPLICATION_AVAILABLE = 1;
    public static final int APPLICATION_UNAVAILABLE = 2;
    public static final int APPLICATION_STILL_UNAVAILABLE = 3;

    public int getAvailability(ApplicationStateListener applicationStateListener, J2EEName j2EEName, Object object) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getAvailability", new Object[]{applicationStateListener, j2EEName, object});
        }
        if (j2EEName == null) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "j2eeName"));
        }
        if (applicationStateListener == null) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "asListener"));
        }
        if (object == null) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "J2EEhandleName"));
        }
        boolean bl2 = this.isAvailable(j2EEName);
        if (bl2) {
            if (bl) {
                Tr.exit(tc, "getAvailability", new Object[]{"APPLICATION_AVAILABLE"});
            }
            return 1;
        }
        if (this.addHandle(applicationStateListener, j2EEName, object)) {
            if (bl) {
                Tr.exit(tc, "getAvailability", new Object[]{"APPLICATION_UNAVAILABLE"});
            }
            return 2;
        }
        if (bl) {
            Tr.exit(tc, "getAvailability", new Object[]{"APPLICATION_STILL_UNAVAILABLE"});
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApplicationStateListener(ApplicationStateListener applicationStateListener, Class clazz) {
        Set set = this.listenerInfos;
        synchronized (set) {
            return this.listenerInfos.add(new ListenerInfo(applicationStateListener, clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeApplicationStateListener(ApplicationStateListener applicationStateListener) {
        Set set = this.listenerInfos;
        synchronized (set) {
            return this.listenerInfos.remove(applicationStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addHandle(ApplicationStateListener applicationStateListener, J2EEName j2EEName, Object object) {
        String string = j2EEName.getApplication();
        String string2 = j2EEName.getModule();
        Map map = this.inactiveAppsToModules;
        synchronized (map) {
            HashSet<ApplicationStateListener> hashSet;
            HashMap<Object, HashSet<ApplicationStateListener>> hashMap;
            HashMap hashMap2 = (HashMap)this.inactiveAppsToModules.get(string);
            if (hashMap2 == null) {
                hashMap2 = new HashMap(1);
                this.inactiveAppsToModules.put(string, hashMap2);
            }
            if ((hashMap = (HashMap<Object, HashSet<ApplicationStateListener>>)hashMap2.get(string2)) == null) {
                hashMap = new HashMap<Object, HashSet<ApplicationStateListener>>(1);
                hashMap2.put(string2, hashMap);
            }
            if ((hashSet = (HashSet<ApplicationStateListener>)hashMap.get(object)) == null) {
                hashSet = new HashSet<ApplicationStateListener>(1);
                hashMap.put(object, hashSet);
            }
            return hashSet.add(applicationStateListener);
        }
    }

    protected boolean isAvailable(J2EEName j2EEName) {
        boolean bl;
        block3: {
            String string = j2EEName.getApplication();
            String string2 = j2EEName.getModule();
            bl = true;
            try {
                this.activeAppsToModulesLock.startReading();
                Set set = (Set)this.activeAppsToModules.get(string);
                if (set == null || !set.contains(string2)) {
                    bl = false;
                }
                this.activeAppsToModulesLock.stopReading();
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.ApplicationTracker.isAvailable", "220", this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Interrupted waiting for activeAppsToModulesLock");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setModuleAvailable(String string, String string2) {
        Object object;
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "setApplicationAvailable", new Object[]{string, string2});
        }
        try {
            this.activeAppsToModulesLock.startWriting();
            object = (HashSet<String>)this.activeAppsToModules.get(string);
            if (object == null) {
                object = new HashSet<String>(1);
                this.activeAppsToModules.put(string, object);
            }
            object.add(string2);
            this.activeAppsToModulesLock.stopWriting();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.ApplicationTracker.setModuleAvailable", "250", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Interrupted waiting for activeAppsToModulesLock");
            }
            if (bl) {
                Tr.exit(tc, "setApplicationAvailable", interruptedException);
            }
            return;
        }
        object = this.inactiveAppsToModules;
        synchronized (object) {
            Map map = (Map)this.inactiveAppsToModules.get(string);
            if (map != null) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Map.Entry entry;
                HashMap hashMap = new HashMap();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    object5 = (String)entry.getKey();
                    if (string2 != null && !((String)object5).equals(string2) || (object4 = (Map)entry.getValue()) == null) continue;
                    object3 = object4.entrySet().iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        Object k = object2.getKey();
                        Set set = (Set)object2.getValue();
                        if (set == null) continue;
                        Iterator iterator2 = set.iterator();
                        while (iterator2.hasNext()) {
                            ApplicationStateListener applicationStateListener = (ApplicationStateListener)iterator2.next();
                            HashSet hashSet = (HashSet)hashMap.get(applicationStateListener);
                            if (hashSet == null) {
                                hashSet = new HashSet(1);
                                hashMap.put(applicationStateListener, hashSet);
                            }
                            hashSet.add(k);
                        }
                    }
                }
                iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    object5 = (ApplicationStateListener)entry.getKey();
                    object4 = (Set)entry.getValue();
                    if (object4 == null) continue;
                    object3 = this.getListenerInfo((ApplicationStateListener)object5);
                    if (object3 != null && ((ListenerInfo)object3).handleType != null) {
                        object2 = Array.newInstance(((ListenerInfo)object3).handleType, object4.size());
                        object4.toArray((T[])object2);
                    } else {
                        object2 = object4.toArray();
                    }
                    object5.applicationAvailable((Object[])object2);
                }
            }
            this.inactiveAppsToModules.remove(string);
        }
        if (bl) {
            Tr.exit(tc, "setApplicationAvailable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerInfo getListenerInfo(ApplicationStateListener applicationStateListener) {
        Set set = this.listenerInfos;
        synchronized (set) {
            Iterator iterator = this.listenerInfos.iterator();
            while (iterator.hasNext()) {
                ListenerInfo listenerInfo = (ListenerInfo)iterator.next();
                if (applicationStateListener.hashCode() != listenerInfo.hashCode()) continue;
                return listenerInfo;
            }
            return null;
        }
    }

    private void setModuleUnavailable(String string, String string2) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "setModuleUnavailable", new Object[]{string, string2});
        }
        try {
            this.activeAppsToModulesLock.startWriting();
            Set set = (Set)this.activeAppsToModules.get(string);
            if (set != null) {
                set.remove(string2);
            }
            this.activeAppsToModulesLock.stopWriting();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.ApplicationTracker.setModuleUnavailable", "400", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Interrupted waiting for activeAppsToModulesLock");
            }
            if (bl) {
                Tr.exit(tc, "setModuleUnavailable", interruptedException);
            }
            return;
        }
        if (bl) {
            Tr.exit(tc, "setModuleUnavailable");
        }
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        block6: {
            boolean bl = tc.isDebugEnabled();
            try {
                DeployedObject deployedObject;
                if (deployedObjectEvent.getNewValue() == "STARTED") {
                    DeployedObject deployedObject2 = deployedObjectEvent.getDeployedObject();
                    if (deployedObject2 instanceof DeployedModule) {
                        DeployedModule deployedModule = (DeployedModule)deployedObject2;
                        String string = deployedModule.getDeployedApplication().getName();
                        String string2 = deployedModule.getName();
                        this.setModuleAvailable(string, string2);
                    }
                } else if (deployedObjectEvent.getNewValue() == "STOPPING" && (deployedObject = deployedObjectEvent.getDeployedObject()) instanceof DeployedModule) {
                    DeployedModule deployedModule = (DeployedModule)deployedObject;
                    String string = deployedModule.getDeployedApplication().getName();
                    String string3 = deployedModule.getName();
                    this.setModuleUnavailable(string, string3);
                }
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.ApplicationTracker.stateChanged", "390", this);
                if (!bl) break block6;
                Tr.debug(tc, "RuntimeException: ", runtimeException);
            }
        }
    }

    private class ListenerInfo {
        ApplicationStateListener asListener = null;
        Class handleType = null;

        ListenerInfo(ApplicationStateListener applicationStateListener, Class clazz) {
            this.asListener = applicationStateListener;
            this.handleType = clazz;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ListenerInfo)) {
                return false;
            }
            return this.asListener.equals(((ListenerInfo)object).asListener);
        }

        public int hashCode() {
            return this.asListener.hashCode();
        }

        public String toString() {
            return this.asListener.toString();
        }
    }
}

