/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.ByteSerializable;
import com.ibm.ws.scheduler.CreateSchedulerObjectInputStream;
import com.ibm.ws.scheduler.DoGetCL;
import com.ibm.ws.scheduler.DoSetCL;
import com.ibm.ws.scheduler.SchedulerObjectInputStream;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.exception.ByteSerializeException;
import com.ibm.ws.scheduler.resources.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ByteSerializationUtils {
    private static final TraceComponent tc = Tr.register(ByteSerializationUtils.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final byte FIELD_TYPE_OBJECT = 1;
    private static final byte FIELD_TYPE_BYTES = 2;
    private static final byte FIELD_TYPE_INT = 3;
    private static final short VER_6_0_0 = 1536;
    private static final short FLD_BYTEID_QUANTITY = 9472;
    public static final int FLDLEN_NULL = -1;
    private static final int LEN_HEADER = 6;
    private static final int LEN_HEADERFLD = 5;
    private static final int LEN_OBJECT_LENGTH = 4;

    public static byte[] getObjectAsBytes(Object object) throws ByteSerializeException {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getObjectAsBytes(Serializable)", object);
        }
        if (object == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            if (bl) {
                Tr.exit(tc, "getObjectAsBytes(Serializable)", new Object[]{ByteSerializationUtils.dumpBytes(byArray), ", L=" + (byArray == null ? -1 : byArray.length)});
            }
            return byArray;
        }
        catch (Throwable throwable) {
            throw new ByteSerializeException(throwable.getLocalizedMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getObjectFromBytes(byte[] byArray, ByteSerializable byteSerializable, J2EEName j2EEName) throws ByteSerializeException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getObjectFromBytes", new Object[]{ByteSerializationUtils.dumpBytes(byArray) + (byArray == null ? "" : ", L=" + byArray.length), byteSerializable, j2EEName});
        }
        if (byArray == null) {
            if (!bl) return null;
            Tr.exit(tc, "getObjectFromBytes", new Object[]{null});
            return null;
        }
        try {
            DoSetCL doSetCL;
            Object object2;
            Object object;
            SchedulerObjectInputStream schedulerObjectInputStream;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                schedulerObjectInputStream = (SchedulerObjectInputStream)AccessController.doPrivileged(new CreateSchedulerObjectInputStream(byteArrayInputStream));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            ClassLoader classLoader = null;
            if (j2EEName != null) {
                object = new DoGetCL();
                try {
                    classLoader = (ClassLoader)AccessController.doPrivileged(object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                object2 = SchedulerServiceImpl.instance().getClassLoader(j2EEName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using App CL: " + Utils.dumpClassLoader((ClassLoader)object2, " "));
                }
                if (object2 != null) {
                    schedulerObjectInputStream.setClassloader((ClassLoader)object2);
                    doSetCL = new DoSetCL((ClassLoader)object2);
                    try {
                        AccessController.doPrivileged(doSetCL);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The ClassLoader was not found for the appliation: " + j2EEName);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no J2EEName.  Using default classloader.");
            }
            try {
                if (byteSerializable == null) {
                    object = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException, ClassNotFoundException {
                            return schedulerObjectInputStream.readObject();
                        }
                    });
                    if (bl) {
                        Tr.exit(tc, "getObjectFromBytes", new Object[]{object});
                    }
                    object2 = object;
                    return object2;
                }
                byteSerializable.setBytes(byArray);
                if (bl) {
                    Tr.exit(tc, "getObjectFromBytes", new Object[]{byteSerializable});
                }
                object = byteSerializable;
                return object;
            }
            finally {
                if (classLoader != null) {
                    doSetCL = new DoSetCL(classLoader);
                    try {
                        AccessController.doPrivileged(doSetCL);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                schedulerObjectInputStream.close();
                byteArrayInputStream.close();
            }
        }
        catch (ByteSerializeException byteSerializeException) {
            throw byteSerializeException;
        }
        catch (Throwable throwable2) {
            throw new ByteSerializeException(Utils.getExceptionMessageWithType(throwable2), throwable2);
        }
    }

    public static int readAllbytes(byte[] byArray, int n, InputStream inputStream) throws IOException {
        int n2;
        int n3 = byArray.length;
        int n4 = n2 = inputStream.read(byArray, n, n3 - n);
        while (n4 < n3 && n2 > 0) {
            n2 = inputStream.read(byArray, n4 + n, n3 - n - n4);
            if (n2 <= 0) continue;
            n4 += n2;
        }
        return n4;
    }

    private static void writeFieldHeader(ObjectOutputStream objectOutputStream, short s, short s2) throws IOException {
        objectOutputStream.writeShort(s);
        objectOutputStream.writeShort(s2);
    }

    public static void writeFieldInt(ObjectOutputStream objectOutputStream, short s, short s2, int n) throws IOException {
        ByteSerializationUtils.writeFieldHeader(objectOutputStream, s, s2);
        objectOutputStream.writeByte(3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing int ID: 0x" + Integer.toHexString(s) + ", V=" + n);
        }
        objectOutputStream.writeInt(n);
    }

    public static void writeFieldObject(ObjectOutputStream objectOutputStream, short s, short s2, Object object) throws IOException {
        ByteSerializationUtils.writeFieldHeader(objectOutputStream, s, s2);
        objectOutputStream.writeByte(1);
        byte[] byArray = ByteSerializationUtils.getObjectAsBytes(object);
        if (byArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing Object ID: 0x" + Integer.toHexString(s) + " <null>");
            }
            objectOutputStream.writeInt(-1);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing Object ID: 0x" + Integer.toHexString(s) + ", 0x" + ByteSerializationUtils.dumpBytes(byArray) + ", L=" + byArray.length);
            }
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    public static void writeFieldByteSerializable(ObjectOutputStream objectOutputStream, short s, short s2, ByteSerializable byteSerializable) throws IOException {
        byte[] byArray;
        ByteSerializationUtils.writeFieldHeader(objectOutputStream, s, s2);
        objectOutputStream.writeByte(2);
        byte[] byArray2 = byArray = byteSerializable == null ? null : byteSerializable.getBytes();
        if (byArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing ByteSerializable ID: 0x" + Integer.toHexString(s) + " <null>");
            }
            objectOutputStream.writeInt(-1);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing ByteSerializable ID: 0x" + Integer.toHexString(s) + ", 0x" + ByteSerializationUtils.dumpBytes(byArray) + ", L=" + byArray.length);
            }
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    public static void writeFieldBytes(ObjectOutputStream objectOutputStream, short s, short s2, byte[] byArray) throws IOException {
        ByteSerializationUtils.writeFieldHeader(objectOutputStream, s, s2);
        objectOutputStream.writeByte(2);
        if (byArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing byte[] ID: 0x" + Integer.toHexString(s) + " <null>");
            }
            objectOutputStream.writeInt(-1);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing byte[] ID: 0x" + Integer.toHexString(s) + ", 0x" + ByteSerializationUtils.dumpBytes(byArray) + ", L=" + byArray.length);
            }
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    public static void writeHeader(ObjectOutputStream objectOutputStream, short s) throws IOException {
        objectOutputStream.writeShort(1536);
        objectOutputStream.writeShort(9472);
        objectOutputStream.writeShort(s);
    }

    public static Object[] getObjectByIDAndVersion(byte[] byArray, short[] sArray, short[] sArray2, J2EEName[] j2EENameArray, ByteSerializeException[] byteSerializeExceptionArray) throws ByteSerializeException {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getObjectByIDAndVersion", new Object[]{ByteSerializationUtils.dumpHexArray(sArray), ByteSerializationUtils.dumpHexArray(sArray2), j2EENameArray});
        }
        try {
            SchedulerObjectInputStream schedulerObjectInputStream;
            if (byArray == null) {
                Object[] objectArray = null;
                if (bl) {
                    Tr.exit(tc, "getObjectByIDAndVersion", objectArray);
                }
                return objectArray;
            }
            if (sArray.length != sArray2.length && sArray2.length != j2EENameArray.length) {
                throw new IllegalArgumentException("Invalid array lengths.  All must match: " + sArray.length + ", " + sArray2.length + ", " + j2EENameArray.length);
            }
            Object[] objectArray = new Object[sArray.length];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                schedulerObjectInputStream = (SchedulerObjectInputStream)AccessController.doPrivileged(new CreateSchedulerObjectInputStream(byteArrayInputStream));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            short s = schedulerObjectInputStream.readShort();
            if (s != 1536) {
                throw new ByteSerializeException(Messages.getMessage("SCHD0105E", new Object[]{"HEADER", "0x1536", "0x" + Integer.toHexString(s)}));
            }
            short s2 = schedulerObjectInputStream.readShort();
            if (s2 != 9472) {
                throw new ByteSerializeException(Messages.getMessage("SCHD0106E", new Object[]{"0x" + Integer.toHexString(9472), "0x" + Integer.toHexString(s)}));
            }
            int n = schedulerObjectInputStream.readShort();
            for (int i = 0; i < n; ++i) {
                int n2;
                s2 = schedulerObjectInputStream.readShort();
                short s3 = schedulerObjectInputStream.readShort();
                byte by = schedulerObjectInputStream.readByte();
                int n3 = ByteSerializationUtils.getIDMatchPos(sArray, s2);
                if (n3 >= 0) {
                    if (s3 != sArray2[n3]) {
                        throw new ByteSerializeException(Messages.getMessage("SCHD0105E", new Object[]{"0x" + Integer.toHexString(s2), "0x" + Integer.toHexString(sArray2[n3]), "0x" + Integer.toHexString(s3)}));
                    }
                    if (by == 2 || by == 1) {
                        n2 = schedulerObjectInputStream.readInt();
                        if (n2 == -1) {
                            objectArray[n3] = null;
                            continue;
                        }
                        objectArray[n3] = new byte[n2];
                        schedulerObjectInputStream.readFully((byte[])objectArray[n3], 0, n2);
                        if (by != 1) continue;
                        try {
                            objectArray[n3] = ByteSerializationUtils.getObjectFromBytes((byte[])objectArray[n3], null, j2EENameArray[n3]);
                        }
                        catch (RuntimeException runtimeException) {
                            if (byteSerializeExceptionArray == null) {
                                throw runtimeException;
                            }
                            objectArray[n3] = null;
                            if (runtimeException instanceof ByteSerializeException) {
                                byteSerializeExceptionArray[n3] = (ByteSerializeException)runtimeException;
                                continue;
                            }
                            byteSerializeExceptionArray[n3] = new ByteSerializeException(Utils.getExceptionMessageWithType(runtimeException), runtimeException);
                        }
                        continue;
                    }
                    if (by == 3) {
                        try {
                            objectArray[n3] = new Integer(schedulerObjectInputStream.readInt());
                        }
                        catch (RuntimeException runtimeException) {
                            if (byteSerializeExceptionArray == null) {
                                throw runtimeException;
                            }
                            objectArray[n3] = null;
                            if (runtimeException instanceof ByteSerializeException) {
                                byteSerializeExceptionArray[n3] = (ByteSerializeException)runtimeException;
                                continue;
                            }
                            byteSerializeExceptionArray[n3] = new ByteSerializeException(Utils.getExceptionMessageWithType(runtimeException), runtimeException);
                        }
                        continue;
                    }
                    throw new ByteSerializeException(Messages.getMessage("SCHD0107E", new Object[]{"0x" + Integer.toHexString(s2), "0x" + Integer.toHexString(by)}));
                }
                if (by == 2 || by == 1) {
                    n2 = schedulerObjectInputStream.readInt();
                } else if (by == 3) {
                    n2 = 4;
                } else {
                    throw new ByteSerializeException(Messages.getMessage("SCHD0107E", new Object[]{"0x" + Integer.toHexString(s2), "0x" + Integer.toHexString(by)}));
                }
                if (n2 == -1) continue;
                schedulerObjectInputStream.skip(n2);
            }
            if (bl) {
                Tr.exit(tc, "getObjectByIDAndVersion", new Object[]{ByteSerializationUtils.dumpArray(objectArray)});
            }
            return objectArray;
        }
        catch (ByteSerializeException byteSerializeException) {
            FFDCFilter.processException(byteSerializeException, "com.ibm.ws.scheduler.TaskInfoBinaryData.getObjectByIDAndVersion", "370");
            if (bl) {
                Tr.exit(tc, "getObjectByIDAndVersion", new Object[]{byteSerializeException});
            }
            throw byteSerializeException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskInfoBinaryData.getObjectByIDAndVersion", "380");
            if (bl) {
                Tr.exit(tc, "getObjectByIDAndVersion", new Object[]{throwable});
            }
            throw new ByteSerializeException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    private static void setFieldHeaderBytes(byte[] byArray, int n, short s, short s2, byte by, int n2) {
        byArray[n + 0] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
        byArray[n + 2] = (byte)(s2 >> 8);
        byArray[n + 3] = (byte)s2;
        byArray[n + 4] = by;
        byArray[n + 5] = (byte)(n2 >> 24);
        byArray[n + 6] = (byte)(n2 >> 16);
        byArray[n + 7] = (byte)(n2 >> 8);
        byArray[n + 8] = (byte)n2;
    }

    public static byte[] getFieldBytesByIDAndVersion(byte[] byArray, short s, short s2) throws ByteSerializeException {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getFieldBytesByIDAndVersion", new Object[]{"0x" + Integer.toHexString(s), "0x" + Integer.toHexString(s2)});
        }
        byte[] byArray2 = null;
        try {
            if (byArray == null) {
                byArray2 = null;
                if (bl) {
                    Tr.exit(tc, "getFieldBytesByIDAndVersion", byArray2);
                }
                return byArray2;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            short s3 = objectInputStream.readShort();
            if (s3 != 1536) {
                throw new ByteSerializeException(Messages.getMessage("SCHD0105E", new Object[]{"HEADER", "0x1536", "0x" + Integer.toHexString(s3)}));
            }
            short s4 = objectInputStream.readShort();
            if (s4 != 9472) {
                throw new ByteSerializeException(Messages.getMessage("SCHD0106E", new Object[]{"0x" + Integer.toHexString(9472), "0x" + Integer.toHexString(s3)}));
            }
            int n = objectInputStream.readShort();
            for (int i = 0; i < n; ++i) {
                int n2;
                s4 = objectInputStream.readShort();
                short s5 = objectInputStream.readShort();
                byte by = objectInputStream.readByte();
                if (s == s4) {
                    if (s5 != s2) {
                        throw new ByteSerializeException(Messages.getMessage("SCHD0105E", new Object[]{"0x" + Integer.toHexString(s4), "0x" + Integer.toHexString(s2), "0x" + Integer.toHexString(s5)}));
                    }
                    if (by == 2 || by == 1) {
                        n2 = objectInputStream.readInt();
                        if (n2 == -1) {
                            byArray2 = new byte[9];
                            ByteSerializationUtils.setFieldHeaderBytes(byArray2, 0, s4, s5, by, n2);
                        } else {
                            byArray2 = new byte[9 + n2];
                            ByteSerializationUtils.setFieldHeaderBytes(byArray2, 0, s4, s5, by, n2);
                            objectInputStream.readFully(byArray2, 9, n2);
                        }
                    } else {
                        if (bl2) {
                            Tr.debug(tc, "This method only supports byte[] or object types.");
                        }
                        throw new ByteSerializeException(Messages.getMessage("SCHD0107E", new Object[]{"0x" + Integer.toHexString(s4), "0x" + Integer.toHexString(by)}));
                    }
                    if (bl) {
                        Tr.exit(tc, "getFieldBytesByIDAndVersion", byArray2 == null ? null : "L=" + byArray2.length);
                    }
                    return byArray2;
                }
                if (by == 2 || by == 1) {
                    n2 = objectInputStream.readInt();
                } else if (by == 3) {
                    n2 = 4;
                } else {
                    throw new ByteSerializeException(Messages.getMessage("SCHD0107E", new Object[]{"0x" + Integer.toHexString(s4), "0x" + Integer.toHexString(by)}));
                }
                if (n2 == -1) continue;
                objectInputStream.skip(n2);
            }
            if (bl) {
                Tr.exit(tc, "getFieldBytesByIDAndVersion", byArray2 == null ? null : "L=" + byArray2.length);
            }
            return byArray2;
        }
        catch (ByteSerializeException byteSerializeException) {
            FFDCFilter.processException(byteSerializeException, "com.ibm.ws.scheduler.TaskInfoBinaryData.getFieldBytesByIDAndVersion", "730");
            if (bl) {
                Tr.exit(tc, "getFieldBytesByIDAndVersion", new Object[]{byteSerializeException});
            }
            throw byteSerializeException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskInfoBinaryData.getFieldBytesByIDAndVersion", "735");
            if (bl) {
                Tr.exit(tc, "getFieldBytesByIDAndVersion", new Object[]{throwable});
            }
            throw new ByteSerializeException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    private static int getIDMatchPos(short[] sArray, short s) {
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != s) continue;
            return i;
        }
        return -1;
    }

    private static String dumpHexArray(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("0x").append(Long.toHexString(lArray[i]));
            if (i + 1 >= n) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static String dumpHexArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("0x").append(Integer.toHexString(nArray[i]));
            if (i + 1 >= n) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static String dumpHexArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("0x").append(Integer.toHexString(sArray[i]));
            if (i + 1 >= n) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static String dumpArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(objectArray[i]);
            if (objectArray[i] != null && objectArray[i].getClass().isArray()) {
                stringBuffer.append(" L=").append(Array.getLength(objectArray[i]));
            }
            if (i + 1 >= n) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String dumpBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append("0123456789ABCDEF".charAt((by & 0xF0) >> 4));
            stringBuffer.append("0123456789ABCDEF".charAt(by & 0xF));
        }
        return stringBuffer.toString();
    }
}

