/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.extensionhelper.InternalDatabaseHelper;
import com.ibm.ws.extensionhelper.InternalTxHandle;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.scheduler.DBHelper;
import com.ibm.ws.scheduler.TaskStore;
import com.ibm.ws.scheduler.TaskStoreImpl;
import com.ibm.ws.scheduler.TaskStoreImplDB2;
import com.ibm.ws.scheduler.TaskStoreImplDerby;
import com.ibm.ws.scheduler.TaskStoreImplInformix;
import com.ibm.ws.scheduler.TaskStoreImplInformix7;
import com.ibm.ws.scheduler.TaskStoreImplMSSQL;
import com.ibm.ws.scheduler.TaskStoreImplMSSQL7;
import com.ibm.ws.scheduler.TaskStoreImplOracle;
import com.ibm.ws.scheduler.TaskStoreImplSybase;
import com.ibm.ws.scheduler.spi.Scheduler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DBHelperImpl
implements DBHelper,
InternalDatabaseHelper {
    private static final TraceComponent tc = Tr.register(DBHelperImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private Scheduler scheduler = null;
    private InternalDatabaseHelper databaseHelper = null;
    private String dataSourceJNDIName = null;

    public DBHelperImpl(Scheduler scheduler, ExtensionHelper extensionHelper, Map map) throws UnableToInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.scheduler = scheduler;
        this.databaseHelper = (InternalDatabaseHelper)extensionHelper.getDatabaseHelper(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public TaskStore getTaskStore() throws NamingException, UnableToInitializeException {
        String string = this.getDatabaseType();
        if (string.equals("ORACLE")) {
            return new TaskStoreImplOracle(this);
        }
        if (string.equals("DB2") || string.equals("DB2ISERIES") || string.equals("DB2ZSERIES")) {
            return new TaskStoreImplDB2(this);
        }
        if (string.equals("SYBASE")) {
            return new TaskStoreImplSybase(this);
        }
        if (string.equals("INFORMIX")) {
            return new TaskStoreImplInformix(this);
        }
        if (string.equals("INFORMIX7")) {
            return new TaskStoreImplInformix7(this);
        }
        if (string.equals("MSSQL")) {
            return new TaskStoreImplMSSQL(this);
        }
        if (string.equals("MSSQL7")) {
            return new TaskStoreImplMSSQL7(this);
        }
        if (string.equals("DERBY")) {
            return new TaskStoreImplDerby(this);
        }
        return new TaskStoreImpl(this);
    }

    public TransactionControl getTransactionControl() {
        return this.databaseHelper.getTransactionControl();
    }

    public String getTablePrefixName() {
        return this.databaseHelper.getTablePrefixName();
    }

    public void dumpNestedSQLException(SQLException sQLException) {
        this.databaseHelper.dumpNestedSQLException(sQLException);
    }

    public void dumpSQLExceptionInfo(Throwable throwable) {
        this.databaseHelper.dumpSQLExceptionInfo(throwable);
    }

    public boolean existsTable(String string) {
        return this.databaseHelper.existsTable(string);
    }

    public boolean existsTable(String string, Connection connection) {
        return this.databaseHelper.existsTable(string, connection);
    }

    public Connection getConnection() throws SQLException {
        return this.databaseHelper.getConnection();
    }

    public String getDatabaseType() {
        return this.databaseHelper.getDatabaseType();
    }

    public DataSource getDataSource() {
        return this.databaseHelper.getDataSource();
    }

    public String getRealTableName(String string) {
        return this.databaseHelper.getRealTableName(string);
    }

    public String getSQLStatement(String string, String string2, String string3) {
        return this.databaseHelper.getSQLStatement(string, string2, string3);
    }

    public String getSQLStatement(String string, String string2) {
        return this.databaseHelper.getSQLStatement(string, string2);
    }

    public void returnConnection(Connection connection) throws SQLException {
        this.databaseHelper.returnConnection(connection);
    }

    public String getDataSourceJNDIName() {
        return this.dataSourceJNDIName;
    }

    public Connection getConnection(TxHandle txHandle) throws SQLException {
        return this.databaseHelper.getConnection(txHandle);
    }

    public Connection getConnection(TxHandle txHandle, int n, boolean bl) throws SQLException {
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "getConnection", new Object[]{txHandle, "iso=" + n, "forceTxIso=" + bl});
        }
        Connection connection = null;
        try {
            boolean bl3 = false;
            if (txHandle != null) {
                InternalTxHandle internalTxHandle = (InternalTxHandle)txHandle;
                boolean bl4 = bl3 = internalTxHandle.localTranWasStarted() || internalTxHandle.globalTranWasStarted();
            }
            if (bl || bl3 || this.isDataSource2Phase() || this.isDataSource40()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retrieving a connection with tran isolation override.");
                }
                connection = this.getConnectionWithTxIso(txHandle, n);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retrieving a default connection.");
                }
                connection = this.getConnection();
            }
            if (bl2) {
                Tr.exit(tc, "getConnection", connection);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            if (bl2) {
                Tr.exit(tc, "getConnection", sQLException);
            }
            throw sQLException;
        }
    }

    public boolean supportsTransactionIsolationLevel(int n) {
        return this.databaseHelper.supportsTransactionIsolationLevel(n);
    }

    public Connection getConnectionWithTxIso(TxHandle txHandle, int n) throws SQLException {
        return this.databaseHelper.getConnectionWithTxIso(txHandle, n);
    }

    public String getDatabaseVendor() {
        return this.databaseHelper.getDatabaseVendor();
    }

    public String getDriverName() {
        return this.databaseHelper.getDriverName();
    }

    public String getDriverVersion() {
        return this.databaseHelper.getDriverVersion();
    }

    public boolean isDataSource2Phase() {
        return this.databaseHelper.isDataSource2Phase();
    }

    public boolean isDataSource40() {
        return this.databaseHelper.isDataSource40();
    }

    public boolean isDataSourceDirect() {
        return this.databaseHelper.isDataSourceDirect();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.databaseHelper.loadClass(string);
    }
}

