/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.asynchbeans.AsynchScope;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.leasemanager.Lease;
import com.ibm.ws.leasemanager.LeaseException;
import com.ibm.ws.leasemanager.LeaseManagerNotAvailableException;
import com.ibm.ws.leasemanager.LeaseManagerService;
import com.ibm.ws.leasemanager.impl.LeaseManagerServiceImpl;
import com.ibm.ws.scheduler.ApplicationStateListener;
import com.ibm.ws.scheduler.ApplicationTracker;
import com.ibm.ws.scheduler.DaemonCoordinator;
import com.ibm.ws.scheduler.FailureCache;
import com.ibm.ws.scheduler.LeaseAlarm;
import com.ibm.ws.scheduler.PartitionInfo;
import com.ibm.ws.scheduler.Range;
import com.ibm.ws.scheduler.SchedulerDaemon;
import com.ibm.ws.scheduler.SchedulerDaemonImpl;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.config.SchedulerConfiguration;
import com.ibm.ws.scheduler.config.SchedulerServiceConfiguration;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import com.ibm.ws.scheduler.exception.SchedulerServiceInternalException;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.Scheduler;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.scheduler.spi.TaskStatus;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DaemonCoordinatorImpl
implements DaemonCoordinator,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(DaemonCoordinatorImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    int totalDaemons;
    PartitionInfo[] partitionInfos;
    AsynchScope asynchScope_Main;
    static final String asynchScope_BaseName = "~Scheduler";
    String asynchScopeName_Main;
    private WriterPriorityReadersWriterLock asynchScope_Main_Lock = new WriterPriorityReadersWriterLock();
    private WriterPriorityReadersWriterLock leaseAlarms_Lock = new WriterPriorityReadersWriterLock();
    private LeaseAlarm leaseAlarmListener = null;
    AsynchScope asynchScope_Tasks;
    String asynchScopeName_Tasks;
    WriterPriorityReadersWriterLock asynchScope_Tasks_Lock = new WriterPriorityReadersWriterLock();
    Scheduler sched;
    protected TransactionControl tranControl;
    Map partitionLeaseMap = new HashMap();
    Range[] acquiredPartitionRanges;
    WriterPriorityReadersWriterLock partitionLeaseMapLock = new WriterPriorityReadersWriterLock();
    Range[] partitionRanges;
    SchedulerDaemon[] daemons;
    private WriterPriorityReadersWriterLock daemonsLock = new WriterPriorityReadersWriterLock();
    private Map daemonRangeMap = new HashMap();
    private WriterPriorityReadersWriterLock daemonRangeMapLock = new WriterPriorityReadersWriterLock();
    int leaseAlarmInterval;
    SchedulerConfiguration schedConfig;
    SchedulerServiceConfiguration schedSvcConfig;
    private LeaseManagerService leaseMgr = null;
    private WriterPriorityReadersWriterLock leaseMgrLock = new WriterPriorityReadersWriterLock();
    String leaseOwnerName;
    String leaseResourceNamePrefix;
    private int[] pollDurations;
    private long[] pollStartTimes;
    protected int avgPollDuration = 0;
    private WriterPriorityReadersWriterLock durationLock = new WriterPriorityReadersWriterLock();
    private int[] querySizes;
    private WriterPriorityReadersWriterLock querySizeLock = new WriterPriorityReadersWriterLock();
    private int leaseTime = 0;
    private ApplicationTracker appTracker;
    protected FailureCache pollFailureCache = new FailureCache(1);
    private boolean useUncommittedRead = false;
    private FailureCache taskFailureCache;

    public DaemonCoordinatorImpl(PartitionInfo[] partitionInfoArray, int n, Scheduler scheduler, SchedulerConfiguration schedulerConfiguration, SchedulerServiceConfiguration schedulerServiceConfiguration, TransactionControl transactionControl, ApplicationTracker applicationTracker) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "DaemonCoordinatorImpl", new Object[]{PartitionInfo.toString(partitionInfoArray), new Integer(n), scheduler, schedulerConfiguration});
        }
        this.asynchScopeName_Main = "~Scheduler_" + schedulerConfiguration.getJndiName();
        this.asynchScopeName_Tasks = this.asynchScopeName_Main + "_Tasks";
        this.sched = scheduler;
        this.schedConfig = schedulerConfiguration;
        this.schedSvcConfig = schedulerServiceConfiguration;
        this.tranControl = transactionControl;
        this.leaseResourceNamePrefix = schedulerConfiguration.getJndiName();
        this.leaseOwnerName = ServerName.getFullName();
        this.appTracker = applicationTracker;
        this.useUncommittedRead = this.supportsUncommittedRead();
        this.taskFailureCache = new FailureCache(schedulerConfiguration.getTaskFailureThreshold());
        this.initialize(partitionInfoArray, n);
        if (bl) {
            Tr.exit(tc, "DaemonCoordinatorImpl");
        }
    }

    public void initialize(PartitionInfo[] partitionInfoArray, int n) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "initialize", new Object[]{PartitionInfo.toString(partitionInfoArray)});
        }
        this.totalDaemons = n;
        this.partitionInfos = partitionInfoArray;
        this.leaseAlarmInterval = (int)this.schedConfig.getLeaseAlarmIntervalMS();
        this.leaseTime = (int)this.schedConfig.getLeaseTimeMS();
        this.partitionRanges = new Range[partitionInfoArray.length];
        for (int i = 0; i < partitionInfoArray.length; ++i) {
            this.partitionRanges[i] = partitionInfoArray[i].getRange();
        }
        try {
            this.asynchScope_Main_Lock.startWriting();
            if (this.asynchScope_Main == null) {
                this.asynchScope_Main = this.sched.getWorkManager().findOrCreateAsynchScope(this.asynchScopeName_Main);
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.initialize", "240", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "AsynchScope_Main"), interruptedException);
        }
        finally {
            this.asynchScope_Main_Lock.stopWriting();
        }
        Properties properties = new Properties();
        properties.setProperty("LEASEMANAGER_DATASOURCE", this.schedConfig.getDataSourceJndiName());
        properties.setProperty("TABLE_PREFIX", this.schedConfig.getTablePrefix());
        if (this.schedConfig.getUsername() != null) {
            properties.setProperty("username", this.schedConfig.getUsername());
        }
        if (this.schedConfig.getPassword() != null) {
            properties.setProperty("password", this.schedConfig.getPassword());
        }
        boolean bl3 = false;
        try {
            if (bl2) {
                Tr.debug(tc, "Attempting to get LeaseManagerService");
            }
            this.leaseMgrLock.startWriting();
            this.leaseMgr = LeaseManagerServiceImpl.createInstance(properties);
            bl3 = true;
            if (bl2) {
                Tr.debug(tc, "LeaseManagerService found: " + this.leaseMgr);
            }
        }
        catch (LeaseManagerNotAvailableException leaseManagerNotAvailableException) {
            FFDCFilter.processException((Throwable)leaseManagerNotAvailableException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.initialize", "260", this);
            Tr.warning(tc, "SCHD0136W", new Object[]{this.schedConfig.getName(), this.schedConfig.getJndiName()});
            if (bl2) {
                Tr.debug(tc, "LeaseManager not available for scheduler: " + this.schedConfig.getJndiName() + ", reason=" + leaseManagerNotAvailableException.getMessage(), leaseManagerNotAvailableException);
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.initialize", "270", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "LeaseManager"), interruptedException);
        }
        finally {
            this.leaseMgrLock.stopWriting();
        }
        try {
            this.partitionLeaseMapLock.startWriting();
            if (bl3) {
                this.acquiredPartitionRanges = new Range[0];
            } else {
                this.acquiredPartitionRanges = new Range[this.partitionRanges.length];
                System.arraycopy(this.partitionRanges, 0, this.acquiredPartitionRanges, 0, this.partitionRanges.length);
            }
            if (bl2) {
                Tr.debug(tc, "Initial acquired partition ranges: " + Range.toString(this.acquiredPartitionRanges));
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.initialize", "280", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "LeaseMap"), interruptedException);
        }
        finally {
            this.partitionLeaseMapLock.stopWriting();
        }
        if (bl) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "destroy");
        }
        this.stopDaemons();
        try {
            this.asynchScope_Main_Lock.startWriting();
            if (this.asynchScope_Main != null) {
                this.asynchScope_Main.destroy();
                this.asynchScope_Main = null;
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.destroy", "307", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "AsynchScope_Main"), interruptedException);
        }
        finally {
            this.asynchScope_Main_Lock.stopWriting();
            if (bl) {
                Tr.exit(tc, "destroy");
            }
        }
    }

    public void startDaemons(int n) throws SchedulerDataStoreException {
        block27: {
            boolean bl = tc.isEntryEnabled();
            boolean bl2 = tc.isDebugEnabled();
            if (bl) {
                Tr.entry(tc, "startDaemons", new Integer(n));
            }
            AsynchScope asynchScope = this.getAsynchScope_Main();
            try {
                int n2;
                this.daemonsLock.startWriting();
                if (this.daemons != null) break block27;
                try {
                    this.leaseAlarms_Lock.startWriting();
                    if (this.leaseAlarmListener == null) {
                        this.leaseAlarmListener = new LeaseAlarm(this, this.getLeaseManager(), this.leaseOwnerName, this.leaseResourceNamePrefix, this.leaseAlarmInterval, this.leaseTime);
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.startDaemons", "350", this);
                    if (bl2) {
                        Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
                    }
                    throw new IllegalStateException(Messages.getMessage("SCHD0118E", "LeaseAlarm"));
                }
                finally {
                    this.leaseAlarms_Lock.stopWriting();
                }
                AsynchScope asynchScope2 = null;
                try {
                    this.asynchScope_Tasks_Lock.startWriting();
                    if (this.asynchScope_Tasks == null) {
                        this.asynchScope_Tasks = asynchScope.findOrCreateAsynchScope(this.asynchScopeName_Tasks);
                    }
                    asynchScope2 = this.asynchScope_Tasks;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.startDaemons", "370", this);
                    if (bl2) {
                        Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
                    }
                    throw new IllegalStateException(Messages.getMessage("SCHD0118E", "AsynchScope_Tasks"));
                }
                finally {
                    this.asynchScope_Tasks_Lock.stopWriting();
                }
                this.primePollTimes(this.schedConfig.getPollIntervalMillis());
                this.daemons = new SchedulerDaemonImpl[this.totalDaemons];
                for (n2 = 0; n2 < this.totalDaemons; ++n2) {
                    String string = "D" + n2;
                    this.daemons[n2] = new SchedulerDaemonImpl(string, this, this.tranControl, this.sched, asynchScope2, this.schedConfig.getPollIntervalMillis(), this.schedConfig.getQuerySize(), this.schedConfig.getMaxTaskLoadSize(), this.appTracker, this.useUncommittedRead);
                }
                this.updateDaemonPartitionRanges();
                for (n2 = 0; n2 < this.totalDaemons; ++n2) {
                    this.daemons[n2].startDaemon(0);
                }
                for (n2 = 0; n2 < this.partitionInfos.length; ++n2) {
                    AlarmManager.createNonDeferrable(0L, this.leaseAlarmListener, this.partitionInfos[n2]);
                }
                this.appTracker.addApplicationStateListener(this, String.class);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getPartitionRangesForDaemon", "400", this);
                if (bl2) {
                    Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
                }
                throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "Daemons"), interruptedException);
            }
            catch (SchedulerDataStoreException schedulerDataStoreException) {
                FFDCFilter.processException((Throwable)schedulerDataStoreException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getPartitionRangesForDaemon", "410", this);
                if (bl2) {
                    Tr.debug(tc, "Caught exception: " + schedulerDataStoreException.getMessage(), schedulerDataStoreException);
                }
                throw schedulerDataStoreException;
            }
            finally {
                this.daemonsLock.stopWriting();
                if (bl) {
                    Tr.exit(tc, "startDaemons");
                }
            }
        }
    }

    public void stopDaemons() {
        boolean bl;
        boolean bl2;
        block28: {
            bl2 = tc.isEntryEnabled();
            bl = tc.isDebugEnabled();
            if (bl2) {
                Tr.entry(tc, "stopDaemons");
            }
            this.appTracker.removeApplicationStateListener(this);
            try {
                this.leaseAlarms_Lock.startWriting();
                if (this.leaseAlarmListener != null) {
                    this.leaseAlarmListener.cancel();
                    this.leaseAlarmListener = null;
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.stopDaemons", "450", this);
                if (bl) {
                    Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
                }
                throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "LeaseAlarms"), interruptedException);
            }
            finally {
                this.leaseAlarms_Lock.stopWriting();
            }
            try {
                this.daemonsLock.startWriting();
                if (this.daemons != null) {
                    for (int i = 0; i < this.daemons.length; ++i) {
                        this.daemons[i].destroy();
                    }
                    this.daemons = null;
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.stopDaemons", "480", this);
                if (bl) {
                    Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
                }
                throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "Daemons"), interruptedException);
            }
            finally {
                this.daemonsLock.stopWriting();
            }
            try {
                this.cancelLeases();
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.stopDaemons", "490", this);
                if (!bl) break block28;
                Tr.debug(tc, "Caught exception: " + runtimeException.getMessage(), runtimeException);
            }
        }
        try {
            this.asynchScope_Tasks_Lock.startWriting();
            if (this.asynchScope_Tasks != null) {
                this.asynchScope_Tasks.destroy();
                this.asynchScope_Tasks = null;
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.stopDaemons", "500", this);
            if (bl) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "AsynchScope_Tasks"), interruptedException);
        }
        finally {
            this.asynchScope_Tasks_Lock.stopWriting();
        }
        this.pollFailureCache.clearAllFailures();
        this.taskFailureCache.clearAllFailures();
        if (bl2) {
            Tr.exit(tc, "stopDaemons");
        }
    }

    public Range[] getPartitionRangesForDaemon(String string) {
        Range[] rangeArray;
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getPartitionRangesForDaemon", string);
        }
        try {
            this.daemonRangeMapLock.startReading();
            rangeArray = (Range[])this.daemonRangeMap.get(string);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getPartitionRangesForDaemon", "525", this);
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "Daemons"));
        }
        finally {
            this.daemonRangeMapLock.stopReading();
        }
        if (bl) {
            Tr.exit(tc, "getPartitionRangesForDaemon", Range.toString(rangeArray));
        }
        return rangeArray;
    }

    public SchedulerDaemon getDaemonFromPartition(int n) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getDaemonFromPartition", new Integer(n));
        }
        SchedulerDaemon schedulerDaemon = null;
        try {
            this.daemonRangeMapLock.startReading();
            if (this.daemons != null) {
                block5: for (int i = 0; i < this.daemons.length; ++i) {
                    String string = this.daemons[i].getID();
                    Range[] rangeArray = (Range[])this.daemonRangeMap.get(string);
                    if (rangeArray == null) continue;
                    for (int j = 0; j < rangeArray.length; ++j) {
                        if (!rangeArray[j].contains(n)) continue;
                        schedulerDaemon = this.daemons[i];
                        continue block5;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getDaemonFromPartition", "550", this);
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "Daemons"));
        }
        finally {
            this.daemonRangeMapLock.stopReading();
        }
        if (bl) {
            Tr.exit(tc, "getDaemonFromPartition", schedulerDaemon == null ? null : schedulerDaemon.getID());
        }
        return schedulerDaemon;
    }

    public void updatePollInterval(int n) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "updatePollInterval", new Integer(n));
        }
        try {
            this.daemonsLock.startReading();
            if (this.daemons != null) {
                for (int i = 0; i < this.daemons.length; ++i) {
                    this.daemons[i].setPollInterval(n);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.updatePollInterval", "590", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "Daemons"));
        }
        finally {
            this.daemonsLock.stopReading();
            if (bl) {
                Tr.exit(tc, "updatePollInterval");
            }
        }
    }

    public void updateQuerySize(int n) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "updateQuerySize", new Integer(n));
        }
        try {
            this.daemonsLock.startReading();
            if (this.daemons != null) {
                for (int i = 0; i < this.daemons.length; ++i) {
                    this.daemons[i].setQuerySize(n);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.updateQuerySize", "670", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "Daemons"));
        }
        finally {
            this.daemonsLock.stopReading();
            if (bl) {
                Tr.exit(tc, "updateQuerySize");
            }
        }
    }

    public void updateDaemonPartitionRanges() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "updateDaemonPartitionRanges");
        }
        Range[] rangeArray = new Range[]{};
        try {
            this.partitionLeaseMapLock.startWriting();
            rangeArray = new Range[this.acquiredPartitionRanges.length];
            System.arraycopy(this.acquiredPartitionRanges, 0, rangeArray, 0, this.acquiredPartitionRanges.length);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.updateDaemonPartitionRanges", "600", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "LeaseMap"), interruptedException);
        }
        finally {
            this.partitionLeaseMapLock.stopWriting();
        }
        List[] listArray = Utils.getPartitionDistribution(rangeArray, this.totalDaemons);
        if (bl2) {
            Tr.debug(tc, "Total Acquired Partition Ranges=" + Range.toString(rangeArray) + ", total Daemons=" + this.totalDaemons);
        }
        ArrayList<SchedulerDaemon> arrayList = new ArrayList<SchedulerDaemon>(listArray.length);
        try {
            this.daemonRangeMapLock.startWriting();
            HashMap hashMap = new HashMap();
            if (this.daemons != null) {
                for (int i = 0; i < listArray.length; ++i) {
                    Range[] rangeArray2 = new Range[listArray[i].size()];
                    String string = this.daemons[i].getID();
                    hashMap.put(string, listArray[i].toArray(rangeArray2));
                    if (!Range.equals((Range[])this.daemonRangeMap.get(string), rangeArray2)) {
                        for (int j = 0; j < this.daemons.length; ++j) {
                            if (!this.daemons[j].getID().equals(string)) continue;
                            arrayList.add(this.daemons[j]);
                            break;
                        }
                        if (!bl2) continue;
                        Tr.debug(tc, "New Distribution Ranges for daemon " + i + "=" + Range.toString(rangeArray2));
                        continue;
                    }
                    if (!bl2) continue;
                    Tr.debug(tc, "Distribution Range unchanged for daemon " + i + "=" + Range.toString(rangeArray2));
                }
            }
            this.daemonRangeMap = hashMap;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.updateDaemonPartitionRanges", "625", this);
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "Daemons"));
        }
        finally {
            this.daemonRangeMapLock.stopWriting();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((SchedulerDaemon)iterator.next()).notifyDaemon();
            }
            if (bl) {
                Tr.exit(tc, "updateDaemonPartitionRanges");
            }
        }
    }

    protected void cancelLeases() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "cancelLeases");
        }
        try {
            this.partitionLeaseMapLock.startWriting();
            Iterator iterator = this.partitionLeaseMap.values().iterator();
            while (iterator.hasNext()) {
                Lease lease = null;
                try {
                    lease = (Lease)iterator.next();
                    if (lease == null) continue;
                    if (bl2) {
                        Tr.debug(tc, "Attempting to cancel lease: " + lease.getResourceName());
                    }
                    lease.cancel();
                }
                catch (LeaseException leaseException) {
                    FFDCFilter.processException((Throwable)leaseException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.cancelLeases", "730", this);
                    if (!bl2) continue;
                    Tr.debug(tc, "LeaseException while cancelling lease: " + lease.getResourceName(), leaseException);
                }
            }
            this.partitionLeaseMap.clear();
            this.acquiredPartitionRanges = new Range[0];
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.cancelLeases", "740", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "LeaseMap"));
        }
        finally {
            this.partitionLeaseMapLock.stopWriting();
            this.updateDaemonPartitionRanges();
            if (bl) {
                Tr.exit(tc, "cancelLeases");
            }
        }
    }

    public void scheduleTaskAlarm(TaskInfo taskInfo) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "scheduleTaskAlarm", taskInfo);
        }
        boolean bl3 = this.taskFailureCache.hasReachedFailureThreshold(taskInfo.getTaskId());
        boolean bl4 = ((TaskStatus)((Object)taskInfo)).canRun();
        SchedulerDaemon schedulerDaemon = this.getDaemonFromPartition(taskInfo.getPartition());
        if (bl4 && schedulerDaemon != null && !bl3 && this.schedSvcConfig.getServiceEnabled() && (schedulerDaemon.getNextEstPollTime() > taskInfo.getNextFireTime().getTime() || schedulerDaemon.isPolling() && schedulerDaemon.getNextEstPollTime() + (long)schedulerDaemon.getPollInterval() > taskInfo.getNextFireTime().getTime())) {
            schedulerDaemon.scheduleAlarm(taskInfo);
        } else if (bl2) {
            Tr.debug(tc, "Skipping alarm schedule: CANRUN=" + ((TaskStatus)((Object)taskInfo)).canRun() + " FAIL=" + bl3);
            if (schedulerDaemon != null) {
                Date date = new Date(schedulerDaemon.getNextEstPollTime());
                Date date2 = taskInfo.getNextFireTime();
                Tr.debug(tc, "NextEstPollTime=" + date + "(" + date.getTime() + ").  NextFireTime=" + date2 + "(" + date2.getTime() + ")");
            } else {
                Tr.debug(tc, "Daemon is null for partition:" + taskInfo.getPartition());
            }
        }
        if (bl) {
            Tr.exit(tc, "scheduleTaskAlarm");
        }
    }

    public AsynchScope getAsynchScope_Tasks() {
        AsynchScope asynchScope;
        block2: {
            boolean bl = tc.isDebugEnabled();
            asynchScope = null;
            try {
                this.asynchScope_Tasks_Lock.startReading();
                asynchScope = this.asynchScope_Tasks;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getAsynchScope_Tasks", "820", this);
                if (!bl) break block2;
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
        }
        this.asynchScope_Tasks_Lock.stopReading();
        return asynchScope;
    }

    public AsynchScope getAsynchScope_Main() {
        AsynchScope asynchScope;
        block2: {
            boolean bl = tc.isDebugEnabled();
            asynchScope = null;
            try {
                this.asynchScope_Main_Lock.startReading();
                asynchScope = this.asynchScope_Main;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getAsynchScope_Main", "840", this);
                if (!bl) break block2;
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
        }
        this.asynchScope_Main_Lock.stopReading();
        return asynchScope;
    }

    public Lease getLeaseFromPartitionInfo(PartitionInfo partitionInfo) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getLeaseFromPartitionInfo", partitionInfo);
        }
        Lease lease = null;
        try {
            this.partitionLeaseMapLock.startReading();
            lease = (Lease)this.partitionLeaseMap.get(partitionInfo.getLabel());
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getLeaseFromPartitionInfo", "870", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "LeaseMap"));
        }
        finally {
            this.partitionLeaseMapLock.stopReading();
            if (bl) {
                Tr.exit(tc, "getLeaseFromPartitionInfo");
            }
        }
        return lease;
    }

    public Lease addLease(PartitionInfo partitionInfo, Lease lease) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "addLease", new Object[]{partitionInfo, lease});
        }
        Lease lease2 = null;
        try {
            this.partitionLeaseMapLock.startWriting();
            lease2 = this.partitionLeaseMap.put(partitionInfo.getLabel(), lease);
            this.acquiredPartitionRanges = Utils.insertRange(this.acquiredPartitionRanges, partitionInfo.getRange());
            if (bl2) {
                Tr.debug(tc, "Updated acquired partition ranges: " + Range.toString(this.acquiredPartitionRanges));
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.addLease", "900", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "LeaseMap"));
        }
        finally {
            this.partitionLeaseMapLock.stopWriting();
            if (bl) {
                Tr.exit(tc, "addLease");
            }
        }
        return lease2;
    }

    public void removeLease(PartitionInfo partitionInfo) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "removeLease", partitionInfo);
        }
        try {
            this.partitionLeaseMapLock.startWriting();
            this.partitionLeaseMap.remove(partitionInfo.getLabel());
            this.acquiredPartitionRanges = Utils.removeRange(this.acquiredPartitionRanges, partitionInfo.getRange());
            if (bl2) {
                Tr.debug(tc, "Updated acquired partition ranges: " + Range.toString(this.acquiredPartitionRanges));
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.removeLease", "920", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "LeaseMap"));
        }
        finally {
            this.partitionLeaseMapLock.stopWriting();
            if (bl) {
                Tr.exit(tc, "removeLease");
            }
        }
    }

    public int getNextQuerySize(int n, int n2, int n3) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getNextQuerySize");
        }
        try {
            int n4;
            this.querySizeLock.startWriting();
            int n5 = Utils.getDecayingAverage(this.schedConfig.getDecayingAvgWeights(), this.querySizes);
            long l = n2;
            int n6 = this.schedConfig.getPollIntervalMillis();
            if (n >= n2 || n3 > n6) {
                n4 = this.getAvgPollDuration();
                int n7 = n6 - n4;
                double d = (double)n7 / (double)n4 * (double)n5;
                l = Math.round((double)n5 + d);
                if (l > Integer.MAX_VALUE) {
                    l = Integer.MAX_VALUE;
                } else if (l < 1L) {
                    l = 1L;
                }
                if (bl2) {
                    Tr.debug(tc, "Next query size changed from " + n2 + " to " + l + ".  DeltaT=" + n7 + ", sizeAdj=" + d + ", AvgQS=" + n5);
                }
            }
            for (n4 = this.querySizes.length - 1; n4 > 0; --n4) {
                this.querySizes[n4] = this.querySizes[n4 - 1];
            }
            this.querySizes[0] = (int)l;
            n4 = (int)l;
            return n4;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getNextQuerySize", "1050", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "QuerySize"), interruptedException);
        }
        finally {
            this.querySizeLock.stopWriting();
            if (bl) {
                Tr.exit(tc, "getNextQuerySize");
            }
        }
    }

    public void addDuration(long l, long l2) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "addDuration");
        }
        try {
            this.durationLock.startWriting();
            for (int i = this.pollDurations.length - 1; i > 0; --i) {
                this.pollDurations[i] = this.pollDurations[i - 1];
                this.pollStartTimes[i] = this.pollStartTimes[i - 1];
            }
            this.pollDurations[0] = (int)(l2 - l);
            this.pollStartTimes[0] = l;
            this.avgPollDuration = Utils.getDecayingAverage(this.schedConfig.getDecayingAvgWeights(), this.pollDurations);
            if (bl2) {
                StringBuffer stringBuffer = new StringBuffer("Durations=");
                for (int i = 0; i < this.pollDurations.length; ++i) {
                    stringBuffer.append(this.pollDurations[i]);
                    if (i + 1 >= this.pollDurations.length) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(" Avg=" + this.avgPollDuration);
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.addDuration", "1090", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "Duration"), interruptedException);
        }
        finally {
            this.durationLock.stopWriting();
            if (bl) {
                Tr.exit(tc, "addDuration");
            }
        }
    }

    public int getPrevPollDuration() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getPrevPollDuration");
        }
        try {
            this.durationLock.startReading();
            int n = this.pollDurations[0];
            return n;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getPrevPollDuration", "1100", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "Duration"), interruptedException);
        }
        finally {
            this.durationLock.stopReading();
            if (bl) {
                Tr.exit(tc, "getPrevPollDuration");
            }
        }
    }

    public int getAvgPollDuration() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getAvgPollDuration");
        }
        try {
            this.durationLock.startReading();
            int n = this.avgPollDuration;
            return n;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getAvgPollDuration", "1105", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "Duration"), interruptedException);
        }
        finally {
            this.durationLock.stopReading();
            if (bl) {
                Tr.exit(tc, "getAvgPollDuration");
            }
        }
    }

    protected long getPrevPollStartTime() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getPrevPollStartTime");
        }
        try {
            this.durationLock.startReading();
            long l = this.pollStartTimes[0];
            return l;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getPrevPollStartTime", "1110", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "Duration"), interruptedException);
        }
        finally {
            this.durationLock.stopReading();
            if (bl) {
                Tr.exit(tc, "getPrevPollStartTime");
            }
        }
    }

    private void primePollTimes(int n) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "primePollTimes");
        }
        int n2 = 0;
        try {
            this.durationLock.startWriting();
            n2 = this.schedConfig.getDecayingAvgWeights().length;
            long l = System.currentTimeMillis();
            this.pollDurations = new int[n2];
            this.pollStartTimes = new long[n2];
            this.querySizes = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.pollDurations[i] = n;
                this.pollStartTimes[i] = l - (long)((i + 1) * n);
                this.querySizes[i] = this.schedConfig.getInitialQuerySize();
            }
            this.avgPollDuration = n;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.primePollTimes", "1115", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "Duration"), interruptedException);
        }
        finally {
            this.durationLock.stopWriting();
        }
        try {
            this.querySizeLock.startWriting();
            this.querySizes = new int[n2];
            int n3 = this.schedConfig.getInitialQuerySize();
            for (int i = 0; i < n2; ++i) {
                this.querySizes[i] = n3;
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.primePollTimes", "1120", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0118E", "QuerySize"), interruptedException);
        }
        finally {
            this.querySizeLock.stopWriting();
            if (bl) {
                Tr.exit(tc, "primePollTimes");
            }
        }
    }

    protected LeaseManagerService getLeaseManager() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getLeaseManager");
        }
        try {
            this.leaseMgrLock.startReading();
            LeaseManagerService leaseManagerService = this.leaseMgr;
            return leaseManagerService;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.getLeaseManager", "1300", this);
            if (bl2) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "LeaseMgr"));
        }
        finally {
            this.leaseMgrLock.stopReading();
            if (bl) {
                Tr.exit(tc, "getLeaseManager");
            }
        }
    }

    public void applicationAvailable(Object[] objectArray) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "applicationAvailable", this.dumpArray(objectArray));
        }
        try {
            this.daemonsLock.startReading();
            for (int i = 0; i < this.totalDaemons; ++i) {
                this.daemons[i].notifyDaemon();
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.DaemonCoordinatorImpl.updateDaemonPartitionRanges", "625", this);
            throw new IllegalStateException(Messages.getMessage("SCHD0118E", "Daemons"));
        }
        finally {
            this.daemonsLock.stopReading();
            if (bl) {
                Tr.exit(tc, "applicationAvailable");
            }
        }
    }

    private String dumpArray(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(objectArray);
            if (i + 1 >= n) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected boolean supportsUncommittedRead() {
        boolean bl = tc.isDebugEnabled();
        boolean bl2 = this.sched.getTaskStore().getDBHelper().supportsTransactionIsolationLevel(1);
        if (bl2 && this.schedConfig.isAllowUncommittedReadPollDaemon() || this.schedConfig.isForceUncommittedReadPollDaemon()) {
            if (bl) {
                Tr.debug(tc, "Using TRANSACTION_READ_UNCOMMITTED");
            }
            return true;
        }
        return false;
    }

    public int setTaskFailure(String string, Throwable throwable) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTaskFailure", new Object[]{string, throwable});
        }
        if ((n = this.taskFailureCache.setFailure(string)) >= this.taskFailureCache.getFailureThreshold()) {
            Tr.warning(tc, "SCHD0132W", new Object[]{string, this.schedConfig.getName(), this.schedConfig.getJndiName()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskFailureCache: " + this.taskFailureCache.dumpFailures());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTaskFailure", new Integer(n));
        }
        return n;
    }

    public boolean hasReachedFailureThreshold(String string) {
        return this.taskFailureCache.hasReachedFailureThreshold(string);
    }

    public void clearTaskFailure(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearTaskFailure", string);
        }
        this.taskFailureCache.clearFailure(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearTaskFailure");
        }
    }
}

