/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FailureCache {
    private Map failureHandles = new HashMap();
    private int failureThreshold = 1;
    private static final String lf = System.getProperty("line.separator", "\n");

    public FailureCache(int n) {
        this.failureThreshold = n;
    }

    public synchronized int setFailure(Object object) {
        Integer n = (Integer)this.failureHandles.get(object);
        n = n == null ? new Integer(1) : new Integer(n + 1);
        this.failureHandles.put(object, n);
        return n;
    }

    public synchronized int clearFailure(Object object) {
        Integer n = (Integer)this.failureHandles.remove(object);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public synchronized boolean isFailure(Object object) {
        return this.failureHandles.containsKey(object);
    }

    public synchronized int getFailures(Object object) {
        Integer n = (Integer)this.failureHandles.get(object);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public synchronized void clearAllFailures() {
        this.failureHandles.clear();
    }

    public synchronized boolean hasReachedFailureThreshold(Object object) {
        return this.getFailures(object) >= this.failureThreshold;
    }

    public synchronized String dumpFailures() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.failureHandles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("H:").append(entry.getKey());
            stringBuffer.append(" F:").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(lf);
        }
        return stringBuffer.toString();
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }
}

