/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.LazyTaskHolderI;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.scheduler.TaskHolder;
import com.ibm.ws.scheduler.TaskHolderI;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.exception.SchedulerServiceInternalException;
import com.ibm.ws.scheduler.spi.Runnable50;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class LazyTaskHolder
implements LazyTaskHolderI,
Serializable {
    private static final TraceComponent tc = Tr.register(LazyTaskHolder.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final long serialVersionUID = -2983424518553797598L;
    private TaskHolderI taskHolder = null;
    private byte[] taskHolderBytes = null;
    private String VERSION = null;

    public LazyTaskHolder() {
        this.taskHolder = new TaskHolder();
    }

    public LazyTaskHolder(byte[] byArray, String string) {
        this.taskHolder = null;
        this.taskHolderBytes = byArray;
        this.VERSION = string;
    }

    public LazyTaskHolder(TaskHolderI taskHolderI) {
        this.taskHolder = taskHolderI;
        this.taskHolderBytes = null;
    }

    public synchronized TaskHolderI getTaskHolder() throws SchedulerServiceInternalException {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (!this.isDeserialized()) {
            try {
                if (this.VERSION.equals("50")) {
                    this.taskHolder = (TaskHolderI)Utils.deserialize(new ByteArrayInputStream(this.taskHolderBytes));
                    this.VERSION = "502";
                    Runnable runnable = this.taskHolder.getTargetRunnable();
                    if (runnable != null && runnable instanceof Runnable50) {
                        if (bl2) {
                            Tr.debug(tc, "Detected a 5.0 formatted TaskInfo object while deserializing.  Converting to the 502 format.");
                        }
                        this.taskHolder.setTargetRunnable(((Runnable50)((Object)runnable)).get502From50TaskInfoVersion());
                    }
                } else if (this.VERSION.equals("502")) {
                    this.taskHolder = new TaskHolder();
                    this.taskHolder.setBytes(this.taskHolderBytes);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.scheduler.AbstractTask.getTaskHolder", "525", this);
                throw new SchedulerServiceInternalException(Utils.getExceptionMessageWithType(iOException), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.scheduler.AbstractTask.getTaskHolder", "530", this);
                throw new SchedulerServiceInternalException(Utils.getExceptionMessageWithType(classNotFoundException), classNotFoundException);
            }
            this.taskHolderBytes = null;
        }
        if (this.taskHolder == null) {
            this.taskHolder = new TaskHolder();
        }
        return this.taskHolder;
    }

    public synchronized void setTaskHolder(TaskHolderI taskHolderI) {
        this.taskHolder = taskHolderI;
    }

    public synchronized void setTaskHolderBytes(byte[] byArray) {
        this.taskHolderBytes = byArray;
    }

    public synchronized byte[] getTaskHolderBytes() {
        return this.taskHolderBytes;
    }

    public synchronized boolean isDeserialized() {
        return this.taskHolder != null && this.taskHolderBytes == null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" LazyTaskHolder: ");
        if (this.isDeserialized()) {
            stringBuffer.append(this.taskHolder.toString());
        } else {
            byte[] byArray = this.getTaskHolderBytes();
            if (byArray != null) {
                stringBuffer.append("BYTES[");
                stringBuffer.append(byArray.length);
                stringBuffer.append("]");
            } else {
                stringBuffer.append((Object)null);
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LazyTaskHolder)) {
            return super.equals(object);
        }
        LazyTaskHolder lazyTaskHolder = (LazyTaskHolder)object;
        return super.equals(object) && (this.taskHolderBytes == null && lazyTaskHolder.taskHolderBytes == null || Arrays.equals(this.taskHolderBytes, lazyTaskHolder.taskHolderBytes)) && (this.taskHolder == null && lazyTaskHolder.taskHolder == null || this.taskHolder.equals(lazyTaskHolder.taskHolder)) && (this.VERSION == null && lazyTaskHolder.VERSION == null || this.VERSION.equals(lazyTaskHolder.VERSION));
    }
}

