/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.leasemanager.Lease;
import com.ibm.ws.leasemanager.LeaseException;
import com.ibm.ws.leasemanager.LeaseHijackedException;
import com.ibm.ws.leasemanager.LeaseInfo;
import com.ibm.ws.leasemanager.LeaseManagerService;
import com.ibm.ws.leasemanager.LeaseNotAvailableException;
import com.ibm.ws.scheduler.DaemonCoordinatorImpl;
import com.ibm.ws.scheduler.PartitionInfo;
import java.util.Date;
import java.util.Iterator;

class LeaseAlarm
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(LeaseAlarm.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private DaemonCoordinatorImpl daemonCoordinator;
    private LeaseManagerService leaseMgr;
    private String leaseOwnerName;
    private String leaseResourceNamePrefix;
    private int leaseAlarmInterval;
    private int leaseTime = 0;
    private boolean loggedRenewalFailure = false;
    private boolean cancelled = false;
    private String schedJNDIName = null;

    public LeaseAlarm(DaemonCoordinatorImpl daemonCoordinatorImpl, LeaseManagerService leaseManagerService, String string, String string2, int n, int n2) {
        this.daemonCoordinator = daemonCoordinatorImpl;
        this.leaseMgr = leaseManagerService;
        this.leaseOwnerName = string;
        this.leaseResourceNamePrefix = string2;
        this.leaseAlarmInterval = n;
        this.leaseTime = n2;
        this.schedJNDIName = daemonCoordinatorImpl.schedConfig.getJndiName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        block35: {
            boolean bl = tc.isEntryEnabled();
            boolean bl2 = tc.isDebugEnabled();
            if (bl) {
                Tr.entry(tc, "alarm", new Object[]{this.schedJNDIName, object});
            }
            PartitionInfo partitionInfo = (PartitionInfo)object;
            String string = this.leaseResourceNamePrefix + "_" + partitionInfo.getLabel();
            try {
                if (this.isCancelled()) {
                    if (bl2) {
                        Tr.debug(tc, "LeaseAlarm listener has been cancelled.  Aborting.");
                    }
                    return;
                }
                Lease lease = this.daemonCoordinator.getLeaseFromPartitionInfo(partitionInfo);
                Lease lease2 = null;
                if (lease == null) {
                    block34: {
                        try {
                            if (partitionInfo.isPreferred) {
                                if (bl2) {
                                    Tr.debug(tc, "No current lease.  Attempting to force acquire new.");
                                }
                                lease2 = this.leaseMgr.acquireLease(this.leaseOwnerName, string, null, this.leaseTime, true);
                            } else {
                                if (bl2) {
                                    Tr.debug(tc, "No current lease.  Attempting to acquire new.");
                                }
                                lease2 = this.leaseMgr.acquireLease(this.leaseOwnerName, string, null, this.leaseTime, false);
                            }
                        }
                        catch (LeaseNotAvailableException leaseNotAvailableException) {
                            if (bl2) {
                                Tr.debug(tc, "LeaseNotAvailableException.  CurOwner=" + leaseNotAvailableException.getOwner() + ", LeaseExp=" + new Date(leaseNotAvailableException.getLeaseExpireTime()));
                            }
                            if (!this.loggedRenewalFailure) {
                                Tr.info(tc, "SCHD0134I", new Object[]{this.daemonCoordinator.schedConfig.getName(), this.daemonCoordinator.schedConfig.getJndiName(), leaseNotAvailableException.getOwner()});
                                this.loggedRenewalFailure = true;
                            }
                        }
                        catch (LeaseException leaseException) {
                            if (bl2) {
                                Tr.debug(tc, "LeaseException", leaseException);
                            }
                            if (this.loggedRenewalFailure) break block34;
                            Tr.error(tc, "SCHD0125E", new Object[]{"acquireLease", leaseException});
                            Tr.info(tc, "SCHD0134I", new Object[]{this.daemonCoordinator.schedConfig.getName(), this.daemonCoordinator.schedConfig.getJndiName(), this.getLeaseOwner(string)});
                            this.loggedRenewalFailure = true;
                        }
                    }
                    if (lease2 != null) {
                        if (bl2) {
                            Tr.debug(tc, "Lease acquired..  LeaseExp: " + lease2.getLeaseExpireTime());
                        }
                        Tr.info(tc, "SCHD0133I", new Object[]{this.daemonCoordinator.schedConfig.getName(), this.daemonCoordinator.schedConfig.getJndiName()});
                        this.loggedRenewalFailure = false;
                        lease = lease2;
                        this.daemonCoordinator.addLease(partitionInfo, lease);
                        this.daemonCoordinator.updateDaemonPartitionRanges();
                    }
                    break block35;
                }
                try {
                    if (bl2) {
                        Tr.debug(tc, "Attempting to renew lease.");
                    }
                    lease.renew(this.leaseTime);
                    if (bl2) {
                        Tr.debug(tc, "Lease renewed.  LeaseExp: " + lease.getLeaseExpireTime());
                    }
                }
                catch (LeaseHijackedException leaseHijackedException) {
                    if (bl2) {
                        Tr.debug(tc, "Lease Hijacked.  CurOwner=" + this.getLeaseOwner(string));
                    }
                    if (!this.loggedRenewalFailure) {
                        Tr.info(tc, "SCHD0134I", new Object[]{this.daemonCoordinator.schedConfig.getName(), this.daemonCoordinator.schedConfig.getJndiName(), this.getLeaseOwner(string)});
                        this.loggedRenewalFailure = true;
                    }
                    this.daemonCoordinator.removeLease(partitionInfo);
                    this.daemonCoordinator.updateDaemonPartitionRanges();
                }
            }
            catch (RuntimeException runtimeException) {
                if (bl2) {
                    Tr.debug(tc, "Exception caught during LeaseAlarm fire: " + runtimeException.getMessage(), runtimeException);
                }
                FFDCFilter.processException(runtimeException, "com.ibm.ws.scheduler.LeaseAlarm", "170");
                if (!this.loggedRenewalFailure) {
                    Tr.error(tc, "SCHD0125E", new Object[]{"LeaseAlarm RuntimeException: " + this.daemonCoordinator.schedConfig.getName() + "(" + this.daemonCoordinator.schedConfig.getJndiName() + ")", runtimeException});
                    Tr.info(tc, "SCHD0134I", new Object[]{this.daemonCoordinator.schedConfig.getName(), this.daemonCoordinator.schedConfig.getJndiName(), this.getLeaseOwner(string)});
                    this.loggedRenewalFailure = true;
                }
            }
            finally {
                if (this.isCancelled()) {
                    if (bl) {
                        Tr.exit(tc, "alarm", "cancelled");
                    }
                } else {
                    AlarmManager.createNonDeferrable(this.leaseAlarmInterval, this, object);
                    if (bl) {
                        Tr.exit(tc, "alarm", "reset");
                    }
                }
            }
        }
    }

    private String getLeaseOwner(String string) {
        String string2 = "?";
        try {
            Iterator iterator = this.leaseMgr.findLeasesByResource(string);
            if (iterator.hasNext()) {
                LeaseInfo leaseInfo = (LeaseInfo)iterator.next();
                string2 = leaseInfo.getOwner();
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during findLeasesByResource", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.LeaseAlarm", "150");
        }
        return string2;
    }

    public synchronized void cancel() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cancelling LeaseAlarm listener for scheduler: " + this.schedJNDIName);
        }
        this.cancelled = true;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }
}

