/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.websphere.scheduler.MessageTaskInfo;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.scheduler.AbstractTask;
import com.ibm.ws.scheduler.LazyTaskHolder;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.tasks.MessageTaskInfoWork;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoder;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

public class MessageTaskInfoImpl
extends AbstractTask
implements MessageTaskInfo {
    private static final long serialVersionUID = -1838516920306783462L;
    private boolean transacted = true;

    public void initialize(String string, String string2, int n, byte by, boolean bl, Date date, String string3, Date date2, Date date3, Date date4, String string4, int n2, int n3, LazyTaskHolder lazyTaskHolder, String string5, boolean bl2, int n4, int n5, int n6, int n7, Date date5) {
        super.initialize(string, string2, n, by, bl, date, string3, date2, date3, date4, string4, n2, n3, lazyTaskHolder, string5, bl2, n4, n5, n6, n7, date5);
    }

    public MessageTaskInfoImpl() {
        this.getTaskHolder().setTargetRunnable(new MessageWork());
    }

    public void initialize(String string, String string2, String string3) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).initialize(string, string2, string3);
    }

    public void initialize(String string, String string2, Map map) throws JMSException {
        this.validateMapMessage(map);
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).initialize(string, string2, new HashMap(map));
    }

    public void initialize(String string, String string2, byte[] byArray) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).initialize(string, string2, byArray);
    }

    public void setConnectionFactoryJndiName(String string) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setConnectionFactoryJndiName(string);
    }

    public String getConnectionFactoryJndiName() {
        return ((MessageWork)this.getTaskHolder().getTargetRunnable()).getConnectionFactoryJndiName();
    }

    public void setDestinationJndiName(String string) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setDestinationJndiName(string);
    }

    public String getDestinationJndiName() {
        return ((MessageWork)this.getTaskHolder().getTargetRunnable()).getDestinationJndiName();
    }

    public void setMessageData(String string) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setMessageData(string);
    }

    public void setMessageData(Map map) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setMessageData(map);
    }

    public void setMessageData(byte[] byArray) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setMessageData(byArray);
    }

    public Object getMessageData() {
        return ((MessageWork)this.getTaskHolder().getTargetRunnable()).getMessageData();
    }

    public void setJMSPriority(int n) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setJMSPriority(n);
    }

    public int getJMSPriority() {
        return ((MessageWork)this.getTaskHolder().getTargetRunnable()).getJMSPriority();
    }

    public void setUsername(String string) {
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setUsername(string);
    }

    public String getUsername() {
        return ((MessageWork)this.getTaskHolder().getTargetRunnable()).getUsername();
    }

    public void setMessageHeaders(Map map) throws JMSException {
        this.validateHeaderMap(map);
        ((MessageWork)this.getTaskHolder().getTargetRunnable()).setMessageHeaders(new HashMap(map));
    }

    public Map getMessageHeaders() {
        HashMap hashMap = ((MessageWork)this.getTaskHolder().getTargetRunnable()).getMessageHeaders();
        if (hashMap != null) {
            hashMap = new HashMap(hashMap);
        }
        return hashMap;
    }

    public void setPassword(String string) {
        if (string != null) {
            String string2 = MessageTaskInfoImpl.getDefaultEncoderDecoder().encode(string);
            ((MessageWork)this.getTaskHolder().getTargetRunnable()).setPassword(string2);
        } else {
            ((MessageWork)this.getTaskHolder().getTargetRunnable()).setPassword(null);
        }
    }

    private static EncoderDecoder getDefaultEncoderDecoder() {
        return EncoderDecoderRegistry.getDefaultRegistry().getDefaultEncoderDecoder();
    }

    private void validateHeaderMap(Map map) throws JMSException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) {
                throw new JMSException(Messages.getMessage("SCHD0123E", new String[]{"MessageHeader Keys, " + k.getClass().getName() + ",", "java.lang.String"}));
            }
            String string = (String)k;
            Object v = map.get(string);
            if (v instanceof Boolean || v instanceof Byte || v instanceof Short || v instanceof Integer || v instanceof Long || v instanceof Float || v instanceof Double || v instanceof String) continue;
            throw new JMSException(Messages.getMessage("SCHD0123E", new String[]{"MessageHeader Values, " + v.getClass().getName() + ",", "java.lang.String, java.lang.[primitives]"}));
        }
    }

    private void validateMapMessage(Map map) throws JMSException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) {
                throw new JMSException(Messages.getMessage("SCHD0123E", new String[]{"MapMessage Keys, " + k.getClass().getName() + ",", "java.lang.String"}));
            }
            String string = (String)k;
            Object v = map.get(string);
            if (v instanceof Serializable) continue;
            throw new JMSException(Messages.getMessage("SCHD0123E", new String[]{"MapMessage Values, " + v.getClass().getName() + ",", "java.io.Serializable"}));
        }
    }

    private class MessageWork
    extends Runnable
    implements FFDCSelfIntrospectable {
        static final int TEXT_MESSAGE = 0;
        static final int BYTE_MESSAGE = 1;
        static final int MAP_MESSAGE = 2;
        private static final long serialVersionUID = -5950686027528041336L;
        protected String destinationJndiName = null;
        protected String cfJndiName = null;
        protected int messageType = -1;
        protected byte[] byteMessage = null;
        protected String textMessage = null;
        protected Map mapMessage = null;
        protected int priority = 0;
        protected String username = null;
        protected String password = null;
        protected Map messageHeaders;

        private String getMessageTypeAsString(int n) {
            switch (n) {
                case 0: {
                    return "TEXT_MESSAGE (" + n + ')';
                }
                case 1: {
                    return "BYTE_MESSAGE (" + n + ')';
                }
                case 2: {
                    return "MAP_MESSAGE (" + n + ')';
                }
            }
            return "UNKNOWN (" + n + ')';
        }

        public void initialize(String string, String string2, String string3) {
            this.messageType = 0;
            this.cfJndiName = string;
            this.destinationJndiName = string2;
            this.textMessage = string3;
        }

        public void initialize(String string, String string2, Map map) {
            this.messageType = 2;
            this.cfJndiName = string;
            this.destinationJndiName = string2;
            this.mapMessage = map;
        }

        public void initialize(String string, String string2, byte[] byArray) {
            this.messageType = 1;
            this.cfJndiName = string;
            this.destinationJndiName = string2;
            this.byteMessage = byArray;
        }

        public String[] introspectSelf() {
            return new String[]{this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)), "Destination JNDI name = " + this.destinationJndiName, "Connection Factory JNDI name = " + this.cfJndiName, "User name = " + this.username, "Password = ******", "Priority = " + this.priority, "Message type = " + this.getMessageTypeAsString(this.messageType), "Text message = " + this.textMessage, "Byte message = " + this.byteMessage, "Map message = " + this.mapMessage, "Message headers = " + this.messageHeaders};
        }

        public void setMessageHeaders(Map map) {
            this.messageHeaders = map;
        }

        public Map getMessageHeaders() {
            return this.messageHeaders;
        }

        public void setConnectionFactoryJndiName(String string) {
            this.cfJndiName = string;
        }

        public String getConnectionFactoryJndiName() {
            return this.cfJndiName;
        }

        public void setDestinationJndiName(String string) {
            this.destinationJndiName = string;
        }

        public String getDestinationJndiName() {
            return this.destinationJndiName;
        }

        public void setMessageData(String string) {
            this.textMessage = string;
            this.messageType = 0;
        }

        public void setMessageData(Map map) {
            this.mapMessage = map;
            this.messageType = 2;
        }

        public void setMessageData(byte[] byArray) {
            this.byteMessage = byArray;
            this.messageType = 1;
        }

        public Object getMessageData() {
            switch (this.messageType) {
                case 0: {
                    return this.textMessage;
                }
                case 2: {
                    return this.mapMessage;
                }
                case 1: {
                    return this.byteMessage;
                }
            }
            return null;
        }

        public void setJMSPriority(int n) {
            this.priority = n;
        }

        public int getJMSPriority() {
            return this.priority;
        }

        public void setUsername(String string) {
            this.username = string;
        }

        public String getUsername() {
            return this.username;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void doWork() throws Exception {
            MessageTaskInfoWork.sendMessage(this.destinationJndiName, this.cfJndiName, this.username, this.password, MessageTaskInfoImpl.this.transacted, this.messageType, this.textMessage, this.byteMessage, this.mapMessage, this.priority, this.messageHeaders);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
        }
    }
}

