/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.scheduler.NotificationException;
import com.ibm.websphere.scheduler.NotificationSink;
import com.ibm.websphere.scheduler.NotificationSinkHome;
import com.ibm.websphere.scheduler.NotificationSinkInvalid;
import com.ibm.websphere.scheduler.TaskNotificationInfo;
import com.ibm.ws.ejbcontainer.BasicEJBInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.scheduler.ByteSerializable;
import com.ibm.ws.scheduler.ByteSerializationUtils;
import com.ibm.ws.scheduler.NotificationSinkHolderI;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.exception.ByteSerializeException;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class NotificationSinkHolder
implements NotificationSinkHolderI,
Serializable,
ByteSerializable {
    private static final TraceComponent tc = Tr.register(NotificationSinkHolder.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final long serialVersionUID = 6628310864235729677L;
    protected int mask = 0;
    protected HomeHandle handle = null;
    protected String jndiName = null;
    ByteSerializeException mask_Error = null;
    ByteSerializeException handle_Error = null;
    ByteSerializeException jndiName_Error = null;
    public static final short VER_6_0_0 = 1536;
    private static final short BYTEID_MASK = 10401;
    private static final short BYTEID_HANDLE = 10402;
    private static final short BYTEID_JNDINAME = 10403;
    private static final short VERSID_MASK = 1536;
    private static final short VERSID_HANDLE = 1536;
    private static final short VERSID_JNDINAME = 1536;

    public void setNotificationListener(String string, int n) {
        this.jndiName = string;
        this.jndiName_Error = null;
        this.mask = n;
        this.mask_Error = null;
    }

    public void setNotificationListener(NotificationSinkHome notificationSinkHome, int n) throws NotificationSinkInvalid {
        if (notificationSinkHome == null) {
            throw new NotificationSinkInvalid(Messages.getMessage("SCHD0109E", "NotificationSinkHome"));
        }
        try {
            this.handle_Error = null;
            this.handle = notificationSinkHome.getHomeHandle();
        }
        catch (RemoteException remoteException) {
            throw new NotificationSinkInvalid(Utils.getExceptionMessageWithType(remoteException), remoteException);
        }
        this.mask = n;
        this.mask_Error = null;
    }

    public NotificationSinkHome getNotificationListener() throws NotificationSinkInvalid {
        try {
            if (this.handle == null) {
                return null;
            }
            return (NotificationSinkHome)this.handle.getEJBHome();
        }
        catch (RemoteException remoteException) {
            throw new NotificationSinkInvalid(Messages.getMessage("SCHD0138E", "NotificationSinkHome"), remoteException);
        }
    }

    public String getNotificationListenerJNDIName() {
        if (this.jndiName_Error != null) {
            throw this.jndiName_Error;
        }
        return this.jndiName;
    }

    public void resolveHome() throws NotificationSinkInvalid {
        if (this.jndiName != null) {
            try {
                InitialContext initialContext = new InitialContext();
                Object object = initialContext.lookup(this.jndiName);
                NotificationSinkHome notificationSinkHome = (NotificationSinkHome)PortableRemoteObject.narrow((Object)object, (Class)NotificationSinkHome.class);
                this.handle = notificationSinkHome.getHomeHandle();
            }
            catch (Exception exception) {
                throw new NotificationSinkInvalid(Utils.getExceptionMessageWithType(exception), exception);
            }
        }
    }

    public void sendNotificationToListeners(TaskNotificationInfo taskNotificationInfo) throws NotificationException {
        if (this.isUsedFor(taskNotificationInfo)) {
            this.fireEvent(taskNotificationInfo);
        }
    }

    public void fireEvent(TaskNotificationInfo taskNotificationInfo) throws NotificationException {
        NotificationSinkHome notificationSinkHome = this.createBeanHome();
        NotificationSink notificationSink = this.createBeanInstance(notificationSinkHome);
        try {
            notificationSink.handleEvent(taskNotificationInfo);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during NotificationSink.handleEvent:", exception);
            }
            try {
                EJBContainer eJBContainer = (EJBContainer)WsServiceRegistry.getService((Object)this, (Class)EJBContainer.class);
                BasicEJBInfo basicEJBInfo = eJBContainer.getBasicEJBInfo(notificationSinkHome);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBInfo: ", basicEJBInfo);
                }
                throw new NotificationException(Messages.getMessage("SCHD0139E", new Object[]{"NotificationSink", Utils.getExceptionMessageWithType(exception) + " " + Messages.getMessage("SCHD0140I", new Object[]{basicEJBInfo.getHost() + " (" + basicEJBInfo.getHostIP() + ")", new Integer(basicEJBInfo.getPort()), basicEJBInfo.getJ2EEName()})}), exception);
            }
            catch (NotificationException notificationException) {
                throw notificationException;
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.scheduler.NotificationSinkHolder.fireEvent", "180", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting EJBInfo:", exception);
                }
                throw new NotificationException(Messages.getMessage("SCHD0139E", new Object[]{"NotificationSink", Utils.getExceptionMessageWithType(exception)}), exception);
            }
        }
    }

    public boolean isUsedFor(TaskNotificationInfo taskNotificationInfo) {
        int n = taskNotificationInfo.getEventType();
        return (n & this.mask) != 0;
    }

    private NotificationSinkHome createBeanHome() throws NotificationException {
        if (this.handle_Error != null) {
            throw new NotificationException(Messages.getMessage("SCHD0014E", this.handle_Error.getLocalizedMessage()), this.handle_Error);
        }
        try {
            return (NotificationSinkHome)this.handle.getEJBHome();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.NotificationSinkHolder.createBeanHome", "280");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during NotificationSink getEJBHome:", throwable);
            }
            throw new NotificationException(Messages.getMessage("SCHD0138E", "TaskHandlerHome"), throwable);
        }
    }

    private NotificationSink createBeanInstance(NotificationSinkHome notificationSinkHome) throws NotificationException {
        NotificationSink notificationSink;
        try {
            notificationSink = notificationSinkHome.create();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.NotificationSinkHolder.createBeanHome", "250");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during NotificationSink create:", throwable);
            }
            try {
                EJBContainer eJBContainer = (EJBContainer)WsServiceRegistry.getService((Object)this, (Class)EJBContainer.class);
                BasicEJBInfo basicEJBInfo = eJBContainer.getBasicEJBInfo(notificationSinkHome);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBInfo: ", basicEJBInfo);
                }
                throw new NotificationException(Messages.getMessage("SCHD0137E", new Object[]{"NotificationSink", Utils.getExceptionMessageWithType(throwable) + " " + Messages.getMessage("SCHD0140I", new Object[]{basicEJBInfo.getHost() + " (" + basicEJBInfo.getHostIP() + ")", new Integer(basicEJBInfo.getPort()), basicEJBInfo.getJ2EEName()})}), throwable);
            }
            catch (NotificationException notificationException) {
                throw notificationException;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.scheduler.NotificationSinkHolder.createBeanHome", "260");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting EJBInfo:", throwable);
                }
                throw new NotificationException(Messages.getMessage("SCHD0137E", new Object[]{"NotificationSink", Utils.getExceptionMessageWithType(throwable)}), throwable);
            }
        }
        return notificationSink;
    }

    public byte[] getBytes() throws ByteSerializeException {
        byte[] byArray;
        block6: {
            boolean bl = tc.isEntryEnabled();
            if (bl) {
                Tr.entry(tc, "getBytes");
            }
            byte[] byArray2 = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                ByteSerializationUtils.writeHeader(objectOutputStream, (short)3);
                ByteSerializationUtils.writeFieldInt(objectOutputStream, (short)10401, (short)1536, this.mask);
                ByteSerializationUtils.writeFieldObject(objectOutputStream, (short)10402, (short)1536, this.handle);
                ByteSerializationUtils.writeFieldObject(objectOutputStream, (short)10403, (short)1536, this.jndiName);
                objectOutputStream.close();
                byteArrayOutputStream.flush();
                byArray2 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                byArray = byArray2;
                if (!bl) break block6;
            }
            catch (Throwable throwable) {
                try {
                    throw new ByteSerializeException(Utils.getExceptionMessageWithType(throwable), throwable);
                }
                catch (Throwable throwable2) {
                    if (bl) {
                        Tr.exit(tc, "getBytes", new Object[]{byArray2});
                    }
                    throw throwable2;
                }
            }
            Tr.exit(tc, "getBytes", new Object[]{byArray2});
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBytes(byte[] byArray) throws ByteSerializeException {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "setBytes", new Object[]{byArray});
        }
        try {
            short[] sArray = new short[]{10401, 10402, 10403};
            short[] sArray2 = new short[]{1536, 1536, 1536};
            J2EEName[] j2EENameArray = new J2EEName[]{null, null, null};
            ByteSerializeException[] byteSerializeExceptionArray = new ByteSerializeException[3];
            Object[] objectArray = ByteSerializationUtils.getObjectByIDAndVersion(byArray, sArray, sArray2, j2EENameArray, byteSerializeExceptionArray);
            Integer n = (Integer)objectArray[0];
            this.mask = n == null ? 0 : n;
            this.mask_Error = byteSerializeExceptionArray[0];
            this.handle = (HomeHandle)objectArray[1];
            this.handle_Error = Utils.getHomeHandleExceptionWrapper(byteSerializeExceptionArray[1]);
            this.jndiName = (String)objectArray[2];
            this.jndiName_Error = byteSerializeExceptionArray[2];
            if (!bl) return;
        }
        catch (Throwable throwable) {
            try {
                throw new ByteSerializeException(Utils.getExceptionMessageWithType(throwable), throwable);
            }
            catch (Throwable throwable2) {
                if (!bl) throw throwable2;
                Tr.exit(tc, "setBytes", new Object[]{new Integer(this.mask), this.handle, this.jndiName});
                throw throwable2;
            }
        }
        Tr.exit(tc, "setBytes", new Object[]{new Integer(this.mask), this.handle, this.jndiName});
        return;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

