/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectUtility {
    static String primSigs = "BSZCIJFD";

    public static String getClassSignature(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getName();
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (clazz.equals(Character.TYPE)) {
                return "C";
            }
            if (clazz.equals(Byte.TYPE)) {
                return "B";
            }
            if (clazz.equals(Short.TYPE)) {
                return "S";
            }
            if (clazz.equals(Integer.TYPE)) {
                return "I";
            }
            if (clazz.equals(Long.TYPE)) {
                return "J";
            }
            if (clazz.equals(Float.TYPE)) {
                return "F";
            }
            if (clazz.equals(Double.TYPE)) {
                return "D";
            }
            return clazz.toString();
        }
        return new String("L" + clazz.getName() + ";");
    }

    public static String getClassSignatures(Class[] classArray) {
        String string = new String("");
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                string = string + ReflectUtility.getClassSignature(classArray[i]);
            }
        }
        return string;
    }

    public static String getMethodParamSignature(Method method2) {
        return ReflectUtility.getClassSignatures(method2.getParameterTypes());
    }

    public static Method getMethodFromObjectSignature(Object object, String string, String string2, ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException {
        return object.getClass().getMethod(string, ReflectUtility.getClassesFromSignature(string2, classLoader));
    }

    static boolean isPrimitiveSig(String string) {
        return primSigs.indexOf(string) >= 0;
    }

    public static Class[] getClassesFromSignature(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int n = 0;
        try {
            ArrayList<Class> arrayList = new ArrayList<Class>();
            while (n < string.length()) {
                String string2 = string.substring(n, n + 1);
                if (ReflectUtility.isPrimitiveSig(string2)) {
                    arrayList.add(ReflectUtility.getClassFromSignature(string2, classLoader));
                    ++n;
                    continue;
                }
                if (string2.equals("L")) {
                    String string3 = string.substring(n, string.indexOf(59, n) + 1);
                    arrayList.add(ReflectUtility.getClassFromSignature(string3, classLoader));
                    n += string3.length();
                    continue;
                }
                if (string2.equals("[")) {
                    String string4;
                    int n2 = ReflectUtility.lastContiguousStringPos(string.substring(n), "[") + 1;
                    string2 = string.substring(n2 + n, n2 + n + 1);
                    if (ReflectUtility.isPrimitiveSig(string2)) {
                        string4 = string.substring(n, n2 + n + 1);
                        arrayList.add(ReflectUtility.getClassFromSignature(string4, classLoader));
                        n += string4.length();
                        continue;
                    }
                    if (string2.equals("L")) {
                        string4 = string.substring(n, string.indexOf(59, n) + 1);
                        arrayList.add(ReflectUtility.getClassFromSignature(string4, classLoader));
                        n += string4.length();
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid signature format detected at position " + n);
                }
                throw new IllegalArgumentException("Invalid signature format detected at position " + n);
            }
            return arrayList.toArray(new Class[arrayList.size()]);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid class signature format detected at position " + n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid class signature format detected at position " + n);
        }
    }

    private static Class getClassFromSignature(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<Comparable<Byte>> clazz = null;
        if (string.length() == 0) {
            return null;
        }
        if (string.equals("B")) {
            clazz = Byte.TYPE;
        } else if (string.equals("S")) {
            clazz = Short.TYPE;
        } else if (string.equals("Z")) {
            clazz = Boolean.TYPE;
        } else if (string.equals("C")) {
            clazz = Character.TYPE;
        } else if (string.equals("I")) {
            clazz = Integer.TYPE;
        } else if (string.equals("J")) {
            clazz = Long.TYPE;
        } else if (string.equals("F")) {
            clazz = Float.TYPE;
        } else if (string.equals("D")) {
            clazz = Double.TYPE;
        } else if (string.startsWith("[")) {
            int n = ReflectUtility.CountStringChars(string, '[');
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 0;
            }
            String string2 = string.substring(string.lastIndexOf("[") + 1, string.length());
            Class clazz2 = ReflectUtility.getClassFromSignature(string2, classLoader);
            Object object = Array.newInstance(clazz2, nArray);
            clazz = object.getClass();
        } else if (string.startsWith("L") && string.endsWith(";")) {
            String string3 = string.substring(1, string.length() - 1);
            clazz = Class.forName(string3, true, classLoader);
        } else {
            throw new IllegalArgumentException("Invalid type signature detected: " + string);
        }
        return clazz;
    }

    public static int getArrayDims(Object object) {
        return ReflectUtility.getArrayDims(object.getClass());
    }

    public static int getArrayDims(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isArray()) {
                return 1 + ReflectUtility.getArrayDims(clazz2);
            }
            return 1;
        }
        return 0;
    }

    public static int[] getArrayDimElements(Object object, int n) {
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Array.getLength(object);
                object = Array.get(object, 0);
            }
            return nArray;
        }
        return null;
    }

    public static Object getBaseArrayObject(Object object) throws Exception {
        if (object.getClass().isArray()) {
            Object object2 = Array.get(object, 0);
            if (object2 == null) {
                return object.getClass().getComponentType().newInstance();
            }
            return ReflectUtility.getBaseArrayObject(object2);
        }
        return object;
    }

    public static Class getBaseArrayClass(Object object) {
        return ReflectUtility.getBaseArrayClass(object.getClass());
    }

    public static Class getBaseArrayClass(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isArray()) {
                return ReflectUtility.getBaseArrayClass(clazz2);
            }
            return clazz2;
        }
        return clazz;
    }

    public static int CountStringChars(String string, char c) {
        int n = -1;
        int n2 = string.length();
        int n3 = 0;
        while (++n < n2) {
            if (string.charAt(n) != c) continue;
            ++n3;
        }
        return n3;
    }

    public static int lastContiguousStringPos(String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.substring(i, i + 1).equals(string2)) continue;
            return i - 1;
        }
        return 0;
    }
}

