/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.scheduler.SchedulerConfigHelper;
import com.ibm.ws.scheduler.SchedulerConfigService;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.WASSchedulerCfgHelper;
import com.ibm.ws.scheduler.WASSchedulerCfgHelperMbeanWrapper;
import com.ibm.ws.scheduler.resources.Messages;
import java.util.Properties;

public class SchedulerConfigServiceImpl
extends ComponentImpl
implements SchedulerConfigService {
    private static final TraceComponent tc = Tr.register(SchedulerConfigServiceImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    protected static SchedulerConfigServiceImpl instance = null;
    protected VariableMap varMap = null;
    protected ResourceMgr resourceMgr = null;
    protected ExtensionHelper extHelper = null;
    protected Repository repository = null;
    protected WASSchedulerCfgHelper cfgHelper = null;

    public void initialize(Object object) {
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (instance == null) {
            this.addService(SchedulerConfigService.class);
            this.varMap = (VariableMap)this.getService(VariableMap.class);
            if (this.varMap == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "The VariableMap service is not available.");
            }
            this.resourceMgr = (ResourceMgr)this.getService(ResourceMgr.class);
            if (this.resourceMgr == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "The ResourceMgr service is not available.");
            }
            this.extHelper = (ExtensionHelper)this.getService(ExtensionHelper.class);
            if (this.extHelper == null) {
                Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"ExtensionHelper"});
                throw new RuntimeWarning(Messages.getMessage("ERR_NO_SERVICE", "ExtensionHelper"));
            }
            this.repository = (Repository)this.getService(Repository.class);
            if (this.repository == null) {
                Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"Repository"});
                throw new RuntimeWarning(Messages.getMessage("ERR_NO_SERVICE", "ExtensionHelper"));
            }
            instance = this;
            this.cfgHelper = new WASSchedulerCfgHelper(SchedulerConfigServiceImpl.getInstance());
            try {
                Utils.createMBean("WASSchedulerCfgHelper", "Scheduler_Config_Helper", null, new DefaultRuntimeCollaborator(new WASSchedulerCfgHelperMbeanWrapper(this.cfgHelper)), new Properties());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerConfigServiceImpl.start", "79", this);
                Tr.error(tc, "SCHD0129E", new Object[]{"WASSchedulerCfgHelper", "System", throwable});
            }
        }
    }

    public void stop() {
        if (this.varMap != null) {
            this.releaseService(this.varMap);
            this.varMap = null;
        }
        if (this.resourceMgr != null) {
            this.releaseService(this.resourceMgr);
            this.resourceMgr = null;
        }
        if (this.extHelper != null) {
            this.releaseService(this.extHelper);
            this.extHelper = null;
        }
    }

    public ResourceMgr getResourceMgr() {
        return this.resourceMgr;
    }

    public VariableMap getVariableMap() {
        return this.varMap;
    }

    public ExtensionHelper getExtensionHelper() {
        if (this.extHelper == null) {
            this.extHelper = (ExtensionHelper)this.getService(ExtensionHelper.class);
        }
        return this.extHelper;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public SchedulerConfigHelper getSchedulerConfigHelper() {
        return this.cfgHelper;
    }

    public static SchedulerConfigService getInstance() {
        return instance;
    }
}

