/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.AlarmManager;
import com.ibm.websphere.asynchbeans.AsynchScope;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkException;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.scheduler.SchedulerNotAvailableException;
import com.ibm.websphere.scheduler.SchedulerRuntimeException;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ThreadMonitor;
import com.ibm.ws.scheduler.AlarmContext;
import com.ibm.ws.scheduler.AlarmListener;
import com.ibm.ws.scheduler.ApplicationTracker;
import com.ibm.ws.scheduler.DBHelper;
import com.ibm.ws.scheduler.DaemonCoordinator;
import com.ibm.ws.scheduler.DaemonCoordinatorImpl;
import com.ibm.ws.scheduler.Range;
import com.ibm.ws.scheduler.RunningThreadInfo;
import com.ibm.ws.scheduler.SchedulerDaemon;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.TaskStore;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.config.SchedulerConfiguration;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import com.ibm.ws.scheduler.exception.SchedulerServiceInternalException;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.Scheduler;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.DuplicateKeyException;

public class SchedulerDaemonImpl
implements SchedulerDaemon,
Work {
    private static final TraceComponent tc = Tr.register(SchedulerDaemonImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private AsynchScope asynchScope_Parent;
    private AsynchScope asynchScope_Tasks = null;
    private String asynchScopeName_Tasks;
    private WriterPriorityReadersWriterLock asynchScope_Tasks_Lock = new WriterPriorityReadersWriterLock();
    protected DaemonCoordinatorImpl daemonCoordinator = null;
    protected TransactionControl tranControl = null;
    protected WorkManager wm = null;
    protected TaskStore ts = null;
    protected boolean released = true;
    protected int pollDelay = 0;
    protected Scheduler sched = null;
    protected Object waitLock = new Object();
    private String daemonID = null;
    private long nextEstPollTime = 0L;
    private int pollInterval;
    private long prevPollStartTime;
    private int querySize;
    private boolean taskStoreGood = false;
    private boolean taskStoreBadNotificationSet = false;
    private boolean daemonNotified = false;
    private boolean isPolling = false;
    private Object isPollingLock = new Object();
    private Set runningTasks = Collections.synchronizedSortedSet(new TreeSet());
    private boolean useUncommittedRead = false;
    private Map runningThreads = Collections.synchronizedMap(new HashMap());
    protected int initialMaxQuerySize;
    protected int maxTaskLoadSize;
    private int executedTasksPerPoll = 0;
    private int taskCollisionsPerPoll = 0;
    private int taskFailuresPerPoll = 0;
    protected ApplicationTracker appTracker;

    private SchedulerDaemonImpl() {
    }

    public SchedulerDaemonImpl(String string, DaemonCoordinatorImpl daemonCoordinatorImpl, TransactionControl transactionControl, Scheduler scheduler, AsynchScope asynchScope, int n, int n2, int n3, ApplicationTracker applicationTracker, boolean bl) throws SchedulerDataStoreException {
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "<ctor>", new Object[]{string, daemonCoordinatorImpl, scheduler, asynchScope, new Integer(n)});
        }
        this.daemonCoordinator = daemonCoordinatorImpl;
        this.tranControl = transactionControl;
        this.sched = scheduler;
        this.ts = scheduler.getTaskStore();
        this.wm = scheduler.getWorkManager();
        this.daemonID = string;
        this.asynchScope_Parent = asynchScope;
        this.appTracker = applicationTracker;
        this.useUncommittedRead = bl;
        this.initialize(n, n2, n3);
        ThreadMonitor threadMonitor = (ThreadMonitor)SchedulerServiceImpl._instance.getService(ThreadMonitor.class);
        threadMonitor.addThreadMonitorListener(new ThreadMonListener());
        SchedulerServiceImpl._instance.releaseService(threadMonitor);
        this.asynchScopeName_Tasks = asynchScope.getName() + "_" + string;
        if (bl2) {
            Tr.exit(tc, "<ctor>");
        }
    }

    protected void initialize(int n, int n2, int n3) throws SchedulerDataStoreException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "initialize", new Object[]{new Integer(n), new Integer(n2), new Integer(n3)});
        }
        this.pollInterval = n;
        this.initialMaxQuerySize = n2;
        this.maxTaskLoadSize = n3;
        this.querySize = n2;
        this.setPrevPollStartTime(System.currentTimeMillis() - (long)n);
        if (bl) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "destroy");
        }
        try {
            this.stopDaemon();
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.destroy", "190", this);
            throw runtimeException;
        }
        finally {
            if (bl) {
                Tr.exit(tc, "destroy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "release");
        }
        SchedulerDaemonImpl schedulerDaemonImpl = this;
        synchronized (schedulerDaemonImpl) {
            this.released = true;
        }
        this.notifyDaemon();
        if (bl) {
            Tr.exit(tc, "release");
        }
    }

    private synchronized boolean getReleased() {
        return this.released;
    }

    private synchronized void setReleased(boolean bl) {
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "setReleased", new Boolean(bl));
        }
        this.released = bl;
        if (bl2) {
            Tr.exit(tc, "setReleased");
        }
    }

    private synchronized void setPollDelay(int n) {
        this.pollDelay = n;
    }

    private synchronized int getPollDelay() {
        return this.pollDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "run");
        }
        boolean bl3 = true;
        try {
            Range[] rangeArray = null;
            int n = -1;
            try {
                Thread.sleep(this.getPollDelay());
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.run", "205", this);
                throw interruptedException;
            }
            Object object = this.waitLock;
            synchronized (object) {
                this.daemonNotified = false;
            }
            while (!this.getReleased() && !Thread.interrupted()) {
                int n2;
                this.setIsPolling(true);
                long l = (long)this.getPollInterval() + System.currentTimeMillis();
                this.resetAsynchScope_Tasks();
                Range[] rangeArray2 = this.daemonCoordinator.getPartitionRangesForDaemon(this.daemonID);
                if (rangeArray2 != null && rangeArray2.length > 0) {
                    n2 = this.getQuerySize();
                    long l2 = System.currentTimeMillis();
                    try {
                        boolean bl4 = false;
                        if (rangeArray == null || rangeArray.length == 0 || !Range.equals(rangeArray, rangeArray2)) {
                            bl4 = true;
                        }
                        if (this.getReleased()) return;
                        if (Thread.interrupted()) {
                            return;
                        }
                        n = this.poll(new Date(l), rangeArray2, n2, bl3, l2, bl4);
                        bl3 = false;
                        long l3 = System.currentTimeMillis();
                        this.addDuration(l2, l3);
                        long l4 = l2 + (long)this.daemonCoordinator.getAvgPollDuration();
                        if (l4 > l) {
                            if (bl2) {
                                Tr.debug(tc, "NextEstPollTime is estimated to be late.");
                            }
                            this.setNextEstPollTime(l4);
                        } else {
                            this.setNextEstPollTime(l);
                        }
                    }
                    catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                        // empty catch block
                    }
                }
                this.setIsPolling(false);
                n2 = (int)(l - System.currentTimeMillis());
                if (n != -1) {
                    rangeArray = rangeArray2;
                }
                try {
                    if (n2 <= 0) continue;
                    if (bl2) {
                        Tr.debug(tc, "Waiting for " + n2 + "ms");
                    }
                    Object object2 = this.waitLock;
                    synchronized (object2) {
                        if (!this.daemonNotified) {
                            this.waitLock.wait(n2);
                        }
                        this.daemonNotified = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!bl2) throw interruptedException;
                    Tr.debug(tc, "Poll wait interrupted.  Stopping Daemon.");
                    throw interruptedException;
                    return;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.run", "380", this);
            if (!bl2) return;
            Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerDaemonImpl.run", "390", this);
            SchedulerConfiguration schedulerConfiguration = this.sched.getSchedulerConfiguration();
            Tr.error(tc, "SCHD0104E", new Object[]{schedulerConfiguration.getName(), schedulerConfiguration.getJndiName(), throwable});
            return;
        }
        finally {
            this.setIsPolling(false);
            this.stopDaemon();
            if (bl) {
                Tr.exit(tc, "run");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poll(Date date, Range[] rangeArray, int n, boolean bl, long l, boolean bl2) throws SchedulerNotAvailableException {
        boolean bl3 = tc.isEntryEnabled();
        boolean bl4 = tc.isDebugEnabled();
        if (bl3) {
            Tr.entry(tc, "poll", new Object[]{date, Range.toString(rangeArray), new Integer(n), new Long(l), new Boolean(bl2)});
        }
        try {
            int n2;
            block46: {
                if (this.sched.getPMIEnabled()) {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - this.getPrevPollStartTime();
                    this.sched.pollComplete(this.getExecutedTasksPerPoll(), this.getTaskCollisionsPerPoll(), (int)Math.round((double)(l3 > Integer.MAX_VALUE ? Integer.MAX_VALUE : l3) / 1000.0));
                    this.setExecutedTasksPerPoll(0);
                    this.setTaskCollisionsPerPoll(0);
                    this.setTaskFailuresPerPoll(0);
                    this.setPrevPollStartTime(l2);
                }
                TxHandle txHandle = null;
                n2 = -1;
                if (this.ts != null) {
                    Connection connection = null;
                    ResultSet resultSet = null;
                    try {
                        Throwable throwable4;
                        block50: {
                            block49: {
                                TaskInfo[] taskInfoArray;
                                block45: {
                                    taskInfoArray = new TaskInfo[]{};
                                    if (!this.taskStoreGood) {
                                        try {
                                            this.ts.getTableStatus();
                                            this.taskStoreGood = true;
                                        }
                                        catch (SchedulerDataStoreException schedulerDataStoreException) {
                                            this.taskStoreGood = false;
                                            if (this.taskStoreGood || this.taskStoreBadNotificationSet) break block45;
                                            SchedulerConfiguration schedulerConfiguration = this.sched.getSchedulerConfiguration();
                                            if (this.daemonCoordinator.pollFailureCache.setFailure(Utils.getExceptionMessageWithType(schedulerDataStoreException)) == this.daemonCoordinator.pollFailureCache.getFailureThreshold()) {
                                                // empty if block
                                            }
                                            Tr.error(tc, "SCHD0046E", new String[]{schedulerDataStoreException.getMessage(), schedulerConfiguration.getDataSourceJndiName(), schedulerConfiguration.getName(), schedulerConfiguration.getJndiName()});
                                            this.taskStoreBadNotificationSet = true;
                                        }
                                    }
                                }
                                if (!this.taskStoreGood) break block46;
                                txHandle = this.tranControl.preinvoke(true, false);
                                connection = this.useUncommittedRead ? this.ts.getDBHelper().getConnection(txHandle, 1, true) : this.ts.getDBHelper().getConnection(txHandle, 2, true);
                                long l4 = System.currentTimeMillis();
                                resultSet = this.ts.findTasksBeforeNotComplete(connection, date, n, rangeArray, bl2);
                                long l5 = System.currentTimeMillis() - l4;
                                try {
                                    try {
                                        long l6 = System.currentTimeMillis();
                                        do {
                                            taskInfoArray = this.ts.loadTasksFromResultSet(resultSet, this.maxTaskLoadSize);
                                            if (n2 == -1) {
                                                n2 = 0;
                                            }
                                            if (taskInfoArray == null || taskInfoArray.length <= 0) break;
                                            n2 += taskInfoArray.length;
                                            this.scheduleAlarmsForTasks(taskInfoArray, bl, l);
                                        } while (taskInfoArray.length == this.maxTaskLoadSize);
                                        if (bl4) {
                                            Tr.debug(tc, "Task Load/Set Time=" + (System.currentTimeMillis() - l6) + "ms");
                                        }
                                    }
                                    catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                                        FFDCFilter.processException((Throwable)schedulerNotAvailableException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "799", this);
                                        if (bl4) {
                                            Tr.debug(tc, "Error scheduling tasks.", new Object[]{schedulerNotAvailableException});
                                        }
                                        throw schedulerNotAvailableException;
                                    }
                                    finally {
                                        block48: {
                                            if (resultSet != null) {
                                                try {
                                                    resultSet.close();
                                                }
                                                catch (SQLException sQLException) {
                                                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "550", this);
                                                    if (!bl4) break block48;
                                                    Tr.debug(tc, "Caught exception closing resultset: " + sQLException.getMessage(), sQLException);
                                                }
                                            }
                                        }
                                    }
                                    this.sched.pmiPollQueryCompleted((int)(l5 > Integer.MAX_VALUE ? Integer.MAX_VALUE : l5), n2);
                                    this.daemonCoordinator.pollFailureCache.clearAllFailures();
                                    Object var24_29 = null;
                                }
                                catch (Throwable throwable2) {
                                    block53: {
                                        Throwable throwable32;
                                        block52: {
                                            block51: {
                                                Object var24_30 = null;
                                                try {
                                                    connection.commit();
                                                }
                                                catch (SQLException throwable32) {
                                                    FFDCFilter.processException(throwable32, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "560", this);
                                                    if (!bl4) break block51;
                                                    Tr.debug(tc, "Error scheduling tasks.", new Object[]{throwable32});
                                                }
                                            }
                                            try {
                                                this.ts.getDBHelper().returnConnection(connection);
                                            }
                                            catch (SQLException throwable32) {
                                                FFDCFilter.processException(throwable32, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "569", this);
                                                if (!bl4) break block52;
                                                Tr.debug(tc, "Error scheduling tasks.", new Object[]{throwable32});
                                            }
                                        }
                                        try {
                                            this.tranControl.postinvoke(txHandle);
                                        }
                                        catch (Throwable throwable32) {
                                            FFDCFilter.processException(throwable32, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "555", this);
                                            if (!bl4) break block53;
                                            Tr.debug(tc, "Caught exception committing tran: " + throwable32.getMessage(), throwable32);
                                        }
                                    }
                                    throw throwable2;
                                }
                                try {
                                    connection.commit();
                                }
                                catch (SQLException throwable4) {
                                    FFDCFilter.processException(throwable4, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "560", this);
                                    if (!bl4) break block49;
                                    Tr.debug(tc, "Error scheduling tasks.", new Object[]{throwable4});
                                }
                            }
                            try {
                                this.ts.getDBHelper().returnConnection(connection);
                            }
                            catch (SQLException throwable4) {
                                FFDCFilter.processException(throwable4, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "569", this);
                                if (!bl4) break block50;
                                Tr.debug(tc, "Error scheduling tasks.", new Object[]{throwable4});
                            }
                        }
                        try {
                            this.tranControl.postinvoke(txHandle);
                        }
                        catch (Throwable throwable4) {
                            FFDCFilter.processException(throwable4, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "555", this);
                            if (bl4) {
                                Tr.debug(tc, "Caught exception committing tran: " + throwable4.getMessage(), throwable4);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        n2 = -1;
                        SchedulerConfiguration schedulerConfiguration = this.sched.getSchedulerConfiguration();
                        if (this.daemonCoordinator.pollFailureCache.setFailure(Utils.getExceptionMessageWithType(throwable)) == this.daemonCoordinator.pollFailureCache.getFailureThreshold()) {
                            Tr.error(tc, "SCHD0104E", new Object[]{schedulerConfiguration.getName(), schedulerConfiguration.getJndiName(), throwable});
                        }
                        try {
                            if (connection != null && !connection.getAutoCommit() && !connection.isClosed()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.poll", "732", this);
                        }
                        this.tranControl.handleException(txHandle);
                    }
                } else {
                    if (this.daemonCoordinator.pollFailureCache.setFailure("NOTaskStore: Daemon=" + this.getID()) == 1) {
                        // empty if block
                    }
                    Tr.error(tc, "SCHD0128E", new Object[]{this.toString(), Messages.getMessage("SCHD0070E")});
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (bl3) {
                Tr.exit(tc, "poll");
            }
        }
    }

    public synchronized long getNextEstPollTime() {
        return this.nextEstPollTime;
    }

    protected synchronized void setNextEstPollTime(long l) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "setNextEstPollTime", new Date(l) + " (" + l + ")");
        }
        this.nextEstPollTime = l;
        if (bl) {
            Tr.exit(tc, "setNextEstPollTime");
        }
    }

    protected void addDuration(long l, long l2) {
        this.daemonCoordinator.addDuration(l, l2);
    }

    protected long getPrevPollStartTime() {
        return this.prevPollStartTime;
    }

    protected void setPrevPollStartTime(long l) {
        this.prevPollStartTime = l;
    }

    public synchronized int getPollInterval() {
        return this.pollInterval;
    }

    public synchronized void setPollInterval(int n) {
        this.pollInterval = n;
    }

    public synchronized void setQuerySize(int n) {
        this.querySize = n;
    }

    public synchronized int getQuerySize() {
        return this.querySize;
    }

    public void scheduleAlarm(TaskInfo taskInfo) {
        this.scheduleAlarmsForTasks(new TaskInfo[]{taskInfo}, false, this.getPrevPollStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAlarm(AlarmContext alarmContext, AlarmManager alarmManager) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "setAlarm", new Object[]{alarmContext.getAbstractTask()});
        }
        try {
            if (alarmContext == null) {
                throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "alarmContext"));
            }
            if (alarmManager == null) {
                throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "alarmManager"));
            }
            AlarmListener alarmListener = new AlarmListener(this, this.tranControl);
            TaskInfo taskInfo = alarmContext.getAbstractTask();
            if (taskInfo != null) {
                long l;
                long l2 = taskInfo.getNextFireTime().getTime();
                l2 = l2 < (l = System.currentTimeMillis()) ? 0L : (l2 -= l);
                if (bl2) {
                    Tr.debug(tc, "Next fire time: " + l2 + "ms");
                }
                alarmManager.create(alarmListener, alarmContext, (int)l2);
            } else if (bl2) {
                Tr.debug(tc, "Unable to setAlarm for task.  task is null");
            }
        }
        finally {
            if (bl) {
                Tr.exit(tc, "setAlarm");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAlarmsForTasks(TaskInfo[] taskInfoArray, boolean bl, long l) {
        boolean bl2 = tc.isEntryEnabled();
        boolean bl3 = tc.isDebugEnabled();
        if (bl2) {
            Tr.entry(tc, "scheduleAlarmsForTasks", new Object[]{new Integer(taskInfoArray.length), new Boolean(bl)});
        }
        try {
            long l2 = System.currentTimeMillis();
            AlarmManager alarmManager = null;
            try {
                this.asynchScope_Tasks_Lock.startReading();
                if (this.asynchScope_Tasks != null) {
                    alarmManager = this.asynchScope_Tasks.getAlarmManager();
                }
                if (alarmManager != null) {
                    boolean bl4 = false;
                    long l3 = 0L;
                    for (int i = 0; i < taskInfoArray.length; ++i) {
                        boolean bl5 = this.daemonCoordinator.hasReachedFailureThreshold(taskInfoArray[i].getTaskId());
                        if (bl5) {
                            if (!bl3) continue;
                            Tr.debug(tc, "Task failure threshold reached.  Skipping alarm.");
                            continue;
                        }
                        int n = 1;
                        J2EEName j2EEName = taskInfoArray[i].getJ2EEName();
                        if (j2EEName != null) {
                            n = this.appTracker.getAvailability(this.daemonCoordinator, j2EEName, taskInfoArray[i].getTaskId());
                        }
                        if (n == 1) {
                            TaskInfo taskInfo = taskInfoArray[i];
                            long l4 = taskInfo.getNextFireTime().getTime();
                            int n2 = 1;
                            if (l4 < l && bl && (n2 = taskInfo.getRecoveryOption()) == 0) {
                                n2 = this.sched.getSchedulerConfiguration().getRecoveryOption();
                            }
                            if (bl && n2 == 2) {
                                TaskInfo taskInfo2 = taskInfo;
                                taskInfo2.setProcessingModes(taskInfo2.getProcessingModes() | 1L);
                            }
                            this.setAlarm(new AlarmContext(this.ts, taskInfo, this.wm), alarmManager);
                            continue;
                        }
                        if (n == 2) {
                            if (bl3) {
                                Tr.debug(tc, "Unable to fire task...APPLICATION_UNAVAILABLE");
                            }
                            Tr.warning(tc, "SCHD0103W", new Object[]{this.daemonCoordinator.schedConfig.getName(), this.daemonCoordinator.schedConfig.getJndiName(), taskInfoArray[i].getTaskId(), taskInfoArray[i].getJ2EEName()});
                            continue;
                        }
                        if (n == 3) {
                            if (!bl3) continue;
                            Tr.debug(tc, "Unable to fire task...APPLICATION_STILL_UNAVAILABLE");
                            continue;
                        }
                        if (!bl3) continue;
                        Tr.debug(tc, "ApplicationTracker returned an unexpected status: " + n);
                    }
                    if (bl3) {
                        Tr.debug(tc, "Alarm Schedule Time=" + (System.currentTimeMillis() - l2) + "ms");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.scheduleAlarmsForTasks", "760", this);
                if (bl3) {
                    Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
                }
                throw new SchedulerServiceInternalException(Messages.getMessage("SCHD0074E", new String[]{this.sched.getSchedulerConfiguration().getName(), this.sched.getSchedulerConfiguration().getJndiName(), Utils.printStackTrace(interruptedException)}), interruptedException);
            }
            finally {
                this.asynchScope_Tasks_Lock.stopReading();
            }
        }
        finally {
            if (bl2) {
                Tr.exit(tc, "scheduleAlarmsForTasks");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMissedTasks(TaskInfo[] taskInfoArray) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "updateMissedTasks");
        }
        try {
            for (int i = 0; i < taskInfoArray.length; ++i) {
                if (taskInfoArray[i] == null) {
                    break;
                }
                TxHandle txHandle = null;
                Connection connection = null;
                DBHelper dBHelper = this.ts.getDBHelper();
                TaskInfo taskInfo = taskInfoArray[i];
                try {
                    txHandle = this.tranControl.preinvoke(true, false);
                    connection = dBHelper.getConnection(txHandle, 2, false);
                    this.ts.update(connection, taskInfo);
                    if (taskInfo.getStatus() == 4) {
                        if (bl2) {
                            Tr.debug(tc, "Notification: Missed task is complete.  TaskID=" + taskInfo.getTaskId());
                        }
                        this.sched.fireNotification(taskInfo, taskInfo.getStatus(), 16, true);
                    } else if (taskInfo.getStatus() == 1) {
                        if (bl2) {
                            Tr.debug(tc, "Notification: Missed task is rescheduled.  TaskID=" + taskInfo.getTaskId() + ", NextFireTime=" + taskInfo.getNextFireTime() + ", RepeatsLeft=" + taskInfo.getRepeatsLeft());
                        }
                        this.sched.fireNotification(taskInfo, taskInfo.getStatus(), 1, true);
                    }
                    connection.commit();
                    this.tranControl.postinvoke(txHandle);
                    continue;
                }
                catch (Exception exception) {
                    block20: {
                        try {
                            if (connection != null) {
                                dBHelper.returnConnection(connection);
                            }
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerDaemonImpl.updateMissedTasks", "975", this);
                            if (!bl2) break block20;
                            Tr.debug(tc, "Caught exception: " + exception.getMessage(), exception);
                        }
                    }
                    try {
                        this.tranControl.handleException(txHandle);
                        continue;
                    }
                    catch (Exception exception3) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerDaemonImpl.updateMissedTasks", "990", this);
                        if (!bl2) continue;
                        Tr.debug(tc, "Caught exception: " + exception.getMessage(), exception);
                    }
                }
            }
        }
        finally {
            if (bl) {
                Tr.exit(tc, "updateMissedTasks");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAsynchScope_Tasks() {
        boolean bl = tc.isDebugEnabled();
        try {
            this.asynchScope_Tasks_Lock.startWriting();
            if (this.asynchScope_Tasks != null) {
                if (bl) {
                    Tr.debug(tc, "Destroying Tasks AsynchScope: " + this.asynchScope_Tasks.getName());
                }
                this.asynchScope_Tasks.destroy();
                this.asynchScope_Tasks = null;
            }
            if (bl) {
                Tr.debug(tc, "Creating Tasks AsynchScope: " + this.asynchScopeName_Tasks);
            }
            try {
                this.asynchScope_Tasks = this.asynchScope_Parent.createAsynchScope(this.asynchScopeName_Tasks);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                this.asynchScope_Tasks = this.asynchScope_Parent.findAsynchScope(this.asynchScopeName_Tasks);
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.resetAsynchScope_Tasks", "890", this);
            if (bl) {
                Tr.debug(tc, "Caught exception: " + interruptedException.getMessage(), interruptedException);
            }
        }
        finally {
            this.asynchScope_Tasks_Lock.stopWriting();
        }
    }

    public String getID() {
        return this.daemonID;
    }

    public String toString() {
        return this.sched.toString() + "_" + this.getID();
    }

    public synchronized void startDaemon(int n) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "startDaemon", new Object[]{new Integer(n)});
        }
        try {
            if (this.getReleased()) {
                this.resetAsynchScope_Tasks();
                this.setReleased(false);
                this.setPollDelay(n);
                this.setNextEstPollTime(System.currentTimeMillis() + (long)this.getPollDelay());
                this.wm.startWork(this, true);
                Tr.info(tc, "SCHD0038I", new Object[]{this.sched.getSchedulerConfiguration().getJndiName()});
                if (bl2) {
                    Tr.debug(tc, "Started daemon for: " + this.toString());
                }
            }
        }
        catch (WorkException workException) {
            FFDCFilter.processException((Throwable)workException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.startDaemon", "825", this);
            throw new SchedulerServiceInternalException(workException);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.startDaemon", "830", this);
            throw runtimeException;
        }
        finally {
            if (bl) {
                Tr.exit(tc, "startDaemon");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopDaemon() {
        block18: {
            boolean bl = tc.isEntryEnabled();
            boolean bl2 = tc.isDebugEnabled();
            if (bl) {
                Tr.entry(tc, "stopDaemon");
            }
            try {
                if (this.getReleased()) break block18;
                this.release();
                try {
                    if (!this.asynchScope_Tasks_Lock.attemptWriting(60000L)) {
                        SchedulerRuntimeException schedulerRuntimeException = new SchedulerRuntimeException("Unable to acquire Tasks AsynchScope Lock.  Lock timeout.");
                        FFDCFilter.processException((Throwable)schedulerRuntimeException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.stopDaemon", "1000", this);
                        throw schedulerRuntimeException;
                    }
                }
                catch (InterruptedException interruptedException) {
                    SchedulerRuntimeException schedulerRuntimeException = new SchedulerRuntimeException("Unable to acquire Tasks AsynchScope Lock.", interruptedException);
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.stopDaemon", "1000", this);
                    throw schedulerRuntimeException;
                }
                try {
                    this.asynchScope_Tasks.destroy();
                    this.asynchScope_Tasks = null;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerDaemonImpl.stopDaemon", "1015", this);
                    if (bl2) {
                        Tr.debug(tc, "Caught exception: " + throwable.getMessage(), throwable);
                    }
                }
                finally {
                    this.asynchScope_Tasks_Lock.stopWriting();
                }
                Tr.info(tc, "SCHD0039I", new Object[]{this.sched.getSchedulerConfiguration().getJndiName()});
                if (bl2) {
                    Tr.debug(tc, "Stopped daemon for: " + this.toString());
                }
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.SchedulerDaemonImpl.stopDaemon", "880", this);
                if (bl2) {
                    Tr.debug(tc, "Caught exception: " + runtimeException.getMessage(), runtimeException);
                }
                throw runtimeException;
            }
            finally {
                if (bl) {
                    Tr.exit(tc, "stopDaemon");
                }
            }
        }
    }

    public Scheduler getScheduler() {
        return this.sched;
    }

    public DaemonCoordinator getDaemonCoordinator() {
        return this.daemonCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDaemon() {
        Object object = this.waitLock;
        synchronized (object) {
            this.daemonNotified = true;
            this.waitLock.notify();
        }
    }

    public void setTaskRunning(Object object) {
        this.runningTasks.add(object);
    }

    public boolean setTaskStopped(Object object) {
        return this.runningTasks.remove(object);
    }

    public boolean isTaskRunning(Object object) {
        return this.runningTasks.contains(object);
    }

    public void setTasksStopped() {
        this.runningTasks.clear();
    }

    public void setThreadRunning(String string, TaskInfo taskInfo) {
        this.runningThreads.put(string, new RunningThreadInfo(taskInfo));
    }

    public RunningThreadInfo setThreadStopped(String string) {
        return (RunningThreadInfo)this.runningThreads.remove(string);
    }

    public boolean isThreadRunning(String string) {
        return this.runningThreads.containsKey(string);
    }

    public RunningThreadInfo getRunningThreadInfo(String string) {
        return (RunningThreadInfo)this.runningThreads.get(string);
    }

    public void taskCollided() {
        if (this.sched.getPMIEnabled()) {
            // empty if block
        }
        this.sched.pmiIncTaskCollisions();
        ++this.taskCollisionsPerPoll;
    }

    public void setTaskCollisionsPerPoll(int n) {
        this.taskCollisionsPerPoll = n;
    }

    public int getTaskCollisionsPerPoll() {
        return this.taskCollisionsPerPoll;
    }

    public void taskFailed() {
        if (this.sched.getPMIEnabled()) {
            // empty if block
        }
        this.sched.pmiTaskFailed();
        ++this.taskFailuresPerPoll;
    }

    public void setTaskFailuresPerPoll(int n) {
        this.taskFailuresPerPoll = n;
    }

    public int getTaskFailuresPerPoll() {
        return this.taskFailuresPerPoll;
    }

    public void taskCompleted(int n, int n2) {
        this.incExecutedTasksPerPoll();
        this.sched.pmiTaskCompleted(n, n2);
    }

    public void incExecutedTasksPerPoll() {
        ++this.executedTasksPerPoll;
    }

    public void setExecutedTasksPerPoll(int n) {
        this.executedTasksPerPoll = n;
    }

    public int getExecutedTasksPerPoll() {
        return this.executedTasksPerPoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        Object object = this.isPollingLock;
        synchronized (object) {
            return this.isPolling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIsPolling(boolean bl) {
        Object object = this.isPollingLock;
        synchronized (object) {
            this.isPolling = bl;
        }
    }

    private class ThreadMonListener
    implements ThreadMonitor.Listener {
        private ThreadMonListener() {
        }

        public void threadIsHung(String string, String string2, long l) {
            RunningThreadInfo runningThreadInfo = SchedulerDaemonImpl.this.getRunningThreadInfo(string);
            if (runningThreadInfo != null) {
                Tr.warning(tc, "SCHD0131W", new Object[]{runningThreadInfo.getTaskInfo().getTaskId(), string + " (" + string2 + ")", SchedulerDaemonImpl.this.sched.getSchedulerConfiguration().getName(), SchedulerDaemonImpl.this.sched.getSchedulerConfiguration().getJndiName(), new Long(l)});
            }
        }

        public void threadIsClear(String string, String string2, long l) {
        }
    }
}

