/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.csi.DefaultComponentMetaData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.scheduler.BeanTaskInfo;
import com.ibm.websphere.scheduler.IllegalTaskState;
import com.ibm.websphere.scheduler.MessageTaskInfo;
import com.ibm.websphere.scheduler.NotificationException;
import com.ibm.websphere.scheduler.NotificationSinkInvalid;
import com.ibm.websphere.scheduler.SchedulerNotAvailableException;
import com.ibm.websphere.scheduler.SchedulerRuntimeException;
import com.ibm.websphere.scheduler.TaskInfoInvalid;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskNotificationInfo;
import com.ibm.websphere.scheduler.TaskPending;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.websphere.scheduler.UserCalendarException;
import com.ibm.websphere.scheduler.UserCalendarInvalid;
import com.ibm.websphere.scheduler.UserCalendarPeriodInvalid;
import com.ibm.websphere.scheduler.UserCalendarSpecifierInvalid;
import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaDataImpl;
import com.ibm.ws.scheduler.AbstractTask;
import com.ibm.ws.scheduler.ApplicationTracker;
import com.ibm.ws.scheduler.DBHelperImpl;
import com.ibm.ws.scheduler.DaemonCoordinator;
import com.ibm.ws.scheduler.DaemonCoordinatorImpl;
import com.ibm.ws.scheduler.NotificationSinkHolderI;
import com.ibm.ws.scheduler.SchedulerConfigurationChangeListener;
import com.ibm.ws.scheduler.SchedulerMBeanWrapper;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.SecurityControlImpl;
import com.ibm.ws.scheduler.TaskStatusImpl;
import com.ibm.ws.scheduler.TaskStore;
import com.ibm.ws.scheduler.ThreadContextHolder;
import com.ibm.ws.scheduler.ThreadContextHolderI;
import com.ibm.ws.scheduler.UserCalendarHolderI;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.WASSchedulerCfgHelper;
import com.ibm.ws.scheduler.calendar.DefaultUserCalendarBean;
import com.ibm.ws.scheduler.config.SchedulerConfiguration;
import com.ibm.ws.scheduler.config.SchedulerServiceConfiguration;
import com.ibm.ws.scheduler.exception.ByteSerializeException;
import com.ibm.ws.scheduler.exception.SchedulerConfigurationException;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import com.ibm.ws.scheduler.exception.SchedulerServiceInternalException;
import com.ibm.ws.scheduler.pmi.SchedulerPerf;
import com.ibm.ws.scheduler.pmi.SchedulerPmiModule;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.Scheduler;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class SchedulerImpl
implements com.ibm.websphere.scheduler.Scheduler,
Scheduler,
SchedulerConfigurationChangeListener {
    private static final TraceComponent tc = Tr.register(SchedulerImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    protected SchedulerConfiguration configuration;
    protected SchedulerServiceConfiguration schedServiceConfig;
    TaskStore persistentStore;
    private ObjectName mbeanName;
    private String mbeanID;
    private DaemonCoordinator daemonCoordinator;
    private SchedulerPerf pmiScheduler;
    private static final String PMI_STATS_CLASS_NAME = "com.ibm.ws.pmi.preprocess.scheduler_StatsTemplateLookup";
    private static boolean arePMIStatsRegistered;
    private TransactionControl tranControl;
    private ExtensionHelper extHelper;
    private ApplicationTracker appTracker;
    private boolean initialized;
    private Object initializedLock;
    private static final ComponentMetaDataAccessorImpl cmda;
    private static final String PROP_FILE = "com/ibm/ws/scheduler/Databases.properties";
    public static final String METHODNAME_CREATE = "create";
    public static final String METHODNAME_CREATETASKINFO = "createTaskInfo";
    public static final String METHODNAME_SUSPEND = "suspend";
    public static final String METHODNAME_RESUME = "resume";
    public static final String METHODNAME_FINDTASKSBYNAME = "findTasksByName";
    public static final String METHODNAME_FINDTASKSTATUSBYNAME = "findTaskStatusByName";
    public static final String METHODNAME_PURGE = "purge";
    public static final String METHODNAME_CANCEL = "cancel";
    public static final String METHODNAME_UPDATE = "update";
    public static final String METHODNAME_GETTASK = "getTask";
    public static final String METHODNAME_GETSTATUS = "getStatus";
    public static final String METHODNAME_GETPOLLINTERVAL = "getPollInterval";
    public static final String METHODNAME_SETPOLLINTERVAL = "setPollInterval";
    public static final String METHODNAME_GETQUERYSIZE = "getQuerySize";
    public static final String METHODNAME_SETQUERYSIZE = "setQuerySize";
    public static final String METHODNAME_SETDAEMONTHREADS = "setDaemonThreads";
    public static final String METHODNAME_GETDAEMONTHREADS = "getDaemonThreads";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerImpl(SchedulerConfiguration schedulerConfiguration, ExtensionHelper extensionHelper, ApplicationTracker applicationTracker) throws SchedulerConfigurationException, SchedulerDataStoreException {
        block10: {
            this.configuration = null;
            this.schedServiceConfig = null;
            this.mbeanName = null;
            this.daemonCoordinator = null;
            this.pmiScheduler = null;
            this.extHelper = null;
            this.initialized = false;
            this.initializedLock = new Object();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", new Object[]{schedulerConfiguration});
            }
            try {
                block11: {
                    if (schedulerConfiguration == null) {
                        throw new SchedulerConfigurationException(Messages.getMessage("SCHD0109E", "schedulerConfiguration"));
                    }
                    if (extensionHelper == null) {
                        throw new SchedulerConfigurationException(Messages.getMessage("SCHD0109E", "extHelper"));
                    }
                    this.extHelper = extensionHelper;
                    SchedulerServiceImpl.instance().addSchedulerConfigurationChangeListener(this, schedulerConfiguration.getJndiName());
                    this.schedServiceConfig = SchedulerServiceImpl.instance().getConfiguration();
                    this.tranControl = extensionHelper.getTransactionControl();
                    this.appTracker = applicationTracker;
                    this.configuration = schedulerConfiguration;
                    this.mbeanID = ("Scheduler_" + schedulerConfiguration.getJndiName()).replace('/', '.');
                    this.createMBean();
                    if (PmiRegistry.isDisabled()) break block10;
                    if (!arePMIStatsRegistered) {
                        arePMIStatsRegistered = true;
                        try {
                            Class<?> clazz = Class.forName(PMI_STATS_CLASS_NAME);
                            StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)clazz.newInstance());
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerImpl.SchedulerImpl", "301", this);
                            if (!tc.isDebugEnabled()) break block11;
                            Tr.debug(tc, "PMI StatsTemplateLookup class not found.");
                        }
                    }
                }
                this.pmiScheduler = new SchedulerPmiModule(this.getMBeanID(), 10000L);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "<init>");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean bl) throws SchedulerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        Object object = this.initializedLock;
        synchronized (object) {
            if (!this.initialized || bl) {
                if (!bl) {
                    Tr.info(tc, "SCHD0032I", new Object[]{this.configuration.getJndiName()});
                }
                try {
                    Object object2;
                    try {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("dbhelper.statements.file", PROP_FILE);
                        hashMap.put("dbhelper.jndi.name", this.configuration.getDataSourceJndiName());
                        hashMap.put("dbhelper.username", this.configuration.getUsername());
                        hashMap.put("dbhelper.password", this.configuration.getPassword());
                        hashMap.put("dbhelper.table.prefix", this.configuration.getTablePrefix());
                        hashMap.put("dbhelper.replacement.map", WASSchedulerCfgHelper.createSQLSubstitutionMap(this.configuration.getTablePrefix()));
                        object2 = new DBHelperImpl(this, this.extHelper, hashMap);
                        this.persistentStore = object2.getTaskStore();
                    }
                    catch (NamingException namingException) {
                        throw new SchedulerConfigurationException(Messages.getMessage("SCHD0019E", this.configuration.getDataSourceJndiName()), namingException);
                    }
                    catch (UnableToInitializeException unableToInitializeException) {
                        if (unableToInitializeException.getCause() instanceof NameNotFoundException) {
                            throw new SchedulerConfigurationException(Messages.getMessage("SCHD0019E", this.configuration.getDataSourceJndiName()));
                        }
                        throw unableToInitializeException;
                    }
                    try {
                        this.persistentStore.getTableStatus();
                    }
                    catch (SchedulerDataStoreException schedulerDataStoreException) {
                        object2 = Messages.getMessage("SCHD0046E", new String[]{schedulerDataStoreException.getMessage(), this.configuration.getDataSourceJndiName(), this.configuration.getName(), this.configuration.getJndiName()});
                        Tr.error(tc, "SCHD0124E", new Object[]{"TaskStore", object2});
                        throw new SchedulerNotAvailableException(Messages.getMessage("SCHD0124E", new Object[]{"TaskStore", object2}));
                    }
                    this.daemonCoordinator = new DaemonCoordinatorImpl(this.configuration.getPartitionInfos(), this.configuration.getDaemonThreads(), this, this.configuration, this.schedServiceConfig, this.tranControl, this.appTracker);
                    Tr.info(tc, "SCHD0033I", new Object[]{this.configuration.getJndiName()});
                    this.initialized = true;
                }
                catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                    FFDCFilter.processException((Throwable)schedulerNotAvailableException, "com.ibm.ws.scheduler.SchedulerImpl.initialize", "350", this);
                    throw schedulerNotAvailableException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.initialize", "359", this);
                    Tr.error(tc, "SCHD0124E", new Object[]{this.configuration.getJndiName(), throwable});
                    throw new SchedulerNotAvailableException(Messages.getMessage("SCHD0124E", new Object[]{this.configuration.getJndiName(), Utils.getExceptionMessageWithType(throwable)}), throwable);
                }
                finally {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "initialize");
                    }
                }
            }
        }
    }

    public synchronized void destroy() {
        RuntimeException runtimeException;
        boolean bl;
        block15: {
            boolean bl2;
            block14: {
                bl = tc.isEntryEnabled();
                bl2 = tc.isDebugEnabled();
                if (bl) {
                    Tr.entry(tc, "destroy");
                }
                runtimeException = null;
                try {
                    if (this.daemonCoordinator != null) {
                        this.daemonCoordinator.destroy();
                    }
                }
                catch (RuntimeException runtimeException2) {
                    FFDCFilter.processException((Throwable)runtimeException2, "com.ibm.ws.scheduler.SchedulerImpl.destroy", "250", this);
                    if (bl2) {
                        Tr.debug(tc, "Caught exception: " + runtimeException2.getMessage(), runtimeException2);
                    }
                    runtimeException = runtimeException2;
                }
                try {
                    this.destroyMBean();
                }
                catch (AdminException adminException) {
                    FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.scheduler.SchedulerImpl.destroy", "265", this);
                    if (bl2) {
                        Tr.debug(tc, "Caught exception: " + adminException.getMessage(), adminException);
                    }
                    if (runtimeException != null) break block14;
                    runtimeException = new SchedulerServiceInternalException(adminException);
                }
            }
            try {
                if (this.pmiScheduler instanceof SchedulerPmiModule) {
                    ((SchedulerPmiModule)this.pmiScheduler).destroy();
                }
            }
            catch (RuntimeException runtimeException3) {
                FFDCFilter.processException((Throwable)runtimeException3, "com.ibm.ws.scheduler.SchedulerImpl.destroy", "270", this);
                if (bl2) {
                    Tr.debug(tc, "Caught exception: " + runtimeException3.getMessage(), runtimeException3);
                }
                if (runtimeException != null) break block15;
                runtimeException = runtimeException3;
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (bl) {
            Tr.exit(tc, "destroy");
        }
    }

    public SchedulerConfiguration getSchedulerConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged(SchedulerConfiguration schedulerConfiguration) {
        CustomContainerComponentMetaData customContainerComponentMetaData = null;
        try {
            this.configuration = schedulerConfiguration;
            customContainerComponentMetaData = this.beginContext();
            this.initialize(true);
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            FFDCFilter.processException((Throwable)schedulerNotAvailableException, "com.ibm.ws.scheduler.SchedulerImpl.configurationChanged", "262", this);
        }
        finally {
            if (customContainerComponentMetaData != null) {
                this.endContext();
            }
        }
    }

    public TaskStatus create(com.ibm.websphere.scheduler.TaskInfo taskInfo) throws SchedulerNotAvailableException, TaskInvalid, UserCalendarInvalid, UserCalendarSpecifierInvalid, UserCalendarPeriodInvalid, NotificationSinkInvalid, NotificationException {
        this.checkMethodAccess(METHODNAME_CREATE);
        return this.updateOrCreate(taskInfo, false);
    }

    private TaskStatus updateOrCreate(final com.ibm.websphere.scheduler.TaskInfo taskInfo, final boolean bl) throws TaskInvalid, UserCalendarSpecifierInvalid, UserCalendarInvalid, SchedulerNotAvailableException, UserCalendarPeriodInvalid, NotificationSinkInvalid, NotificationException {
        final String string = bl ? METHODNAME_UPDATE : METHODNAME_CREATE;
        try {
            return (TaskStatus)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    boolean bl3 = tc.isEntryEnabled();
                    if (bl3) {
                        Tr.entry(tc, "updateOrCreate", new Object[]{taskInfo, string, SchedulerImpl.this.configuration.getJndiName()});
                    }
                    CustomContainerComponentMetaData customContainerComponentMetaData = null;
                    try {
                        Object object;
                        Object object2;
                        customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                        SchedulerImpl.this.initialize(false);
                        SchedulerServiceImpl schedulerServiceImpl = (SchedulerServiceImpl)SchedulerServiceImpl.instance();
                        if (!schedulerServiceImpl.isTaskInfoImplementationRegistered(taskInfo.getClass())) {
                            throw new TaskInvalid(Messages.getMessage("SCHD0047E", taskInfo.getClass().getName()));
                        }
                        Date date = new Date(System.currentTimeMillis());
                        TxHandle txHandle = null;
                        TaskInfo taskInfo2 = (TaskInfo)taskInfo;
                        taskInfo2.setTaskId(null);
                        ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                        if (componentMetaData != null && !(componentMetaData instanceof DefaultComponentMetaData)) {
                            object2 = new ThreadContextHolder(SchedulerImpl.this.getWorkManager());
                            taskInfo2.setThreadContextHolder((ThreadContextHolderI)object2);
                            ((AbstractTask)taskInfo2).setJ2EEName(componentMetaData.getJ2EEName());
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Component Meta Data is null. J2EEName will be assumed to be <null>");
                        }
                        object2 = null;
                        TaskStatusImpl taskStatusImpl = null;
                        try {
                            txHandle = SchedulerImpl.this.tranControl.preinvoke();
                            if (taskInfo instanceof TaskInfo) {
                                ((TaskInfo)taskInfo).preSerialize();
                            }
                            taskInfo.validate();
                            SecurityControlImpl.checkAccess(taskInfo2, 4128L);
                            taskInfo2.setSuspended(taskInfo2.getInitialState() == 2);
                            object = taskInfo2.getUserCalendarHolder();
                            if (taskInfo2.getNextFireTime() == null) {
                                if (object == null) {
                                    taskInfo2.setStartTime(new DefaultUserCalendarBean().applyDelta(date, null, taskInfo2.getStartTimeAsDelta()));
                                } else {
                                    taskInfo2.setStartTime(taskInfo2.getUserCalendarHolder().applyDelta(date, taskInfo2.getStartTimeAsDelta()));
                                }
                            }
                            Date date2 = taskInfo2.getNextFireTime();
                            Date date3 = taskInfo2.getStartByTime();
                            if (date3 != null && date3.before(date2) && taskInfo2.getMaximumRepeats() == 1) {
                                throw new TaskInvalid(Messages.getMessage("SCHD0049E"));
                            }
                            boolean bl2 = SchedulerImpl.this.configuration.isSetDefaultWriteTransactionIsolation();
                            object2 = SchedulerImpl.this.getPersistentStore().getDBHelper().getConnection(txHandle, SchedulerImpl.this.configuration.getDefaultWriteTransactionIsolation(), bl2);
                            if (bl) {
                                SchedulerImpl.this.getPersistentStore().update((Connection)object2, taskInfo2);
                            } else {
                                taskInfo2 = SchedulerImpl.this.getPersistentStore().create((Connection)object2, taskInfo2);
                            }
                            ((DaemonCoordinatorImpl)SchedulerImpl.this.daemonCoordinator).clearTaskFailure(taskInfo2.getTaskId());
                            taskStatusImpl = new TaskStatusImpl(taskInfo2);
                            if (taskInfo2.getInitialState() == 1) {
                                taskStatusImpl.setStatus(1);
                                SchedulerImpl.this.fireNotification(taskInfo2, taskStatusImpl.getStatus(), 1, false);
                            } else if (taskInfo2.getInitialState() == 2) {
                                taskStatusImpl.setStatus(2);
                                SchedulerImpl.this.fireNotification(taskInfo2, taskStatusImpl.getStatus(), 4, false);
                            } else {
                                throw new TaskInvalid(Messages.getMessage("SCHD0050E", new String[]{new Integer(taskInfo2.getInitialState()).toString(), new Integer(1).toString(), new Integer(2).toString()}));
                            }
                            SchedulerImpl.this.tranControl.postinvoke(txHandle);
                        }
                        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                            try {
                                SchedulerImpl.this.tranControl.handleException(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "115", this);
                            }
                            throw schedulerNotAvailableException;
                        }
                        catch (TaskInvalid taskInvalid) {
                            try {
                                SchedulerImpl.this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "120", this);
                            }
                            throw taskInvalid;
                        }
                        catch (UserCalendarInvalid userCalendarInvalid) {
                            try {
                                SchedulerImpl.this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "125", this);
                            }
                            throw userCalendarInvalid;
                        }
                        catch (UserCalendarSpecifierInvalid userCalendarSpecifierInvalid) {
                            try {
                                SchedulerImpl.this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "130", this);
                            }
                            throw userCalendarSpecifierInvalid;
                        }
                        catch (UserCalendarPeriodInvalid userCalendarPeriodInvalid) {
                            try {
                                SchedulerImpl.this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "135", this);
                            }
                            throw userCalendarPeriodInvalid;
                        }
                        catch (NotificationSinkInvalid notificationSinkInvalid) {
                            try {
                                SchedulerImpl.this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "140", this);
                            }
                            throw notificationSinkInvalid;
                        }
                        catch (NotificationException notificationException) {
                            try {
                                SchedulerImpl.this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "145", this);
                            }
                            throw notificationException;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "142", this);
                            SchedulerImpl.this.tranControl.handleException(txHandle);
                            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{SchedulerImpl.this.configuration.getName(), SchedulerImpl.this.configuration.getJndiName(), string, taskInfo2.getTaskId(), Utils.getExceptionMessageWithType(throwable)}), throwable);
                        }
                        finally {
                            try {
                                SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection((Connection)object2);
                            }
                            catch (SQLException sQLException) {
                                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.updateOrCreate", "212", this);
                            }
                        }
                        SchedulerImpl.this.daemonCoordinator.scheduleTaskAlarm(taskInfo2);
                        object = taskStatusImpl;
                        return object;
                    }
                    finally {
                        if (customContainerComponentMetaData != null) {
                            SchedulerImpl.this.endContext();
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "updateOrCreate");
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerNotAvailableException) {
                throw (SchedulerNotAvailableException)throwable;
            }
            if (throwable instanceof TaskInvalid) {
                throw (TaskInvalid)throwable;
            }
            if (throwable instanceof UserCalendarSpecifierInvalid) {
                throw (UserCalendarSpecifierInvalid)throwable;
            }
            if (throwable instanceof UserCalendarInvalid) {
                throw (UserCalendarInvalid)throwable;
            }
            if (throwable instanceof UserCalendarPeriodInvalid) {
                throw (UserCalendarPeriodInvalid)throwable;
            }
            if (throwable instanceof NotificationSinkInvalid) {
                throw (NotificationSinkInvalid)throwable;
            }
            if (throwable instanceof NotificationException) {
                throw (NotificationException)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{this.configuration.getName(), this.configuration.getJndiName(), string, ((TaskInfo)taskInfo).getTaskId(), Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    public TaskStatus cancel(final String string, final boolean bl) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, NotificationException {
        try {
            return (TaskStatus)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    boolean bl3 = tc.isEntryEnabled();
                    if (bl3) {
                        Tr.entry(tc, SchedulerImpl.METHODNAME_CANCEL, new Object[]{string, new Boolean(bl), SchedulerImpl.this.configuration.getJndiName()});
                    }
                    TaskStatusImpl taskStatusImpl = null;
                    try {
                        SchedulerImpl.this.checkMethodAccess(SchedulerImpl.METHODNAME_CANCEL);
                        Connection connection = null;
                        TaskInfo taskInfo = null;
                        TxHandle txHandle = null;
                        CustomContainerComponentMetaData customContainerComponentMetaData = null;
                        try {
                            customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                            txHandle = SchedulerImpl.this.tranControl.preinvoke();
                            SchedulerImpl.this.initialize(false);
                            boolean bl2 = SchedulerImpl.this.configuration.isSetDefaultWriteTransactionIsolation();
                            connection = SchedulerImpl.this.getPersistentStore().getDBHelper().getConnection(txHandle, SchedulerImpl.this.configuration.getDefaultWriteTransactionIsolation(), bl2);
                            taskInfo = SchedulerImpl.this.getPersistentStore().findByPrimaryKey(connection, string, SecurityControlImpl.getCurrentOwnerToken(), true);
                            SecurityControlImpl.checkAccess(taskInfo, 4144L);
                            int n = taskInfo.getStatus();
                            taskInfo.setCancelled(true);
                            taskStatusImpl = new TaskStatusImpl(taskInfo);
                            taskStatusImpl.setStatus(taskInfo.getStatus());
                            if (bl) {
                                SchedulerImpl.this.getPersistentStore().remove(connection, taskInfo);
                            } else {
                                taskInfo.setCancelled(true);
                                SchedulerImpl.this.getPersistentStore().update(connection, taskInfo);
                            }
                            if (n != 4 && n != 3 && n != -1) {
                                SchedulerImpl.this.fireNotification(taskInfo, taskStatusImpl.getStatus(), 32, false);
                            }
                            if (bl) {
                                taskStatusImpl.setStatus(-1);
                                SchedulerImpl.this.fireNotification(taskInfo, taskStatusImpl.getStatus(), 2, false);
                            }
                            SchedulerImpl.this.tranControl.postinvoke(txHandle);
                        }
                        catch (TaskInvalid taskInvalid) {
                            try {
                                try {
                                    SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                    throw taskInvalid;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.cancel", "630", this);
                                }
                                throw taskInvalid;
                                catch (TaskPending taskPending) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw taskPending;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.cancel", "635", this);
                                    }
                                    throw taskPending;
                                }
                                catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                                    try {
                                        SchedulerImpl.this.tranControl.handleException(txHandle);
                                        throw schedulerNotAvailableException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.cancel", "640", this);
                                    }
                                    throw schedulerNotAvailableException;
                                }
                                catch (NotificationException notificationException) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw notificationException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.cancel", "645", this);
                                    }
                                    throw notificationException;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.cancel", "173", this);
                                    SchedulerImpl.this.tranControl.handleException(txHandle);
                                    throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{SchedulerImpl.this.configuration.getName(), SchedulerImpl.this.configuration.getJndiName(), SchedulerImpl.METHODNAME_CANCEL, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                                }
                                catch (SQLException sQLException) {
                                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.cancel", "279", this);
                                }
                                if (customContainerComponentMetaData == null) throw throwable;
                                SchedulerImpl.this.endContext();
                                throw throwable;
                            }
                        }
                        try {
                            SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.cancel", "279", this);
                        }
                        if (customContainerComponentMetaData == null) return taskStatusImpl;
                        SchedulerImpl.this.endContext();
                        return taskStatusImpl;
                    }
                    finally {
                        if (bl3) {
                            Tr.exit(tc, SchedulerImpl.METHODNAME_CANCEL);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerNotAvailableException) {
                throw (SchedulerNotAvailableException)throwable;
            }
            if (throwable instanceof TaskInvalid) {
                throw (TaskInvalid)throwable;
            }
            if (throwable instanceof TaskPending) {
                throw (TaskPending)throwable;
            }
            if (throwable instanceof NotificationException) {
                throw (NotificationException)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{this.configuration.getName(), this.configuration.getJndiName(), METHODNAME_CANCEL, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    public TaskStatus resume(final String string) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, IllegalTaskState, NotificationException {
        try {
            return (TaskStatus)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    boolean bl = tc.isEntryEnabled();
                    if (bl) {
                        Tr.entry(tc, SchedulerImpl.METHODNAME_RESUME, new Object[]{string, SchedulerImpl.this.configuration.getJndiName()});
                    }
                    TaskInfo taskInfo = null;
                    try {
                        SchedulerImpl.this.checkMethodAccess(SchedulerImpl.METHODNAME_RESUME);
                        Connection connection = null;
                        TxHandle txHandle = null;
                        CustomContainerComponentMetaData customContainerComponentMetaData = null;
                        try {
                            customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                            txHandle = SchedulerImpl.this.tranControl.preinvoke();
                            SchedulerImpl.this.initialize(false);
                            boolean bl2 = SchedulerImpl.this.configuration.isSetDefaultWriteTransactionIsolation();
                            connection = SchedulerImpl.this.getPersistentStore().getDBHelper().getConnection(txHandle, SchedulerImpl.this.configuration.getDefaultWriteTransactionIsolation(), bl2);
                            taskInfo = SchedulerImpl.this.getPersistentStore().findByPrimaryKey(connection, string, SecurityControlImpl.getCurrentOwnerToken(), true);
                            SecurityControlImpl.checkAccess(taskInfo, 4176L);
                            int n = taskInfo.getStatus();
                            if (n == 3) throw new IllegalTaskState(Messages.getMessage("SCHD0051E", taskInfo.getTaskId()));
                            if (n == 4) {
                                throw new IllegalTaskState(Messages.getMessage("SCHD0051E", taskInfo.getTaskId()));
                            }
                            if (taskInfo.getRepeatsLeft() != 1 && !((AbstractTask)taskInfo).getRunning()) {
                                taskInfo.setNextFireTime(SchedulerImpl.this.getNextTimeDelta(taskInfo, taskInfo.getRepeatInterval(), true, taskInfo.getNextFireTime(), new Date()));
                            }
                            taskInfo.setSuspended(false);
                            ((AbstractTask)taskInfo).setStatus(2);
                            SchedulerImpl.this.getPersistentStore().update(connection, taskInfo);
                            ((DaemonCoordinatorImpl)SchedulerImpl.this.daemonCoordinator).clearTaskFailure(string);
                            SchedulerImpl.this.fireNotification(taskInfo, taskInfo.getStatus(), 8, false);
                            SchedulerImpl.this.tranControl.postinvoke(txHandle);
                            SchedulerImpl.this.daemonCoordinator.scheduleTaskAlarm(taskInfo);
                        }
                        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                            try {
                                try {
                                    SchedulerImpl.this.tranControl.handleException(txHandle);
                                    throw schedulerNotAvailableException;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.resume", "750", this);
                                }
                                throw schedulerNotAvailableException;
                                catch (IllegalTaskState illegalTaskState) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw illegalTaskState;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.resume", "755", this);
                                    }
                                    throw illegalTaskState;
                                }
                                catch (TaskInvalid taskInvalid) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw taskInvalid;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.resume", "760", this);
                                    }
                                    throw taskInvalid;
                                }
                                catch (TaskPending taskPending) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw taskPending;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.resume", "765", this);
                                    }
                                    throw taskPending;
                                }
                                catch (NotificationException notificationException) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw notificationException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.resume", "770", this);
                                    }
                                    throw notificationException;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.resume", "195", this);
                                    SchedulerImpl.this.tranControl.handleException(txHandle);
                                    throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{SchedulerImpl.this.configuration.getName(), SchedulerImpl.this.configuration.getJndiName(), SchedulerImpl.METHODNAME_RESUME, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                                }
                                catch (SQLException sQLException) {
                                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.resume", "319", this);
                                }
                                if (customContainerComponentMetaData == null) throw throwable;
                                SchedulerImpl.this.endContext();
                                throw throwable;
                            }
                        }
                        try {
                            SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.resume", "319", this);
                        }
                        if (customContainerComponentMetaData != null) {
                            SchedulerImpl.this.endContext();
                        }
                        TaskStatusImpl taskStatusImpl = new TaskStatusImpl(taskInfo);
                        return taskStatusImpl;
                    }
                    finally {
                        if (bl) {
                            Tr.exit(tc, SchedulerImpl.METHODNAME_RESUME);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerNotAvailableException) {
                throw (SchedulerNotAvailableException)throwable;
            }
            if (throwable instanceof TaskInvalid) {
                throw (TaskInvalid)throwable;
            }
            if (throwable instanceof TaskPending) {
                throw (TaskPending)throwable;
            }
            if (throwable instanceof IllegalTaskState) {
                throw (IllegalTaskState)throwable;
            }
            if (throwable instanceof NotificationException) {
                throw (NotificationException)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{this.configuration.getName(), this.configuration.getJndiName(), METHODNAME_RESUME, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    public TaskStatus purge(final String string) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, IllegalTaskState, NotificationException {
        try {
            return (TaskStatus)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    boolean bl = tc.isEntryEnabled();
                    if (bl) {
                        Tr.entry(tc, SchedulerImpl.METHODNAME_PURGE, new Object[]{string, SchedulerImpl.this.configuration.getJndiName()});
                    }
                    TaskStatusImpl taskStatusImpl = null;
                    try {
                        SchedulerImpl.this.checkMethodAccess(SchedulerImpl.METHODNAME_PURGE);
                        TaskInfo taskInfo = null;
                        Connection connection = null;
                        TxHandle txHandle = null;
                        CustomContainerComponentMetaData customContainerComponentMetaData = null;
                        try {
                            customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                            txHandle = SchedulerImpl.this.tranControl.preinvoke();
                            SchedulerImpl.this.initialize(false);
                            boolean bl2 = SchedulerImpl.this.configuration.isSetDefaultWriteTransactionIsolation();
                            connection = SchedulerImpl.this.getPersistentStore().getDBHelper().getConnection(txHandle, SchedulerImpl.this.configuration.getDefaultWriteTransactionIsolation(), bl2);
                            taskInfo = SchedulerImpl.this.getPersistentStore().findByPrimaryKey(connection, string, SecurityControlImpl.getCurrentOwnerToken(), true);
                            SecurityControlImpl.checkAccess(taskInfo, 4192L);
                            taskStatusImpl = new TaskStatusImpl(taskInfo);
                            int n = taskStatusImpl.getStatus();
                            if (n != 3 && n != 4) {
                                throw new IllegalTaskState(Messages.getMessage("SCHD0052E", new String[]{taskStatusImpl.getTaskId(), new Integer(n).toString(), new Integer(4).toString(), new Integer(3).toString()}));
                            }
                            taskStatusImpl.setStatus(-1);
                            SchedulerImpl.this.getPersistentStore().remove(connection, taskInfo);
                            SchedulerImpl.this.fireNotification(taskInfo, taskStatusImpl.getStatus(), 2, false);
                            SchedulerImpl.this.tranControl.postinvoke(txHandle);
                        }
                        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                            try {
                                try {
                                    SchedulerImpl.this.tranControl.handleException(txHandle);
                                    throw schedulerNotAvailableException;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.purge", "900", this);
                                }
                                throw schedulerNotAvailableException;
                                catch (TaskInvalid taskInvalid) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw taskInvalid;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.purge", "905", this);
                                    }
                                    throw taskInvalid;
                                }
                                catch (IllegalTaskState illegalTaskState) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw illegalTaskState;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.purge", "910", this);
                                    }
                                    throw illegalTaskState;
                                }
                                catch (NotificationException notificationException) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw notificationException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.purge", "915", this);
                                    }
                                    throw notificationException;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.purge", "215", this);
                                    SchedulerImpl.this.tranControl.handleException(txHandle);
                                    throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{SchedulerImpl.this.configuration.getName(), SchedulerImpl.this.configuration.getJndiName(), SchedulerImpl.METHODNAME_PURGE, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                                }
                                catch (SQLException sQLException) {
                                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.purge", "370", this);
                                }
                                if (customContainerComponentMetaData == null) throw throwable;
                                SchedulerImpl.this.endContext();
                                throw throwable;
                            }
                        }
                        try {
                            SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.purge", "370", this);
                        }
                        if (customContainerComponentMetaData != null) {
                            SchedulerImpl.this.endContext();
                        }
                        TaskStatusImpl taskStatusImpl2 = taskStatusImpl;
                        return taskStatusImpl2;
                    }
                    finally {
                        if (bl) {
                            Tr.exit(tc, SchedulerImpl.METHODNAME_PURGE);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerNotAvailableException) {
                throw (SchedulerNotAvailableException)throwable;
            }
            if (throwable instanceof TaskInvalid) {
                throw (TaskInvalid)throwable;
            }
            if (throwable instanceof TaskPending) {
                throw (TaskPending)throwable;
            }
            if (throwable instanceof IllegalTaskState) {
                throw (IllegalTaskState)throwable;
            }
            if (throwable instanceof NotificationException) {
                throw (NotificationException)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{this.configuration.getName(), this.configuration.getJndiName(), METHODNAME_PURGE, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    public TaskStatus suspend(final String string) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, IllegalTaskState, NotificationException {
        try {
            return (TaskStatus)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    boolean bl = tc.isEntryEnabled();
                    if (bl) {
                        Tr.entry(tc, SchedulerImpl.METHODNAME_SUSPEND, new Object[]{string, SchedulerImpl.this.configuration.getJndiName()});
                    }
                    TaskStatusImpl taskStatusImpl = null;
                    try {
                        SchedulerImpl.this.checkMethodAccess(SchedulerImpl.METHODNAME_SUSPEND);
                        TaskInfo taskInfo = null;
                        Connection connection = null;
                        TxHandle txHandle = null;
                        CustomContainerComponentMetaData customContainerComponentMetaData = null;
                        try {
                            customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                            txHandle = SchedulerImpl.this.tranControl.preinvoke();
                            SchedulerImpl.this.initialize(false);
                            boolean bl2 = SchedulerImpl.this.configuration.isSetDefaultWriteTransactionIsolation();
                            connection = SchedulerImpl.this.getPersistentStore().getDBHelper().getConnection(txHandle, SchedulerImpl.this.configuration.getDefaultWriteTransactionIsolation(), bl2);
                            taskInfo = SchedulerImpl.this.getPersistentStore().findByPrimaryKey(connection, string, SecurityControlImpl.getCurrentOwnerToken(), true);
                            SecurityControlImpl.checkAccess(taskInfo, 4160L);
                            taskStatusImpl = new TaskStatusImpl(taskInfo);
                            int n = taskStatusImpl.getStatus();
                            if (n == 3) throw new IllegalTaskState(Messages.getMessage("SCHD0053E", taskStatusImpl.getTaskId()));
                            if (n == 4) {
                                throw new IllegalTaskState(Messages.getMessage("SCHD0053E", taskStatusImpl.getTaskId()));
                            }
                            taskInfo.setSuspended(true);
                            taskStatusImpl.setStatus(taskInfo.getStatus());
                            SchedulerImpl.this.getPersistentStore().update(connection, taskInfo);
                            SchedulerImpl.this.fireNotification(taskInfo, taskStatusImpl.getStatus(), 4, false);
                            SchedulerImpl.this.tranControl.postinvoke(txHandle);
                        }
                        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                            try {
                                try {
                                    SchedulerImpl.this.tranControl.handleException(txHandle);
                                    throw schedulerNotAvailableException;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "1015", this);
                                }
                                throw schedulerNotAvailableException;
                                catch (TaskInvalid taskInvalid) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw taskInvalid;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "1020", this);
                                    }
                                    throw taskInvalid;
                                }
                                catch (TaskPending taskPending) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw taskPending;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "1025", this);
                                    }
                                    throw taskPending;
                                }
                                catch (IllegalTaskState illegalTaskState) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw illegalTaskState;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "1030", this);
                                    }
                                    throw illegalTaskState;
                                }
                                catch (NotificationException notificationException) {
                                    try {
                                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                        throw notificationException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "1035", this);
                                    }
                                    throw notificationException;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "236", this);
                                    SchedulerImpl.this.tranControl.handleException(txHandle);
                                    throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{SchedulerImpl.this.configuration.getName(), SchedulerImpl.this.configuration.getJndiName(), SchedulerImpl.METHODNAME_SUSPEND, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                                }
                                catch (SQLException sQLException) {
                                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "421", this);
                                }
                                if (customContainerComponentMetaData == null) throw throwable;
                                SchedulerImpl.this.endContext();
                                throw throwable;
                            }
                        }
                        try {
                            SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.suspend", "421", this);
                        }
                        if (customContainerComponentMetaData != null) {
                            SchedulerImpl.this.endContext();
                        }
                        TaskStatusImpl taskStatusImpl2 = taskStatusImpl;
                        return taskStatusImpl2;
                    }
                    finally {
                        if (bl) {
                            Tr.exit(tc, SchedulerImpl.METHODNAME_SUSPEND);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerNotAvailableException) {
                throw (SchedulerNotAvailableException)throwable;
            }
            if (throwable instanceof TaskInvalid) {
                throw (TaskInvalid)throwable;
            }
            if (throwable instanceof TaskPending) {
                throw (TaskPending)throwable;
            }
            if (throwable instanceof IllegalTaskState) {
                throw (IllegalTaskState)throwable;
            }
            if (throwable instanceof NotificationException) {
                throw (NotificationException)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{this.configuration.getName(), this.configuration.getJndiName(), METHODNAME_SUSPEND, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    public TaskStatus getStatus(String string) throws SchedulerNotAvailableException, TaskInvalid {
        this.checkMethodAccess(METHODNAME_GETSTATUS);
        return new TaskStatusImpl((AbstractTask)this.getTask(string));
    }

    public com.ibm.websphere.scheduler.TaskInfo getTask(final String string) throws SchedulerNotAvailableException, TaskInvalid {
        try {
            return (com.ibm.websphere.scheduler.TaskInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws Exception {
                    boolean bl = tc.isEntryEnabled();
                    if (bl) {
                        Tr.entry(tc, SchedulerImpl.METHODNAME_GETTASK, new Object[]{string, SchedulerImpl.this.configuration.getJndiName()});
                    }
                    TaskInfo taskInfo = null;
                    Connection connection = null;
                    TxHandle txHandle = null;
                    CustomContainerComponentMetaData customContainerComponentMetaData = null;
                    try {
                        SchedulerImpl.this.checkMethodAccess(SchedulerImpl.METHODNAME_GETTASK);
                        customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                        txHandle = SchedulerImpl.this.tranControl.preinvoke();
                        SchedulerImpl.this.initialize(false);
                        boolean bl2 = SchedulerImpl.this.configuration.isSetDefaultReadTransactionIsolation();
                        connection = SchedulerImpl.this.getPersistentStore().getDBHelper().getConnection(txHandle, SchedulerImpl.this.configuration.getDefaultReadTransactionIsolation(), bl2);
                        taskInfo = SchedulerImpl.this.getPersistentStore().findByPrimaryKey(connection, string, SecurityControlImpl.getCurrentOwnerToken(), false);
                        SecurityControlImpl.checkAccess(taskInfo, 4609L);
                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                    }
                    catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                        try {
                            try {
                                SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                throw schedulerNotAvailableException;
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.getTask", "1130", this);
                            }
                            throw schedulerNotAvailableException;
                            catch (TaskInvalid taskInvalid) {
                                try {
                                    SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                    throw taskInvalid;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.getTask", "1135", this);
                                }
                                throw taskInvalid;
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.getTask", "800", this);
                                SchedulerImpl.this.tranControl.handleException(txHandle);
                                throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{SchedulerImpl.this.configuration.getName(), SchedulerImpl.this.configuration.getJndiName(), SchedulerImpl.METHODNAME_GETTASK, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                            }
                            catch (SQLException sQLException) {
                                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.getTask", "825", this);
                            }
                            if (customContainerComponentMetaData != null) {
                                SchedulerImpl.this.endContext();
                            }
                            if (!bl) throw throwable;
                            Tr.exit(tc, SchedulerImpl.METHODNAME_GETTASK, new Object[]{taskInfo});
                            throw throwable;
                        }
                    }
                    try {
                        SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.getTask", "825", this);
                    }
                    if (customContainerComponentMetaData != null) {
                        SchedulerImpl.this.endContext();
                    }
                    if (!bl) return taskInfo;
                    Tr.exit(tc, SchedulerImpl.METHODNAME_GETTASK, new Object[]{taskInfo});
                    return taskInfo;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerNotAvailableException) {
                throw (SchedulerNotAvailableException)throwable;
            }
            if (throwable instanceof TaskInvalid) {
                throw (TaskInvalid)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0075E", new String[]{this.configuration.getName(), this.configuration.getJndiName(), METHODNAME_GETTASK, string, Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    public Iterator findTasksByName(String string) throws SchedulerNotAvailableException {
        this.checkMethodAccess(METHODNAME_FINDTASKSBYNAME);
        return this.findByName(string, com.ibm.websphere.scheduler.TaskInfo.class);
    }

    public Iterator findTaskStatusByName(String string) throws SchedulerNotAvailableException {
        this.checkMethodAccess(METHODNAME_FINDTASKSTATUSBYNAME);
        return this.findByName(string, TaskStatus.class);
    }

    public TaskStatus[] findTaskStatusByName(String string, Integer n, Integer n2) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        return this.findTaskStatusByName(string, (int)n, (int)n2);
    }

    public TaskStatus[] findTaskStatusByName(String string, int n, int n2) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        this.checkMethodAccess(METHODNAME_FINDTASKSTATUSBYNAME);
        return (TaskStatus[])this.findByName(string, TaskStatus.class, n, n2, true);
    }

    public com.ibm.websphere.scheduler.TaskInfo[] findTasksByName(String string, Integer n, Integer n2) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        return this.findTasksByName(string, (int)n, (int)n2);
    }

    public com.ibm.websphere.scheduler.TaskInfo[] findTasksByName(String string, int n, int n2) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        this.checkMethodAccess(METHODNAME_FINDTASKSBYNAME);
        return (com.ibm.websphere.scheduler.TaskInfo[])this.findByName(string, com.ibm.websphere.scheduler.TaskInfo.class, n, n2, true);
    }

    public Iterator findByName(String string, Class clazz) throws SchedulerNotAvailableException {
        Object[] objectArray = this.findByName(string, clazz, -1, -1, false);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList.iterator();
    }

    protected Object[] findByName(final String string, final Class clazz, final int n, final int n2, final boolean bl) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        try {
            return (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Loose catch block
                 */
                public Object run() throws Exception {
                    Object[] objectArray;
                    block21: {
                        boolean bl3 = tc.isEntryEnabled();
                        if (bl3) {
                            Tr.entry(tc, "findByName", new Object[]{string, clazz, new Integer(n), new Integer(n2), new Boolean(bl), SchedulerImpl.this.configuration.getJndiName()});
                        }
                        Connection connection = null;
                        TxHandle txHandle = null;
                        objectArray = null;
                        CustomContainerComponentMetaData customContainerComponentMetaData = null;
                        customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                        txHandle = SchedulerImpl.this.tranControl.preinvoke();
                        SchedulerImpl.this.initialize(false);
                        boolean bl2 = SchedulerImpl.this.configuration.isSetDefaultReadTransactionIsolation();
                        connection = SchedulerImpl.this.getPersistentStore().getDBHelper().getConnection(txHandle, SchedulerImpl.this.configuration.getDefaultReadTransactionIsolation(), bl2);
                        objectArray = SchedulerImpl.this.getPersistentStore().findByName(connection, string, SecurityControlImpl.getCurrentOwnerToken(), clazz, n, n2, bl);
                        SchedulerImpl.this.tranControl.postinvoke(txHandle);
                        Object var9_10 = null;
                        try {
                            if (connection != null) {
                                SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                            }
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.findByName", "499", this);
                        }
                        if (customContainerComponentMetaData != null) {
                            SchedulerImpl.this.endContext();
                        }
                        if (bl3) {
                            Tr.exit(tc, "findByName", new Object[]{new Integer(objectArray == null ? 0 : objectArray.length)});
                        }
                        break block21;
                        {
                            catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                                try {
                                    SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.findByName", "485", this);
                                }
                                throw schedulerNotAvailableException;
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                try {
                                    SchedulerImpl.this.tranControl.postinvoke(txHandle);
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.findByName", "1513", this);
                                }
                                throw indexOutOfBoundsException;
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.findByName", "490", this);
                                SchedulerImpl.this.tranControl.handleException(txHandle);
                                throw new SchedulerRuntimeException(Messages.getMessage("SCHD0125E", new String[]{"find", Utils.getExceptionMessageWithType(throwable)}), throwable);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            try {
                                if (connection != null) {
                                    SchedulerImpl.this.getPersistentStore().getDBHelper().returnConnection(connection);
                                }
                            }
                            catch (SQLException sQLException) {
                                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.SchedulerImpl.findByName", "499", this);
                            }
                            if (customContainerComponentMetaData != null) {
                                SchedulerImpl.this.endContext();
                            }
                            if (bl3) {
                                Tr.exit(tc, "findByName", new Object[]{new Integer(objectArray == null ? 0 : objectArray.length)});
                            }
                            throw throwable;
                        }
                    }
                    return objectArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerNotAvailableException) {
                throw (SchedulerNotAvailableException)throwable;
            }
            if (throwable instanceof IndexOutOfBoundsException) {
                throw (IndexOutOfBoundsException)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0125E", new String[]{"find", Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    protected synchronized TaskStore getPersistentStore() {
        return this.persistentStore;
    }

    public WorkManager getWorkManager() {
        return this.configuration.getWorkManager();
    }

    public synchronized void startDaemon(final Integer n) throws SchedulerDataStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    boolean bl = tc.isEntryEnabled();
                    if (bl) {
                        Tr.entry(tc, "startDaemon", new Object[]{SchedulerImpl.this.configuration.getJndiName()});
                    }
                    if (SchedulerImpl.this.pmiScheduler != null) {
                        SchedulerImpl.this.pmiScheduler.daemonEnabled();
                    }
                    boolean bl2 = SchedulerImpl.this.initialized;
                    Object object = SchedulerImpl.this.initializedLock;
                    synchronized (object) {
                        if (!bl2) {
                            CustomContainerComponentMetaData customContainerComponentMetaData = null;
                            try {
                                customContainerComponentMetaData = SchedulerImpl.this.beginContext();
                                SchedulerImpl.this.initialize(false);
                            }
                            catch (SchedulerNotAvailableException schedulerNotAvailableException) {
                                Throwable throwable = schedulerNotAvailableException.getCause();
                                if (throwable != null && throwable instanceof SchedulerDataStoreException) {
                                    throw (SchedulerDataStoreException)throwable;
                                }
                                throw new SchedulerDataStoreException(schedulerNotAvailableException.getLocalizedMessage(), schedulerNotAvailableException);
                            }
                            finally {
                                if (customContainerComponentMetaData != null) {
                                    SchedulerImpl.this.endContext();
                                }
                            }
                        }
                    }
                    SchedulerImpl.this.daemonCoordinator.startDaemons(n);
                    if (bl) {
                        Tr.exit(tc, "startDaemon");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SchedulerDataStoreException) {
                throw (SchedulerDataStoreException)throwable;
            }
            if (throwable instanceof SchedulerRuntimeException) {
                throw (SchedulerRuntimeException)throwable;
            }
            throw new SchedulerRuntimeException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    public synchronized void stopDaemon() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "stopDaemons", new Object[]{this.configuration.getJndiName()});
        }
        if (this.pmiScheduler != null) {
            this.pmiScheduler.daemonDisabled();
        }
        if (this.daemonCoordinator != null) {
            this.daemonCoordinator.stopDaemons();
        }
        if (bl) {
            Tr.exit(tc, "stopDaemons");
        }
    }

    public String toString() {
        return this.getMBeanID();
    }

    String getMBeanID() {
        return this.mbeanID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createMBean() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "createMBean");
        }
        String string = this.getMBeanID();
        try {
            Properties properties = new Properties();
            properties.put("scheduler", this.configuration.getJndiName());
            this.mbeanName = Utils.createMBean("WASScheduler", string, null, new DefaultRuntimeCollaborator(new SchedulerMBeanWrapper(this)), properties);
        }
        catch (Throwable throwable) {
            Exception exception;
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerImpl.createMBean", "1250", this);
            if (throwable instanceof PrivilegedActionException) {
                PrivilegedActionException privilegedActionException = (PrivilegedActionException)throwable;
                exception = privilegedActionException.getException();
            }
            Tr.error(tc, "SCHD0129E", new Object[]{"WASScheduler", this.configuration.getJndiName(), exception});
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception activating Scheduler MBean " + string, exception);
            }
        }
        finally {
            if (bl) {
                Tr.exit(tc, "createMBean");
            }
        }
    }

    protected synchronized void destroyMBean() throws AdminException {
        if (this.mbeanName != null) {
            Utils.destroyMBean(this.mbeanName);
            this.mbeanName = null;
        }
    }

    public Long getPollInterval() {
        this.checkMethodAccess(METHODNAME_GETPOLLINTERVAL);
        return new Long(this.configuration.getPollIntervalMillis());
    }

    public synchronized void setPollInterval(Long l) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, METHODNAME_SETPOLLINTERVAL, new Object[]{this.configuration.getJndiName(), l});
        }
        this.checkMethodAccess(METHODNAME_SETPOLLINTERVAL);
        this.configuration.setPollIntervalMillis(l.intValue());
        if (this.daemonCoordinator != null) {
            this.daemonCoordinator.updatePollInterval(l.intValue());
        }
        if (bl) {
            Tr.exit(tc, METHODNAME_SETPOLLINTERVAL);
        }
    }

    public void setPollInterval(long l) {
        this.setPollInterval(new Long(l));
    }

    public Integer getQuerySize() {
        this.checkMethodAccess(METHODNAME_GETQUERYSIZE);
        return new Integer(this.configuration.getQuerySize());
    }

    public synchronized void setQuerySize(Integer n) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, METHODNAME_SETQUERYSIZE, new Object[]{n, this.configuration.getJndiName()});
        }
        this.checkMethodAccess(METHODNAME_SETQUERYSIZE);
        this.configuration.setQuerySize(n);
        if (this.daemonCoordinator != null) {
            this.daemonCoordinator.updateQuerySize(n);
        }
        if (bl) {
            Tr.exit(tc, METHODNAME_SETQUERYSIZE);
        }
    }

    public boolean getPMIEnabled() {
        return this.pmiScheduler != null;
    }

    public void pmiPollQueryCompleted(int n, int n2) {
        if (this.pmiScheduler != null) {
            this.pmiScheduler.pollqueryComplete(n, n2);
        }
    }

    public void pmiIncTaskCollisions() {
        if (this.pmiScheduler != null) {
            this.pmiScheduler.taskCollided();
        }
    }

    public void pmiTaskFailed() {
        if (this.pmiScheduler != null) {
            this.pmiScheduler.taskFailed();
        }
    }

    public void pmiTaskCompleted(int n, int n2) {
        if (this.pmiScheduler != null) {
            this.pmiScheduler.taskExecuted(n2, n);
        }
    }

    public void pollComplete(int n, int n2, int n3) {
        if (this.pmiScheduler != null) {
            this.pmiScheduler.pollComplete(n, n2, n3);
        }
    }

    public synchronized Integer getDaemonThreads() {
        this.checkMethodAccess(METHODNAME_GETDAEMONTHREADS);
        return new Integer(this.configuration.getDaemonThreads());
    }

    public synchronized void setDaemonThreads(Integer n) throws SchedulerDataStoreException, SchedulerConfigurationException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "setDaemonCount", new Object[]{n});
        }
        this.checkMethodAccess(METHODNAME_SETDAEMONTHREADS);
        if (this.configuration.getDaemonThreads() != n.intValue()) {
            if (this.daemonCoordinator != null) {
                this.daemonCoordinator.destroy();
            }
            this.configuration.setDaemonThreads(n);
        }
    }

    public Object createTaskInfo(Class clazz) throws TaskInfoInvalid {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHODNAME_CREATETASKINFO, new Object[]{clazz, this.configuration.getJndiName()});
        }
        SchedulerServiceImpl schedulerServiceImpl = (SchedulerServiceImpl)SchedulerServiceImpl.instance();
        Object object = null;
        try {
            this.checkMethodAccess(METHODNAME_CREATETASKINFO);
            Class clazz2 = schedulerServiceImpl.getTaskInfoImplementation(clazz);
            Constructor constructor = clazz2.getConstructor(null);
            object = constructor.newInstance(null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, METHODNAME_CREATETASKINFO, object == null ? null : object.getClass().getName());
            }
            return object;
        }
        catch (Throwable throwable) {
            TaskInfoInvalid taskInfoInvalid = new TaskInfoInvalid(Messages.getMessage("SCHD0054E", new String[]{clazz.getName(), throwable.getMessage()}), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, METHODNAME_CREATETASKINFO, taskInfoInvalid);
            }
            throw taskInfoInvalid;
        }
    }

    public TaskStore getTaskStore() {
        return this.persistentStore;
    }

    public Date applyUserCalendar(TaskInfo taskInfo, String string, Date date) throws UserCalendarException {
        Date date2 = null;
        UserCalendarHolderI userCalendarHolderI = null;
        try {
            userCalendarHolderI = taskInfo.getUserCalendarHolder();
            date2 = userCalendarHolderI == null ? new DefaultUserCalendarBean().applyDelta(date, null, string) : userCalendarHolderI.applyDelta(date, string);
        }
        catch (UserCalendarException userCalendarException) {
            FFDCFilter.processException((Throwable)userCalendarException, "com.ibm.ws.scheduler.SchedulerImpl.applyUserCalendar", "1700", this);
            throw userCalendarException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerImpl.applyUserCalendar", "1720", this);
            if (exception instanceof ByteSerializeException) {
                throw new UserCalendarException(Messages.getMessage("SCHD0013E", new Object[]{userCalendarHolderI == null ? "IBM_INTERNAL" : userCalendarHolderI.getCalendarSessionBeanJNDI(), userCalendarHolderI == null ? "IBM_DEFAULT" : userCalendarHolderI.getCalendarSpecifier(), exception.getLocalizedMessage()}), exception);
            }
            throw new UserCalendarException(Messages.getMessage("SCHD0013E", new Object[]{userCalendarHolderI == null ? "IBM_INTERNAL" : userCalendarHolderI.getCalendarSessionBeanJNDI(), userCalendarHolderI == null ? "IBM_DEFAULT" : userCalendarHolderI.getCalendarSpecifier(), Utils.getExceptionMessageWithType(exception)}), exception);
        }
        return date2;
    }

    public void fireNotification(TaskInfo taskInfo, int n, int n2, boolean bl) throws NotificationException {
        NotificationSinkHolderI notificationSinkHolderI;
        try {
            notificationSinkHolderI = taskInfo.getNotificationSinkHolder();
        }
        catch (Throwable throwable) {
            NotificationException notificationException = new NotificationException(Messages.getMessage("SCHD0055E", new Object[]{taskInfo.getTaskId(), this.getSchedulerConfiguration().getName(), this.getSchedulerConfiguration().getJndiName(), Utils.getExceptionMessageWithType(throwable)}), throwable);
            FFDCFilter.processException((Throwable)notificationException, "com.ibm.ws.scheduler.AlarmListener.fireNotification", "715", this);
            throw notificationException;
        }
        if (notificationSinkHolderI != null) {
            Object object;
            if (tc.isDebugEnabled()) {
                object = "INVALID";
                switch (n2) {
                    case 32: {
                        object = "CANCELLED";
                        break;
                    }
                    case 16: {
                        object = "COMPLETE";
                        break;
                    }
                    case 256: {
                        object = "FIRE_DELAYED";
                        break;
                    }
                    case 128: {
                        object = "FIRE_FAILED";
                        break;
                    }
                    case 64: {
                        object = "FIRED";
                        break;
                    }
                    case 512: {
                        object = "FIRING";
                        break;
                    }
                    case 2: {
                        object = "PURGED";
                        break;
                    }
                    case 8: {
                        object = "RESUMED";
                        break;
                    }
                    case 1: {
                        object = "SCHEDULED";
                        break;
                    }
                    case 4: {
                        object = "SUSPENDED";
                    }
                }
                Tr.debug(tc, "Firing " + (String)object);
            }
            object = null;
            TaskStatusImpl taskStatusImpl = new TaskStatusImpl(taskInfo, n);
            if (bl) {
                try {
                    object = this.tranControl.preinvoke(true, false);
                    notificationSinkHolderI.sendNotificationToListeners(new TaskNotificationInfo(taskStatusImpl, n2));
                    this.tranControl.postinvoke((TxHandle)object);
                }
                catch (NotificationException notificationException) {
                    try {
                        this.tranControl.handleException((TxHandle)object);
                    }
                    catch (RuntimeException runtimeException) {
                        FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.AlarmListener.fireNotification", "605", this);
                    }
                    throw new NotificationException(Messages.getMessage("SCHD0014E", notificationException.getLocalizedMessage()), notificationException);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.AlarmListener.fireNotification", "607", this);
                    try {
                        this.tranControl.handleException((TxHandle)object);
                    }
                    catch (RuntimeException runtimeException) {
                        FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.AlarmListener.fireNotification", "610", this);
                    }
                    throw new NotificationException(Messages.getMessage("SCHD0014E", Utils.getExceptionMessageWithType(throwable)), throwable);
                }
            }
            notificationSinkHolderI.sendNotificationToListeners(new TaskNotificationInfo(taskStatusImpl, n2));
        }
    }

    private Date getNextTimeDelta(TaskInfo taskInfo, String string, boolean bl, Date date, Date date2) throws UserCalendarException {
        boolean bl2 = tc.isDebugEnabled();
        Date date3 = date;
        if (bl) {
            if (date3.before(date2)) {
                boolean bl3 = false;
                boolean bl4 = false;
                String string2 = taskInfo.getUserCalendarJNDIName();
                String string3 = taskInfo.getUserCalendarSpecifier();
                if (string2 == null && string3 == null) {
                    bl3 = true;
                } else if (string2 != null && string3 != null && string2.equals("com/ibm/websphere/scheduler/calendar/DefaultUserCalendarHome")) {
                    if (string3.equalsIgnoreCase("SIMPLE")) {
                        bl3 = true;
                    } else if (string3.equalsIgnoreCase("CRON")) {
                        bl4 = true;
                    }
                }
                while (date3.before(date2)) {
                    if (bl3) {
                        Date date4 = this.applyUserCalendar(taskInfo, string, date);
                        if (date4 == null) {
                            throw new UserCalendarException(Messages.getMessage("SCHD0013E", new Object[]{string2, string3, "Null Date Invalid"}));
                        }
                        if (bl2) {
                            Tr.debug(tc, "Beginning catchup algorithm for SIMPLE calendar: " + date3);
                        }
                        long l = date4.getTime() - date.getTime();
                        long l2 = date2.getTime() - date.getTime();
                        long l3 = l2 / l;
                        date3 = new Date(date.getTime() + (l3 * l + l));
                        if (!bl2) continue;
                        Tr.debug(tc, "Completed catchup algorithm for SIMPLE calendar: simpleDeltaMS=" + l + ", actualDeltaMS=" + l2 + ", newFireTime=" + date3);
                        continue;
                    }
                    if (bl4) {
                        date3 = this.applyUserCalendar(taskInfo, string, date2);
                        continue;
                    }
                    date3 = this.applyUserCalendar(taskInfo, string, date3);
                }
            }
        } else {
            date3 = this.applyUserCalendar(taskInfo, string, date);
            if (bl2) {
                Tr.debug(tc, "Used non-catchup for next fire time: " + date3);
            }
        }
        return date3;
    }

    public Date getNextFireTime(TaskInfo taskInfo, Date date) throws UserCalendarException {
        int n = taskInfo.getTimeCalcMethod();
        boolean bl = n == 2;
        Date date2 = taskInfo.getNextFireTime();
        Date date3 = n == 1 || n == 2 ? date2 : date;
        Date date4 = new Date(System.currentTimeMillis());
        return this.getNextTimeDelta(taskInfo, taskInfo.getRepeatInterval(), bl, date3, date4);
    }

    public BeanTaskInfo createBeanTaskInfo() {
        try {
            return (BeanTaskInfo)this.createTaskInfo(BeanTaskInfo.class);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0125E", new String[]{"createBeanTaskInfo", Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    public MessageTaskInfo createMessageTaskInfo() {
        try {
            return (MessageTaskInfo)this.createTaskInfo(MessageTaskInfo.class);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            throw new SchedulerRuntimeException(Messages.getMessage("SCHD0125E", new String[]{"createMessageTaskInfo", Utils.getExceptionMessageWithType(throwable)}), throwable);
        }
    }

    private void checkMethodAccess(String string) throws SecurityException {
        if (this.configuration.getUseAdminRoles()) {
            SecurityControlImpl.checkMethodAccess(string);
        }
    }

    public static String getMethodNameFromOperation(long l) {
        if (l == 4128L) {
            return METHODNAME_CREATE;
        }
        if (l == 4112L) {
            return METHODNAME_CREATETASKINFO;
        }
        if (l == 4353L) {
            return METHODNAME_FINDTASKSBYNAME;
        }
        if (l == 4354L) {
            return METHODNAME_FINDTASKSTATUSBYNAME;
        }
        if (l == 4610L) {
            return METHODNAME_GETSTATUS;
        }
        if (l == 4609L) {
            return METHODNAME_GETTASK;
        }
        if (l == 4192L) {
            return METHODNAME_PURGE;
        }
        if (l == 4176L) {
            return METHODNAME_RESUME;
        }
        if (l == 4160L) {
            return METHODNAME_SUSPEND;
        }
        if (l == 4144L) {
            return METHODNAME_CANCEL;
        }
        return "UNKNOWN";
    }

    public CustomContainerComponentMetaData beginContext() {
        CustomContainerComponentMetaDataImpl customContainerComponentMetaDataImpl = new CustomContainerComponentMetaDataImpl(cmda.getComponentMetaData());
        CustomContainerComponentMetaData.CustomLocalTranCfg customLocalTranCfg = customContainerComponentMetaDataImpl.getCustomLocalTranConfigData();
        customLocalTranCfg.setValueBoundary(0);
        customLocalTranCfg.setValueResolver(0);
        customLocalTranCfg.setValueUnresolvedAction(0);
        CustomContainerComponentMetaData.CustomResRefList customResRefList = customContainerComponentMetaDataImpl.getCustomResourceRefList();
        customResRefList.addResRef("Scheduler Custom JDBC Res-Ref", this.configuration.getDataSourceJndiName(), this.configuration.getDataSourceJndiName(), "javax.resource.cci.ConnectionFactory", 1, 0, 2);
        cmda.beginContext(customContainerComponentMetaDataImpl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CustomContainerComponentMetaData applied:", customContainerComponentMetaDataImpl);
        }
        return customContainerComponentMetaDataImpl;
    }

    public void endContext() {
        cmda.endContext();
    }

    static {
        cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    }
}

