/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.csi.DefaultComponentMetaData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scheduler.IllegalTaskState;
import com.ibm.websphere.scheduler.NotificationException;
import com.ibm.websphere.scheduler.NotificationSinkInvalid;
import com.ibm.websphere.scheduler.SchedulerNotAvailableException;
import com.ibm.websphere.scheduler.SchedulerRuntimeException;
import com.ibm.websphere.scheduler.TaskInfo;
import com.ibm.websphere.scheduler.TaskInfoInvalid;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskPending;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.websphere.scheduler.UserCalendarInvalid;
import com.ibm.websphere.scheduler.UserCalendarPeriodInvalid;
import com.ibm.websphere.scheduler.UserCalendarSpecifierInvalid;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.scheduler.SchedulerImpl;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.exception.SchedulerConfigurationException;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.PlatformHelper;

public class SchedulerMBeanWrapper {
    private static final TraceComponent tc = Tr.register(SchedulerMBeanWrapper.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    protected SchedulerImpl sched = null;
    private ComponentMetaDataAccessorImpl cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    private ComponentMetaData defaultCMD = DefaultComponentMetaData.getInstance();
    protected boolean isCRA;

    public SchedulerMBeanWrapper(SchedulerImpl schedulerImpl) {
        this();
        this.sched = schedulerImpl;
    }

    protected SchedulerMBeanWrapper() {
        PlatformHelper platformHelper = AdminHelper.getPlatformHelper();
        this.isCRA = platformHelper.isZOS() ? platformHelper.isCRAJvm() : false;
    }

    public TaskStatus create(TaskInfo taskInfo) throws TaskInvalid, UserCalendarSpecifierInvalid, UserCalendarInvalid, SchedulerNotAvailableException, UserCalendarPeriodInvalid, NotificationSinkInvalid, NotificationException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskStatus taskStatus = this.sched.create(taskInfo);
            return taskStatus;
        }
        catch (TaskInvalid taskInvalid) {
            throw (TaskInvalid)this.createSerializableException(taskInvalid);
        }
        catch (UserCalendarSpecifierInvalid userCalendarSpecifierInvalid) {
            throw (UserCalendarSpecifierInvalid)this.createSerializableException(userCalendarSpecifierInvalid);
        }
        catch (UserCalendarInvalid userCalendarInvalid) {
            throw (UserCalendarInvalid)this.createSerializableException(userCalendarInvalid);
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (UserCalendarPeriodInvalid userCalendarPeriodInvalid) {
            throw (UserCalendarPeriodInvalid)this.createSerializableException(userCalendarPeriodInvalid);
        }
        catch (NotificationSinkInvalid notificationSinkInvalid) {
            throw (NotificationSinkInvalid)this.createSerializableException(notificationSinkInvalid);
        }
        catch (NotificationException notificationException) {
            throw (NotificationException)this.createSerializableException(notificationException);
        }
        catch (SchedulerRuntimeException schedulerRuntimeException) {
            throw (SchedulerRuntimeException)this.createSerializableException(schedulerRuntimeException);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public Object createTaskInfo(Class clazz) throws TaskInfoInvalid {
        try {
            return this.sched.createTaskInfo(clazz);
        }
        catch (TaskInfoInvalid taskInfoInvalid) {
            throw (TaskInfoInvalid)this.createSerializableException(taskInfoInvalid);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
    }

    public TaskStatus cancel(String string, Boolean bl) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, NotificationException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskStatus taskStatus = this.sched.cancel(string, bl);
            return taskStatus;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (TaskInvalid taskInvalid) {
            throw (TaskInvalid)this.createSerializableException(taskInvalid);
        }
        catch (TaskPending taskPending) {
            throw (TaskPending)this.createSerializableException(taskPending);
        }
        catch (NotificationException notificationException) {
            throw (NotificationException)this.createSerializableException(notificationException);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public TaskStatus suspend(String string) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, IllegalTaskState, NotificationException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskStatus taskStatus = this.sched.suspend(string);
            return taskStatus;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (TaskInvalid taskInvalid) {
            throw (TaskInvalid)this.createSerializableException(taskInvalid);
        }
        catch (TaskPending taskPending) {
            throw (TaskPending)this.createSerializableException(taskPending);
        }
        catch (NotificationException notificationException) {
            throw (NotificationException)this.createSerializableException(notificationException);
        }
        catch (IllegalTaskState illegalTaskState) {
            throw (IllegalTaskState)this.createSerializableException(illegalTaskState);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public TaskStatus resume(String string) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, IllegalTaskState, NotificationException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskStatus taskStatus = this.sched.resume(string);
            return taskStatus;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (TaskInvalid taskInvalid) {
            throw (TaskInvalid)this.createSerializableException(taskInvalid);
        }
        catch (TaskPending taskPending) {
            throw (TaskPending)this.createSerializableException(taskPending);
        }
        catch (NotificationException notificationException) {
            throw (NotificationException)this.createSerializableException(notificationException);
        }
        catch (IllegalTaskState illegalTaskState) {
            throw (IllegalTaskState)this.createSerializableException(illegalTaskState);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public TaskStatus purge(String string) throws SchedulerNotAvailableException, TaskInvalid, TaskPending, IllegalTaskState, NotificationException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskStatus taskStatus = this.sched.purge(string);
            return taskStatus;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (TaskInvalid taskInvalid) {
            throw (TaskInvalid)this.createSerializableException(taskInvalid);
        }
        catch (TaskPending taskPending) {
            throw (TaskPending)this.createSerializableException(taskPending);
        }
        catch (NotificationException notificationException) {
            throw (NotificationException)this.createSerializableException(notificationException);
        }
        catch (IllegalTaskState illegalTaskState) {
            throw (IllegalTaskState)this.createSerializableException(illegalTaskState);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public TaskStatus getStatus(String string) throws SchedulerNotAvailableException, TaskInvalid {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskStatus taskStatus = this.sched.getStatus(string);
            return taskStatus;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (TaskInvalid taskInvalid) {
            throw (TaskInvalid)this.createSerializableException(taskInvalid);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public TaskInfo getTask(String string) throws SchedulerNotAvailableException, TaskInvalid {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskInfo taskInfo = this.sched.getTask(string);
            return taskInfo;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (TaskInvalid taskInvalid) {
            throw (TaskInvalid)this.createSerializableException(taskInvalid);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public TaskStatus[] findTaskStatusByName(String string, Integer n, Integer n2) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskStatus[] taskStatusArray = this.sched.findTaskStatusByName(string, n, n2);
            return taskStatusArray;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public TaskInfo[] findTasksByName(String string, Integer n, Integer n2) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            TaskInfo[] taskInfoArray = this.sched.findTasksByName(string, n, n2);
            return taskInfoArray;
        }
        catch (SchedulerNotAvailableException schedulerNotAvailableException) {
            throw (SchedulerNotAvailableException)this.createSerializableException(schedulerNotAvailableException);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public void startDaemon(Integer n) throws SchedulerDataStoreException {
        if (!this.isCRA) {
            this.cmda.beginContext(this.defaultCMD);
            try {
                this.sched.startDaemon(n);
            }
            catch (SchedulerDataStoreException schedulerDataStoreException) {
                throw (SchedulerDataStoreException)this.createSerializableException(schedulerDataStoreException);
            }
            catch (RuntimeException runtimeException) {
                throw this.createSchedulerRuntimeException(runtimeException);
            }
            finally {
                this.cmda.endContext();
            }
        }
    }

    public void stopDaemon() {
        if (!this.isCRA) {
            this.cmda.beginContext(this.defaultCMD);
            try {
                this.sched.stopDaemon();
            }
            catch (RuntimeException runtimeException) {
                throw this.createSchedulerRuntimeException(runtimeException);
            }
            finally {
                this.cmda.endContext();
            }
        }
    }

    public Long getPollInterval() {
        try {
            return this.sched.getPollInterval();
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
    }

    public Integer getDaemonThreads() {
        try {
            return this.sched.getDaemonThreads();
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
    }

    public Integer getQuerySize() {
        try {
            return this.sched.getQuerySize();
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
    }

    public void setPollInterval(Long l) {
        try {
            this.sched.setPollInterval(l);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
    }

    public void setDaemonThreads(Integer n) throws SchedulerDataStoreException, SchedulerConfigurationException {
        this.cmda.beginContext(this.defaultCMD);
        try {
            this.sched.setDaemonThreads(n);
        }
        catch (SchedulerDataStoreException schedulerDataStoreException) {
            throw (SchedulerDataStoreException)this.createSerializableException(schedulerDataStoreException);
        }
        catch (SchedulerConfigurationException schedulerConfigurationException) {
            throw (SchedulerConfigurationException)this.createSerializableException(schedulerConfigurationException);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
        finally {
            this.cmda.endContext();
        }
    }

    public void setQuerySize(Integer n) {
        try {
            this.sched.setQuerySize(n);
        }
        catch (RuntimeException runtimeException) {
            throw this.createSchedulerRuntimeException(runtimeException);
        }
    }

    protected SchedulerRuntimeException createSchedulerRuntimeException(RuntimeException runtimeException) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The original exception is:", runtimeException);
        }
        SchedulerRuntimeException schedulerRuntimeException = new SchedulerRuntimeException(runtimeException);
        SchedulerRuntimeException schedulerRuntimeException2 = (SchedulerRuntimeException)this.createSerializableException(schedulerRuntimeException);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The wrapped exception is: ", schedulerRuntimeException2);
        }
        return schedulerRuntimeException2;
    }

    protected Exception createSerializableException(Throwable throwable) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The original exception is:", throwable);
        }
        Exception exception = Utils.createSerializableException(throwable, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The wrapped exception is: ", exception);
        }
        return exception;
    }
}

