/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.scheduler.SchedulerException;
import com.ibm.websphere.scheduler.TaskInfo;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsRuntimeFwException;
import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.AsynchronousInitializer;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadMonitor;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.scheduler.ApplicationTracker;
import com.ibm.ws.scheduler.SchedulerConfigurationChangeListener;
import com.ibm.ws.scheduler.SchedulerImpl;
import com.ibm.ws.scheduler.SchedulerResourceBinder;
import com.ibm.ws.scheduler.SchedulerService;
import com.ibm.ws.scheduler.TaskInfoRegistry;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.config.SchedulerConfiguration;
import com.ibm.ws.scheduler.config.SchedulerConfigurationImpl;
import com.ibm.ws.scheduler.config.SchedulerServiceConfiguration;
import com.ibm.ws.scheduler.config.SchedulerServiceConfigurationImpl;
import com.ibm.ws.scheduler.exception.SchedulerConfigurationException;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import com.ibm.ws.scheduler.exception.SchedulerServiceNotInitialized;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.Scheduler;
import com.ibm.ws.scheduler.spi.TaskInfoRegistryUI;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.WebContainerService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class SchedulerServiceImpl
extends ContainerImpl
implements SchedulerService,
PropertyChangeListener,
SecurityServiceListener {
    private static final TraceComponent tc = Tr.register(SchedulerServiceImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    protected static SchedulerServiceImpl _instance = null;
    protected SchedulerServiceConfiguration _schedulerServiceConfiguration = null;
    protected Map _schedulerInstances = new HashMap();
    protected static Map _schedulerConfigurations = new HashMap();
    private EJBContainer ejbContainer = null;
    private WebContainerService webContainerSvc = null;
    private ExtensionHelper eh = null;
    private boolean isConfigAvailable = false;
    private SecurityService securityService = null;
    private RoleBasedConfigurator roleBasedConfigurator = null;
    private RoleBasedAuthorizer roleBasedAuthorizer = null;
    private J2EENameFactory j2eeNameFactory = null;
    private ApplicationTracker applicationTracker = null;
    private int hungThreadThreshold;
    private boolean appServerStarted = false;
    private boolean isCRA = false;
    Map taskInfoRegistryByID = new HashMap();
    Map taskInfoRegistryByInterface = new HashMap();
    Map taskInfoRegistryByImplementation = new HashMap();

    public static SchedulerService instance() {
        if (_instance == null) {
            throw new SchedulerServiceNotInitialized(Messages.getMessage("SCHD0126E"));
        }
        return _instance;
    }

    public SchedulerServiceConfiguration getConfiguration() {
        if (this._schedulerServiceConfiguration == null) {
            throw new SchedulerServiceNotInitialized(Messages.getMessage("SCHD0020I"));
        }
        return this._schedulerServiceConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.ibm.websphere.scheduler.Scheduler getSchedulerInstance(String string) throws SchedulerDataStoreException {
        Map map = this._schedulerInstances;
        synchronized (map) {
            com.ibm.websphere.scheduler.Scheduler scheduler = (com.ibm.websphere.scheduler.Scheduler)this._schedulerInstances.get(string);
            if (scheduler == null) {
                SchedulerConfiguration schedulerConfiguration = this.getSchedulerConfiguration(string);
                if (schedulerConfiguration == null) {
                    return null;
                }
                try {
                    scheduler = (SchedulerImpl)AccessController.doPrivileged(new DoNewSchedulerImpl(schedulerConfiguration));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof SchedulerDataStoreException) {
                        throw (SchedulerDataStoreException)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
                this.addSchedulerInstance(string, scheduler);
            }
            return scheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchedulerInstance(String string, com.ibm.websphere.scheduler.Scheduler scheduler) {
        Map map = this._schedulerInstances;
        synchronized (map) {
            this._schedulerInstances.put(string, scheduler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerConfiguration getSchedulerConfiguration(String string) {
        Map map = _schedulerConfigurations;
        synchronized (map) {
            return (SchedulerConfiguration)_schedulerConfigurations.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.ibm.websphere.scheduler.Scheduler[] getSchedulerInstances() {
        Map map = this._schedulerInstances;
        synchronized (map) {
            com.ibm.websphere.scheduler.Scheduler[] schedulerArray = new SchedulerImpl[this._schedulerInstances.size()];
            Iterator iterator = this._schedulerInstances.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                schedulerArray[n] = (SchedulerImpl)iterator.next();
                ++n;
            }
            return schedulerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerConfiguration[] getSchedulerConfigurations() {
        Map map = _schedulerConfigurations;
        synchronized (map) {
            SchedulerConfiguration[] schedulerConfigurationArray = null;
            Map map2 = _schedulerConfigurations;
            synchronized (map2) {
                schedulerConfigurationArray = new SchedulerConfiguration[_schedulerConfigurations.size()];
                Iterator iterator = _schedulerConfigurations.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    schedulerConfigurationArray[n] = (SchedulerConfiguration)iterator.next();
                    ++n;
                }
            }
            return schedulerConfigurationArray;
        }
    }

    public void addSchedulerConfigurationChangeListener(SchedulerConfigurationChangeListener schedulerConfigurationChangeListener, String string) {
    }

    public void addSchedulerServiceConfigurationChangeListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSchedulerConfiguration(String string, SchedulerConfiguration schedulerConfiguration) throws SchedulerConfigurationException {
        Map map = _schedulerConfigurations;
        synchronized (map) {
            if (_schedulerConfigurations.containsKey(string)) {
                throw new SchedulerConfigurationException(Messages.getMessage("SCHD0020I", "Duplicate JNDI Name: " + string));
            }
            _schedulerConfigurations.put(string, schedulerConfiguration);
        }
    }

    public static boolean existsSchedulerConfiguration(String string) {
        return _schedulerConfigurations.containsKey(string);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (Utils.isAppServer()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", new Object[]{object});
            }
            if (object instanceof ContainerConfig) {
                ContainerConfig containerConfig = (ContainerConfig)object;
                try {
                    this.setState("INITIALIZING");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "230", this);
                }
                PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
                this.isCRA = platformHelper.isZOS() ? platformHelper.isCRAJvm() : false;
                this.securityService = (SecurityService)this.getService(SecurityService.class);
                this.securityService.addListener(this);
                ApplicationServer applicationServer = null;
                ResourceMgr resourceMgr = null;
                SchedulerResourceBinder schedulerResourceBinder = null;
                MetaDataFactoryMgr metaDataFactoryMgr = null;
                try {
                    this.isConfigAvailable = containerConfig != null && containerConfig.getConfig() instanceof com.ibm.websphere.models.config.schedulerservice.SchedulerService;
                    boolean bl = true;
                    com.ibm.websphere.models.config.schedulerservice.SchedulerService schedulerService = null;
                    if (this.isConfigAvailable) {
                        schedulerService = (com.ibm.websphere.models.config.schedulerservice.SchedulerService)containerConfig.getConfig();
                        this._schedulerServiceConfiguration = new SchedulerServiceConfigurationImpl(schedulerService);
                        bl = this._schedulerServiceConfiguration.getServiceEnabled();
                    }
                    if (!bl) {
                        Tr.info(tc, "SCHD0009I");
                        throw new ComponentDisabledException();
                    }
                    Tr.info(tc, "SCHD0036I");
                    this.getOuterBCS().addService(SchedulerService.class, this);
                    if (this.isConfigAvailable) {
                        schedulerResourceBinder = new SchedulerResourceBinder();
                        resourceMgr = (ResourceMgr)this.getService(ResourceMgr.class);
                        resourceMgr.addResourceBinder(schedulerResourceBinder);
                    }
                    if ((metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(MetaDataFactoryMgr.class)) == null) {
                        Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"MetaDataFactoryMgr"});
                        Tr.error(tc, "SCHD0029W");
                        throw new ComponentDisabledException("Unable to locate the MetaDataFactoryMgr service.");
                    }
                    this.j2eeNameFactory = metaDataFactoryMgr.getJ2EENameFactory();
                    this.eh = (ExtensionHelper)this.getService(ExtensionHelper.class);
                    if (this.eh == null) {
                        Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"ExtensionHelper"});
                        Tr.error(tc, "SCHD0029W");
                        throw new ComponentDisabledException("Unable to locate the ExtensionHelper service.");
                    }
                    applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
                    if (applicationServer == null) {
                        Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"ApplicationServer"});
                        Tr.error(tc, "SCHD0029W");
                        throw new ComponentDisabledException("Unable to locate the ApplicationServer service.");
                    }
                    applicationServer.addPropertyChangeListener("state", this);
                    ThreadMonitor threadMonitor = (ThreadMonitor)this.getService(ThreadMonitor.class);
                    this.hungThreadThreshold = 600;
                    this.releaseService(threadMonitor);
                    Server server2 = (Server)this.getService(Server.class);
                    server2.addPropertyChangeListener("threadMonitorInterval", this);
                    this.releaseService(server2);
                    _instance = this;
                    this.components = this.loadComponents("META-INF/ws-scheduler-startup.xml");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Scheduler Components=" + this.components);
                    }
                    this.initializeComponents((EObject)schedulerService, containerConfig.getLocators());
                    Tr.info(tc, "SCHD0037I");
                    if (applicationServer != null) {
                        this.releaseService(applicationServer);
                    }
                    if (resourceMgr != null) {
                        this.releaseService(resourceMgr);
                    }
                    if (metaDataFactoryMgr != null) {
                        this.releaseService(metaDataFactoryMgr);
                    }
                }
                catch (ComponentDisabledException componentDisabledException) {
                    try {
                        if (resourceMgr == null) throw componentDisabledException;
                        if (schedulerResourceBinder == null) throw componentDisabledException;
                        resourceMgr.removeResourceBinder(schedulerResourceBinder);
                        throw componentDisabledException;
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "197", this);
                            String string = "The SchedulerService configuration could not be processed due to the Exception " + throwable.toString();
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, string);
                            }
                            Tr.error(tc, "SCHD0020I", new Object[]{throwable.toString()});
                            Tr.service(tc, "SCHD0102I", new Object[]{string + "\n" + Utils.printStackTrace(throwable)});
                            throw new ConfigurationWarning(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        if (applicationServer != null) {
                            this.releaseService(applicationServer);
                        }
                        if (resourceMgr != null) {
                            this.releaseService(resourceMgr);
                        }
                        if (metaDataFactoryMgr != null) {
                            this.releaseService(metaDataFactoryMgr);
                        }
                        try {
                            this.setState("INITIALIZED");
                            throw throwable;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "300", this);
                        }
                        throw throwable;
                    }
                }
                try {
                    this.setState("INITIALIZED");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "300", this);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initialize called on SchedulerServiceImpl with incorrect config object type. Parameter type was " + object.getClass().getName());
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "initialize");
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Scheduler Service not initialized because not running in an AppServer");
        }
        Tr.info(tc, "SCHD0009I");
        throw new ComponentDisabledException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeWarning, RuntimeError {
        block17: {
            block16: {
                block15: {
                    if (!Utils.isAppServer()) break block16;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "start");
                    }
                    Tr.info(tc, "SCHD0031I");
                    ApplicationMgr applicationMgr = null;
                    try {
                        try {
                            this.setState("STARTING");
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "320", this);
                        }
                        this.applicationTracker = new ApplicationTracker();
                        this.ejbContainer = (EJBContainer)this.getService(EJBContainer.class);
                        if (this.ejbContainer == null) {
                            Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"EJBContainer"});
                            Tr.error(tc, "SCHD0029W");
                            throw new RuntimeError("Unable to locate the EJBContainer service.");
                        }
                        if (!this.isCRA) {
                            this.webContainerSvc = (WebContainerService)this.getService(WebContainerService.class);
                            if (this.webContainerSvc == null) {
                                Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"WebContainerService"});
                                Tr.error(tc, "SCHD0029W");
                                throw new RuntimeError("Unable to locate the WebContainerService service.");
                            }
                        }
                        if ((applicationMgr = (ApplicationMgr)this.getService(ApplicationMgr.class)) == null) {
                            Tr.error(tc, "ERR_NO_SERVICE", new Object[]{"ApplicationMgr"});
                            Tr.error(tc, "SCHD0029W");
                            throw new RuntimeError("Unable to locate the ApplicationMgr service.");
                        }
                        applicationMgr.addDeployedObjectListener(this.applicationTracker);
                        this.startComponents();
                        try {
                            this.setState("STARTED");
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "340", this);
                        }
                        if (applicationMgr == null) break block15;
                        this.releaseService(applicationMgr);
                    }
                    catch (Throwable throwable) {
                        if (applicationMgr != null) {
                            this.releaseService(applicationMgr);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "start");
                        }
                        throw throwable;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start");
                }
                Tr.info(tc, "SCHD0001I");
                break block17;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scheduler Service not started because not running in an AppServer");
            }
            Tr.info(tc, "SCHD0009I");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "propertyChange", new Object[]{propertyChangeEvent, propertyChangeEvent != null ? propertyChangeEvent.getNewValue() : ""});
        }
        try {
            ApplicationServer applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
            if (propertyChangeEvent.getSource() == applicationServer) {
                if (propertyChangeEvent.getNewValue().equals("STARTED")) {
                    this.appServerStarted = true;
                    if (_instance != null) {
                        this.startSchedulers(true);
                    }
                } else if (propertyChangeEvent.getNewValue().equals("STOPPING")) {
                    if (_instance != null) {
                        this.stopSchedulers();
                    }
                    this.appServerStarted = false;
                }
            } else if ("threadMonitorInterval".equals(propertyChangeEvent.getPropertyName())) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                this.setHungThreadThreshold(n);
            }
            this.releaseService(applicationServer);
        }
        finally {
            if (bl) {
                Tr.exit(tc, "propertyChange");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSchedulers(boolean bl) {
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startSchedulers", new Boolean(bl));
            }
            try {
                if (bl) {
                    try {
                        this.runAsynchronousInitializer(new DaemonStarter());
                    }
                    catch (WsRuntimeFwException wsRuntimeFwException) {
                        FFDCFilter.processException((Throwable)wsRuntimeFwException, "com.ibm.ws.scheduler.SchedulerServiceImpl.startSchedulers", "698", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Execption running startSchedulers asynchronously", wsRuntimeFwException);
                        }
                        bl = false;
                    }
                }
                if (bl) break block24;
                SchedulerServiceConfiguration schedulerServiceConfiguration = null;
                SchedulerConfiguration[] schedulerConfigurationArray = this.getSchedulerConfigurations();
                try {
                    schedulerServiceConfiguration = this.getConfiguration();
                }
                catch (SchedulerServiceNotInitialized schedulerServiceNotInitialized) {
                    FFDCFilter.processException((Throwable)schedulerServiceNotInitialized, "com.ibm.ws.scheduler.SchedulerServiceImpl.startSchedulers", "339", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Error: Could not retrieve the service configuration: " + schedulerServiceNotInitialized.toString());
                    }
                    Tr.error(tc, "SCHD0003E", new Object[]{schedulerServiceNotInitialized.toString()});
                    Tr.service(tc, "SCHD0003E", new Object[]{Utils.printStackTrace(schedulerServiceNotInitialized)});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "startSchedulers");
                    }
                    return;
                }
                if (!schedulerServiceConfiguration.getServiceEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SchedulerService has been disabled in this server. No daemons will be started");
                    }
                    return;
                }
                Tr.info(tc, "SCHD0077I");
                if (schedulerConfigurationArray == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No schedulers in the config to start(schedulerConfigurations is null)");
                    }
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting alarms which will poll the database");
                    Tr.debug(tc, "   Counted a total of " + schedulerConfigurationArray.length + " schedulers");
                }
                for (int i = 0; i < schedulerConfigurationArray.length; ++i) {
                    try {
                        this.autoStartDaemon((Scheduler)this.getSchedulerInstance(schedulerConfigurationArray[i].getJndiName()));
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerServiceImpl.startSchedulers", "379", this);
                        Tr.error(tc, "SCHD0026E", new Object[]{schedulerConfigurationArray[i].getJndiName(), throwable});
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Caught Exception: ", new Object[]{throwable});
                    }
                }
                Tr.info(tc, "SCHD0078I");
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "startSchedulers");
                }
            }
        }
    }

    void autoStartDaemon(Scheduler scheduler) throws SchedulerDataStoreException {
        block8: {
            SchedulerConfiguration schedulerConfiguration = scheduler.getSchedulerConfiguration();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting Scheduler Daemon for instance: " + schedulerConfiguration.getJndiName());
            }
            if (this.isCRA && tc.isDebugEnabled()) {
                Tr.debug(tc, "This process is a z/OS CR-A.  This daemon will not start.");
            }
            if (!this.appServerStarted && tc.isDebugEnabled()) {
                Tr.debug(tc, "Server is not started.  This daemon will not be autostarted at this time.");
            }
            try {
                if (schedulerConfiguration.isAutoStartDaemons() && schedulerConfiguration.getDaemonThreads() > 0 && !this.isCRA) {
                    long l = schedulerConfiguration.getStartupDelayMillis();
                    int n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
                    scheduler.startDaemon(new Integer(n));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Scheduler Daemon for instance is disabled: " + schedulerConfiguration.getJndiName());
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.SchedulerServiceImpl.startSchedulers", "379", this);
                Tr.error(tc, "SCHD0128E", new Object[]{schedulerConfiguration.getJndiName(), throwable});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Caught Exception: ", new Object[]{throwable});
            }
        }
    }

    private void stopSchedulers() {
        block7: {
            try {
                if (!this.getConfiguration().getServiceEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Service did not start, so there is nothing to stop.");
                    }
                    return;
                }
                Iterator iterator = this._schedulerInstances.values().iterator();
                while (iterator.hasNext()) {
                    SchedulerImpl schedulerImpl = (SchedulerImpl)iterator.next();
                    try {
                        Tr.info(tc, "SCHD0034I", new Object[]{schedulerImpl.getSchedulerConfiguration().getJndiName()});
                        schedulerImpl.destroy();
                        Tr.info(tc, "SCHD0035I", new Object[]{schedulerImpl.getSchedulerConfiguration().getJndiName()});
                    }
                    catch (RuntimeException runtimeException) {
                        FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.scheduler.SchedulerServiceImpl.stopSchedulers", "440", this);
                    }
                }
            }
            catch (SchedulerServiceNotInitialized schedulerServiceNotInitialized) {
                FFDCFilter.processException((Throwable)schedulerServiceNotInitialized, "com.ibm.ws.scheduler.SchedulerServiceImpl.stopSchedulers", "445", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Schedule service did not initialize, so nothing to stop.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        try {
            try {
                this.setState("STOPPING");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "230", this);
            }
            Tr.info(tc, "SCHD0040I");
            this.stopComponents();
            if (this.webContainerSvc != null) {
                this.releaseService(this.webContainerSvc);
                this.webContainerSvc = null;
            }
            if (this.ejbContainer != null) {
                this.releaseService(this.ejbContainer);
                this.ejbContainer = null;
            }
            if (this.securityService != null) {
                this.releaseService(this.securityService);
            }
            if (this.eh != null) {
                this.releaseService(this.eh);
                this.eh = null;
            }
            try {
                this.setState("STOPPED");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "240", this);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.SchedulerServiceImpl.initialize", "250", this);
        }
        finally {
            Tr.info(tc, "SCHD0002I");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceVariable(String string, String string2) {
        VariableMap variableMap = (VariableMap)this.getService(VariableMap.class);
        try {
            StringBuffer stringBuffer = new StringBuffer("$(");
            stringBuffer.append(string);
            stringBuffer.append(")");
            String string3 = stringBuffer.toString();
            String string4 = null;
            try {
                string4 = variableMap.expand(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (string4 != null && !string4.equals(string3)) {
                String string5 = string4;
                return string5;
            }
            String string6 = string2;
            return string6;
        }
        finally {
            this.releaseService(variableMap);
        }
    }

    public void register(TaskInfoRegistry taskInfoRegistry) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "register", new Object[]{taskInfoRegistry});
        }
        int n = taskInfoRegistry.getID();
        Class clazz = taskInfoRegistry.getTaskInfoImplementation();
        Class clazz2 = taskInfoRegistry.getTaskInfoInterface();
        if (!clazz2.isInterface()) {
            throw new IllegalArgumentException("TaskInfoInterface: " + clazz2 + " is not an interface.");
        }
        boolean bl2 = false;
        Class<?>[] classArray = clazz2.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != (class$com$ibm$websphere$scheduler$TaskInfo == null ? SchedulerServiceImpl.class$("com.ibm.websphere.scheduler.TaskInfo") : class$com$ibm$websphere$scheduler$TaskInfo)) continue;
            bl2 = true;
        }
        if (!bl2) {
            throw new IllegalArgumentException("TaskInfoInterface: " + clazz2.getName() + " must extend: " + TaskInfo.class.getName());
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("TaskInfoImplementation: " + clazz.getName() + " must be a TaskInfo implementation class.");
        }
        Integer n2 = new Integer(n);
        if (this.taskInfoRegistryByID.containsKey(n2)) {
            TaskInfoRegistry taskInfoRegistry2 = (TaskInfoRegistry)this.taskInfoRegistryByID.get(n2);
            throw new IllegalArgumentException("Duplicate ID detected: " + n + ".  Duplicate interface=" + taskInfoRegistry2.getTaskInfoInterface().getName());
        }
        this.taskInfoRegistryByID.put(n2, taskInfoRegistry);
        this.taskInfoRegistryByInterface.put(clazz2, taskInfoRegistry);
        this.taskInfoRegistryByImplementation.put(clazz, taskInfoRegistry);
        if (bl) {
            Tr.exit(tc, "register", new Object[0]);
        }
    }

    Class getTaskInfoImplementation(int n) {
        TaskInfoRegistry taskInfoRegistry = (TaskInfoRegistry)this.taskInfoRegistryByID.get(new Integer(n));
        if (taskInfoRegistry == null) {
            throw new IllegalArgumentException("Task Id Not Registered");
        }
        return taskInfoRegistry.getTaskInfoImplementation();
    }

    Class getTaskInfoImplementation(Class clazz) {
        TaskInfoRegistry taskInfoRegistry = (TaskInfoRegistry)this.taskInfoRegistryByInterface.get(clazz);
        if (taskInfoRegistry == null) {
            throw new IllegalArgumentException("TaskInfo Interface Not Registered");
        }
        return taskInfoRegistry.getTaskInfoImplementation();
    }

    int getTaskIDFromTaskInfoImplementation(Class clazz) {
        TaskInfoRegistry taskInfoRegistry = (TaskInfoRegistry)this.taskInfoRegistryByImplementation.get(clazz);
        if (taskInfoRegistry == null) {
            throw new IllegalArgumentException("TaskInfo Interface Not Registered");
        }
        return taskInfoRegistry.getID();
    }

    boolean isTaskInfoImplementationRegistered(Class clazz) {
        return this.taskInfoRegistryByImplementation.containsKey(clazz);
    }

    public com.ibm.websphere.scheduler.Scheduler createSchedulerInstance(SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException {
        schedulerConfiguration.validate();
        SchedulerServiceImpl.addSchedulerConfiguration(schedulerConfiguration.getJndiName(), schedulerConfiguration);
        com.ibm.websphere.scheduler.Scheduler scheduler = this.getSchedulerInstance(schedulerConfiguration.getJndiName());
        this.autoStartDaemon((Scheduler)scheduler);
        return scheduler;
    }

    public SchedulerConfiguration createSchedulerConfiguration(String string, String string2, String string3, String string4, String string5, long l, WorkManager workManager) {
        return new SchedulerConfigurationImpl(string, string2, string3, string4, string5, l, workManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(J2EEName j2EEName) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getClassLoader", j2EEName);
        }
        ClassLoader classLoader = null;
        try {
            classLoader = this.ejbContainer.getClassLoader(j2EEName);
            if (classLoader == null) {
                if (bl2) {
                    Tr.debug(tc, "EJBContainer ClassLoader is null");
                }
                if (this.webContainerSvc != null && (classLoader = this.webContainerSvc.getClassLoader(j2EEName)) == null && bl2) {
                    Tr.debug(tc, "WebContainer ClassLoader is null");
                }
            }
        }
        finally {
            if (bl) {
                Tr.exit(tc, "getClassLoader", classLoader);
            }
        }
        return classLoader;
    }

    public J2EEName getJ2EEName(Object object) throws SchedulerException {
        J2EEName j2EEName = null;
        if (this.ejbContainer == null) {
            this.ejbContainer = (EJBContainer)this.getService(EJBContainer.class);
        }
        try {
            if (this.ejbContainer != null) {
                j2EEName = this.ejbContainer.getJ2EEName(object);
            }
        }
        catch (Throwable throwable) {
            throw new SchedulerException(throwable);
        }
        return j2EEName;
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        if (securityServiceEvent.getState() == 1) {
            try {
                this.roleBasedConfigurator = this.securityService.getConfigurator();
                this.roleBasedAuthorizer = this.roleBasedConfigurator.getRoleBasedAuthorizer("admin-authz", null);
            }
            catch (RoleBasedAppException roleBasedAppException) {
                Tr.error(tc, "SCHD0102I", roleBasedAppException);
            }
        }
    }

    public RoleBasedAuthorizer getRoleBasedAuthorizer() {
        return this.roleBasedAuthorizer;
    }

    public boolean isTaskOperationSupported(long l, long l2, TaskInfo taskInfo) {
        boolean bl = true;
        TaskInfoRegistry taskInfoRegistry = (TaskInfoRegistry)this.taskInfoRegistryByImplementation.get(taskInfo.getClass());
        if (taskInfoRegistry == null) {
            throw new IllegalArgumentException("TaskInfo Interface Not Registered");
        }
        if (taskInfoRegistry instanceof TaskInfoRegistryUI) {
            bl = ((TaskInfoRegistryUI)taskInfoRegistry).isOperationSupported(l, l2);
        }
        return bl;
    }

    public ExtensionHelper getExtensionHelper() {
        return this.eh;
    }

    public J2EENameFactory getJ2EENameFactory() {
        return this.j2eeNameFactory;
    }

    public Object getService(Class clazz) {
        return super.getService(clazz);
    }

    public void releaseService(Object object) {
        super.releaseService(object);
    }

    private synchronized void setHungThreadThreshold(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updating HungThreadThreshold to " + n + "s");
        }
        this.hungThreadThreshold = n;
    }

    public synchronized int getHungThreadThreshold() {
        return this.hungThreadThreshold;
    }

    private class DaemonStarter
    implements AsynchronousInitializer {
        private DaemonStarter() {
        }

        public void run() throws WsRuntimeFwException {
            SchedulerServiceImpl.this.startSchedulers(false);
        }
    }

    private class DoNewSchedulerImpl
    implements PrivilegedExceptionAction {
        SchedulerConfiguration configuration = null;

        public DoNewSchedulerImpl(SchedulerConfiguration schedulerConfiguration) {
            this.configuration = schedulerConfiguration;
        }

        public Object run() throws Exception {
            return new SchedulerImpl(this.configuration, SchedulerServiceImpl.this.eh, SchedulerServiceImpl.this.applicationTracker);
        }
    }
}

